/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.util.KenaiUtil;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.StackTraceSupport;
import org.netbeans.modules.bugtracking.util.TextUtils;
import org.netbeans.modules.bugtracking.util.WebUrlHyperlinkSupport;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueFinder;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.kenai.ui.spi.KenaiUserUI;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CommentsPanel
extends JPanel {
    private static final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String ISSUE_ATTRIBUTE = "issue";
    private static final String URL_ATTRIBUTE = "url hyperlink";
    private static final String REPLY_TO_PROPERTY = "replyTo";
    private static final String QUOTE_PREFIX = "> ";
    private static final int MAX_COMMENT_HEIGHT = 10000;
    private final BugzillaIssueFinder issueFinder;
    private BugzillaIssue issue;
    private MouseAdapter listener;
    private NewCommentHandler newCommentHandler;
    private ActionListener replyListener;

    public CommentsPanel() {
        this.setBackground(UIManager.getColor("EditorPane.background"));
        this.listener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        JTextPane jTextPane = (JTextPane)mouseEvent.getSource();
                        StyledDocument styledDocument = jTextPane.getStyledDocument();
                        Element element = styledDocument.getCharacterElement(jTextPane.viewToModel(mouseEvent.getPoint()));
                        AttributeSet attributeSet = element.getAttributes();
                        IssueAction issueAction = (IssueAction)attributeSet.getAttribute(CommentsPanel.ISSUE_ATTRIBUTE);
                        if (issueAction != null) {
                            int n = element.getStartOffset();
                            int n2 = element.getEndOffset();
                            int n3 = n2 - n;
                            String string = styledDocument.getText(n, n3);
                            issueAction.openIssue(string);
                            return;
                        }
                        UrlAction urlAction = (UrlAction)attributeSet.getAttribute(CommentsPanel.URL_ATTRIBUTE);
                        if (urlAction != null) {
                            int n = element.getStartOffset();
                            int n4 = element.getEndOffset();
                            int n5 = n4 - n;
                            String string = styledDocument.getText(n, n5);
                            urlAction.openUrlHyperlink(string);
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    Bugzilla.LOG.log(Level.SEVERE, null, exception);
                }
            }
        };
        this.issueFinder = (BugzillaIssueFinder)((Object)Lookup.getDefault().lookup(BugzillaIssueFinder.class));
        assert (this.issueFinder != null);
    }

    public void setIssue(BugzillaIssue bugzillaIssue) {
        this.removeAll();
        this.issue = bugzillaIssue;
        GroupLayout groupLayout = new GroupLayout((Container)this);
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup(1);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)parallelGroup).addContainerGap());
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        sequentialGroup.addContainerGap();
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)sequentialGroup));
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
        String string = bugzillaIssue.getFieldValue(BugzillaIssue.IssueField.CREATION);
        try {
            BugzillaIssue.Comment[] commentArray = dateTimeFormat.parse(string);
            string = dateFormat.format((Date)commentArray);
        }
        catch (ParseException parseException) {
            Bugzilla.LOG.log(Level.INFO, null, parseException);
        }
        this.addSection(groupLayout, bugzillaIssue.getFieldValue(BugzillaIssue.IssueField.DESCRIPTION), bugzillaIssue.getFieldValue(BugzillaIssue.IssueField.REPORTER), bugzillaIssue.getFieldValue(BugzillaIssue.IssueField.REPORTER_NAME), string, parallelGroup, sequentialGroup, true);
        for (BugzillaIssue.Comment comment : bugzillaIssue.getComments()) {
            String string2 = dateFormat.format(comment.getWhen());
            this.addSection(groupLayout, comment.getText(), comment.getAuthor(), comment.getAuthorName(), string2, parallelGroup, sequentialGroup, false);
        }
        sequentialGroup.addContainerGap();
        this.setLayout((LayoutManager)groupLayout);
    }

    public void setNewCommentHandler(NewCommentHandler newCommentHandler) {
        this.newCommentHandler = newCommentHandler;
    }

    private void addSection(GroupLayout groupLayout, String string, String string2, String string3, String string4, GroupLayout.ParallelGroup parallelGroup, GroupLayout.SequentialGroup sequentialGroup, boolean bl) {
        Object object;
        Object object2;
        String string5;
        String string6;
        Object object3;
        JTextPane jTextPane = new JTextPane();
        JLabel jLabel = new JLabel();
        ResourceBundle resourceBundle = NbBundle.getBundle(CommentsPanel.class);
        if (bl) {
            object3 = resourceBundle.getString("CommentsPanel.leftLabel.format");
            string6 = TextUtils.escapeForHTMLLabel((String)this.issue.getSummary());
            string5 = MessageFormat.format((String)object3, string6);
        } else {
            string5 = resourceBundle.getString("CommentsPanel.leftLabel.text");
        }
        jLabel.setText(string5);
        object3 = new JLabel();
        string6 = resourceBundle.getString("CommentsPanel.rightLabel.format");
        String string7 = string3 != null && string3.trim().length() > 0 ? string3 : string2;
        String string8 = MessageFormat.format(string6, string4, string7);
        ((JLabel)object3).setText(string8);
        ((JLabel)object3).setLabelFor(jTextPane);
        JLabel jLabel2 = null;
        if (this.issue.getRepository() instanceof KenaiRepository) {
            int n = string2.indexOf(64);
            object2 = n == -1 ? string2 : string2.substring(0, n);
            object = new KenaiUserUI((String)object2);
            object.setMessage(KenaiUtil.getChatLink((Issue)this.issue));
            jLabel2 = object.createUserWidget();
            jLabel2.setText(null);
        }
        LinkButton linkButton = new LinkButton(resourceBundle.getString("Comments.replyButton.text"));
        linkButton.addActionListener(this.getReplyListener());
        linkButton.putClientProperty((Object)REPLY_TO_PROPERTY, (Object)jTextPane);
        linkButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.replyButton.AccessibleContext.accessibleDescription"));
        this.setupTextPane(jTextPane, string);
        object2 = jTextPane;
        if (jTextPane.getPreferredSize().height > Short.MAX_VALUE) {
            object2 = new JScrollPane(jTextPane);
            ((JComponent)object2).setBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.foreground")));
            jTextPane.setBorder(null);
            object = new Dimension(jTextPane.getPreferredSize());
            object.height = 10000;
            ((JComponent)object2).setPreferredSize((Dimension)object);
        }
        object = groupLayout.createSequentialGroup().add((Component)jLabel, 0, 0, Short.MAX_VALUE).addPreferredGap(0).add((Component)linkButton).addPreferredGap(0).add((Component)object3);
        if (jLabel2 != null) {
            object.addPreferredGap(0);
            object.add((Component)jLabel2);
        }
        parallelGroup.add((GroupLayout.Group)object).add((Component)object2, -1, -1, Short.MAX_VALUE);
        if (!bl) {
            sequentialGroup.addPreferredGap(1);
        }
        GroupLayout.ParallelGroup parallelGroup2 = groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)linkButton).add((Component)object3);
        if (jLabel2 != null) {
            parallelGroup2.add((Component)jLabel2);
        }
        sequentialGroup.add((GroupLayout.Group)parallelGroup2).addPreferredGap(0).add((Component)object2, -2, -1, -2);
    }

    private void setupTextPane(JTextPane jTextPane, String string) {
        int n;
        int n2;
        Style style;
        Object object;
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        Caret caret = jTextPane.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
        jTextPane.setText(string);
        StackTraceSupport.addHyperlinks((JTextPane)jTextPane);
        int[] nArray = this.issueFinder.getIssueSpans(string);
        if (nArray.length > 0) {
            object = StyleContext.getDefaultStyleContext().getStyle("default");
            style = styledDocument.addStyle("bugBlue", (Style)object);
            style.addAttribute(ISSUE_ATTRIBUTE, new IssueAction());
            StyleConstants.setForeground(style, Color.BLUE);
            StyleConstants.setUnderline(style, true);
            for (int i = 0; i < nArray.length; i += 2) {
                n2 = nArray[i];
                n = nArray[i + 1] - nArray[i];
                try {
                    styledDocument.remove(n2, n);
                    styledDocument.insertString(n2, string.substring(nArray[i], nArray[i + 1]), style);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
        if ((object = WebUrlHyperlinkSupport.findBoundaries((String)string)) != null && ((int[])object).length != 0) {
            style = StyleContext.getDefaultStyleContext().getStyle("default");
            Style style2 = styledDocument.addStyle("regularBlue", style);
            style2.addAttribute(URL_ATTRIBUTE, new UrlAction());
            StyleConstants.setForeground(style2, Color.BLUE);
            StyleConstants.setUnderline(style2, true);
            for (n2 = 0; n2 < ((int[])object).length; n2 += 2) {
                n = object[n2];
                int n3 = object[n2 + 1] - object[n2];
                try {
                    styledDocument.remove(n, n3);
                    styledDocument.insertString(n, string.substring(object[n2], object[n2 + 1]), style2);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
        jTextPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.foreground")), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        jTextPane.setEditable(false);
        jTextPane.addMouseListener(this.listener);
        jTextPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.textPane.AccessibleContext.accessibleName"));
        jTextPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.textPane.AccessibleContext.accessibleDescription"));
    }

    private ActionListener getReplyListener() {
        if (this.replyListener == null) {
            this.replyListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JComponent jComponent;
                    Object object;
                    Object object2 = actionEvent.getSource();
                    if (object2 instanceof JComponent && (object = (jComponent = (JComponent)object2).getClientProperty(CommentsPanel.REPLY_TO_PROPERTY)) instanceof JTextPane) {
                        JTextPane jTextPane = (JTextPane)object;
                        String string = jTextPane.getText();
                        StringBuilder stringBuilder = new StringBuilder();
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                        while (stringTokenizer.hasMoreElements()) {
                            String string2 = stringTokenizer.nextToken();
                            stringBuilder.append(CommentsPanel.QUOTE_PREFIX).append(string2).append('\n');
                        }
                        CommentsPanel.this.newCommentHandler.append(stringBuilder.toString());
                    }
                }
            };
        }
        return this.replyListener;
    }

    private class IssueAction {
        private IssueAction() {
        }

        void openIssue(String string) {
            final String string2 = CommentsPanel.this.issueFinder.getIssueId(string);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Issue issue = CommentsPanel.this.issue.getRepository().getIssue(string2);
                    if (issue != null) {
                        issue.open();
                    }
                }
            });
        }
    }

    public static interface NewCommentHandler {
        public void append(String var1);
    }

    private class UrlAction {
        private UrlAction() {
        }

        void openUrlHyperlink(String string) {
            try {
                URL uRL = new URI(string).toURL();
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            }
            catch (Exception exception) {
                assert (false);
                ErrorManager.getDefault().log(16, "Could not open URL: " + string);
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }
}

