/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.KenaiUtil;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.RepositoryUserRenderer;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.issue.AttachmentsPanel;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueProvider;
import org.netbeans.modules.bugzilla.issue.CommentsPanel;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.kenai.ui.api.NbModuleOwnerSupport;
import org.netbeans.modules.kenai.ui.spi.KenaiUserUI;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IssuePanel
extends JPanel
implements Scrollable {
    private static final Color HIGHLIGHT_COLOR = new Color(217, 255, 217);
    private BugzillaIssue issue;
    private CommentsPanel commentsPanel;
    private AttachmentsPanel attachmentsPanel;
    private int resolvedIndex;
    private Map<BugzillaIssue.IssueField, String> initialValues = new HashMap<BugzillaIssue.IssueField, String>();
    private List<String> keywords = new LinkedList<String>();
    private boolean reloading;
    private boolean skipReload;
    private boolean usingTargetMilestones;
    private PropertyChangeListener tasklistListener;
    private NbModuleOwnerSupport.OwnerInfo ownerInfo;
    PropertyChangeListener cacheListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() != IssuePanel.this.issue) {
                return;
            }
            if ("issue.seen_changed".equals(propertyChangeEvent.getPropertyName())) {
                IssuePanel.this.updateFieldStatuses();
            }
        }
    };
    private int oldCommentCount;
    private boolean noSummary = false;
    private boolean invalidKeyword = false;
    private boolean cyclicDependency = false;
    private boolean noComponent = false;
    private boolean noVersion = false;
    private boolean noTargetMilestione = false;
    private List<String> fieldErrors = new LinkedList<String>();
    private List<String> fieldWarnings = new LinkedList<String>();
    private Map<Component, Boolean> enableMap = new HashMap<Component, Boolean>();
    private JTextArea addCommentArea;
    private JLabel addCommentLabel;
    private JComboBox assignedCombo;
    private JTextField assignedField;
    private JLabel assignedLabel;
    private JLabel assignedToStatusLabel;
    private JLabel assignedToWarning;
    private JLabel attachmentsLabel;
    private JButton blocksButton;
    private JTextField blocksField;
    private JLabel blocksLabel;
    private JLabel blocksWarning;
    private JButton cancelButton;
    private JTextField ccField;
    private JLabel ccLabel;
    private JLabel ccWarning;
    private JComboBox componentCombo;
    private JLabel componentLabel;
    private JLabel componentWarning;
    private JTextField dependsField;
    private JLabel dependsLabel;
    private JButton dependsOnButton;
    private JLabel dependsOnWarning;
    private JPanel dummyAttachmentsPanel;
    private JPanel dummyCommentsPanel;
    private JLabel dummyLabel1;
    private JLabel dummyLabel2;
    private JLabel dummyLabel3;
    private JButton duplicateButton;
    private JTextField duplicateField;
    private JLabel duplicateLabel;
    private JLabel headerLabel;
    private JComboBox issueTypeCombo;
    private JLabel issueTypeLabel;
    private JLabel issueTypeWarning;
    private JButton keywordsButton;
    private JTextField keywordsField;
    private JLabel keywordsLabel;
    private JLabel keywordsWarning;
    private JPanel messagePanel;
    private JLabel milestoneWarning;
    private JTextField modifiedField;
    private JLabel modifiedLabel;
    private JComboBox osCombo;
    private JLabel osWarning;
    private JComboBox platformCombo;
    private JLabel platformLabel;
    private JLabel platformWarning;
    private JComboBox priorityCombo;
    private JLabel priorityLabel;
    private JLabel priorityWarning;
    private JComboBox productCombo;
    private JTextField productField;
    private JLabel productLabel;
    private JLabel productWarning;
    private JTextField qaContactField;
    private JLabel qaContactLabel;
    private JLabel qaContactWarning;
    private LinkButton refreshButton;
    private LinkButton reloadButton;
    private JTextField reportedField;
    private JLabel reportedLabel;
    private JLabel reportedStatusLabel;
    private JComboBox resolutionCombo;
    private JTextField resolutionField;
    private JLabel resolutionLabel;
    private JLabel resolutionWarning;
    private JScrollPane scrollPane1;
    private JSeparator separator;
    private JLabel separatorLabel;
    private JLabel separatorLabel2;
    private JComboBox severityCombo;
    private JLabel severityWarning;
    private JComboBox statusCombo;
    private JLabel statusLabel;
    private JLabel statusWarning;
    private JTextField statusWhiteboardField;
    private JLabel statusWhiteboardLabel;
    private JLabel statusWhiteboardWarning;
    private JButton submitButton;
    private JTextField summaryField;
    private JLabel summaryLabel;
    private JLabel summaryWarning;
    private JComboBox targetMilestoneCombo;
    private JLabel targetMilestoneLabel;
    private LinkButton tasklistButton;
    private JTextField urlField;
    private JLabel urlLabel;
    private JLabel urlWarning;
    private JComboBox versionCombo;
    private JLabel versionLabel;
    private JLabel versionWarning;
    private int unitIncrement;

    public IssuePanel() {
        this.initComponents();
        this.reportedField.setBackground(this.getBackground());
        this.modifiedField.setBackground(this.getBackground());
        this.resolutionField.setBackground(this.getBackground());
        this.productField.setBackground(this.getBackground());
        this.messagePanel.setBackground(this.getBackground());
        Font font = this.headerLabel.getFont();
        this.headerLabel.setFont(font.deriveFont((float)((double)font.getSize() * 1.7)));
        this.duplicateLabel.setVisible(false);
        this.duplicateField.setVisible(false);
        this.duplicateButton.setVisible(false);
        this.attachDocumentListeners();
        this.attachHideStatusListener();
        BugtrackingUtil.fixFocusTraversalKeys((JComponent)this.addCommentArea);
        this.commentsPanel = new CommentsPanel();
        this.commentsPanel.setNewCommentHandler(new CommentsPanel.NewCommentHandler(){

            public void append(String string) {
                IssuePanel.this.addCommentArea.append(string);
                IssuePanel.this.addCommentArea.requestFocus();
                IssuePanel.this.scrollRectToVisible(IssuePanel.this.scrollPane1.getBounds());
            }
        });
        this.attachmentsPanel = new AttachmentsPanel();
        GroupLayout groupLayout = (GroupLayout)this.getLayout();
        groupLayout.replace((Component)this.dummyCommentsPanel, (Component)this.commentsPanel);
        groupLayout.replace((Component)this.dummyAttachmentsPanel, (Component)this.attachmentsPanel);
        this.attachmentsLabel.setLabelFor(this.attachmentsPanel);
        BugtrackingUtil.issue163946Hack((JScrollPane)this.scrollPane1);
    }

    void reloadFormInAWT(final boolean bl) {
        if (EventQueue.isDispatchThread()) {
            this.reloadForm(bl);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    IssuePanel.this.reloadForm(bl);
                }
            });
        }
    }

    public void setIssue(BugzillaIssue bugzillaIssue) {
        Object object;
        boolean bl;
        if (this.issue == null) {
            bugzillaIssue.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("issue.data_changed".equals(propertyChangeEvent.getPropertyName())) {
                        IssuePanel.this.reloadFormInAWT(false);
                    }
                }
            });
            IssueCacheUtils.removeCacheListener((Issue)bugzillaIssue, (PropertyChangeListener)this.cacheListener);
            IssueCacheUtils.addCacheListener((Issue)bugzillaIssue, (PropertyChangeListener)this.cacheListener);
            this.summaryField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    IssuePanel.this.updateNoSummary();
                }
            });
            this.keywordsField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    IssuePanel.this.updateInvalidKeyword();
                }
            });
        }
        this.issue = bugzillaIssue;
        this.initCombos();
        List<String> list = bugzillaIssue.getBugzillaRepository().getConfiguration().getKeywords();
        this.keywords.clear();
        for (String string : list) {
            this.keywords.add(string.toUpperCase());
        }
        boolean bl2 = BugzillaUtil.isNbRepository(bugzillaIssue.getRepository());
        boolean bl3 = bl = bl2 || !(bugzillaIssue.getBugzillaRepository() instanceof KenaiRepository);
        if (this.qaContactLabel.isVisible() != bl) {
            GroupLayout groupLayout = (GroupLayout)this.getLayout();
            JLabel jLabel = new JLabel();
            IssuePanel.swap(groupLayout, this.ccLabel, this.qaContactLabel, jLabel);
            IssuePanel.swap(groupLayout, this.ccField, this.qaContactField, jLabel);
            this.qaContactLabel.setVisible(bl);
            this.qaContactField.setVisible(bl);
        }
        boolean bl4 = bl2 || !(bugzillaIssue.getBugzillaRepository() instanceof KenaiRepository);
        this.statusWhiteboardLabel.setVisible(bl4);
        this.statusWhiteboardField.setVisible(bl4);
        this.statusWhiteboardWarning.setVisible(bl4);
        boolean bl5 = BugzillaUtil.isNbRepository(bugzillaIssue.getRepository());
        this.issueTypeLabel.setVisible(false);
        this.issueTypeCombo.setVisible(bl5);
        this.issueTypeWarning.setVisible(bl5);
        this.severityCombo.setVisible(!bl5);
        this.severityWarning.setVisible(!bl5);
        if (bl5) {
            object = (Node[])this.getLayout();
            JLabel jLabel = new JLabel();
            IssuePanel.swap((GroupLayout)object, this.severityCombo, this.issueTypeCombo, jLabel);
            IssuePanel.swap((GroupLayout)object, this.severityWarning, this.issueTypeWarning, jLabel);
        }
        this.tasklistButton.setEnabled(false);
        this.reloadForm(true);
        if (BugtrackingUtil.isNbRepository((Repository)bugzillaIssue.getRepository())) {
            object = bugzillaIssue.getSelection();
            if (object == null) {
                object = WindowManager.getDefault().getRegistry().getActivatedNodes();
            }
            this.ownerInfo = ((BugzillaRepository)bugzillaIssue.getRepository()).getOwnerInfo((Node[])object);
        }
        this.selectProduct();
        object = this.ccField.getPreferredSize();
        int n = Math.max(this.osCombo.getPreferredSize().width, this.platformCombo.getPreferredSize().width);
        int n2 = Math.max(this.priorityCombo.getPreferredSize().width, bl5 ? this.issueTypeCombo.getPreferredSize().width : this.severityCombo.getPreferredSize().width);
        int n3 = LayoutStyle.getSharedInstance().getPreferredGap((JComponent)this.osCombo, (JComponent)this.platformCombo, 0, 3, (Container)this);
        this.ccField.setPreferredSize(new Dimension(2 * Math.max(n, n2) + n3, object.height));
    }

    private void selectProduct() {
        if (this.ownerInfo != null) {
            String string = this.findInModel(this.productCombo, this.ownerInfo.getOwner());
            this.selectInCombo(this.productCombo, string, true);
            List list = this.ownerInfo.getExtraData();
            if (list != null && list.size() > 0) {
                String string2 = this.findInModel(this.componentCombo, (String)list.get(0));
                this.selectInCombo(this.componentCombo, string2, true);
            }
        } else if (this.issue.getRepository() instanceof KenaiRepository) {
            String string = ((KenaiRepository)this.issue.getRepository()).getProductName();
            this.selectInCombo(this.productCombo, string, true);
        }
    }

    private String findInModel(JComboBox jComboBox, String string) {
        ComboBoxModel comboBoxModel = jComboBox.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            String string2 = comboBoxModel.getElementAt(i).toString();
            if (!string.toLowerCase().equals(string2.toString().toLowerCase())) continue;
            return string2;
        }
        return null;
    }

    private static void swap(GroupLayout groupLayout, JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        groupLayout.replace((Component)jComponent, (Component)jComponent3);
        groupLayout.replace((Component)jComponent2, (Component)jComponent);
        groupLayout.replace((Component)jComponent3, (Component)jComponent2);
    }

    private void reloadForm(boolean bl) {
        String string;
        if (this.skipReload) {
            return;
        }
        int n = this.fieldWarnings.size();
        int n2 = this.fieldErrors.size();
        if (bl) {
            this.fieldWarnings.clear();
            this.fieldErrors.clear();
        }
        this.reloading = true;
        boolean bl2 = this.issue.getTaskData().isNew();
        boolean bl3 = bl2 || !(this.issue.getRepository() instanceof KenaiRepository) || BugzillaUtil.isNbRepository(this.issue.getRepository());
        GroupLayout groupLayout = (GroupLayout)this.getLayout();
        if (bl3) {
            if (this.productCombo.getParent() == null) {
                groupLayout.replace((Component)this.productField, (Component)this.productCombo);
            }
        } else if (this.productField.getParent() == null) {
            groupLayout.replace((Component)this.productCombo, (Component)this.productField);
        }
        this.productLabel.setLabelFor(bl2 ? this.productCombo : this.productField);
        this.headerLabel.setVisible(!bl2);
        this.statusCombo.setEnabled(!bl2);
        Mnemonics.setLocalizedText((JLabel)this.addCommentLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)(bl2 ? "IssuePanel.description" : "IssuePanel.addCommentLabel.text")));
        this.reportedLabel.setVisible(!bl2);
        this.reportedField.setVisible(!bl2);
        this.modifiedLabel.setVisible(!bl2);
        this.modifiedField.setVisible(!bl2);
        this.separator.setVisible(!bl2);
        this.commentsPanel.setVisible(!bl2);
        this.attachmentsLabel.setVisible(!bl2);
        this.attachmentsPanel.setVisible(!bl2);
        this.refreshButton.setVisible(!bl2);
        this.separatorLabel.setVisible(!bl2);
        this.cancelButton.setVisible(!bl2);
        this.assignedField.setEditable(this.issue.isNew() || this.issue.canReassign());
        this.assignedCombo.setEnabled(this.assignedField.isEditable());
        Mnemonics.setLocalizedText((AbstractButton)this.submitButton, (String)NbBundle.getMessage(IssuePanel.class, (String)(bl2 ? "IssuePanel.submitButton.text.new" : "IssuePanel.submitButton.text")));
        if (bl2 && bl) {
            this.selectProduct();
            this.initStatusCombo("NEW");
        } else {
            Object object;
            String string2;
            Object object2;
            String string3;
            Object object3;
            String string4 = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.headerLabel.format");
            string = MessageFormat.format(string4, this.issue.getID(), this.issue.getSummary());
            this.headerLabel.setText(string);
            Dimension dimension = this.headerLabel.getPreferredSize();
            this.headerLabel.setMinimumSize(new Dimension(0, dimension.height));
            this.headerLabel.setPreferredSize(new Dimension(0, dimension.height));
            this.reloadField(bl, this.summaryField, BugzillaIssue.IssueField.SUMMARY, this.summaryWarning, this.summaryLabel);
            this.reloadField(bl, this.productCombo, BugzillaIssue.IssueField.PRODUCT, this.productWarning, this.productLabel);
            this.reloadField(bl, this.productField, BugzillaIssue.IssueField.PRODUCT, null, null);
            this.reloadField(bl, this.componentCombo, BugzillaIssue.IssueField.COMPONENT, this.componentWarning, this.componentLabel);
            this.reloadField(bl, this.versionCombo, BugzillaIssue.IssueField.VERSION, this.versionWarning, this.versionLabel);
            this.reloadField(bl, this.platformCombo, BugzillaIssue.IssueField.PLATFORM, this.platformWarning, this.platformLabel);
            this.reloadField(bl, this.osCombo, BugzillaIssue.IssueField.OS, this.osWarning, this.platformLabel);
            this.reloadField(bl, this.resolutionField, BugzillaIssue.IssueField.RESOLUTION, null, null);
            String string5 = this.reloadField(bl, this.statusCombo, BugzillaIssue.IssueField.STATUS, this.statusWarning, this.statusLabel);
            this.initStatusCombo(string5);
            this.reloadField(bl, this.resolutionCombo, BugzillaIssue.IssueField.RESOLUTION, this.resolutionWarning, this.resolutionLabel);
            String string6 = this.initialValues.get((Object)BugzillaIssue.IssueField.RESOLUTION);
            if ("DUPLICATE".equals(string6)) {
                this.duplicateField.setEditable(false);
                this.duplicateField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.duplicateField.setBackground(this.getBackground());
            } else {
                JTextField jTextField = new JTextField();
                this.duplicateField.setEditable(true);
                this.duplicateField.setBorder(jTextField.getBorder());
                this.duplicateField.setBackground(jTextField.getBackground());
            }
            this.reloadField(bl, this.priorityCombo, BugzillaIssue.IssueField.PRIORITY, this.priorityWarning, this.priorityLabel);
            if (BugzillaUtil.isNbRepository(this.issue.getRepository())) {
                this.reloadField(bl, this.issueTypeCombo, BugzillaIssue.IssueField.ISSUE_TYPE, this.issueTypeWarning, this.issueTypeLabel);
            }
            this.reloadField(bl, this.severityCombo, BugzillaIssue.IssueField.SEVERITY, this.severityWarning, this.priorityLabel);
            if (this.usingTargetMilestones) {
                this.reloadField(bl, this.targetMilestoneCombo, BugzillaIssue.IssueField.MILESTONE, this.milestoneWarning, this.targetMilestoneLabel);
            }
            this.reloadField(bl, this.urlField, BugzillaIssue.IssueField.URL, this.urlWarning, this.urlLabel);
            this.reloadField(bl, this.statusWhiteboardField, BugzillaIssue.IssueField.WHITEBOARD, this.statusWhiteboardWarning, this.statusWhiteboardLabel);
            this.reloadField(bl, this.keywordsField, BugzillaIssue.IssueField.KEYWORDS, this.keywordsWarning, this.keywordsLabel);
            boolean bl4 = this.issue.getRepository() instanceof KenaiRepository;
            if (!bl2) {
                Date date;
                Object object4;
                string4 = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedLabel.format");
                object3 = this.issue.getCreatedDate();
                string3 = object3 != null ? DateFormat.getDateInstance(2).format((Date)object3) : "";
                String string7 = this.issue.getFieldValue(BugzillaIssue.IssueField.REPORTER_NAME);
                object2 = this.issue.getFieldValue(BugzillaIssue.IssueField.REPORTER);
                string2 = string7 == null || string7.trim().length() == 0 ? object2 : string7;
                object = MessageFormat.format(string4, string3, string2);
                this.reportedField.setText((String)object);
                IssuePanel.fixPrefSize(this.reportedField);
                if (bl4 && this.reportedStatusLabel.getIcon() == null) {
                    int n3 = ((String)object2).indexOf(64);
                    object4 = n3 == -1 ? object2 : ((String)object2).substring(0, n3);
                    KenaiUserUI kenaiUserUI = new KenaiUserUI((String)object4);
                    kenaiUserUI.setMessage(KenaiUtil.getChatLink((Issue)this.issue));
                    JLabel jLabel = kenaiUserUI.createUserWidget();
                    jLabel.setText(null);
                    ((GroupLayout)this.getLayout()).replace((Component)this.reportedStatusLabel, (Component)jLabel);
                    this.reportedStatusLabel = jLabel;
                }
                object4 = (date = this.issue.getCreatedDate()) != null ? DateFormat.getDateTimeInstance().format(date) : "";
                this.modifiedField.setText((String)object4);
                IssuePanel.fixPrefSize(this.modifiedField);
            }
            object3 = this.issue.getFieldValue(BugzillaIssue.IssueField.ASSIGNED_TO);
            String string8 = string3 = this.assignedField.getParent() == null ? this.assignedCombo.getSelectedItem().toString() : this.assignedField.getText();
            if (bl4 && ((String)object3).trim().length() > 0 && (bl || !string3.equals(object3))) {
                int n4 = ((String)object3).indexOf(64);
                object2 = n4 == -1 ? object3 : ((String)object3).substring(0, n4);
                string2 = new KenaiUserUI((String)object2);
                string2.setMessage(KenaiUtil.getChatLink((Issue)this.issue));
                object = string2.createUserWidget();
                ((JLabel)object).setText(null);
                ((GroupLayout)this.getLayout()).replace((Component)this.assignedToStatusLabel, (Component)object);
                ((JComponent)object).setVisible(this.assignedToStatusLabel.isVisible());
                this.assignedToStatusLabel = object;
            }
            if (bl) {
                this.assignedToStatusLabel.setVisible(((String)object3).trim().length() > 0);
            }
            if (this.assignedField.getParent() == null) {
                this.reloadField(bl, this.assignedCombo, BugzillaIssue.IssueField.ASSIGNED_TO, this.assignedToWarning, this.assignedLabel);
            } else {
                this.reloadField(bl, this.assignedField, BugzillaIssue.IssueField.ASSIGNED_TO, this.assignedToWarning, this.assignedLabel);
            }
            this.reloadField(bl, this.qaContactField, BugzillaIssue.IssueField.QA_CONTACT, this.qaContactWarning, this.qaContactLabel);
            this.reloadField(bl, this.ccField, BugzillaIssue.IssueField.CC, this.ccWarning, this.ccLabel);
            this.reloadField(bl, this.dependsField, BugzillaIssue.IssueField.DEPENDS_ON, this.dependsOnWarning, this.dependsLabel);
            this.reloadField(bl, this.blocksField, BugzillaIssue.IssueField.BLOCKS, this.blocksWarning, this.blocksLabel);
        }
        int n5 = this.issue.getComments().length;
        if (!bl && this.oldCommentCount != n5 && !this.fieldWarnings.contains(string = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.commentAddedWarning"))) {
            this.fieldWarnings.add(0, string);
        }
        this.oldCommentCount = n5;
        if (!bl2) {
            this.commentsPanel.setIssue(this.issue);
        }
        this.attachmentsPanel.setIssue(this.issue);
        BugtrackingUtil.keepFocusedComponentVisible((Component)this.commentsPanel);
        BugtrackingUtil.keepFocusedComponentVisible((Component)this.attachmentsPanel);
        if (bl) {
            this.addCommentArea.setText("");
        }
        this.updateTasklistButton();
        this.updateFieldStatuses();
        this.updateNoSummary();
        if (this.fieldWarnings.size() != n || this.fieldErrors.size() != n2) {
            this.updateMessagePanel();
        }
        this.reloading = false;
    }

    private static void fixPrefSize(JTextField jTextField) {
        jTextField.setPreferredSize(null);
        Dimension dimension = jTextField.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension.width + 1, dimension.height);
        jTextField.setPreferredSize(dimension2);
    }

    private String reloadField(boolean bl, JComponent jComponent, BugzillaIssue.IssueField issueField, JLabel jLabel, JLabel jLabel2) {
        boolean bl2;
        Object object;
        String string = null;
        if (this.issue.getTaskData().isNew()) {
            bl = true;
        }
        if (!bl) {
            if (jComponent instanceof JComboBox) {
                object = ((JComboBox)jComponent).getSelectedItem();
                string = object == null ? "" : object.toString();
            } else if (jComponent instanceof JTextField) {
                string = ((JTextField)jComponent).getText();
            }
        }
        object = this.initialValues.get((Object)issueField);
        String string2 = this.issue.getFieldValue(issueField);
        boolean bl3 = string != null && object != null && !string.equals(object);
        boolean bl4 = bl2 = object != null && string2 != null && !((String)object).equals(string2);
        if (bl || !bl3) {
            Object object2;
            if (jComponent instanceof JComboBox) {
                object2 = (JComboBox)jComponent;
                this.selectInCombo((JComboBox)object2, string2, true);
            } else if (jComponent instanceof JTextField) {
                ((JTextField)jComponent).setText(string2);
            }
            if (bl) {
                if (jLabel != null) {
                    jLabel.setIcon(null);
                }
            } else if (bl2 && jLabel != null) {
                jLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/warning.gif", (boolean)true));
                object2 = this.fieldName(jLabel2);
                String string3 = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.fieldModifiedWarning");
                String string4 = MessageFormat.format(string3, object2, string, string2);
                this.fieldWarnings.add(string4);
                jLabel.setToolTipText(string4);
            }
            string = string2;
        } else if (bl2 && jLabel != null) {
            jLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/error.gif", (boolean)true));
            String string5 = this.fieldName(jLabel2);
            String string6 = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.fieldModifiedError");
            String string7 = MessageFormat.format(string6, string5, string2);
            this.fieldErrors.add(string7);
            jLabel.setToolTipText(string7);
        }
        if (BugzillaIssue.IssueField.SUMMARY == issueField || BugzillaIssue.IssueField.PLATFORM == issueField || BugzillaIssue.IssueField.PRIORITY == issueField) {
            jLabel.setVisible(jLabel.getIcon() != null);
        }
        this.initialValues.put(issueField, string2);
        return string;
    }

    private boolean selectInCombo(JComboBox jComboBox, Object object, boolean bl) {
        ComboBoxModel comboBoxModel;
        if (object == null) {
            return false;
        }
        jComboBox.setSelectedItem(object);
        if (bl && !object.equals("") && !object.equals(jComboBox.getSelectedItem()) && (comboBoxModel = jComboBox.getModel()) instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)comboBoxModel).insertElementAt(object, 0);
            jComboBox.setSelectedIndex(0);
        }
        return object.equals(jComboBox.getSelectedItem());
    }

    private String fieldName(JLabel jLabel) {
        String string = jLabel.getText().trim();
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void initCombos() {
        BugzillaRepository bugzillaRepository = this.issue.getBugzillaRepository();
        BugzillaConfiguration bugzillaConfiguration = bugzillaRepository.getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return;
        }
        this.productCombo.setModel(this.toComboModel(bugzillaConfiguration.getProducts()));
        this.platformCombo.setModel(this.toComboModel(bugzillaConfiguration.getPlatforms()));
        this.osCombo.setModel(this.toComboModel(bugzillaConfiguration.getOSs()));
        LinkedList<String> linkedList = new LinkedList<String>(bugzillaConfiguration.getResolutions());
        linkedList.remove("MOVED");
        this.resolutionCombo.setModel(this.toComboModel(linkedList));
        this.priorityCombo.setModel(this.toComboModel(bugzillaConfiguration.getPriorities()));
        this.priorityCombo.setRenderer(new PriorityRenderer());
        this.severityCombo.setModel(this.toComboModel(bugzillaConfiguration.getSeverities()));
        this.initAssignedCombo();
        if (BugzillaUtil.isNbRepository(bugzillaRepository)) {
            this.issueTypeCombo.setModel(this.toComboModel(bugzillaConfiguration.getIssueTypes()));
        }
    }

    private void initAssignedCombo() {
        this.assignedCombo.setRenderer(new RepositoryUserRenderer());
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                BugzillaRepository bugzillaRepository = IssuePanel.this.issue.getBugzillaRepository();
                final Collection<RepositoryUser> collection = bugzillaRepository.getUsers();
                final DefaultComboBoxModel<RepositoryUser> defaultComboBoxModel = new DefaultComboBoxModel<RepositoryUser>();
                for (RepositoryUser repositoryUser : collection) {
                    defaultComboBoxModel.addElement(repositoryUser);
                }
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        IssuePanel.this.reloading = true;
                        try {
                            Object object;
                            Object object2 = object = IssuePanel.this.assignedField.getParent() == null ? IssuePanel.this.assignedCombo.getSelectedItem() : IssuePanel.this.assignedField.getText();
                            if (object == null) {
                                object = "";
                            }
                            IssuePanel.this.assignedCombo.setModel(defaultComboBoxModel);
                            GroupLayout groupLayout = (GroupLayout)IssuePanel.this.getLayout();
                            if (IssuePanel.this.assignedCombo.getParent() == null != collection.isEmpty()) {
                                groupLayout.replace((Component)(collection.isEmpty() ? IssuePanel.this.assignedCombo : IssuePanel.this.assignedField), (Component)(collection.isEmpty() ? IssuePanel.this.assignedField : IssuePanel.this.assignedCombo));
                                IssuePanel.this.assignedLabel.setLabelFor(collection.isEmpty() ? IssuePanel.this.assignedField : IssuePanel.this.assignedCombo);
                            }
                            if (IssuePanel.this.assignedField.getParent() == null) {
                                IssuePanel.this.assignedCombo.setSelectedItem(object);
                            } else {
                                IssuePanel.this.assignedField.setText(object.toString());
                            }
                        }
                        finally {
                            IssuePanel.this.reloading = false;
                        }
                    }
                });
            }
        });
    }

    private void initStatusCombo(String string) {
        BugzillaRepository bugzillaRepository = this.issue.getBugzillaRepository();
        BugzillaConfiguration bugzillaConfiguration = bugzillaRepository.getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return;
        }
        List<String> list = bugzillaConfiguration.getStatusValues();
        List<String> list2 = bugzillaConfiguration.getOpenStatusValues();
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = this.issue.getBugzillaRepository().getConfiguration().getInstalledVersion().compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2) < 0;
        String string2 = "NEW";
        String string3 = "UNCONFIRMED";
        String string4 = "REOPENED";
        String string5 = "RESOLVED";
        if (list2.contains(string)) {
            linkedList.addAll(list2);
            if (!string3.equals(string)) {
                linkedList.remove(string3);
            }
            if (!string4.equals(string)) {
                linkedList.remove(string4);
            }
            if (bl && !string2.equals(string)) {
                linkedList.remove(string2);
            }
            linkedList.add(string5);
        } else {
            if (list.contains(string4)) {
                linkedList.add(string4);
            } else {
                linkedList.addAll(list2);
                linkedList.remove(string3);
                if (bl) {
                    linkedList.remove(string2);
                }
            }
            if (string5.equals(string)) {
                LinkedList<String> linkedList2 = new LinkedList<String>(list);
                linkedList2.removeAll(list2);
                linkedList.addAll(linkedList2);
            } else {
                if (!bl) {
                    linkedList.add(string5);
                }
                if (!string.equals("")) {
                    for (int i = list.indexOf(string); i < list.size(); ++i) {
                        String string6 = list.get(i);
                        if (list2.contains(string6)) continue;
                        linkedList.add(string6);
                    }
                }
            }
            this.resolvedIndex = linkedList.indexOf(string5);
        }
        this.statusCombo.setModel(this.toComboModel(linkedList));
        this.statusCombo.setSelectedItem(string);
    }

    private ComboBoxModel toComboModel(List<String> list) {
        return new DefaultComboBoxModel<Object>(list.toArray());
    }

    private void updateFieldStatuses() {
        this.updateFieldStatus(BugzillaIssue.IssueField.PRODUCT, this.productLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.COMPONENT, this.componentLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.VERSION, this.versionLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.PLATFORM, this.platformLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.OS, this.platformLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.STATUS, this.statusLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.RESOLUTION, this.resolutionLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.PRIORITY, this.priorityLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.SEVERITY, this.priorityLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.MILESTONE, this.targetMilestoneLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.URL, this.urlLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.WHITEBOARD, this.statusWhiteboardLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.KEYWORDS, this.keywordsLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.ASSIGNED_TO, this.assignedLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.QA_CONTACT, this.qaContactLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.CC, this.ccLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.DEPENDS_ON, this.dependsLabel);
        this.updateFieldStatus(BugzillaIssue.IssueField.BLOCKS, this.blocksLabel);
        if (BugzillaUtil.isNbRepository(this.issue.getRepository())) {
            this.updateFieldStatus(BugzillaIssue.IssueField.ISSUE_TYPE, this.issueTypeLabel);
        }
    }

    private void updateFieldStatus(BugzillaIssue.IssueField issueField, JLabel jLabel) {
        boolean bl = !this.issue.getTaskData().isNew() && this.issue.getFieldStatus(issueField) != 1;
        jLabel.setOpaque(bl);
        if (bl) {
            jLabel.setBackground(HIGHLIGHT_COLOR);
        }
    }

    private void cancelHighlight(JLabel jLabel) {
        if (!this.reloading) {
            jLabel.setOpaque(false);
            jLabel.getParent().repaint();
        }
    }

    private void storeFieldValue(BugzillaIssue.IssueField issueField, JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        if (object != null) {
            this.storeFieldValue(issueField, object.toString());
        }
    }

    private void storeFieldValue(BugzillaIssue.IssueField issueField, JTextComponent jTextComponent) {
        this.storeFieldValue(issueField, jTextComponent.getText());
    }

    private void storeFieldValue(BugzillaIssue.IssueField issueField, String string) {
        if (this.issue.getTaskData().isNew() || !string.equals(this.initialValues.get((Object)issueField))) {
            if (issueField == BugzillaIssue.IssueField.STATUS) {
                if (string.equals("CLOSED")) {
                    this.issue.close();
                } else if (string.equals("VERIFIED")) {
                    this.issue.verify();
                } else if (string.equals("REOPENED")) {
                    this.issue.reopen();
                } else if (string.equals("RESOLVED")) {
                    this.issue.resolve(this.resolutionCombo.getSelectedItem().toString());
                } else if (string.equals("ASSIGNED")) {
                    this.issue.accept();
                }
            } else if (issueField == BugzillaIssue.IssueField.ASSIGNED_TO && !this.issue.isNew()) {
                this.issue.reassign(string);
            }
            this.issue.setFieldValue(issueField, string);
        }
    }

    private void attachDocumentListeners() {
        this.urlField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.urlLabel));
        this.statusWhiteboardField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.statusWhiteboardLabel));
        this.keywordsField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.keywordsLabel));
        this.assignedField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.assignedLabel));
        this.qaContactField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.qaContactLabel));
        this.ccField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.ccLabel));
        this.blocksField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.blocksLabel));
        this.dependsField.getDocument().addDocumentListener(new CancelHighlightDocumentListener(this.dependsLabel));
        CyclicDependencyDocumentListener cyclicDependencyDocumentListener = new CyclicDependencyDocumentListener();
        this.blocksField.getDocument().addDocumentListener(cyclicDependencyDocumentListener);
        this.dependsField.getDocument().addDocumentListener(cyclicDependencyDocumentListener);
        this.addCommentArea.getDocument().addDocumentListener(new RevalidatingListener());
    }

    private void attachHideStatusListener() {
        this.assignedField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (!IssuePanel.this.reloading) {
                    IssuePanel.this.assignedToStatusLabel.setVisible(false);
                }
            }
        });
    }

    private void updateNoSummary() {
        if (this.summaryField.getText().trim().length() == 0) {
            if (!this.noSummary) {
                this.noSummary = true;
                this.updateMessagePanel();
            }
        } else if (this.noSummary) {
            this.noSummary = false;
            this.updateMessagePanel();
        }
    }

    private void updateInvalidKeyword() {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(this.keywordsField.getText(), ", \t\n\r\f");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (this.keywords.contains(string.toUpperCase())) continue;
            bl = true;
            break;
        }
        if (bl != this.invalidKeyword) {
            this.invalidKeyword = bl;
            this.updateMessagePanel();
        }
    }

    private void updateNoComponent() {
        boolean bl;
        boolean bl2 = bl = this.componentCombo.getSelectedItem() == null;
        if (this.noComponent != bl) {
            this.noComponent = bl;
            this.updateMessagePanel();
        }
    }

    private void updateNoVersion() {
        boolean bl;
        boolean bl2 = bl = this.versionCombo.getSelectedItem() == null;
        if (this.noVersion != bl) {
            this.noVersion = bl;
            this.updateMessagePanel();
        }
    }

    private void updateNoTargetMilestone() {
        boolean bl;
        boolean bl2 = bl = this.targetMilestoneCombo.getSelectedItem() == null;
        if (this.noTargetMilestione != bl) {
            this.noTargetMilestione = bl;
            this.updateMessagePanel();
        }
    }

    private void updateMessagePanel() {
        JLabel jLabel;
        Iterator<String> iterator;
        this.messagePanel.removeAll();
        if (this.noComponent) {
            this.addMessage("IssuePanel.noComponent");
        }
        if (this.noVersion) {
            this.addMessage("IssuePanel.noVersion");
        }
        if (this.noTargetMilestione) {
            this.addMessage("IssuePanel.noTargetMilestone");
        }
        if (this.noSummary) {
            iterator = new JLabel();
            ((JLabel)((Object)iterator)).setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.noSummary"));
            String string = this.issue.getTaskData().isNew() ? "org/netbeans/modules/bugzilla/resources/info.png" : "org/netbeans/modules/bugzilla/resources/error.gif";
            ((JLabel)((Object)iterator)).setIcon(new ImageIcon(ImageUtilities.loadImage((String)string)));
            this.messagePanel.add((Component)((Object)iterator));
        }
        if (this.cyclicDependency) {
            iterator = new JLabel();
            ((JLabel)((Object)iterator)).setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cyclicDependency"));
            ((JLabel)((Object)iterator)).setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugzilla/resources/error.gif")));
            this.messagePanel.add((Component)((Object)iterator));
        }
        if (this.invalidKeyword) {
            iterator = new JLabel();
            ((JLabel)((Object)iterator)).setText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.invalidKeyword"));
            ((JLabel)((Object)iterator)).setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugzilla/resources/error.gif")));
            this.messagePanel.add((Component)((Object)iterator));
        }
        if (this.noSummary || this.cyclicDependency || this.invalidKeyword || this.noComponent || this.noVersion || this.noTargetMilestione) {
            this.submitButton.setEnabled(false);
        } else {
            this.submitButton.setEnabled(true);
        }
        for (String string : this.fieldErrors) {
            jLabel = new JLabel(string);
            jLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/error.gif", (boolean)true));
            this.messagePanel.add(jLabel);
        }
        for (String string : this.fieldWarnings) {
            jLabel = new JLabel(string);
            jLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugzilla/resources/warning.gif", (boolean)true));
            this.messagePanel.add(jLabel);
        }
        if (this.noSummary || this.cyclicDependency || this.invalidKeyword || this.noComponent || this.noVersion || this.noTargetMilestione || this.fieldErrors.size() + this.fieldWarnings.size() > 0) {
            this.messagePanel.setVisible(true);
            this.messagePanel.revalidate();
        } else {
            this.messagePanel.setVisible(false);
        }
    }

    void addMessage(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(NbBundle.getMessage(IssuePanel.class, (String)string));
        String string2 = this.issue.getTaskData().isNew() ? "org/netbeans/modules/bugzilla/resources/info.png" : "org/netbeans/modules/bugzilla/resources/error.gif";
        jLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)string2)));
        this.messagePanel.add(jLabel);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.issue != null) {
            this.reloadForm(true);
            this.issue.opened();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.issue != null) {
            this.issue.closed();
        }
    }

    private void enableComponents(boolean bl) {
        this.enableComponents(this, bl);
        if (bl) {
            this.enableMap.clear();
        }
    }

    private void enableComponents(Component component, boolean bl) {
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.enableComponents(component2, bl);
            }
        }
        if (component instanceof JComboBox || component instanceof JTextComponent && ((JTextComponent)component).isEditable() || component instanceof AbstractButton) {
            if (bl) {
                Boolean bl2 = this.enableMap.get(component);
                if (bl2 != null) {
                    component.setEnabled(bl2);
                }
            } else {
                this.enableMap.put(component, component.isEnabled());
                component.setEnabled(false);
            }
        }
    }

    private void attachTasklistListener(BugzillaIssueProvider bugzillaIssueProvider) {
        if (this.tasklistListener == null) {
            this.tasklistListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("issue-removed".equals(propertyChangeEvent.getPropertyName()) && ((Object)((Object)IssuePanel.this.issue)).equals(propertyChangeEvent.getOldValue())) {
                        Runnable runnable = new Runnable(){

                            public void run() {
                                IssuePanel.this.updateTasklistButton();
                            }
                        };
                        if (EventQueue.isDispatchThread()) {
                            runnable.run();
                        } else {
                            EventQueue.invokeLater(runnable);
                        }
                    }
                }
            };
            bugzillaIssueProvider.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.tasklistListener, (Object)bugzillaIssueProvider));
        }
    }

    private void updateTasklistButton() {
        this.tasklistButton.setEnabled(false);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                BugzillaIssueProvider bugzillaIssueProvider = BugzillaIssueProvider.getInstance();
                if (bugzillaIssueProvider == null || IssuePanel.this.issue.isNew()) {
                    return;
                }
                final boolean bl = bugzillaIssueProvider.isAdded(IssuePanel.this.issue);
                if (bl) {
                    IssuePanel.this.attachTasklistListener(bugzillaIssueProvider);
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        String string = NbBundle.getMessage(IssuePanel.class, (String)(bl ? "IssuePanel.tasklistButton.remove" : "IssuePanel.tasklistButton.add"));
                        IssuePanel.this.tasklistButton.setText(string);
                        IssuePanel.this.tasklistButton.setEnabled(true);
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.productField = new JTextField();
        this.resolutionCombo = new JComboBox();
        this.assignedCombo = new JComboBox();
        this.reportedField = new JTextField();
        this.dependsOnWarning = new JLabel();
        this.osWarning = new JLabel();
        this.messagePanel = new JPanel();
        this.ccWarning = new JLabel();
        this.dummyAttachmentsPanel = new JPanel();
        this.qaContactWarning = new JLabel();
        this.assignedToWarning = new JLabel();
        this.reportedStatusLabel = new JLabel();
        this.blocksButton = new JButton();
        this.modifiedField = new JTextField();
        this.blocksLabel = new JLabel();
        this.modifiedLabel = new JLabel();
        this.dependsOnButton = new JButton();
        this.dependsField = new JTextField();
        this.dependsLabel = new JLabel();
        this.reportedLabel = new JLabel();
        this.resolutionField = new JTextField();
        this.duplicateButton = new JButton();
        this.statusCombo = new JComboBox();
        this.duplicateField = new JTextField();
        this.statusLabel = new JLabel();
        this.duplicateLabel = new JLabel();
        this.osCombo = new JComboBox();
        this.summaryWarning = new JLabel();
        this.ccField = new JTextField();
        this.ccLabel = new JLabel();
        this.qaContactLabel = new JLabel();
        this.blocksWarning = new JLabel();
        this.assignedField = new JTextField();
        this.resolutionWarning = new JLabel();
        this.assignedLabel = new JLabel();
        this.statusWarning = new JLabel();
        this.keywordsWarning = new JLabel();
        this.milestoneWarning = new JLabel();
        this.severityWarning = new JLabel();
        this.platformWarning = new JLabel();
        this.versionWarning = new JLabel();
        this.productWarning = new JLabel();
        this.addCommentLabel = new JLabel();
        this.attachmentsLabel = new JLabel();
        this.summaryLabel = new JLabel();
        this.assignedToStatusLabel = new JLabel();
        this.keywordsButton = new JButton();
        this.dummyLabel2 = new JLabel();
        this.keywordsLabel = new JLabel();
        this.targetMilestoneCombo = new JComboBox();
        this.blocksField = new JTextField();
        this.severityCombo = new JComboBox();
        this.priorityLabel = new JLabel();
        this.dummyLabel1 = new JLabel();
        this.componentCombo = new JComboBox();
        this.productCombo = new JComboBox();
        this.dummyCommentsPanel = new JPanel();
        this.separator = new JSeparator();
        this.headerLabel = new JLabel();
        this.refreshButton = new LinkButton();
        this.reloadButton = new LinkButton();
        this.separatorLabel = new JLabel();
        this.resolutionLabel = new JLabel();
        this.tasklistButton = new LinkButton();
        this.separatorLabel2 = new JLabel();
        this.productLabel = new JLabel();
        this.componentLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.versionCombo = new JComboBox();
        this.platformCombo = new JComboBox();
        this.platformLabel = new JLabel();
        this.priorityCombo = new JComboBox();
        this.priorityWarning = new JLabel();
        this.targetMilestoneLabel = new JLabel();
        this.qaContactField = new JTextField();
        this.urlLabel = new JLabel();
        this.keywordsField = new JTextField();
        this.urlField = new JTextField();
        this.statusWhiteboardLabel = new JLabel();
        this.statusWhiteboardField = new JTextField();
        this.issueTypeLabel = new JLabel();
        this.issueTypeCombo = new JComboBox();
        this.dummyLabel3 = new JLabel();
        this.summaryField = new JTextField();
        this.urlWarning = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.addCommentArea = new JTextArea(){

            public Dimension getPreferredScrollableViewportSize() {
                Serializable serializable;
                Dimension dimension = super.getPreferredScrollableViewportSize();
                JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
                int n = 0;
                if (jScrollPane != null) {
                    serializable = jScrollPane.getHorizontalScrollBar();
                    n = ((Component)serializable).isVisible() ? ((Component)serializable).getHeight() : 0;
                }
                serializable = this.getInsets();
                int n2 = 5 * this.getRowHeight() + ((Insets)serializable).top + ((Insets)serializable).bottom;
                dimension = new Dimension(dimension.width, n + (dimension.height < n2 ? n2 : dimension.height));
                return dimension;
            }
        };
        this.submitButton = new JButton();
        this.cancelButton = new JButton();
        this.componentWarning = new JLabel();
        this.statusWhiteboardWarning = new JLabel();
        this.issueTypeWarning = new JLabel();
        FormListener formListener = new FormListener();
        this.productField.setEditable(false);
        this.productField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.productField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productField.AccessibleContext.accessibleDescription"));
        this.resolutionCombo.addActionListener(formListener);
        this.resolutionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionCombo.AccessibleContext.accessibleDescription"));
        this.assignedCombo.setEditable(true);
        this.assignedCombo.addActionListener(formListener);
        this.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        this.reportedField.setEditable(false);
        this.reportedField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 3));
        Mnemonics.setLocalizedText((AbstractButton)this.blocksButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.text"));
        this.blocksButton.setFocusPainted(false);
        this.blocksButton.setMargin(new Insets(0, 0, 0, 0));
        this.blocksButton.addActionListener(formListener);
        this.modifiedField.setEditable(false);
        this.modifiedField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.blocksLabel.setLabelFor(this.blocksField);
        Mnemonics.setLocalizedText((JLabel)this.blocksLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksLabel.text"));
        this.modifiedLabel.setLabelFor(this.modifiedField);
        Mnemonics.setLocalizedText((JLabel)this.modifiedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.modifiedLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.dependsOnButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.text"));
        this.dependsOnButton.setFocusPainted(false);
        this.dependsOnButton.setMargin(new Insets(0, 0, 0, 0));
        this.dependsOnButton.addActionListener(formListener);
        this.dependsField.setColumns(15);
        this.dependsLabel.setLabelFor(this.dependsField);
        Mnemonics.setLocalizedText((JLabel)this.dependsLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsLabel.text"));
        this.reportedLabel.setLabelFor(this.reportedField);
        Mnemonics.setLocalizedText((JLabel)this.reportedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedLabel.text"));
        this.resolutionField.setEditable(false);
        this.resolutionField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.text"));
        this.duplicateButton.setFocusPainted(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.addActionListener(formListener);
        this.statusCombo.addActionListener(formListener);
        this.duplicateField.setColumns(15);
        this.statusLabel.setLabelFor(this.statusCombo);
        Mnemonics.setLocalizedText((JLabel)this.statusLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.statusLabel.text"));
        this.duplicateLabel.setLabelFor(this.duplicateField);
        Mnemonics.setLocalizedText((JLabel)this.duplicateLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateLabel.text"));
        this.osCombo.addActionListener(formListener);
        this.ccLabel.setLabelFor(this.ccField);
        Mnemonics.setLocalizedText((JLabel)this.ccLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.ccLabel.text"));
        this.qaContactLabel.setLabelFor(this.qaContactField);
        Mnemonics.setLocalizedText((JLabel)this.qaContactLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.qaContactLabel.text"));
        this.assignedLabel.setLabelFor(this.assignedField);
        Mnemonics.setLocalizedText((JLabel)this.assignedLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.assignedLabel.text"));
        this.addCommentLabel.setLabelFor(this.addCommentArea);
        Mnemonics.setLocalizedText((JLabel)this.addCommentLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.addCommentLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.attachmentsLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.attachmentsLabel.text"));
        this.summaryLabel.setLabelFor(this.summaryField);
        Mnemonics.setLocalizedText((JLabel)this.summaryLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.summaryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.keywordsButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.text"));
        this.keywordsButton.setFocusPainted(false);
        this.keywordsButton.setMargin(new Insets(0, 0, 0, 0));
        this.keywordsButton.addActionListener(formListener);
        this.keywordsLabel.setLabelFor(this.keywordsField);
        Mnemonics.setLocalizedText((JLabel)this.keywordsLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsLabel.text"));
        this.targetMilestoneCombo.addActionListener(formListener);
        this.blocksField.setColumns(15);
        this.severityCombo.addActionListener(formListener);
        this.priorityLabel.setLabelFor(this.priorityCombo);
        Mnemonics.setLocalizedText((JLabel)this.priorityLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.priorityLabel.text"));
        this.componentCombo.addActionListener(formListener);
        this.productCombo.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.text"));
        this.refreshButton.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.toolTipText"));
        this.refreshButton.addActionListener((ActionListener)formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.reloadButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reloadButton.text"));
        this.reloadButton.setToolTipText(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reloadButton.toolTipText"));
        this.reloadButton.addActionListener((ActionListener)formListener);
        this.separatorLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        Mnemonics.setLocalizedText((JLabel)this.resolutionLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.tasklistButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.tasklistButton.add"));
        this.tasklistButton.addActionListener((ActionListener)formListener);
        this.separatorLabel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        Mnemonics.setLocalizedText((JLabel)this.productLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productLabel.text"));
        this.componentLabel.setLabelFor(this.componentCombo);
        Mnemonics.setLocalizedText((JLabel)this.componentLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.componentLabel.text"));
        this.versionLabel.setLabelFor(this.versionCombo);
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.versionLabel.text"));
        this.versionCombo.addActionListener(formListener);
        this.platformCombo.addActionListener(formListener);
        this.platformLabel.setLabelFor(this.platformCombo);
        Mnemonics.setLocalizedText((JLabel)this.platformLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.platformLabel.text"));
        this.priorityCombo.addActionListener(formListener);
        this.targetMilestoneLabel.setLabelFor(this.targetMilestoneCombo);
        Mnemonics.setLocalizedText((JLabel)this.targetMilestoneLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.targetMilestoneLabel.text"));
        this.urlLabel.setLabelFor(this.urlField);
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.urlLabel.text"));
        this.keywordsField.setColumns(15);
        this.urlField.setColumns(15);
        Mnemonics.setLocalizedText((JLabel)this.statusWhiteboardLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.statusWhiteboardLabel.text"));
        this.statusWhiteboardField.setColumns(15);
        Mnemonics.setLocalizedText((JLabel)this.issueTypeLabel, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.issueTypeLabel.text"));
        this.issueTypeCombo.addActionListener(formListener);
        this.scrollPane1.setVerticalScrollBarPolicy(21);
        this.scrollPane1.setViewportView(this.addCommentArea);
        this.addCommentArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.addCommentArea.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.submitButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitButton.text"));
        this.submitButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cancelButton.text"));
        this.cancelButton.addActionListener(formListener);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.separator).add((Component)this.dummyCommentsPanel, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.headerLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.tasklistButton, -2, -1, -2).addPreferredGap(0).add((Component)this.separatorLabel2).addPreferredGap(0).add((Component)this.refreshButton, -2, -1, -2).addPreferredGap(0).add((Component)this.separatorLabel).addPreferredGap(0).add((Component)this.reloadButton, -2, -1, -2).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.urlLabel).add((Component)this.componentLabel).add((Component)this.productLabel).add((Component)this.versionLabel).add((Component)this.platformLabel).add((Component)this.dummyLabel1).add((Component)this.priorityLabel).add((Component)this.targetMilestoneLabel).add((Component)this.dummyLabel2).add((Component)this.keywordsLabel).add((Component)this.statusWhiteboardLabel).add((Component)this.issueTypeLabel).add((Component)this.dummyLabel3).add((Component)this.summaryLabel).add((Component)this.attachmentsLabel).add((Component)this.addCommentLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.dummyAttachmentsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.issueTypeCombo, 0, -1, Short.MAX_VALUE).add((Component)this.statusWhiteboardField, 0, 0, Short.MAX_VALUE).add((Component)this.urlField, 0, 0, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.keywordsField, 0, 0, Short.MAX_VALUE).add(0, 0, 0).add((Component)this.keywordsButton)).add((Component)this.targetMilestoneCombo, 0, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.priorityCombo, -2, -1, -2).addPreferredGap(0).add((Component)this.priorityWarning, -2, 16, -2).addPreferredGap(0).add((Component)this.severityCombo, -2, -1, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.platformCombo, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.platformWarning, -2, 16, -2).addPreferredGap(0).add((Component)this.osCombo, -2, -1, -2)).add((Component)this.versionCombo, 0, -1, Short.MAX_VALUE).add((Component)this.componentCombo, 0, -1, Short.MAX_VALUE).add((Component)this.productCombo, 0, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.componentWarning, -2, 16, -2).add((Component)this.productWarning, -2, 16, -2).add((Component)this.versionWarning, -2, 16, -2).add((Component)this.osWarning, -2, 16, -2).add((Component)this.issueTypeWarning, -2, 16, -2).add((Component)this.severityWarning, -2, 16, -2).add((Component)this.milestoneWarning, -2, 16, -2).add((Component)this.urlWarning, -2, 16, -2).add((Component)this.keywordsWarning, -2, 16, -2).add((Component)this.statusWhiteboardWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.reportedLabel).add(2, (Component)this.blocksLabel).add(2, (Component)this.assignedLabel).add(2, (Component)this.qaContactLabel).add(2, (Component)this.ccLabel).add(2, (Component)this.statusLabel).add(2, (Component)this.resolutionLabel).add(2, (Component)this.dependsLabel).add(2, (Component)this.duplicateLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.ccField).add((Component)this.qaContactField).add((Component)this.assignedField).add((Component)this.statusCombo, 0, -1, Short.MAX_VALUE).add((Component)this.resolutionField).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.duplicateField).add(0, 0, 0).add((Component)this.duplicateButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.dependsField).add(0, 0, 0).add((Component)this.dependsOnButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.blocksField).add(0, 0, 0).add((Component)this.blocksButton))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.assignedToStatusLabel).addPreferredGap(0).add((Component)this.assignedToWarning, -2, 16, -2)).add((Component)this.qaContactWarning, -2, 16, -2).add((Component)this.ccWarning, -2, 16, -2).add((Component)this.statusWarning, -2, 16, -2).add((Component)this.resolutionWarning, -2, 11, -2).add((Component)this.blocksWarning, -2, 16, -2).add((Component)this.dependsOnWarning, -2, 16, -2))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.reportedField, -2, -1, -2).addPreferredGap(0).add((Component)this.reportedStatusLabel).addPreferredGap(1).add((Component)this.modifiedLabel).addPreferredGap(0).add((Component)this.modifiedField, -2, -1, -2))).addContainerGap(20, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.scrollPane1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.summaryField).addPreferredGap(0).add((Component)this.summaryWarning, -2, 9, -2)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.submitButton).addPreferredGap(0).add((Component)this.cancelButton)).add(1, (Component)this.messagePanel, -1, -1, Short.MAX_VALUE)).add(10, 10, 10)))))));
        groupLayout.linkSize(new Component[]{this.osCombo, this.platformCombo, this.priorityCombo, this.severityCombo}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.headerLabel).add((Component)this.separatorLabel2).add((Component)this.tasklistButton, -2, -1, -2).add((Component)this.separatorLabel).add((Component)this.reloadButton, -2, -1, -2).add((Component)this.refreshButton, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.productLabel).add((Component)this.productCombo, -2, -1, -2).add((Component)this.productWarning, -2, 16, -2).add((Component)this.reportedLabel).add((Component)this.reportedField, -2, -1, -2).add((Component)this.modifiedLabel).add((Component)this.modifiedField, -2, -1, -2).add((Component)this.reportedStatusLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.componentLabel).add((Component)this.componentCombo, -2, -1, -2).add((Component)this.componentWarning, -2, 16, -2).add((Component)this.assignedLabel).add((Component)this.assignedField, -2, -1, -2).add((Component)this.assignedToStatusLabel).add((Component)this.assignedToWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.versionLabel).add((Component)this.versionCombo, -2, -1, -2).add((Component)this.versionWarning, -2, 16, -2).add((Component)this.qaContactLabel).add((Component)this.qaContactField, -2, -1, -2).add((Component)this.qaContactWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.platformLabel).add((Component)this.platformCombo, -2, -1, -2).add((Component)this.ccLabel).add((Component)this.ccField, -2, -1, -2).add((Component)this.platformWarning, -2, 16, -2).add((Component)this.osCombo, -2, -1, -2).add((Component)this.ccWarning, -2, 16, -2).add((Component)this.osWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.issueTypeLabel).add((Component)this.issueTypeCombo, -2, -1, -2).add((Component)this.issueTypeWarning, -2, 16, -2)).addPreferredGap(0).add((Component)this.dummyLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.priorityLabel).add((Component)this.priorityCombo, -2, -1, -2).add((Component)this.priorityWarning, -2, 16, -2).add((Component)this.severityCombo, -2, -1, -2).add((Component)this.severityWarning, -2, 16, -2).add((Component)this.statusLabel).add((Component)this.statusCombo, -2, -1, -2).add((Component)this.statusWarning, -2, 16, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.targetMilestoneLabel).add((Component)this.targetMilestoneCombo, -2, -1, -2).add((Component)this.milestoneWarning, -2, 16, -2).add((Component)this.resolutionLabel).add((Component)this.resolutionField, -2, -1, -2).add((Component)this.resolutionWarning, -2, 11, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.dummyLabel2).add((Component)this.duplicateLabel).add((Component)this.duplicateField, -2, -1, -2).add((Component)this.duplicateButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.urlLabel).add((Component)this.urlField, -2, -1, -2).add((Component)this.urlWarning, -2, 16, -2).add((Component)this.dependsLabel).add((Component)this.dependsField, -2, -1, -2).add((Component)this.dependsOnWarning, -2, 16, -2).add((Component)this.dependsOnButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.keywordsLabel).add((Component)this.keywordsField, -2, -1, -2).add((Component)this.keywordsButton).add((Component)this.keywordsWarning, -2, 16, -2).add((Component)this.blocksLabel).add((Component)this.blocksField, -2, -1, -2).add((Component)this.blocksWarning, -2, 16, -2).add((Component)this.blocksButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.statusWhiteboardLabel).add((Component)this.statusWhiteboardField, -2, -1, -2).add((Component)this.statusWhiteboardWarning, -2, 16, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.attachmentsLabel).addPreferredGap(0).add((Component)this.dummyLabel3)).add((Component)this.dummyAttachmentsPanel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.summaryLabel).add((Component)this.summaryField, -2, -1, -2).add((Component)this.summaryWarning, -2, 12, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addCommentLabel).add((Component)this.scrollPane1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.submitButton).add((Component)this.cancelButton)).addPreferredGap(1).add((Component)this.messagePanel, -2, -1, -2).addPreferredGap(1).add((Component)this.separator, -2, -1, -2).addPreferredGap(0).add((Component)this.dummyCommentsPanel, -1, -1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.dummyLabel1, this.dummyLabel2, this.dummyLabel3, this.priorityCombo}, 2);
        groupLayout.linkSize(new Component[]{this.refreshButton, this.reloadButton, this.separatorLabel, this.separatorLabel2}, 2);
        this.reportedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reportedField.AccessibleContext.accessibleDescription"));
        this.blocksButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.AccessibleContext.accessibleDescription"));
        this.modifiedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.modifiedField.AccessibleContext.accessibleDescription"));
        this.dependsOnButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.AccessibleContext.accessibleDescription"));
        this.dependsField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsField.AccessibleContext.accessibleDescription"));
        this.resolutionField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.resolutionField.AccessibleContext.accessibleDescription"));
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.AccessibleContext.accessibleDescription"));
        this.statusCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.statusCombo.AccessibleContext.accessibleDescription"));
        this.duplicateField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateField.AccessibleContext.accessibleDescription"));
        this.osCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.osCombo.AccessibleContext.accessibleDescription"));
        this.ccField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.ccField.AccessibleContext.accessibleDescription"));
        this.assignedField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.assignedField.AccessibleContext.accessibleDescription"));
        this.keywordsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.AccessibleContext.accessibleDescription"));
        this.targetMilestoneCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.targetMilestoneCombo.AccessibleContext.accessibleDescription"));
        this.blocksField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksField.AccessibleContext.accessibleDescription"));
        this.severityCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.severityCombo.AccessibleContext.accessibleDescription"));
        this.componentCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.componentCombo.AccessibleContext.accessibleDescription"));
        this.productCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.productCombo.AccessibleContext.accessibleDescription"));
        this.refreshButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshButton.AccessibleContext.accessibleDescription"));
        this.versionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.versionCombo.AccessibleContext.accessibleDescription"));
        this.platformCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.platformCombo.AccessibleContext.accessibleDescription"));
        this.priorityCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.priorityCombo.AccessibleContext.accessibleDescription"));
        this.qaContactField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.qaContactField.AccessibleContext.accessibleDescription"));
        this.keywordsField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsField.AccessibleContext.accessibleDescription"));
        this.urlField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.urlField.AccessibleContext.accessibleDescription"));
        this.submitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitButton.AccessibleContext.accessibleDescription"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.cancelButton.AccessibleContext.accessibleDescription"));
    }

    private void productComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.productLabel);
        BugzillaRepository bugzillaRepository = this.issue.getBugzillaRepository();
        BugzillaConfiguration bugzillaConfiguration = bugzillaRepository.getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return;
        }
        String string = this.productCombo.getSelectedItem().toString();
        Object object = this.componentCombo.getSelectedItem();
        Object object2 = this.versionCombo.getSelectedItem();
        Object object3 = this.targetMilestoneCombo.getSelectedItem();
        this.componentCombo.setModel(this.toComboModel(bugzillaConfiguration.getComponents(string)));
        this.versionCombo.setModel(this.toComboModel(bugzillaConfiguration.getVersions(string)));
        List<String> list = bugzillaConfiguration.getTargetMilestones(string);
        this.usingTargetMilestones = list.size() != 0;
        this.targetMilestoneCombo.setModel(this.toComboModel(list));
        boolean bl = this.issue.getTaskData().isNew();
        if (!bl && !this.selectInCombo(this.componentCombo, object, false) && this.componentCombo.getModel().getSize() > 1) {
            this.componentCombo.setSelectedItem(null);
        }
        if (!bl && !this.selectInCombo(this.versionCombo, object2, false) && this.versionCombo.getModel().getSize() > 1) {
            this.versionCombo.setSelectedItem(null);
        }
        if (this.usingTargetMilestones && !bl && !this.selectInCombo(this.targetMilestoneCombo, object3, false) && this.targetMilestoneCombo.getModel().getSize() > 1) {
            this.targetMilestoneCombo.setSelectedItem(null);
        }
        this.targetMilestoneLabel.setVisible(this.usingTargetMilestones);
        this.targetMilestoneCombo.setVisible(this.usingTargetMilestones);
        this.milestoneWarning.setVisible(this.usingTargetMilestones);
        TaskData taskData = this.issue.getTaskData();
        if (taskData.isNew()) {
            String string2 = this.summaryField.getText();
            this.issue.setFieldValue(BugzillaIssue.IssueField.PRODUCT, string);
            BugzillaRepositoryConnector bugzillaRepositoryConnector = Bugzilla.getInstance().getRepositoryConnector();
            try {
                bugzillaRepositoryConnector.getTaskDataHandler().initializeTaskData(this.issue.getBugzillaRepository().getTaskRepository(), taskData, bugzillaRepositoryConnector.getTaskMapping(taskData), (IProgressMonitor)new NullProgressMonitor());
                this.reloadForm(false);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            this.summaryField.setText(string2);
        }
    }

    private void statusComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.statusLabel);
        this.cancelHighlight(this.resolutionLabel);
        String string = this.initialValues.get((Object)BugzillaIssue.IssueField.STATUS);
        boolean bl = "RESOLVED".equals(string);
        if (!bl) {
            if ("RESOLVED".equals(this.statusCombo.getSelectedItem())) {
                if (this.resolutionCombo.getParent() == null) {
                    ((GroupLayout)this.getLayout()).replace((Component)this.resolutionField, (Component)this.resolutionCombo);
                }
                this.resolutionCombo.setSelectedItem("FIXED");
                this.resolutionCombo.setVisible(true);
            } else {
                this.resolutionCombo.setVisible(false);
                this.duplicateLabel.setVisible(false);
                this.duplicateField.setVisible(false);
                this.duplicateButton.setVisible(false);
            }
        }
        if (!this.resolutionField.getText().trim().equals("")) {
            if (this.statusCombo.getSelectedIndex() >= this.resolvedIndex) {
                if (this.resolutionField.getParent() == null) {
                    ((GroupLayout)this.getLayout()).replace((Component)this.resolutionCombo, (Component)this.resolutionField);
                }
                this.resolutionField.setVisible(true);
            } else {
                this.resolutionField.setVisible(false);
            }
            this.duplicateLabel.setVisible(false);
            this.duplicateField.setVisible(false);
            this.duplicateButton.setVisible(false);
        }
        this.resolutionLabel.setLabelFor(this.resolutionCombo.isVisible() ? this.resolutionCombo : this.resolutionField);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.reloadForm(true);
    }

    private void submitButtonActionPerformed(ActionEvent actionEvent) {
        BugzillaRepository bugzillaRepository;
        String string;
        String string2;
        boolean bl = this.issue.getTaskData().isNew();
        if (bl) {
            this.storeFieldValue(BugzillaIssue.IssueField.DESCRIPTION, this.addCommentArea);
        }
        this.storeFieldValue(BugzillaIssue.IssueField.SUMMARY, this.summaryField);
        this.storeFieldValue(BugzillaIssue.IssueField.PRODUCT, this.productCombo);
        this.storeFieldValue(BugzillaIssue.IssueField.COMPONENT, this.componentCombo);
        this.storeFieldValue(BugzillaIssue.IssueField.VERSION, this.versionCombo);
        this.storeFieldValue(BugzillaIssue.IssueField.PLATFORM, this.platformCombo);
        this.storeFieldValue(BugzillaIssue.IssueField.OS, this.osCombo);
        this.storeFieldValue(BugzillaIssue.IssueField.STATUS, this.statusCombo);
        if (this.resolutionCombo.isVisible()) {
            this.storeFieldValue(BugzillaIssue.IssueField.RESOLUTION, this.resolutionCombo);
        } else if (!this.resolutionField.isVisible()) {
            this.storeFieldValue(BugzillaIssue.IssueField.RESOLUTION, "");
        }
        if (this.duplicateField.isVisible() && this.duplicateField.isEditable()) {
            this.issue.duplicate(this.duplicateField.getText());
        }
        this.storeFieldValue(BugzillaIssue.IssueField.PRIORITY, this.priorityCombo);
        if (BugzillaUtil.isNbRepository(this.issue.getRepository())) {
            this.storeFieldValue(BugzillaIssue.IssueField.ISSUE_TYPE, this.issueTypeCombo);
        }
        this.storeFieldValue(BugzillaIssue.IssueField.SEVERITY, this.severityCombo);
        if (this.usingTargetMilestones) {
            this.storeFieldValue(BugzillaIssue.IssueField.MILESTONE, this.targetMilestoneCombo);
        }
        this.storeFieldValue(BugzillaIssue.IssueField.URL, this.urlField);
        this.storeFieldValue(BugzillaIssue.IssueField.WHITEBOARD, this.statusWhiteboardField);
        this.storeFieldValue(BugzillaIssue.IssueField.KEYWORDS, this.keywordsField);
        if (this.assignedField.getParent() == null) {
            this.storeFieldValue(BugzillaIssue.IssueField.ASSIGNED_TO, this.assignedCombo);
        } else {
            this.storeFieldValue(BugzillaIssue.IssueField.ASSIGNED_TO, this.assignedField);
        }
        this.storeFieldValue(BugzillaIssue.IssueField.QA_CONTACT, this.qaContactField);
        this.storeCCValue();
        this.storeFieldValue(BugzillaIssue.IssueField.DEPENDS_ON, this.dependsField);
        this.storeFieldValue(BugzillaIssue.IssueField.BLOCKS, this.blocksField);
        if (!bl && !"".equals(this.addCommentArea.getText().trim())) {
            this.issue.addComment(this.addCommentArea.getText());
        }
        if (bl) {
            string2 = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitNewMessage");
        } else {
            string = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.submitMessage");
            string2 = MessageFormat.format(string, this.issue.getID());
        }
        string = ProgressHandleFactory.createHandle((String)string2);
        string.start();
        string.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RequestProcessor.getDefault().post(new Runnable((ProgressHandle)string){
            final /* synthetic */ ProgressHandle val$handle;
            {
                this.val$handle = progressHandle;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean bl = false;
                try {
                    bl = IssuePanel.this.issue.submitAndRefresh();
                    for (AttachmentsPanel.AttachmentInfo attachmentInfo : IssuePanel.this.attachmentsPanel.getNewAttachments()) {
                        if (!attachmentInfo.file.exists()) continue;
                        if (attachmentInfo.description.trim().length() == 0) {
                            attachmentInfo.description = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.attachment.noDescription");
                        }
                        IssuePanel.this.issue.addAttachment(attachmentInfo.file, null, attachmentInfo.description, attachmentInfo.contentType, attachmentInfo.isPatch);
                    }
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.skipReload = false;
                        }
                    });
                    this.val$handle.finish();
                    if (bl) {
                        IssuePanel.this.reloadFormInAWT(true);
                    }
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                this.val$handle.finish();
                if (bl) {
                    IssuePanel.this.reloadFormInAWT(true);
                }
            }
        });
        if (bl && (bugzillaRepository = this.issue.getBugzillaRepository()) != null) {
            BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.SELECTED_FILE_AND_ALL_PROJECTS, (Repository)bugzillaRepository);
        }
    }

    private void storeCCValue() {
        Set<String> set = this.ccs(this.issue.getFieldValue(BugzillaIssue.IssueField.CC));
        Set<String> set2 = this.ccs(this.ccField.getText());
        String string = this.getMissingCCs(set, set2);
        String string2 = this.getMissingCCs(set2, set);
        this.storeFieldValue(BugzillaIssue.IssueField.REMOVECC, string);
        this.storeFieldValue(BugzillaIssue.IssueField.NEWCC, string2);
    }

    private Set<String> ccs(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r\f");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        return hashSet;
    }

    private String getMissingCCs(Set<String> set, Set<String> set2) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.trim().equals("") || set2.contains(string)) continue;
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    private void refreshButtonActionPerformed(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.refreshMessage");
        String string2 = MessageFormat.format(string, this.issue.getID());
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string2);
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    IssuePanel.this.issue.refresh();
                }
                catch (Throwable throwable) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.skipReload = false;
                        }
                    });
                    progressHandle.finish();
                    IssuePanel.this.reloadFormInAWT(true);
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                progressHandle.finish();
                IssuePanel.this.reloadFormInAWT(true);
            }
        });
    }

    private void resolutionComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.resolutionLabel);
        if (this.resolutionCombo.getParent() == null) {
            return;
        }
        boolean bl = "DUPLICATE".equals(this.resolutionCombo.getSelectedItem());
        this.duplicateLabel.setVisible(bl);
        this.duplicateField.setVisible(bl);
        this.duplicateButton.setVisible(bl && this.duplicateField.isEditable());
    }

    private void keywordsButtonActionPerformed(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.keywordsButton.message");
        String string2 = BugzillaUtil.getKeywords(string, this.keywordsField.getText(), this.issue.getBugzillaRepository());
        this.keywordsField.setText(string2);
    }

    private void blocksButtonActionPerformed(ActionEvent actionEvent) {
        Issue issue = BugtrackingUtil.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.blocksButton.message"), (Repository)this.issue.getBugzillaRepository(), (JPanel)this, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.blocksChooser"));
        if (issue != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.blocksField.getText().trim().equals("")) {
                stringBuilder.append(this.blocksField.getText()).append(',').append(' ');
            }
            stringBuilder.append(issue.getID());
            this.blocksField.setText(stringBuilder.toString());
        }
    }

    private void dependsOnButtonActionPerformed(ActionEvent actionEvent) {
        Issue issue = BugtrackingUtil.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.dependsOnButton.message"), (Repository)this.issue.getBugzillaRepository(), (JPanel)this, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.dependsOnChooser"));
        if (issue != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.dependsField.getText().trim().equals("")) {
                stringBuilder.append(this.dependsField.getText()).append(',').append(' ');
            }
            stringBuilder.append(issue.getID());
            this.dependsField.setText(stringBuilder.toString());
        }
    }

    private void componentComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.componentLabel);
        this.updateNoComponent();
    }

    private void versionComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.versionLabel);
        this.updateNoVersion();
    }

    private void platformComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.platformLabel);
    }

    private void priorityComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.priorityLabel);
    }

    private void severityComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.priorityLabel);
    }

    private void targetMilestoneComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.targetMilestoneLabel);
        this.updateNoTargetMilestone();
    }

    private void osComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.platformLabel);
    }

    private void reloadButtonActionPerformed(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.reloadMessage");
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        this.skipReload = true;
        this.enableComponents(false);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                IssuePanel.this.issue.getBugzillaRepository().refreshConfiguration();
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            IssuePanel.this.reloading = true;
                            Object object = IssuePanel.this.productCombo.getSelectedItem();
                            Object object2 = IssuePanel.this.platformCombo.getSelectedItem();
                            Object object3 = IssuePanel.this.osCombo.getSelectedItem();
                            Object object4 = IssuePanel.this.priorityCombo.getSelectedItem();
                            Object object5 = IssuePanel.this.severityCombo.getSelectedItem();
                            Object object6 = IssuePanel.this.resolutionCombo.getSelectedItem();
                            Object object7 = IssuePanel.this.issueTypeCombo.getSelectedItem();
                            IssuePanel.this.initCombos();
                            IssuePanel.this.selectInCombo(IssuePanel.this.productCombo, object, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.platformCombo, object2, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.osCombo, object3, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.priorityCombo, object4, false);
                            IssuePanel.this.selectInCombo(IssuePanel.this.severityCombo, object5, false);
                            IssuePanel.this.initStatusCombo(IssuePanel.this.statusCombo.getSelectedItem().toString());
                            IssuePanel.this.selectInCombo(IssuePanel.this.resolutionCombo, object6, false);
                            if (BugzillaUtil.isNbRepository(IssuePanel.this.issue.getRepository())) {
                                IssuePanel.this.issueTypeCombo.setSelectedItem(object7);
                            }
                        }
                        finally {
                            IssuePanel.this.reloading = false;
                            IssuePanel.this.enableComponents(true);
                            IssuePanel.this.skipReload = false;
                        }
                    }
                });
                progressHandle.finish();
            }
        });
    }

    private void duplicateButtonActionPerformed(ActionEvent actionEvent) {
        Issue issue = BugtrackingUtil.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.message"), (Repository)this.issue.getBugzillaRepository(), (JPanel)this, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.duplicateChooser"));
        if (issue != null) {
            this.duplicateField.setText(issue.getID());
        }
    }

    private void tasklistButtonActionPerformed(ActionEvent actionEvent) {
        this.tasklistButton.setEnabled(false);
        BugzillaIssueProvider bugzillaIssueProvider = BugzillaIssueProvider.getInstance();
        if (bugzillaIssueProvider.isAdded(this.issue)) {
            bugzillaIssueProvider.remove(this.issue);
        } else {
            this.attachTasklistListener(bugzillaIssueProvider);
            bugzillaIssueProvider.add(this.issue, true);
        }
        this.updateTasklistButton();
    }

    private void assignedComboActionPerformed(ActionEvent actionEvent) {
        Object object;
        this.cancelHighlight(this.assignedLabel);
        if (!this.reloading) {
            this.assignedToStatusLabel.setVisible(false);
        }
        if ((object = this.assignedCombo.getSelectedItem()) instanceof RepositoryUser) {
            String string = ((RepositoryUser)object).getUserName();
            Repository repository = this.issue.getRepository();
            if (repository instanceof KenaiRepository) {
                string = string + '@' + ((KenaiRepository)repository).getHost();
            }
            this.assignedCombo.setSelectedItem(string);
        }
    }

    private void issueTypeComboActionPerformed(ActionEvent actionEvent) {
        this.cancelHighlight(this.issueTypeLabel);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.getUnitIncrement();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
        if (jScrollPane != null) {
            JScrollBar jScrollBar;
            int n = this.getMinimumSize().width;
            int n2 = jScrollPane.getSize().width;
            Insets insets = jScrollPane.getInsets();
            n2 -= insets.left + insets.right;
            Border border = jScrollPane.getViewportBorder();
            if (border != null) {
                insets = border.getBorderInsets(jScrollPane);
                n2 -= insets.left + insets.right;
            }
            if ((jScrollBar = jScrollPane.getVerticalScrollBar()) != null && jScrollBar.isVisible()) {
                n2 -= jScrollBar.getSize().width;
            }
            if (n > n2) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private int getUnitIncrement() {
        Font font;
        if (this.unitIncrement == 0 && (font = UIManager.getFont("Label.font")) != null) {
            this.unitIncrement = (int)((double)font.getSize() * 1.5);
        }
        return this.unitIncrement;
    }

    class CancelHighlightDocumentListener
    implements DocumentListener {
        private JLabel label;

        CancelHighlightDocumentListener(JLabel jLabel) {
            this.label = jLabel;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            IssuePanel.this.cancelHighlight(this.label);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            IssuePanel.this.cancelHighlight(this.label);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            IssuePanel.this.cancelHighlight(this.label);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CyclicDependencyDocumentListener
    implements DocumentListener {
        CyclicDependencyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            Set<Integer> set = this.bugs(IssuePanel.this.blocksField.getText());
            Set<Integer> set2 = this.bugs(IssuePanel.this.dependsField.getText());
            set.retainAll(set2);
            if (set.isEmpty()) {
                if (IssuePanel.this.cyclicDependency) {
                    IssuePanel.this.cyclicDependency = false;
                    IssuePanel.this.updateMessagePanel();
                }
            } else if (!IssuePanel.this.cyclicDependency) {
                IssuePanel.this.cyclicDependency = true;
                IssuePanel.this.updateMessagePanel();
            }
        }

        private Set<Integer> bugs(String string) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r\f");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    hashSet.add(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return hashSet;
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == IssuePanel.this.blocksButton) {
                IssuePanel.this.blocksButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.dependsOnButton) {
                IssuePanel.this.dependsOnButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.duplicateButton) {
                IssuePanel.this.duplicateButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.statusCombo) {
                IssuePanel.this.statusComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.osCombo) {
                IssuePanel.this.osComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.keywordsButton) {
                IssuePanel.this.keywordsButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.targetMilestoneCombo) {
                IssuePanel.this.targetMilestoneComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.severityCombo) {
                IssuePanel.this.severityComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.componentCombo) {
                IssuePanel.this.componentComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.productCombo) {
                IssuePanel.this.productComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.refreshButton) {
                IssuePanel.this.refreshButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.reloadButton) {
                IssuePanel.this.reloadButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.tasklistButton) {
                IssuePanel.this.tasklistButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.versionCombo) {
                IssuePanel.this.versionComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.platformCombo) {
                IssuePanel.this.platformComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.priorityCombo) {
                IssuePanel.this.priorityComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.issueTypeCombo) {
                IssuePanel.this.issueTypeComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.submitButton) {
                IssuePanel.this.submitButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.cancelButton) {
                IssuePanel.this.cancelButtonActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.resolutionCombo) {
                IssuePanel.this.resolutionComboActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == IssuePanel.this.assignedCombo) {
                IssuePanel.this.assignedComboActionPerformed(actionEvent);
            }
        }
    }

    private static class PriorityRenderer
    extends DefaultListCellRenderer {
        private PriorityRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setIcon(BugzillaConfig.getInstance().getPriorityIcon((String)object));
            return jLabel;
        }
    }

    class RevalidatingListener
    implements DocumentListener,
    Runnable {
        private boolean ignoreUpdate;

        RevalidatingListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.ignoreUpdate) {
                return;
            }
            this.ignoreUpdate = true;
            EventQueue.invokeLater(this);
        }

        public void run() {
            IssuePanel.this.revalidate();
            IssuePanel.this.repaint();
            this.ignoreUpdate = false;
        }
    }
}

