/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.query;

import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.netbeans.modules.bugzilla.BugzillaConfig;

public abstract class QueryParameter {
    static final ParameterValue[] EMPTY_PARAMETER_VALUE = new ParameterValue[]{new ParameterValue("", "")};
    static final ParameterValue PV_CONTAINS_ALL_KEYWORDS = new ParameterValue("contains all keywords", "allwords");
    static final ParameterValue PV_CONTAINS_ANY_KEYWORDS = new ParameterValue("contains any keywords", "anywords");
    static final ParameterValue PV_CONTAINS_NONE_KEYWORDS = new ParameterValue("contains none keywords", "nowords");
    static final ParameterValue PV_CONTAINS = new ParameterValue("contains", "substring");
    static final ParameterValue PV_IS = new ParameterValue("is", "exact");
    static final ParameterValue PV_MATCHES_REGEX = new ParameterValue("matches the regexp", "regexp");
    static final ParameterValue PV_DOESNT_MATCH_REGEX = new ParameterValue("doesn't match the regexp", "notregexp");
    static final ParameterValue PV_CONTAINS_ALL_STRINGS = new ParameterValue("contains all of the words/strings", "allwordssubstr");
    static final ParameterValue PV_CONTAINS_ANY_STRINGS = new ParameterValue("contains any of the words/strings", "anywordssubstr");
    static final ParameterValue PV_CONTAINS_THE_STRING = new ParameterValue("contains the string", "substring");
    static final ParameterValue PV_CONTAINS_THE_STRING_CASE = new ParameterValue("contains the string (exact case)", "casesubstring");
    static final ParameterValue PV_CONTAINS_ALL_WORDS = new ParameterValue("contains all of the words", "allwords");
    static final ParameterValue PV_CONTAINS_ANY_WORDS = new ParameterValue("contains any of the words", "anywords");
    static final ParameterValue PV_FIELD_BUG_CREATION = new ParameterValue("[Bug+creation]", "[Bug+creation]");
    static final ParameterValue PV_FIELD_ALIAS = new ParameterValue("alias", "alias");
    static final ParameterValue PV_FIELD_ASSIGNED_TO = new ParameterValue("assigned_to", "assigned_to");
    static final ParameterValue PV_FIELD_LIST_ACCESSIBLE = new ParameterValue("cclist_accessible", "cclist_accessible");
    static final ParameterValue PV_FIELD_COMPONENT = new ParameterValue("component", "component");
    static final ParameterValue PV_FIELD_DEADLINE = new ParameterValue("deadline", "deadline");
    static final ParameterValue PV_FIELD_EVER_CONFIRMED = new ParameterValue("everconfirmed", "everconfirmed");
    static final ParameterValue PV_FIELD_REP_PLARFORM = new ParameterValue("rep_platform", "rep_platform");
    static final ParameterValue PV_FIELD_REMAINING_TIME = new ParameterValue("remaining_time", "remaining_time");
    static final ParameterValue PV_FIELD_WORK_TIME = new ParameterValue("work_time", "work_time");
    static final ParameterValue PV_FIELD_KEYWORDS = new ParameterValue("keywords", "keywords");
    static final ParameterValue PV_FIELD_ESTIMATED_TIME = new ParameterValue("estimated_time", "estimated_time");
    static final ParameterValue PV_FIELD_OP_SYS = new ParameterValue("op_sys", "op_sys");
    static final ParameterValue PV_FIELD_PRIORITY = new ParameterValue("priority", "priority");
    static final ParameterValue PV_FIELD_PRODUCT = new ParameterValue("product", "product");
    static final ParameterValue PV_FIELD_QA_CONTACT = new ParameterValue("qa_contact", "qa_contact");
    static final ParameterValue PV_FIELD_REPORTER_ACCESSIBLE = new ParameterValue("reporter_accessible", "reporter_accessible");
    static final ParameterValue PV_FIELD_RESOLUTION = new ParameterValue("resolution", "resolution");
    static final ParameterValue PV_FIELD_BUG_SEVERITY = new ParameterValue("bug_severity", "bug_severity");
    static final ParameterValue PV_FIELD_BUG_STATUS = new ParameterValue("bug_status", "bug_status");
    static final ParameterValue PV_FIELD_SHORT_DESC = new ParameterValue("short_desc", "short_desc");
    static final ParameterValue PV_FIELD_TARGET_MILESTONE = new ParameterValue("target_milestone", "target_milestone");
    static final ParameterValue PV_FIELD_BUG_FILE_LOC = new ParameterValue("bug_file_loc", "bug_file_loc");
    static final ParameterValue PV_FIELD_VERSION = new ParameterValue("version", "version");
    static final ParameterValue PV_FIELD_VOTES = new ParameterValue("votes", "votes");
    static final ParameterValue PV_FIELD_STATUS_WHITEBOARD = new ParameterValue("status_whiteboard", "status_whiteboard");
    static final ParameterValue[] PV_TEXT_SEARCH_VALUES = new ParameterValue[]{PV_CONTAINS_ALL_STRINGS, PV_CONTAINS_ANY_STRINGS, PV_CONTAINS_THE_STRING, PV_CONTAINS_THE_STRING_CASE, PV_CONTAINS_ALL_WORDS, PV_CONTAINS_ANY_WORDS, PV_MATCHES_REGEX, PV_DOESNT_MATCH_REGEX};
    static final ParameterValue[] PV_KEYWORDS_VALUES = new ParameterValue[]{PV_CONTAINS_ALL_KEYWORDS, PV_CONTAINS_ANY_KEYWORDS, PV_CONTAINS_NONE_KEYWORDS};
    static final ParameterValue[] PV_PEOPLE_VALUES = new ParameterValue[]{PV_CONTAINS, PV_IS, PV_MATCHES_REGEX, PV_DOESNT_MATCH_REGEX};
    static final ParameterValue[] PV_LAST_CHANGE = new ParameterValue[]{PV_FIELD_BUG_CREATION, PV_FIELD_ALIAS, PV_FIELD_ASSIGNED_TO, PV_FIELD_LIST_ACCESSIBLE, PV_FIELD_COMPONENT, PV_FIELD_DEADLINE, PV_FIELD_EVER_CONFIRMED, PV_FIELD_REP_PLARFORM, PV_FIELD_REMAINING_TIME, PV_FIELD_WORK_TIME, PV_FIELD_KEYWORDS, PV_FIELD_ESTIMATED_TIME, PV_FIELD_OP_SYS, PV_FIELD_PRIORITY, PV_FIELD_PRODUCT, PV_FIELD_QA_CONTACT, PV_FIELD_REPORTER_ACCESSIBLE, PV_FIELD_RESOLUTION, PV_FIELD_BUG_SEVERITY, PV_FIELD_BUG_STATUS, PV_FIELD_SHORT_DESC, PV_FIELD_TARGET_MILESTONE, PV_FIELD_BUG_FILE_LOC, PV_FIELD_VERSION, PV_FIELD_VOTES, PV_FIELD_STATUS_WHITEBOARD};
    private final String parameter;
    protected boolean alwaysDisabled = false;

    public QueryParameter(String string) {
        this.parameter = string;
    }

    public String getParameter() {
        return this.parameter;
    }

    abstract ParameterValue[] getValues();

    abstract void setValues(ParameterValue[] var1);

    void setAlwaysDisabled(boolean bl) {
        this.alwaysDisabled = bl;
        this.setEnabled(false);
    }

    abstract void setEnabled(boolean var1);

    public StringBuffer get() {
        ParameterValue[] parameterValueArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (ParameterValue parameterValue : parameterValueArray = this.getValues()) {
            stringBuffer.append("&");
            stringBuffer.append(this.getParameter());
            stringBuffer.append("=");
            stringBuffer.append(parameterValue.getValue());
        }
        return stringBuffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(this.get());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static class CheckBoxParameter
    extends QueryParameter {
        private ParameterValue[] selected = new ParameterValue[]{new ParameterValue("1")};
        private final JCheckBox chk;

        public CheckBoxParameter(JCheckBox jCheckBox, String string) {
            super(string);
            this.chk = jCheckBox;
        }

        public ParameterValue[] getValues() {
            return this.chk.isSelected() ? this.selected : EMPTY_PARAMETER_VALUE;
        }

        public void setValues(ParameterValue[] parameterValueArray) {
            assert (parameterValueArray.length < 2);
            if (parameterValueArray.length == 0 || parameterValueArray[0] == null) {
                return;
            }
            this.chk.setSelected(parameterValueArray[0].getValue().equals("1"));
        }

        void setEnabled(boolean bl) {
            this.chk.setEnabled(this.alwaysDisabled ? false : bl);
        }
    }

    static class ComboParameter
    extends QueryParameter {
        private final JComboBox combo;

        public ComboParameter(JComboBox jComboBox, String string) {
            super(string);
            this.combo = jComboBox;
            jComboBox.setModel(new DefaultComboBoxModel());
        }

        public ParameterValue[] getValues() {
            ParameterValue[] parameterValueArray;
            ParameterValue parameterValue = (ParameterValue)this.combo.getSelectedItem();
            if (parameterValue != null) {
                ParameterValue[] parameterValueArray2 = new ParameterValue[1];
                parameterValueArray = parameterValueArray2;
                parameterValueArray2[0] = parameterValue;
            } else {
                parameterValueArray = EMPTY_PARAMETER_VALUE;
            }
            return parameterValueArray;
        }

        public void setParameterValues(ParameterValue[] parameterValueArray) {
            this.combo.setModel(new DefaultComboBoxModel<ParameterValue>(parameterValueArray));
        }

        public void setValues(ParameterValue[] parameterValueArray) {
            assert (parameterValueArray.length < 2);
            if (parameterValueArray.length == 0) {
                return;
            }
            ParameterValue parameterValue = parameterValueArray[0];
            int n = ((DefaultComboBoxModel)this.combo.getModel()).getIndexOf(parameterValue);
            if (n != -1) {
                this.combo.setSelectedIndex(n);
            }
        }

        void setEnabled(boolean bl) {
            this.combo.setEnabled(this.alwaysDisabled ? false : bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListParameter
    extends QueryParameter {
        private final JList list;

        public ListParameter(JList jList, String string) {
            super(string);
            this.list = jList;
            jList.setModel(new DefaultListModel());
        }

        @Override
        public ParameterValue[] getValues() {
            Object[] objectArray = this.list.getSelectedValues();
            if (objectArray == null || objectArray.length == 0) {
                return EMPTY_PARAMETER_VALUE;
            }
            ParameterValue[] parameterValueArray = new ParameterValue[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                parameterValueArray[i] = (ParameterValue)objectArray[i];
            }
            return parameterValueArray;
        }

        public void setParameterValues(List<ParameterValue> list) {
            this.setParameterValues(list.toArray(new ParameterValue[list.size()]));
        }

        public void setParameterValues(ParameterValue[] parameterValueArray) {
            DefaultListModel<ParameterValue> defaultListModel = new DefaultListModel<ParameterValue>();
            for (ParameterValue parameterValue : parameterValueArray) {
                defaultListModel.addElement(parameterValue);
            }
            this.list.setModel(defaultListModel);
        }

        @Override
        public void setValues(ParameterValue[] parameterValueArray) {
            int n;
            if (parameterValueArray.length == 0) {
                return;
            }
            this.list.clearSelection();
            if (parameterValueArray.length == 1 && "".equals(parameterValueArray[0].getValue().trim())) {
                return;
            }
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            block0: for (int i = 0; i < parameterValueArray.length; ++i) {
                ListModel listModel = this.list.getModel();
                for (int j = 0; j < listModel.getSize(); ++j) {
                    ParameterValue parameterValue = (ParameterValue)listModel.getElementAt(j);
                    if (!parameterValue.getValue().toLowerCase().equals(parameterValueArray[i].getValue().toLowerCase())) continue;
                    linkedList.add(j);
                    continue block0;
                }
            }
            int[] nArray = new int[linkedList.size()];
            int n2 = 0;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                nArray[n2++] = n3;
            }
            this.list.setSelectedIndices(nArray);
            int n4 = n = nArray.length > 0 ? nArray[0] : -1;
            if (n > -1) {
                this.list.scrollRectToVisible(this.list.getCellBounds(n, n));
            }
        }

        @Override
        void setEnabled(boolean bl) {
            this.list.setEnabled(this.alwaysDisabled ? false : bl);
        }
    }

    static class ParameterValue {
        private final String displayName;
        private final String value;
        private String toString;

        public ParameterValue(String string) {
            this(string, string);
        }

        public ParameterValue(String string, String string2) {
            assert (string != null);
            assert (string2 != null);
            this.displayName = string;
            this.value = string2;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            if (this.toString == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.displayName);
                stringBuffer.append("[");
                stringBuffer.append(this.value);
                stringBuffer.append("]");
                this.toString = stringBuffer.toString();
            }
            return this.toString;
        }

        public boolean equals(Object object) {
            if (object instanceof ParameterValue) {
                ParameterValue parameterValue = (ParameterValue)object;
                return this.value.equals(parameterValue.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    static class ParameterValueCellRenderer
    extends DefaultListCellRenderer {
        ParameterValueCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof ParameterValue) {
                object = ((ParameterValue)object).getDisplayName();
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    static class PriorityRenderer
    extends ParameterValueCellRenderer {
        PriorityRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object instanceof ParameterValue) {
                String string = ((ParameterValue)object).getValue();
                jLabel.setIcon(BugzillaConfig.getInstance().getPriorityIcon(string));
            } else {
                jLabel.setIcon(null);
            }
            return jLabel;
        }
    }

    public static class SimpleQueryParameter
    extends QueryParameter {
        private final String[] values;

        public SimpleQueryParameter(String string, String[] stringArray) {
            super(string);
            this.values = stringArray;
        }

        ParameterValue[] getValues() {
            if (this.values == null || this.values.length == 0) {
                return EMPTY_PARAMETER_VALUE;
            }
            ParameterValue[] parameterValueArray = new ParameterValue[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                parameterValueArray[i] = new ParameterValue(this.values[i]);
            }
            return parameterValueArray;
        }

        void setValues(ParameterValue[] parameterValueArray) {
        }

        void setEnabled(boolean bl) {
        }
    }

    static class TextFieldParameter
    extends QueryParameter {
        private final JTextField txt;

        public TextFieldParameter(JTextField jTextField, String string) {
            super(string);
            this.txt = jTextField;
        }

        public ParameterValue[] getValues() {
            String string = this.txt.getText();
            if (string == null || string.equals("")) {
                return EMPTY_PARAMETER_VALUE;
            }
            String[] stringArray = string.split(" ");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                stringBuffer.append(string2);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append("+");
            }
            String string3 = stringBuffer.toString();
            return new ParameterValue[]{new ParameterValue(string3, string3)};
        }

        public void setValues(ParameterValue[] parameterValueArray) {
            assert (parameterValueArray.length < 2);
            if (parameterValueArray.length == 0 || parameterValueArray[0] == null) {
                return;
            }
            this.txt.setText(parameterValueArray[0].getValue().replace("+", " "));
        }

        void setEnabled(boolean bl) {
            this.txt.setEnabled(this.alwaysDisabled ? false : bl);
        }
    }
}

