/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponent<C extends Component<C>>
implements Component<C> {
    private C parent;
    private List<C> children = null;
    private AbstractModel model;

    public AbstractComponent(AbstractModel abstractModel) {
        this.model = abstractModel;
    }

    protected abstract void appendChildQuietly(C var1, List<C> var2);

    protected abstract void insertAtIndexQuietly(C var1, List<C> var2, int var3);

    protected abstract void removeChildQuietly(C var1, List<C> var2);

    protected abstract void populateChildren(List<C> var1);

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.model == null) {
            return;
        }
        this.model.removePropertyChangeListener(propertyChangeListener);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.model == null) {
            return;
        }
        this.model.addPropertyChangeListener(new DelegateListener(propertyChangeListener));
    }

    public void removeComponentListener(ComponentListener componentListener) {
        if (this.getModel() != null) {
            this.getModel().removeComponentListener(componentListener);
        }
    }

    @Override
    public synchronized C getParent() {
        return this.parent;
    }

    protected synchronized void setParent(C c) {
        this.parent = c;
    }

    protected synchronized void setModel(AbstractModel abstractModel) {
        this.model = abstractModel;
        if (this.isChildrenInitialized()) {
            for (Component component : this.getChildren()) {
                ((AbstractComponent)component).setModel(abstractModel);
            }
        }
    }

    private void _appendChildQuietly(C c, List<C> list) {
        if (c.getModel() == null) {
            throw new IllegalStateException("Cannot add a removed component, should use a fresh or a copy component.");
        }
        this.appendChildQuietly(c, list);
        ((AbstractComponent)c).setModel(this.getModel());
        ((AbstractComponent)c).setParent(this);
    }

    private void _insertAtIndexQuietly(C c, List<C> list, int n) {
        if (c.getModel() == null) {
            throw new IllegalStateException("Cannot add a removed component, should use a fresh or a copy component.");
        }
        this.insertAtIndexQuietly(c, list, n);
        ((AbstractComponent)c).setModel(this.getModel());
        ((AbstractComponent)c).setParent(this);
    }

    private void _removeChildQuietly(C c, List<C> list) {
        this.removeChildQuietly(c, list);
        ((AbstractComponent)c).setModel(null);
        ((AbstractComponent)c).setParent(null);
    }

    @Override
    public List<C> getChildren() {
        ArrayList<C> arrayList = new ArrayList<C>(this._getChildren());
        return Collections.unmodifiableList(arrayList);
    }

    public void checkChildrenPopulated() {
        this._getChildren();
    }

    public int getChildrenCount() {
        return this._getChildren().size();
    }

    protected final boolean isChildrenInitialized() {
        return this.children != null;
    }

    private synchronized List<C> _getChildren() {
        if (!this.isChildrenInitialized()) {
            this.children = new ArrayList<C>();
            this.populateChildren(this.children);
            for (Component component : this.children) {
                ((AbstractComponent)component).setParent(this);
            }
        }
        return this.children;
    }

    @Override
    public synchronized <T extends C> List<T> getChildren(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>(this._getChildren().size());
        for (Component component : this._getChildren()) {
            if (!clazz.isAssignableFrom(component.getClass())) continue;
            arrayList.add(clazz.cast(component));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<C> getChildren(Collection<Class<? extends C>> collection) {
        ArrayList<C> arrayList = new ArrayList<C>();
        for (Class<C> clazz : collection) {
            arrayList.addAll(this.getChildren(clazz));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public synchronized AbstractModel getModel() {
        return this.model;
    }

    protected void verifyWrite() {
        this.getModel().validateWrite();
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        this.getModel().firePropertyChangeEvent(propertyChangeEvent);
    }

    protected void fireValueChanged() {
        this.getModel().fireComponentChangedEvent(new ComponentEvent(this, ComponentEvent.EventType.VALUE_CHANGED));
    }

    protected void fireChildRemoved() {
        this.getModel().fireComponentChangedEvent(new ComponentEvent(this, ComponentEvent.EventType.CHILD_REMOVED));
    }

    protected void fireChildAdded() {
        this.getModel().fireComponentChangedEvent(new ComponentEvent(this, ComponentEvent.EventType.CHILD_ADDED));
    }

    protected <T extends C> T getChild(Class<T> clazz) {
        List<T> list = this.getChildren(clazz);
        Component component = null;
        if (!list.isEmpty()) {
            component = (Component)list.get(0);
        }
        return (T)component;
    }

    protected synchronized void addBefore(String string, C c, Collection<Class<? extends C>> collection) {
        this.verifyWrite();
        this.checkNullOrDuplicateChild(c);
        this.addChild(string, c, collection, true);
        this.firePropertyChange(string, null, c);
        this.fireChildAdded();
    }

    protected synchronized void addAfter(String string, C c, Collection<Class<? extends C>> collection) {
        this.verifyWrite();
        this.checkNullOrDuplicateChild(c);
        this.addChild(string, c, collection, false);
        this.firePropertyChange(string, null, c);
        this.fireChildAdded();
    }

    private void addChild(String string, C c, Collection<Class<? extends C>> collection, boolean bl) {
        assert (c != null);
        if (collection == null) {
            throw new IllegalArgumentException("typeList == null");
        }
        List<C> list = this.getChildren();
        if (collection.isEmpty() || list.isEmpty()) {
            this._appendChildQuietly(c, this._getChildren());
        } else {
            int n = bl ? list.size() : -1;
            for (Class<C> clazz : collection) {
                for (Component component : list) {
                    if (!clazz.isAssignableFrom(component.getClass())) continue;
                    int n2 = list.indexOf(component);
                    if (!bl) {
                        if (n2 <= n) continue;
                        n = n2;
                        continue;
                    }
                    if (n2 >= n) continue;
                    n = n2;
                }
            }
            if (!bl) {
                for (int i = ++n; i < list.size() && ((Component)list.get(i)).getClass().equals(c.getClass()); ++i) {
                    ++n;
                }
            }
            this._insertAtIndexQuietly(c, this._getChildren(), n);
        }
    }

    protected void checkNullOrDuplicateChild(C c) {
        if (c == null) {
            throw new IllegalArgumentException("child == null");
        }
        if (this._getChildren().contains(c)) {
            throw new IllegalArgumentException("child already in children list");
        }
    }

    protected synchronized void appendChild(String string, C c) {
        this.verifyWrite();
        this.checkNullOrDuplicateChild(c);
        this._appendChildQuietly(c, this._getChildren());
        this.firePropertyChange(string, null, c);
        this.fireChildAdded();
    }

    protected synchronized void insertAtIndex(String string, C c, int n, Class<? extends C> clazz) {
        this.verifyWrite();
        this.checkNullOrDuplicateChild(c);
        if (clazz != null) {
            Component component;
            int n2 = 0;
            Iterator<C> iterator = this.getChildren().iterator();
            while (iterator.hasNext() && !clazz.isAssignableFrom((component = (Component)iterator.next()).getClass())) {
                ++n2;
            }
            n += n2;
        }
        this._insertAtIndexQuietly(c, this._getChildren(), n);
        this.firePropertyChange(string, null, c);
        this.fireChildAdded();
    }

    public synchronized void insertAtIndex(String string, C c, int n) {
        this.insertAtIndex(string, c, n, null);
    }

    public synchronized void removeChild(String string, C c) {
        this.verifyWrite();
        if (c == null) {
            throw new IllegalArgumentException("component == null");
        }
        if (!this._getChildren().contains(c)) {
            throw new IllegalArgumentException("component to be deleted is not a child");
        }
        this._removeChildQuietly(c, this._getChildren());
        this.firePropertyChange(string, c, null);
        this.fireChildRemoved();
    }

    protected void setChild(Class<? extends C> clazz, String string, C c, Collection<Class<? extends C>> collection) {
        this.setChildAfter(clazz, string, c, collection);
    }

    protected void setChildAfter(Class<? extends C> clazz, String string, C c, Collection<Class<? extends C>> collection) {
        this.setChild(clazz, string, c, collection, false);
    }

    protected void setChildBefore(Class<? extends C> clazz, String string, C c, Collection<Class<? extends C>> collection) {
        this.setChild(clazz, string, c, collection, true);
    }

    protected synchronized void setChild(Class<? extends C> clazz, String string, C c, Collection<Class<? extends C>> collection, boolean bl) {
        this.verifyWrite();
        List<C> list = this.getChildren(clazz);
        if (list.contains(c)) {
            return;
        }
        Component component = list.isEmpty() ? null : (Component)list.get(list.size() - 1);
        for (Component component2 : list) {
            this._removeChildQuietly(component2, this._getChildren());
            this.fireChildRemoved();
        }
        if (c != null) {
            this.addChild(string, c, collection, bl);
            this.fireChildAdded();
        }
        this.firePropertyChange(string, component, c);
    }

    @Override
    public boolean canPaste(Component component) {
        return true;
    }

    private class DelegateListener
    implements PropertyChangeListener {
        private final PropertyChangeListener delegate;

        public DelegateListener(PropertyChangeListener propertyChangeListener) {
            this.delegate = propertyChangeListener;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == AbstractComponent.this) {
                this.delegate.propertyChange(propertyChangeEvent);
            }
        }

        public boolean equals(Object object) {
            return this.delegate == object;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

