/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.netbeans.modules.editor.settings.storage.spi.TypedValue;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.netbeans.modules.options.indentation.CustomizerSelector;
import org.netbeans.modules.options.indentation.FormattingPanel;
import org.netbeans.modules.options.indentation.ProxyPreferences;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormattingCustomizerPanel
extends JPanel
implements ActionListener,
HelpCtx.Provider {
    private JPanel customizerPanel;
    private JButton editGlobalButton;
    private JRadioButton globalButton;
    private ButtonGroup group;
    private JButton loadButton;
    private JRadioButton projectButton;
    private static final Logger LOG = Logger.getLogger(FormattingCustomizerPanel.class.getName());
    private static final String GLOBAL_OPTIONS_CATEGORY = "Editor/Formating";
    private static final String CODE_STYLE_PROFILE = "CodeStyle";
    private static final String DEFAULT_PROFILE = "default";
    private static final String PROJECT_PROFILE = "project";
    private static final String USED_PROFILE = "usedProfile";
    private final String allowedMimeTypes;
    private ProjectPreferencesFactory pf;
    private CustomizerSelector selector;
    private final FormattingPanel panel;
    private boolean copyOnFork;

    public static ProjectCustomizer.CompositeCategoryProvider createCategoryProvider(Map map) {
        return new Factory((String)map.get("allowedMimeTypes"));
    }

    public static ProjectCustomizer.CompositeCategoryProvider createCategoryProviderForAll() {
        return new Factory();
    }

    public static ProjectCustomizer.CompositeCategoryProvider createCategoryProviderForJava() {
        return new Factory("text/x-java");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (DEFAULT_PROFILE.equals(this.pf.getPreferences("").parent().get(USED_PROFILE, DEFAULT_PROFILE))) {
            Preferences preferences = ProjectUtils.getPreferences((Project)this.pf.getProject(), IndentUtils.class, (boolean)true);
            try {
                FormattingCustomizerPanel.removeAllKidsAndKeys(preferences);
            }
            catch (BackingStoreException backingStoreException) {
                LOG.log(Level.WARNING, null, backingStoreException);
            }
        } else {
            this.pf.applyChanges();
            HashSet hashSet = new HashSet(EditorSettings.getDefault().getAllMimeTypes());
            hashSet.removeAll(this.selector.getMimeTypes());
            Preferences preferences = ProjectUtils.getPreferences((Project)this.pf.getProject(), IndentUtils.class, (boolean)true);
            for (String string : hashSet) {
                try {
                    preferences.node(string).removeNode();
                }
                catch (BackingStoreException backingStoreException) {
                    LOG.log(Level.WARNING, null, backingStoreException);
                }
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(FormattingCustomizerPanel.class);
    }

    private void initComponents() {
        this.group = new ButtonGroup();
        this.globalButton = new JRadioButton();
        this.editGlobalButton = new JButton();
        this.projectButton = new JRadioButton();
        this.loadButton = new JButton();
        this.customizerPanel = new JPanel();
        this.group.add(this.globalButton);
        Mnemonics.setLocalizedText((AbstractButton)this.globalButton, (String)NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"LBL_FormattingCustomizer_Global"));
        this.globalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattingCustomizerPanel.this.globalButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editGlobalButton, (String)NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"LBL_FormattingCustomizer_EditGlobal"));
        this.editGlobalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattingCustomizerPanel.this.editGlobalButtonActionPerformed(actionEvent);
            }
        });
        this.group.add(this.projectButton);
        Mnemonics.setLocalizedText((AbstractButton)this.projectButton, (String)NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"LBL_FormattingCustomizer_Project"));
        this.projectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattingCustomizerPanel.this.projectButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.loadButton, (String)NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"LBL_ForamttingCustomizer_Load"));
        this.loadButton.setHorizontalAlignment(4);
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormattingCustomizerPanel.this.loadButtonActionPerformed(actionEvent);
            }
        });
        this.customizerPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectButton, -1, 339, Short.MAX_VALUE).add((Component)this.globalButton, -1, 339, Short.MAX_VALUE)).add(14, 14, 14).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.editGlobalButton, -1, -1, Short.MAX_VALUE).add((Component)this.loadButton, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.customizerPanel, -1, 490, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.globalButton).add((Component)this.editGlobalButton)).add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectButton).add((Component)this.loadButton)).addPreferredGap(1).add((Component)this.customizerPanel, -1, 239, Short.MAX_VALUE)));
        this.globalButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"FormattingCustomizerPanel.globalButton.AccessibleContext.accessibleDescription"));
        this.editGlobalButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"FormattingCustomizerPanel.editGlobalButton.AccessibleContext.accessibleDescription"));
        this.projectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"FormattingCustomizerPanel.projectButton.AccessibleContext.accessibleDescription"));
        this.loadButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"FormattingCustomizerPanel.loadButton.AccessibleContext.accessibleDescription"));
    }

    private void globalButtonActionPerformed(ActionEvent actionEvent) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"MSG_use_global_settings_confirmation"), NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"MSG_use_global_settings_confirmation_title"), 2);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.OK_OPTION) {
            this.pf.getPreferences("").parent().put(USED_PROFILE, DEFAULT_PROFILE);
            this.loadButton.setEnabled(false);
            this.setEnabled(this.panel, false);
        }
    }

    private void projectButtonActionPerformed(ActionEvent actionEvent) {
        this.pf.getPreferences("").parent().put(USED_PROFILE, PROJECT_PROFILE);
        this.loadButton.setEnabled(true);
        this.setEnabled(this.panel, true);
        if (this.copyOnFork) {
            this.copyOnFork = false;
            EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get((String)"Preferences");
            for (String string : this.selector.getMimeTypes()) {
                Map map;
                try {
                    map = editorSettingsStorage.load(MimePath.parse((String)string), null, false);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                    continue;
                }
                Preferences preferences = this.pf.getPreferences(string);
                boolean bl = false;
                bl |= FormattingCustomizerPanel.copyValueIfExists(map, preferences, "expand-tabs");
                bl |= FormattingCustomizerPanel.copyValueIfExists(map, preferences, "indent-shift-width");
                bl |= FormattingCustomizerPanel.copyValueIfExists(map, preferences, "spaces-per-tab");
                bl |= FormattingCustomizerPanel.copyValueIfExists(map, preferences, "tab-size");
                if (string.length() <= 0 || !(bl |= FormattingCustomizerPanel.copyValueIfExists(map, preferences, "text-limit-width"))) continue;
                preferences.putBoolean("FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS", true);
            }
        }
    }

    private void loadButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        FileObject fileObject;
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        if (jFileChooser.showOpenDialog(this) == 0 && (fileObject = FileUtil.toFileObject((File)(file = jFileChooser.getSelectedFile()))) != null) {
            Object object;
            Object object2;
            try {
                object2 = ProjectManager.getDefault().findProject(fileObject);
                if (object2 == this.pf.getProject()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"MSG_CodeStyle_Import_Forbidden_From_The_Same_Project"), -1));
                    return;
                }
                object = ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                    public Object run() throws Exception {
                        Preferences preferences = ProjectUtils.getPreferences((Project)object2, IndentUtils.class, (boolean)true);
                        if (!preferences.nodeExists(FormattingCustomizerPanel.CODE_STYLE_PROFILE) || preferences.node(FormattingCustomizerPanel.CODE_STYLE_PROFILE).get(FormattingCustomizerPanel.USED_PROFILE, null) == null) {
                            return NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"MSG_No_CodeStyle_Info_To_Import");
                        }
                        ProjectPreferencesFactory projectPreferencesFactory = new ProjectPreferencesFactory(FormattingCustomizerPanel.this.pf.getProject());
                        ProxyPreferences proxyPreferences = projectPreferencesFactory.projectPrefs;
                        FormattingCustomizerPanel.removeAllKidsAndKeys(proxyPreferences);
                        FormattingCustomizerPanel.deepCopy(preferences, proxyPreferences);
                        return projectPreferencesFactory;
                    }
                });
            }
            catch (Exception exception) {
                LOG.log(Level.INFO, null, exception);
                object = exception;
            }
            if (object instanceof ProjectPreferencesFactory) {
                object2 = this.selector.getSelectedMimeType();
                PreferencesCustomizer preferencesCustomizer = this.selector.getSelectedCustomizer();
                String string = preferencesCustomizer != null ? preferencesCustomizer.getId() : null;
                this.pf.destroy();
                this.pf = (ProjectPreferencesFactory)object;
                this.selector = new CustomizerSelector(this.pf, false, this.allowedMimeTypes);
                this.panel.setSelector(this.selector);
                if (object2 != null) {
                    this.selector.setSelectedMimeType((String)object2);
                }
                if (string != null) {
                    this.selector.setSelectedCustomizer(string);
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"MSG_CodeStyle_Import_Successful"), -1));
            } else if (object instanceof Exception) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(FormattingCustomizerPanel.class, (String)"MSG_CodeStyle_Import_Failed"), 2));
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)((String)object), -1));
            }
        }
    }

    private void dump(Preferences preferences, String string) throws BackingStoreException {
        for (String string2 : preferences.keys()) {
            System.out.println(string + ", " + preferences.absolutePath() + "/" + string2 + "=" + preferences.get(string2, null));
        }
        for (String string2 : preferences.childrenNames()) {
            this.dump(preferences.node(string2), string);
        }
    }

    private void editGlobalButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open(GLOBAL_OPTIONS_CATEGORY);
    }

    private FormattingCustomizerPanel(Lookup lookup, String string) {
        this.allowedMimeTypes = string;
        this.pf = new ProjectPreferencesFactory((Project)lookup.lookup(Project.class));
        this.selector = new CustomizerSelector(this.pf, false, string);
        this.panel = new FormattingPanel();
        this.panel.setSelector(this.selector);
        this.initComponents();
        this.customizerPanel.add((Component)this.panel, "Center");
        Preferences preferences = this.pf.getPreferences("").parent();
        this.copyOnFork = preferences.get(USED_PROFILE, null) == null;
        String string2 = preferences.get(USED_PROFILE, DEFAULT_PROFILE);
        if (DEFAULT_PROFILE.equals(string2)) {
            this.globalButton.setSelected(true);
            this.loadButton.setEnabled(false);
            this.setEnabled(this.panel, false);
        } else {
            this.projectButton.setSelected(true);
            this.loadButton.setEnabled(true);
            this.setEnabled(this.panel, true);
        }
    }

    private void setEnabled(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof Container && !(component instanceof JSpinner)) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.setEnabled(component2, bl);
            }
        }
    }

    private static boolean copyValueIfExists(Map<String, TypedValue> map, Preferences preferences, String string) {
        TypedValue typedValue = map.get(string);
        if (typedValue != null) {
            preferences.put(string, typedValue.getValue());
            return true;
        }
        return false;
    }

    private static void removeAllKidsAndKeys(Preferences preferences) throws BackingStoreException {
        for (String string : preferences.childrenNames()) {
            FormattingCustomizerPanel.removeAllKidsAndKeys(preferences.node(string));
        }
        for (String string : preferences.keys()) {
            preferences.remove(string);
        }
    }

    private static void deepCopy(Preferences preferences, Preferences preferences2) throws BackingStoreException {
        Object object;
        Object object2;
        for (String string : preferences.childrenNames()) {
            object2 = preferences.node(string);
            object = preferences2.node(string);
            FormattingCustomizerPanel.deepCopy((Preferences)object2, (Preferences)object);
        }
        for (String string : preferences.keys()) {
            object2 = preferences.get(string, null);
            if (object2 == null) continue;
            object = FormattingCustomizerPanel.guessType((String)object2);
            if (Integer.class == object) {
                preferences2.putInt(string, preferences.getInt(string, -1));
                continue;
            }
            if (Long.class == object) {
                preferences2.putLong(string, preferences.getLong(string, -1L));
                continue;
            }
            if (Float.class == object) {
                preferences2.putFloat(string, preferences.getFloat(string, -1.0f));
                continue;
            }
            if (Double.class == object) {
                preferences2.putDouble(string, preferences.getDouble(string, -1.0));
                continue;
            }
            if (Boolean.class == object) {
                preferences2.putBoolean(string, preferences.getBoolean(string, false));
                continue;
            }
            if (String.class == object) {
                preferences2.put(string, (String)object2);
                continue;
            }
            preferences2.putByteArray(string, preferences.getByteArray(string, new byte[0]));
        }
    }

    private static Class guessType(String string) {
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
            return Boolean.class;
        }
        try {
            Integer.parseInt(string);
            return Integer.class;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Long.parseLong(string);
                return Long.class;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    Float.parseFloat(string);
                    return Float.class;
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        Double.parseDouble(string);
                        return Double.class;
                    }
                    catch (NumberFormatException numberFormatException4) {
                        return String.class;
                    }
                }
            }
        }
    }

    public static class Factory
    implements ProjectCustomizer.CompositeCategoryProvider {
        private static final String CATEGORY_FORMATTING = "Formatting";
        private final String allowedMimeTypes;

        public Factory() {
            this(null);
        }

        public Factory(String string) {
            this.allowedMimeTypes = string;
        }

        public ProjectCustomizer.Category createCategory(Lookup lookup) {
            return lookup.lookup(Project.class) == null ? null : ProjectCustomizer.Category.create((String)CATEGORY_FORMATTING, (String)NbBundle.getMessage(Factory.class, (String)"LBL_CategoryFormatting"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        }

        public JComponent createComponent(ProjectCustomizer.Category category, Lookup lookup) {
            FormattingCustomizerPanel formattingCustomizerPanel = new FormattingCustomizerPanel(lookup, this.allowedMimeTypes);
            category.setStoreListener((ActionListener)formattingCustomizerPanel);
            return formattingCustomizerPanel;
        }
    }

    private static final class ProjectPreferencesFactory
    implements CustomizerSelector.PreferencesFactory {
        private final Project project;
        private final Set<String> accessedMimeTypes = new HashSet<String>();
        private ProxyPreferences projectPrefs;

        public ProjectPreferencesFactory(Project project) {
            this.project = project;
            Preferences preferences = ProjectUtils.getPreferences((Project)project, IndentUtils.class, (boolean)true);
            this.projectPrefs = ProxyPreferences.getProxyPreferences(this, preferences);
        }

        public Project getProject() {
            return this.project;
        }

        public void destroy() {
            this.accessedMimeTypes.clear();
            this.projectPrefs.destroy();
            this.projectPrefs = null;
        }

        public synchronized Preferences getPreferences(String string) {
            assert (this.projectPrefs != null);
            this.accessedMimeTypes.add(string);
            return this.projectPrefs.node(string).node(FormattingCustomizerPanel.CODE_STYLE_PROFILE).node(FormattingCustomizerPanel.PROJECT_PROFILE);
        }

        public synchronized void applyChanges() {
            for (String string : this.accessedMimeTypes) {
                ProxyPreferences proxyPreferences;
                if (string.length() == 0 || null == (proxyPreferences = (ProxyPreferences)this.getPreferences(string)).get("FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS", null)) continue;
                proxyPreferences.silence();
                if (!proxyPreferences.getBoolean("FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS", false)) {
                    proxyPreferences.remove("expand-tabs");
                    proxyPreferences.remove("indent-shift-width");
                    proxyPreferences.remove("spaces-per-tab");
                    proxyPreferences.remove("tab-size");
                    proxyPreferences.remove("text-limit-width");
                }
                proxyPreferences.remove("FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS");
            }
            this.projectPrefs.silence();
            try {
                LOG.fine("Flushing root pp");
                this.projectPrefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                LOG.log(Level.WARNING, "Can't flush project codestyle root preferences", backingStoreException);
            }
            this.destroy();
        }

        public boolean isKeyOverridenForMimeType(String string, String string2) {
            Preferences preferences = this.projectPrefs != null ? this.projectPrefs : ProjectUtils.getPreferences((Project)this.project, IndentUtils.class, (boolean)true);
            preferences = preferences.node(string2).node(FormattingCustomizerPanel.CODE_STYLE_PROFILE).node(FormattingCustomizerPanel.PROJECT_PROFILE);
            return preferences.get(string, null) != null;
        }
    }
}

