/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.netbeans.modules.editor.settings.storage.spi.TypedValue;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.netbeans.modules.options.indentation.CustomizerSelector;
import org.netbeans.modules.options.indentation.FormattingPanel;
import org.netbeans.modules.options.indentation.ProxyPreferences;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public final class FormattingPanelController
extends OptionsPanelController {
    public static final String OVERRIDE_GLOBAL_FORMATTING_OPTIONS = "FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS";
    private static final Logger LOG = Logger.getLogger(FormattingPanelController.class.getName());
    private static String[] BASIC_SETTINGS_NAMES = new String[]{"expand-tabs", "indent-shift-width", "spaces-per-tab", "tab-size", "text-limit-width"};
    private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private MimeLookupPreferencesFactory pf;
    private CustomizerSelector selector;
    private FormattingPanel panel;
    private boolean changed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        boolean bl;
        FormattingPanelController formattingPanelController = this;
        synchronized (formattingPanelController) {
            LOG.fine("update");
            if (this.pf != null) {
                this.pf.destroy();
            }
            this.pf = new MimeLookupPreferencesFactory(new Callable(){

                public Object call() {
                    FormattingPanelController.this.notifyChanged(true);
                    return null;
                }
            });
            this.selector = new CustomizerSelector(this.pf, true, null);
            this.panel.setSelector(this.selector);
            bl = this.changed;
            this.changed = false;
        }
        if (bl) {
            this.pcs.firePropertyChange("changed", true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges() {
        boolean bl;
        FormattingPanelController formattingPanelController = this;
        synchronized (formattingPanelController) {
            LOG.fine("applyChanges");
            this.pf.applyChanges();
            for (String object2 : this.pf.getAccessedMimeTypes()) {
                for (PreferencesCustomizer preferencesCustomizer : this.selector.getCustomizers(object2)) {
                    if (!(preferencesCustomizer instanceof CustomizerSelector.WrapperCustomizer)) continue;
                    ((CustomizerSelector.WrapperCustomizer)preferencesCustomizer).applyChanges();
                }
            }
            HashSet hashSet = new HashSet(EditorSettings.getDefault().getAllMimeTypes());
            hashSet.removeAll(this.selector.getMimeTypes());
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Preferences preferences = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
                EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get((String)"Preferences");
                for (String string2 : BASIC_SETTINGS_NAMES) {
                    try {
                        Map map = editorSettingsStorage.load(MimePath.parse((String)string), null, false);
                        Map map2 = editorSettingsStorage.load(MimePath.parse((String)string), null, true);
                        if (!map.containsKey(string2) && !map2.containsKey(string2)) continue;
                        TypedValue typedValue = (TypedValue)map2.get(string2);
                        if (typedValue != null) {
                            if (typedValue.getJavaType().equals(Integer.class.getName())) {
                                preferences.putInt(string2, Integer.parseInt(typedValue.getValue()));
                                continue;
                            }
                            if (typedValue.getJavaType().equals(Boolean.class.getName())) {
                                preferences.putBoolean(string2, Boolean.parseBoolean(typedValue.getValue()));
                                continue;
                            }
                            preferences.put(string2, typedValue.getValue());
                            continue;
                        }
                        preferences.remove(string2);
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.WARNING, null, iOException);
                    }
                }
            }
            this.pf.destroy();
            this.pf = null;
            this.panel.setSelector(null);
            this.selector = null;
            bl = this.changed;
            this.changed = false;
        }
        if (bl) {
            this.pcs.firePropertyChange("changed", true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        boolean bl;
        FormattingPanelController formattingPanelController = this;
        synchronized (formattingPanelController) {
            LOG.fine("cancel");
            for (String string : this.pf.getAccessedMimeTypes()) {
                for (PreferencesCustomizer preferencesCustomizer : this.selector.getCustomizers(string)) {
                    if (!(preferencesCustomizer instanceof CustomizerSelector.WrapperCustomizer)) continue;
                    ((CustomizerSelector.WrapperCustomizer)preferencesCustomizer).cancel();
                }
            }
            this.pf.destroy();
            this.pf = null;
            this.panel.setSelector(null);
            this.selector = null;
            bl = this.changed;
            this.changed = false;
        }
        if (bl) {
            this.pcs.firePropertyChange("changed", true, false);
        }
    }

    public boolean isValid() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChanged() {
        FormattingPanelController formattingPanelController = this;
        synchronized (formattingPanelController) {
            return this.changed;
        }
    }

    public HelpCtx getHelpCtx() {
        PreferencesCustomizer preferencesCustomizer = this.selector == null ? null : this.selector.getSelectedCustomizer();
        HelpCtx helpCtx = preferencesCustomizer == null ? null : preferencesCustomizer.getHelpCtx();
        return helpCtx != null ? helpCtx : new HelpCtx("netbeans.optionsDialog.editor.formatting");
    }

    public synchronized JComponent getComponent(Lookup lookup) {
        if (this.panel == null) {
            this.panel = new FormattingPanel();
        }
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChanged(boolean bl) {
        boolean bl2;
        FormattingPanelController formattingPanelController = this;
        synchronized (formattingPanelController) {
            if (this.changed != bl) {
                this.changed = bl;
                bl2 = true;
            } else {
                bl2 = false;
            }
        }
        if (bl2) {
            this.pcs.firePropertyChange("changed", !bl, bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MimeLookupPreferencesFactory
    implements CustomizerSelector.PreferencesFactory,
    PreferenceChangeListener,
    NodeChangeListener {
        private final Map<String, ProxyPreferences> mimeTypePreferences = new HashMap<String, ProxyPreferences>();
        private final PreferenceChangeListener weakPrefL = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, null);
        private final NodeChangeListener weakNodeL = (NodeChangeListener)WeakListeners.create(NodeChangeListener.class, (EventListener)this, null);
        private final Callable callback;

        public MimeLookupPreferencesFactory(Callable callable) {
            this.callback = callable;
        }

        public Set<? extends String> getAccessedMimeTypes() {
            return this.mimeTypePreferences.keySet();
        }

        public void applyChanges() {
            for (String string : this.mimeTypePreferences.keySet()) {
                ProxyPreferences proxyPreferences = this.mimeTypePreferences.get(string);
                proxyPreferences.silence();
                if (string.length() > 0) {
                    if (!proxyPreferences.getBoolean(FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS, false)) {
                        for (String string2 : BASIC_SETTINGS_NAMES) {
                            proxyPreferences.remove(string2);
                        }
                    }
                    proxyPreferences.remove(FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS);
                } else assert (proxyPreferences.get(FormattingPanelController.OVERRIDE_GLOBAL_FORMATTING_OPTIONS, null) == null);
                try {
                    LOG.fine("    flushing pp for '" + string + "'");
                    proxyPreferences.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    LOG.log(Level.WARNING, "Can't flush preferences for '" + string + "'", backingStoreException);
                }
            }
        }

        public void destroy() {
            for (String string : this.mimeTypePreferences.keySet()) {
                ProxyPreferences proxyPreferences = this.mimeTypePreferences.get(string);
                proxyPreferences.removeNodeChangeListener(this.weakNodeL);
                proxyPreferences.removePreferenceChangeListener(this.weakPrefL);
                proxyPreferences.destroy();
                LOG.fine("destroying pp for '" + string + "'");
            }
            this.mimeTypePreferences.clear();
        }

        @Override
        public Preferences getPreferences(String string) {
            ProxyPreferences proxyPreferences = this.mimeTypePreferences.get(string);
            try {
                if (proxyPreferences != null && !proxyPreferences.nodeExists("")) {
                    proxyPreferences = null;
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            if (proxyPreferences == null) {
                Preferences preferences = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
                proxyPreferences = ProxyPreferences.getProxyPreferences(this, preferences);
                proxyPreferences.addPreferenceChangeListener(this.weakPrefL);
                proxyPreferences.addNodeChangeListener(this.weakNodeL);
                this.mimeTypePreferences.put(string, proxyPreferences);
                LOG.fine("getPreferences(" + string + ")");
            }
            return proxyPreferences;
        }

        @Override
        public boolean isKeyOverridenForMimeType(String string, String string2) {
            EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get((String)"Preferences");
            try {
                Map map = editorSettingsStorage.load(MimePath.parse((String)string2), null, false);
                return map.containsKey(string);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
                return false;
            }
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            try {
                this.callback.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void childAdded(NodeChangeEvent nodeChangeEvent) {
            try {
                this.callback.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void childRemoved(NodeChangeEvent nodeChangeEvent) {
            try {
                this.callback.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

