/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.modules.editor.settings.storage.spi.TypedValue;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyPreferences
extends Preferences
implements PreferenceChangeListener,
NodeChangeListener {
    private static final Logger LOG = Logger.getLogger(ProxyPreferences.class.getName());
    private final ProxyPreferences parent;
    private final String name;
    private Preferences delegate;
    private final Tree tree;
    private boolean removed;
    private final Map<String, TypedValue> data = new HashMap<String, TypedValue>();
    private final Set<String> removedKeys = new HashSet<String>();
    private final Map<String, ProxyPreferences> children = new HashMap<String, ProxyPreferences>();
    private final Set<String> removedChildren = new HashSet<String>();
    private boolean noEvents = false;
    private PreferenceChangeListener weakPrefListener;
    private final Set<PreferenceChangeListener> prefListeners = new HashSet<PreferenceChangeListener>();
    private NodeChangeListener weakNodeListener;
    private final Set<NodeChangeListener> nodeListeners = new HashSet<NodeChangeListener>();

    public static ProxyPreferences getProxyPreferences(Object object, Preferences preferences) {
        return Tree.getTree(object, preferences).get(null, preferences.name(), preferences);
    }

    @Override
    public void put(String string, String string2) {
        this._put(string, string2, String.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String string, String string2) {
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.checkNotNull(string, "key");
            this.checkRemoved();
            if (this.removedKeys.contains(string)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Key '" + string + "' removed, using default '" + string2 + "'");
                }
                return string2;
            }
            TypedValue typedValue = this.data.get(string);
            if (typedValue != null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Key '" + string + "' modified, local value '" + typedValue.getValue() + "'");
                }
                return typedValue.getValue();
            }
            if (this.delegate != null) {
                String string3 = this.delegate.get(string, string2);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Key '" + string + "' undefined, original value '" + string3 + "'");
                }
                return string3;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Key '" + string + "' undefined, '" + this.name + "' is a new node, using default '" + string2 + "'");
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String string) {
        EventBag<PreferenceChangeListener, PreferenceChangeEvent> eventBag = null;
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.checkNotNull(string, "key");
            this.checkRemoved();
            if (this.removedKeys.add(string)) {
                this.data.remove(string);
                eventBag = new EventBag<PreferenceChangeListener, PreferenceChangeEvent>();
                eventBag.addListeners(this.prefListeners);
                eventBag.addEvent(new PreferenceChangeEvent(this, string, null));
            }
        }
        if (eventBag != null) {
            this.firePrefEvents(Collections.singletonList(eventBag));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws BackingStoreException {
        EventBag<PreferenceChangeListener, PreferenceChangeEvent> eventBag = new EventBag<PreferenceChangeListener, PreferenceChangeEvent>();
        Object object = this.tree.treeLock();
        synchronized (object) {
            String string;
            this.checkRemoved();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(this.data.keySet());
            hashSet.removeAll(this.removedKeys);
            if (!hashSet.isEmpty()) {
                for (String string2 : hashSet) {
                    string = this.delegate == null ? null : this.delegate.get(string2, null);
                    eventBag.addEvent(new PreferenceChangeEvent(this, string2, string));
                }
            }
            if (this.delegate != null) {
                for (String string2 : this.removedKeys) {
                    string = this.delegate.get(string2, null);
                    if (string == null) continue;
                    eventBag.addEvent(new PreferenceChangeEvent(this, string2, string));
                }
            }
            eventBag.addListeners(this.prefListeners);
            this.data.clear();
            this.removedKeys.clear();
        }
        this.firePrefEvents(Collections.singletonList(eventBag));
    }

    @Override
    public void putInt(String string, int n) {
        this._put(string, Integer.toString(n), Integer.class.getName());
    }

    @Override
    public int getInt(String string, int n) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public void putLong(String string, long l) {
        this._put(string, Long.toString(l), Long.class.getName());
    }

    @Override
    public long getLong(String string, long l) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    @Override
    public void putBoolean(String string, boolean bl) {
        this._put(string, Boolean.toString(bl), Boolean.class.getName());
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    @Override
    public void putFloat(String string, float f) {
        this._put(string, Float.toString(f), Float.class.getName());
    }

    @Override
    public float getFloat(String string, float f) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return f;
    }

    @Override
    public void putDouble(String string, double d) {
        this._put(string, Double.toString(d), Double.class.getName());
    }

    @Override
    public double getDouble(String string, double d) {
        String string2 = this.get(string, null);
        if (string2 != null) {
            try {
                return Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    @Override
    public void putByteArray(String string, byte[] byArray) {
        this._put(string, Base64.encode(byArray), byArray.getClass().getName());
    }

    @Override
    public byte[] getByteArray(String string, byte[] byArray) {
        byte[] byArray2;
        String string2 = this.get(string, null);
        if (string2 != null && (byArray2 = Base64.decode(string2)) != null) {
            return byArray2;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] keys() throws BackingStoreException {
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.checkRemoved();
            HashSet<String> hashSet = new HashSet<String>();
            if (this.delegate != null) {
                hashSet.addAll(Arrays.asList(this.delegate.keys()));
            }
            hashSet.addAll(this.data.keySet());
            hashSet.removeAll(this.removedKeys);
            return hashSet.toArray(new String[hashSet.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] childrenNames() throws BackingStoreException {
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.checkRemoved();
            HashSet<String> hashSet = new HashSet<String>();
            if (this.delegate != null) {
                hashSet.addAll(Arrays.asList(this.delegate.childrenNames()));
            }
            hashSet.addAll(this.children.keySet());
            hashSet.removeAll(this.removedChildren);
            return hashSet.toArray(new String[hashSet.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Preferences parent() {
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.checkRemoved();
            return this.parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Preferences node(String string) {
        ProxyPreferences proxyPreferences;
        LinkedList<EventBag<NodeChangeListener, NodeChangeEvent>> linkedList = new LinkedList<EventBag<NodeChangeListener, NodeChangeEvent>>();
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.checkNotNull(string, "pathName");
            this.checkRemoved();
            proxyPreferences = this.node(string, true, linkedList);
        }
        this.fireNodeEvents(linkedList);
        return proxyPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nodeExists(String string) throws BackingStoreException {
        Object object = this.tree.treeLock();
        synchronized (object) {
            if (string.length() == 0) {
                return !this.removed;
            }
            this.checkRemoved();
            return this.node(string, false, null) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode() throws BackingStoreException {
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.checkRemoved();
            ProxyPreferences proxyPreferences = this.parent;
            if (proxyPreferences == null) {
                throw new UnsupportedOperationException("Can't remove the root.");
            }
            proxyPreferences.removeChild(this);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String absolutePath() {
        Object object = this.tree.treeLock();
        synchronized (object) {
            ProxyPreferences proxyPreferences = this.parent;
            if (proxyPreferences != null) {
                if (proxyPreferences.parent == null) {
                    return "/" + this.name();
                }
                return proxyPreferences.absolutePath() + "/" + this.name();
            }
            return "/";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserNode() {
        Object object = this.tree.treeLock();
        synchronized (object) {
            if (this.delegate != null) {
                return this.delegate.isUserNode();
            }
            ProxyPreferences proxyPreferences = this.parent;
            if (proxyPreferences != null) {
                return proxyPreferences.isUserNode();
            }
            return true;
        }
    }

    @Override
    public String toString() {
        return (this.isUserNode() ? "User" : "System") + " Preference Node: " + this.absolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws BackingStoreException {
        Object object = this.tree.treeLock();
        synchronized (object) {
            Preferences preferences;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Flushing " + this.absolutePath());
            }
            this.checkRemoved();
            for (ProxyPreferences object2 : this.children.values()) {
                object2.flush();
            }
            if (this.delegate == null) {
                Iterator<String> iterator = this.parent.node("/", false, null);
                assert (iterator != null) : "Root must always exist";
                Preferences preferences2 = ((ProxyPreferences)((Object)iterator)).delegate;
                assert (preferences2 != null) : "Root must always have its corresponding delegate";
                preferences = preferences2.node(this.absolutePath());
                this.changeDelegate(preferences);
            }
            this.delegate.removeNodeChangeListener(this.weakNodeListener);
            this.delegate.removePreferenceChangeListener(this.weakPrefListener);
            try {
                for (String string : this.removedChildren) {
                    if (!this.delegate.nodeExists(string)) continue;
                    this.delegate.node(string).removeNode();
                }
                for (String string : this.data.keySet()) {
                    if (this.removedKeys.contains(string)) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Writing " + this.absolutePath() + "/" + string + "=" + this.data.get(string));
                    }
                    preferences = this.data.get(string);
                    if (String.class.getName().equals(preferences.getJavaType())) {
                        this.delegate.put(string, preferences.getValue());
                        continue;
                    }
                    if (Integer.class.getName().equals(preferences.getJavaType())) {
                        this.delegate.putInt(string, Integer.parseInt(preferences.getValue()));
                        continue;
                    }
                    if (Long.class.getName().equals(preferences.getJavaType())) {
                        this.delegate.putLong(string, Long.parseLong(preferences.getValue()));
                        continue;
                    }
                    if (Boolean.class.getName().equals(preferences.getJavaType())) {
                        this.delegate.putBoolean(string, Boolean.parseBoolean(preferences.getValue()));
                        continue;
                    }
                    if (Float.class.getName().equals(preferences.getJavaType())) {
                        this.delegate.putFloat(string, Float.parseFloat(preferences.getValue()));
                        continue;
                    }
                    if (Double.class.getName().equals(preferences.getJavaType())) {
                        this.delegate.putDouble(string, Double.parseDouble(preferences.getValue()));
                        continue;
                    }
                    this.delegate.putByteArray(string, Base64.decode(preferences.getValue()));
                }
                this.data.clear();
                for (String string : this.removedKeys) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Removing " + this.absolutePath() + "/" + string);
                    }
                    this.delegate.remove(string);
                }
                this.removedKeys.clear();
            }
            finally {
                this.delegate.addNodeChangeListener(this.weakNodeListener);
                this.delegate.addPreferenceChangeListener(this.weakPrefListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws BackingStoreException {
        ArrayList<EventBag<PreferenceChangeListener, PreferenceChangeEvent>> arrayList = new ArrayList<EventBag<PreferenceChangeListener, PreferenceChangeEvent>>();
        ArrayList<EventBag<NodeChangeListener, NodeChangeEvent>> arrayList2 = new ArrayList<EventBag<NodeChangeListener, NodeChangeEvent>>();
        Object object = this.tree.treeLock();
        synchronized (object) {
            this._sync(arrayList, arrayList2);
        }
        this.fireNodeEvents(arrayList2);
        this.firePrefEvents(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.prefListeners.add(preferenceChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.prefListeners.remove(preferenceChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNodeChangeListener(NodeChangeListener nodeChangeListener) {
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.nodeListeners.add(nodeChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeChangeListener(NodeChangeListener nodeChangeListener) {
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.nodeListeners.remove(nodeChangeListener);
        }
    }

    @Override
    public void exportNode(OutputStream outputStream) throws IOException, BackingStoreException {
        throw new UnsupportedOperationException("exportNode not supported");
    }

    @Override
    public void exportSubtree(OutputStream outputStream) throws IOException, BackingStoreException {
        throw new UnsupportedOperationException("exportSubtree not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        PreferenceChangeListener[] preferenceChangeListenerArray;
        Object object = this.tree.treeLock();
        synchronized (object) {
            if (this.removed || this.removedKeys.contains(preferenceChangeEvent.getKey()) || this.data.containsKey(preferenceChangeEvent.getKey())) {
                return;
            }
            preferenceChangeListenerArray = this.prefListeners.toArray(new PreferenceChangeListener[this.prefListeners.size()]);
        }
        object = null;
        for (PreferenceChangeListener preferenceChangeListener : preferenceChangeListenerArray) {
            if (object == null) {
                object = new PreferenceChangeEvent(this, preferenceChangeEvent.getKey(), preferenceChangeEvent.getNewValue());
            }
            preferenceChangeListener.preferenceChange((PreferenceChangeEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void childAdded(NodeChangeEvent nodeChangeEvent) {
        NodeChangeListener[] nodeChangeListenerArray;
        Preferences preferences;
        Object object = this.tree.treeLock();
        synchronized (object) {
            NodeChangeListener[] nodeChangeListenerArray2 = nodeChangeEvent.getChild().name();
            if (this.removed || this.removedChildren.contains(nodeChangeListenerArray2)) {
                return;
            }
            preferences = this.children.get(nodeChangeListenerArray2);
            if (preferences != null) {
                ((ProxyPreferences)preferences).changeDelegate(nodeChangeEvent.getChild());
            } else {
                preferences = this.node(nodeChangeEvent.getChild().name());
            }
            nodeChangeListenerArray = this.nodeListeners.toArray(new NodeChangeListener[this.nodeListeners.size()]);
        }
        object = null;
        for (NodeChangeListener nodeChangeListener : nodeChangeListenerArray) {
            if (object == null) {
                object = new NodeChangeEvent(this, preferences);
            }
            nodeChangeListener.childAdded(nodeChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void childRemoved(NodeChangeEvent nodeChangeEvent) {
        NodeChangeListener[] nodeChangeListenerArray;
        Preferences preferences;
        Object object = this.tree.treeLock();
        synchronized (object) {
            NodeChangeListener[] nodeChangeListenerArray2 = nodeChangeEvent.getChild().name();
            if (this.removed || this.removedChildren.contains(nodeChangeListenerArray2)) {
                return;
            }
            preferences = this.children.get(nodeChangeListenerArray2);
            if (preferences == null) {
                return;
            }
            ((ProxyPreferences)preferences).changeDelegate(null);
            nodeChangeListenerArray = this.nodeListeners.toArray(new NodeChangeListener[this.nodeListeners.size()]);
        }
        object = null;
        for (NodeChangeListener nodeChangeListener : nodeChangeListenerArray) {
            if (object == null) {
                object = new NodeChangeEvent(this, preferences);
            }
            nodeChangeListener.childAdded(nodeChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.tree.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void silence() {
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.noEvents = true;
        }
    }

    private ProxyPreferences(ProxyPreferences proxyPreferences, String string, Preferences preferences, Tree tree) {
        assert (string != null);
        this.parent = proxyPreferences;
        this.name = string;
        this.delegate = preferences;
        if (preferences != null) {
            assert (string.equals(preferences.name()));
            this.weakPrefListener = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)preferences);
            preferences.addPreferenceChangeListener(this.weakPrefListener);
            this.weakNodeListener = (NodeChangeListener)WeakListeners.create(NodeChangeListener.class, (EventListener)this, (Object)preferences);
            preferences.addNodeChangeListener(this.weakNodeListener);
        }
        this.tree = tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _put(String string, String string2, String string3) {
        EventBag<PreferenceChangeListener, PreferenceChangeEvent> eventBag = null;
        Object object = this.tree.treeLock();
        synchronized (object) {
            this.checkNotNull(string, "key");
            this.checkNotNull(string2, "value");
            this.checkRemoved();
            String string4 = this.get(string, null);
            if (string4 == null || !string4.equals(string2)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Overwriting '" + string + "' = '" + string2 + "'");
                }
                this.data.put(string, new TypedValue(string2, string3));
                this.removedKeys.remove(string);
                eventBag = new EventBag<PreferenceChangeListener, PreferenceChangeEvent>();
                eventBag.addListeners(this.prefListeners);
                eventBag.addEvent(new PreferenceChangeEvent(this, string, string2));
            }
        }
        if (eventBag != null) {
            this.firePrefEvents(Collections.singletonList(eventBag));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ProxyPreferences node(String string, boolean bl, List<EventBag<NodeChangeListener, NodeChangeEvent>> list) {
        void var4_9;
        String string2;
        if (string.length() > 0 && string.charAt(0) == '/') {
            if (this.parent != null) {
                void var4_5;
                ProxyPreferences proxyPreferences = this;
                while (var4_5.parent() != null) {
                    Preferences preferences = var4_5.parent();
                }
                return ((ProxyPreferences)var4_5).node(string, bl, list);
            }
            string = string.substring(1);
        }
        if (string.length() <= 0) return this;
        int n = string.indexOf(47);
        if (n != -1) {
            String string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            String string4 = string;
            string2 = null;
        }
        ProxyPreferences proxyPreferences = this.children.get(var4_9);
        if (proxyPreferences == null) {
            if (this.removedChildren.contains(var4_9) && !bl) {
                return null;
            }
            Preferences preferences = null;
            try {
                if (this.delegate != null && this.delegate.nodeExists((String)var4_9)) {
                    preferences = this.delegate.node((String)var4_9);
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            if (preferences == null && !bl) return null;
            proxyPreferences = this.tree.get(this, (String)var4_9, preferences);
            this.children.put((String)var4_9, proxyPreferences);
            this.removedChildren.remove(var4_9);
            if (preferences != null) return string2 != null ? proxyPreferences.node(string2, bl, list) : proxyPreferences;
            EventBag<NodeChangeListener, NodeChangeEventExt> eventBag = new EventBag<NodeChangeListener, NodeChangeEventExt>();
            eventBag.addListeners(this.nodeListeners);
            eventBag.addEvent(new NodeChangeEventExt(this, proxyPreferences, false));
            list.add(eventBag);
            return string2 != null ? proxyPreferences.node(string2, bl, list) : proxyPreferences;
        }
        assert (!proxyPreferences.removed);
        return string2 != null ? proxyPreferences.node(string2, bl, list) : proxyPreferences;
    }

    private void addChild(ProxyPreferences proxyPreferences) {
        ProxyPreferences proxyPreferences2 = this.children.get(proxyPreferences.name());
        if (proxyPreferences2 == null) {
            this.children.put(proxyPreferences.name(), proxyPreferences);
        } else assert (proxyPreferences2 == proxyPreferences);
    }

    private void removeChild(ProxyPreferences proxyPreferences) {
        assert (proxyPreferences != null);
        assert (this.children.get(proxyPreferences.name()) == proxyPreferences);
        proxyPreferences.nodeRemoved();
        this.children.remove(proxyPreferences.name());
        this.removedChildren.add(proxyPreferences.name());
    }

    private void nodeRemoved() {
        for (ProxyPreferences proxyPreferences : this.children.values()) {
            proxyPreferences.nodeRemoved();
        }
        this.data.clear();
        this.removedKeys.clear();
        this.children.clear();
        this.removedChildren.clear();
        this.tree.removeNode(this);
        this.removed = true;
    }

    private void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("The " + string + " must not be null");
        }
    }

    private void checkRemoved() {
        if (this.removed) {
            throw new IllegalStateException("The node '" + this + " has already been removed.");
        }
    }

    private void changeDelegate(Preferences preferences) {
        if (this.delegate != null) {
            try {
                if (this.delegate.nodeExists("")) {
                    assert (this.weakPrefListener != null);
                    assert (this.weakNodeListener != null);
                    this.delegate.removePreferenceChangeListener(this.weakPrefListener);
                    this.delegate.removeNodeChangeListener(this.weakNodeListener);
                }
            }
            catch (BackingStoreException backingStoreException) {
                LOG.log(Level.WARNING, null, backingStoreException);
            }
        }
        this.delegate = preferences;
        this.weakPrefListener = null;
        this.weakNodeListener = null;
        if (this.delegate != null) {
            this.weakPrefListener = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.delegate);
            this.delegate.addPreferenceChangeListener(this.weakPrefListener);
            this.weakNodeListener = (NodeChangeListener)WeakListeners.create(NodeChangeListener.class, (EventListener)this, (Object)this.delegate);
            this.delegate.addNodeChangeListener(this.weakNodeListener);
        }
    }

    private void _sync(List<EventBag<PreferenceChangeListener, PreferenceChangeEvent>> list, List<EventBag<NodeChangeListener, NodeChangeEvent>> list2) {
        for (ProxyPreferences object : this.children.values()) {
            object._sync(list, list2);
        }
        EventBag eventBag = new EventBag();
        eventBag.addListeners(this.nodeListeners);
        for (ProxyPreferences proxyPreferences : this.children.values()) {
            if (proxyPreferences.delegate != null) continue;
            eventBag.addEvent(new NodeChangeEventExt(this, proxyPreferences, true));
        }
        if (!eventBag.getEvents().isEmpty()) {
            list2.add(eventBag);
        }
        if (this.delegate != null) {
            EventBag<PreferenceChangeListener, PreferenceChangeEvent> eventBag2 = new EventBag<PreferenceChangeListener, PreferenceChangeEvent>();
            eventBag2.addListeners(this.prefListeners);
            list.add(eventBag2);
            for (String string : this.data.keySet()) {
                eventBag2.addEvent(new PreferenceChangeEvent(this, string, this.delegate.get(string, this.data.get(string).getValue())));
            }
        }
        for (NodeChangeEvent nodeChangeEvent : eventBag.getEvents()) {
            this.children.remove(nodeChangeEvent.getChild().name());
        }
        this.data.clear();
    }

    private void firePrefEvents(List<EventBag<PreferenceChangeListener, PreferenceChangeEvent>> list) {
        if (this.noEvents) {
            return;
        }
        for (EventBag<PreferenceChangeListener, PreferenceChangeEvent> eventBag : list) {
            for (PreferenceChangeEvent preferenceChangeEvent : eventBag.getEvents()) {
                for (PreferenceChangeListener preferenceChangeListener : eventBag.getListeners()) {
                    try {
                        preferenceChangeListener.preferenceChange(preferenceChangeEvent);
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.WARNING, null, throwable);
                    }
                }
            }
        }
    }

    private void fireNodeEvents(List<EventBag<NodeChangeListener, NodeChangeEvent>> list) {
        if (this.noEvents) {
            return;
        }
        for (EventBag<NodeChangeListener, NodeChangeEvent> eventBag : list) {
            for (NodeChangeEvent nodeChangeEvent : eventBag.getEvents()) {
                for (NodeChangeListener nodeChangeListener : eventBag.getListeners()) {
                    try {
                        if (nodeChangeEvent instanceof NodeChangeEventExt && ((NodeChangeEventExt)nodeChangeEvent).isRemovalEvent()) {
                            nodeChangeListener.childRemoved(nodeChangeEvent);
                            continue;
                        }
                        nodeChangeListener.childAdded(nodeChangeEvent);
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.WARNING, null, throwable);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EventBag<L, E extends EventObject> {
        private final Set<L> listeners = new HashSet<L>();
        private final Set<E> events = new HashSet();

        public Set<? extends L> getListeners() {
            return this.listeners;
        }

        public Set<? extends E> getEvents() {
            return this.events;
        }

        public void addListeners(Collection<? extends L> collection) {
            this.listeners.addAll(collection);
        }

        public void addEvent(E e) {
            this.events.add(e);
        }
    }

    private static final class NodeChangeEventExt
    extends NodeChangeEvent {
        private final boolean removal;

        public NodeChangeEventExt(Preferences preferences, Preferences preferences2, boolean bl) {
            super(preferences, preferences2);
            this.removal = bl;
        }

        public boolean isRemovalEvent() {
            return this.removal;
        }
    }

    static final class Tree {
        static final Map<Object, Map<Preferences, Tree>> trees = new WeakHashMap<Object, Map<Preferences, Tree>>();
        private final Preferences root;
        private final Reference<?> tokenRef;
        private final Map<String, ProxyPreferences> nodes = new HashMap<String, ProxyPreferences>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Tree getTree(Object object, Preferences preferences) {
            Map<Object, Map<Preferences, Tree>> map = trees;
            synchronized (map) {
                Preferences preferences2;
                Tree tree;
                Map<Preferences, Tree> map2 = trees.get(object);
                if (map2 == null) {
                    map2 = new HashMap<Preferences, Tree>();
                    trees.put(object, map2);
                }
                if ((tree = map2.get(preferences2 = preferences.node("/"))) == null) {
                    tree = new Tree(object, preferences2);
                    map2.put(preferences2, tree);
                }
                return tree;
            }
        }

        private Tree(Object object, Preferences preferences) {
            this.root = preferences;
            this.tokenRef = new WeakReference<Object>(object);
        }

        public Object treeLock() {
            return this;
        }

        public ProxyPreferences get(ProxyPreferences proxyPreferences, String string, Preferences preferences) {
            ProxyPreferences proxyPreferences2;
            Object object;
            if (preferences != null) {
                assert (string.equals(preferences.name()));
                if (proxyPreferences == null) {
                    object = preferences.parent();
                    if (object != null) {
                        proxyPreferences = this.get(null, ((Preferences)object).name(), (Preferences)object);
                    }
                } else assert (proxyPreferences.delegate == preferences.parent());
            }
            if ((proxyPreferences2 = this.nodes.get(object = proxyPreferences == null ? "/" : (proxyPreferences.parent() == null ? "/" + string : proxyPreferences.absolutePath() + "/" + string))) == null) {
                proxyPreferences2 = new ProxyPreferences(proxyPreferences, string, preferences, this);
                this.nodes.put((String)object, proxyPreferences2);
                if (proxyPreferences != null) {
                    proxyPreferences.addChild(proxyPreferences2);
                }
            } else assert (!proxyPreferences2.removed);
            return proxyPreferences2;
        }

        public void removeNode(ProxyPreferences proxyPreferences) {
            String string = proxyPreferences.absolutePath();
            assert (this.nodes.containsKey(string));
            ProxyPreferences proxyPreferences2 = this.nodes.remove(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Map<Object, Map<Preferences, Tree>> map = trees;
            synchronized (map) {
                Object obj = this.tokenRef.get();
                if (obj != null) {
                    trees.remove(obj);
                }
            }
        }
    }
}

