/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LazyArrayList<T>
extends ArrayList<T> {
    private final Map<Integer, LazyEntry<T>> lazyEntries = new HashMap<Integer, LazyEntry<T>>();

    LazyArrayList() {
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = super.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            LazyEntry<T> lazyEntry = this.lazyEntries.remove(i);
            if (lazyEntry == null) continue;
            objectArray[i] = lazyEntry.get();
            this.set(i, objectArray[i]);
        }
        return objectArray;
    }

    @Override
    public <TT> TT[] toArray(TT[] TTArray) {
        TT[] TTArray2 = super.toArray(TTArray);
        for (int i = 0; i < TTArray2.length; ++i) {
            LazyEntry<T> lazyEntry = this.lazyEntries.remove(i);
            if (lazyEntry == null) continue;
            T t = lazyEntry.get();
            TTArray2[i] = t;
            this.set(i, t);
        }
        return TTArray2;
    }

    private Object[] toOriginalArray() {
        return super.toArray();
    }

    @Override
    public boolean add(LazyEntry<T> lazyEntry) {
        this.lazyEntries.put(this.size(), lazyEntry);
        return this.add((Object)null);
    }

    @Override
    public boolean remove(Object object) {
        if (object instanceof LazyEntry) {
            for (Integer n : this.lazyEntries.keySet()) {
                if (!object.equals(this.lazyEntries.get(n))) continue;
                super.remove(n);
                this.lazyEntries.remove(n);
                this.shiftLazyEntries(n, -1);
                return true;
            }
            return false;
        }
        return super.remove(object);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (collection instanceof LazyArrayList) {
            LazyArrayList lazyArrayList = (LazyArrayList)collection;
            int n = this.size();
            Map<Integer, LazyEntry<T>> map = lazyArrayList.lazyEntries;
            for (Map.Entry<Integer, LazyEntry<T>> entry : map.entrySet()) {
                this.lazyEntries.put(entry.getKey() + n, entry.getValue());
            }
            return super.addAll(Arrays.asList(lazyArrayList.toOriginalArray()));
        }
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        this.lazyEntries.clear();
        super.clear();
    }

    @Override
    public T get(int n) {
        LazyEntry<T> lazyEntry = this.lazyEntries.remove(n);
        if (lazyEntry != null) {
            T t = lazyEntry.get();
            this.set(n, t);
            return t;
        }
        return (T)super.get(n);
    }

    public Object getEntry(int n) {
        LazyEntry<T> lazyEntry = this.lazyEntries.get(n);
        if (lazyEntry != null) {
            return lazyEntry;
        }
        return super.get(n);
    }

    @Override
    public void add(int n, T t) {
        this.shiftLazyEntries(n, 1);
        super.add(n, t);
    }

    @Override
    public T remove(int n) {
        LazyEntry<T> lazyEntry = this.lazyEntries.remove(n);
        if (lazyEntry != null) {
            T t = lazyEntry.get();
            super.remove(n);
            this.shiftLazyEntries(n, -1);
            return t;
        }
        return (T)super.remove(n);
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr();
    }

    private void shiftLazyEntries(int n, final int n2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n22) {
                int n3 = n;
                int n4 = n22;
                return (int)(Math.signum(n4 - n3) * Math.signum(n2));
            }
        });
        treeSet.addAll(this.lazyEntries.keySet());
        for (Integer n3 : treeSet) {
            if (n3 < n) continue;
            this.lazyEntries.put(n3 + n2, this.lazyEntries.remove(n3));
        }
    }

    @Override
    public List<T> subList(int n, int n2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LazyArrayList)) {
            return false;
        }
        LazyArrayList lazyArrayList = (LazyArrayList)object;
        if (this.size() != lazyArrayList.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Object object2 = this.getEntry(i);
            Object object3 = lazyArrayList.getEntry(i);
            if (object2 != null ? object2.equals(object3) : object3 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size(); ++i) {
            Object object = this.getEntry(i);
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    static /* synthetic */ int access$100(LazyArrayList lazyArrayList) {
        return lazyArrayList.modCount;
    }

    private class Itr
    implements Iterator {
        private int cursor = 0;
        private int expectedModCount = LazyArrayList.access$100(LazyArrayList.this);

        private Itr() {
        }

        public boolean hasNext() {
            return this.cursor < LazyArrayList.this.size();
        }

        public Object next() {
            if (this.cursor >= LazyArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            if (LazyArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return LazyArrayList.this.get(this.cursor++);
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class LazyEntry<T> {
        protected LazyEntry() {
        }

        protected abstract T get();
    }
}

