/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathLookup
extends Lookup {
    private Lookup delegate;
    private String path;

    PathLookup(String string) {
        this.delegate = Lookups.forPath((String)string);
        this.path = string;
    }

    public <T> T lookup(Class<T> clazz) {
        Lookup.Item item = this.lookupItem(new Lookup.Template(clazz));
        return (T)(item == null ? null : item.getInstance());
    }

    public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        return this.resultJustForPath(this.delegate.lookup(template));
    }

    public <T> Lookup.Result<T> lookupResult(Class<T> clazz) {
        return this.resultJustForPath(this.delegate.lookupResult(clazz));
    }

    private <T> Lookup.Result<T> resultJustForPath(Lookup.Result<T> result) {
        int n = this.path.length() + 1;
        int n2 = 0;
        Collection collection = result.allItems();
        for (Lookup.Item item : collection) {
            String string = item.getId();
            assert (string.startsWith(this.path)) : "File path '" + string + "' does not start with searched path '" + this.path + "'";
            if (string.indexOf(47, n) > 0) break;
            ++n2;
        }
        if (n2 < collection.size()) {
            return new PathLookupResult<T>(result, n2);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PathLookupResult<T>
    extends Lookup.Result<T> {
        private Lookup.Result<T> orig;
        private int n;

        PathLookupResult(Lookup.Result<T> result, int n) {
            this.orig = result;
            this.n = n;
        }

        public void addLookupListener(LookupListener lookupListener) {
            this.orig.addLookupListener(lookupListener);
        }

        public void removeLookupListener(LookupListener lookupListener) {
            this.orig.removeLookupListener(lookupListener);
        }

        public Collection<? extends T> allInstances() {
            return new PathLookupCollection(this.orig.allInstances(), this.n);
        }

        public Set<Class<? extends T>> allClasses() {
            return new PathLookupSet<Class<? extends T>>(this.orig.allClasses(), this.n);
        }

        public Collection<? extends Lookup.Item<T>> allItems() {
            return new PathLookupCollection(this.orig.allItems(), this.n);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class PathLookupCollection<IT>
        implements Collection<IT> {
            private Collection<IT> delegate;
            private int n;

            PathLookupCollection(Collection<IT> collection, int n) {
                this.delegate = collection;
                this.n = n;
            }

            @Override
            public int size() {
                return this.n;
            }

            @Override
            public boolean isEmpty() {
                return this.n == 0;
            }

            @Override
            public boolean contains(Object object) {
                Iterator<IT> iterator = this.iterator();
                for (int i = 0; i < this.n; ++i) {
                    IT IT = iterator.next();
                    if (object != IT && (object == null || !object.equals(IT))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<IT> iterator() {
                return new PathLookupIterator<IT>(this.delegate.iterator(), this.n);
            }

            @Override
            public Object[] toArray() {
                Object[] objectArray = new Object[this.n];
                Iterator<IT> iterator = this.iterator();
                for (int i = 0; i < this.n; ++i) {
                    objectArray[i] = iterator.next();
                }
                return objectArray;
            }

            @Override
            public <T> T[] toArray(T[] objectArray) {
                if (objectArray.length < this.n) {
                    objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.n);
                }
                System.arraycopy(this.toArray(), 0, objectArray, 0, this.n);
                if (objectArray.length > this.n) {
                    objectArray[this.n] = null;
                }
                return objectArray;
            }

            @Override
            public boolean add(IT IT) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                Iterator<?> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (this.contains(iterator.next())) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends IT> collection) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public void clear() {
                this.delegate.clear();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class PathLookupIterator<IIT>
        implements Iterator<IIT> {
            private int i;
            private Iterator<IIT> delegate;
            private int n;

            PathLookupIterator(Iterator<IIT> iterator, int n) {
                this.delegate = iterator;
                this.n = n;
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.n;
            }

            @Override
            public IIT next() {
                if (this.i < this.n) {
                    ++this.i;
                    return this.delegate.next();
                }
                throw new NoSuchElementException("Index = " + this.i + ", size = " + this.n);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class PathLookupSet<IT>
        extends PathLookupCollection<IT>
        implements Set<IT> {
            PathLookupSet(Set<IT> set, int n) {
                super(set, n);
            }
        }
    }
}

