/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.Action;
import org.netbeans.modules.xml.catalog.CatalogEntry;
import org.netbeans.modules.xml.catalog.lib.URLEnvironment;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.netbeans.modules.xml.catalog.user.UserXMLCatalog;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.EditAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ViewAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;

final class CatalogEntryNode
extends BeanNode
implements EditCookie,
Node.Cookie {
    private transient ViewCookie view;
    private boolean isCatalogWriter;
    private CatalogReader catalogReader;

    public CatalogEntryNode(CatalogEntry catalogEntry) throws IntrospectionException {
        super((Object)catalogEntry);
        this.getCookieSet().add((Node.Cookie)this);
        this.catalogReader = catalogEntry.getCatalog();
        if (this.catalogReader instanceof CatalogWriter) {
            this.isCatalogWriter = true;
        }
    }

    public boolean isCatalogWriter() {
        return this.isCatalogWriter;
    }

    public Action getPreferredAction() {
        if (this.isCatalogWriter) {
            return SystemAction.get(EditAction.class);
        }
        return SystemAction.get(ViewAction.class);
    }

    public void edit() {
        UserXMLCatalog userXMLCatalog = (UserXMLCatalog)this.getCatalogReader();
        try {
            DataObject dataObject;
            EditCookie editCookie;
            URI uRI = new URI(this.getSystemID());
            File file = new File(uRI);
            FileObject fileObject = FileUtil.toFileObject((File)file);
            boolean bl = false;
            if (fileObject != null && (editCookie = (EditCookie)(dataObject = DataObject.find((FileObject)fileObject)).getCookie(EditCookie.class)) != null) {
                bl = true;
                editCookie.edit();
            }
            if (!bl) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CatalogEntryNode.class, (String)"MSG_CannotOpenURI", (Object)this.getSystemID()), 1));
            }
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
    }

    private CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    public Action[] getActions(boolean bl) {
        if (this.isCatalogWriter) {
            return new Action[]{SystemAction.get(EditAction.class), SystemAction.get(DeleteAction.class), null, SystemAction.get(PropertiesAction.class)};
        }
        return new Action[]{SystemAction.get(ViewAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public Node.Cookie getCookie(Class clazz) {
        if (ViewCookie.class.equals((Object)clazz)) {
            try {
                String string = this.getSystemID();
                if (string == null) {
                    return null;
                }
                if (this.view == null) {
                    URL uRL = new URL(string);
                    ViewEnv viewEnv = new ViewEnv(this.getPublicID(), string);
                    this.view = new ViewCookieImpl(viewEnv);
                }
                return this.view;
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.notify(1, (Throwable)malformedURLException);
                return null;
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.notify(1, (Throwable)iOException);
                return null;
            }
        }
        return super.getCookie(clazz);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private String getPublicID() {
        return ((CatalogEntry)this.getBean()).getPublicID();
    }

    private String getSystemID() {
        return ((CatalogEntry)this.getBean()).getSystemID();
    }

    public String getShortDescription() {
        String string = this.getPublicID();
        if (string.startsWith("SCHEMA:")) {
            string = string.substring("SCHEMA:".length());
        }
        return string;
    }

    public void destroy() throws IOException {
        super.destroy();
        if (this.isCatalogWriter) {
            CatalogWriter catalogWriter = (CatalogWriter)((Object)((CatalogEntry)this.getBean()).getCatalog());
            catalogWriter.registerCatalogEntry(this.getPublicID(), null);
        }
    }

    private class ViewCookieImpl
    extends CloneableEditorSupport
    implements ViewCookie {
        ViewCookieImpl(CloneableEditorSupport.Env env) {
            super(env);
        }

        protected String messageName() {
            return NbBundle.getMessage(CatalogEntryNode.class, (String)"MSG_opened_entity", (Object)CatalogEntryNode.this.getPublicID());
        }

        protected String messageSave() {
            return NbBundle.getMessage(CatalogEntryNode.class, (String)"MSG_ENTITY_SAVE", (Object)CatalogEntryNode.this.getPublicID());
        }

        protected String messageToolTip() {
            String string = CatalogEntryNode.this.getPublicID();
            if (string.startsWith("SCHEMA:")) {
                string = string.substring("SCHEMA:".length());
            }
            return string;
        }

        protected String messageOpening() {
            return NbBundle.getMessage(CatalogEntryNode.class, (String)"MSG_ENTITY_OPENING", (Object)CatalogEntryNode.this.getPublicID());
        }

        protected String messageOpened() {
            return NbBundle.getMessage(CatalogEntryNode.class, (String)"MSG_ENTITY_OPENED", (Object)CatalogEntryNode.this.getPublicID());
        }

        protected CloneableEditor createCloneableEditor() {
            CloneableEditor cloneableEditor = super.createCloneableEditor();
            cloneableEditor.setActivatedNodes(new Node[]{CatalogEntryNode.this});
            return cloneableEditor;
        }

        private Object writeReplace() {
            return null;
        }
    }

    private class ViewEnv
    extends URLEnvironment {
        private static final long serialVersionUID = -5031004511063404433L;

        ViewEnv(String string, String string2) {
            super(string, string2);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (ViewCookieImpl)CatalogEntryNode.this.getCookie(ViewCookieImpl.class);
        }
    }
}

