/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.xml.catalog.lib.Util;
import org.openide.util.Utilities;

final class CatalogMounterModel {
    private Object catalog = null;
    private ComboBoxModel cxModel = null;
    private List changeListeners = new ArrayList(2);

    public CatalogMounterModel(Iterator iterator) {
        Vector<Entry> vector = new Vector<Entry>();
        while (iterator.hasNext()) {
            vector.add(new Entry((Class)iterator.next()));
        }
        this.cxModel = new DefaultComboBoxModel(vector);
        this.cxModel.addListDataListener(new Lis());
        this.initCatalog();
    }

    public Object getCatalog() {
        return this.catalog;
    }

    public Customizer getCatalogCustomizer() {
        if (this.catalog == null) {
            return null;
        }
        return Util.getProviderCustomizer(this.catalog.getClass());
    }

    public ComboBoxModel getCatalogComboBoxModel() {
        return this.cxModel;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private Entry getSelectedEntry() {
        return (Entry)this.cxModel.getSelectedItem();
    }

    private void initCatalog() {
        Entry entry = this.getSelectedEntry();
        this.catalog = entry == null ? null : Util.createProvider(entry.src);
        this.fireStateChanged();
    }

    private void fireStateChanged() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private class Entry {
        String name = null;
        Class src;

        public Entry(Class clazz) {
            this.src = clazz;
            try {
                this.name = Utilities.getBeanInfo((Class)clazz).getBeanDescriptor().getDisplayName();
            }
            catch (IntrospectionException introspectionException) {
                this.name = clazz.toString();
            }
        }

        public String toString() {
            return this.name;
        }
    }

    private class Lis
    implements ListDataListener {
        private Lis() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            CatalogMounterModel.this.initCatalog();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            CatalogMounterModel.this.initCatalog();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            CatalogMounterModel.this.initCatalog();
        }
    }
}

