/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JTextArea;
import org.netbeans.modules.xml.catalog.CatalogMounterModel;
import org.netbeans.modules.xml.catalog.CatalogMounterPanel;
import org.netbeans.modules.xml.catalog.CatalogNode;
import org.netbeans.modules.xml.catalog.impl.SystemCatalogReader;
import org.netbeans.modules.xml.catalog.settings.CatalogSettings;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.ProvidersRegistry;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public final class CatalogRootNode
extends AbstractNode
implements Node.Cookie {
    public CatalogRootNode() {
        super((Children)new RootChildren());
        this.setName("XML-CATALOG");
        this.setDisplayName(NbBundle.getMessage(CatalogRootNode.class, (String)"TEXT_catalog_root"));
        this.setIconBaseWithExtension("org/netbeans/modules/xml/catalog/resources/catalog-root.gif");
        this.setShortDescription(NbBundle.getMessage(CatalogRootNode.class, (String)"PROP_catalog_root_desc"));
        this.getCookieSet().add((Node.Cookie)this);
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get(MountAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mountCatalog(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return;
        }
        try {
            Node node = nodeArray[0];
            CatalogRootNode catalogRootNode = (CatalogRootNode)node.getCookie(CatalogRootNode.class);
            CatalogMounter catalogMounter = catalogRootNode.new CatalogMounter();
            catalogMounter.create();
        }
        catch (IOException iOException) {}
    }

    class CatalogMounter
    extends NewType
    implements ActionListener {
        CatalogMounterModel model = null;
        Dialog myDialog = null;

        CatalogMounter() {
        }

        public void create() throws IOException {
            Iterator iterator = ProvidersRegistry.getProviderClasses(new Class[]{CatalogReader.class});
            this.model = new CatalogMounterModel(iterator);
            CatalogMounterPanel catalogMounterPanel = new CatalogMounterPanel(this.model);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)catalogMounterPanel, NbBundle.getMessage(CatalogRootNode.class, (String)"PROP_Mount_Catalog"), true, (ActionListener)this);
            dialogDescriptor.setHelpCtx(new HelpCtx(CatalogMounterPanel.class));
            this.myDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setColumns(60);
            jTextArea.setRows(10);
            Dimension dimension = jTextArea.getPreferredSize();
            int n = dimension.height + 120;
            int n2 = dimension.width + 48;
            Dimension dimension2 = new Dimension(n2, n);
            this.myDialog.setSize(dimension2);
            this.myDialog.setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                Object object = this.model.getCatalog();
                if (object == null) {
                    return;
                }
                CatalogSettings catalogSettings = CatalogSettings.getDefault();
                catalogSettings.addCatalog((CatalogReader)object);
            }
            if (this.myDialog != null) {
                this.myDialog.dispose();
                this.myDialog = null;
            }
        }

        public String getName() {
            return NbBundle.getMessage(CatalogRootNode.class, (String)"LBL_mount");
        }
    }

    private static final class MountAction
    extends NodeAction {
        private static final long serialVersionUID = -3608629636833099065L;

        public String getName() {
            return NbBundle.getMessage(CatalogRootNode.class, (String)"LBL_mount");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(MountAction.class);
        }

        protected synchronized boolean enable(Node[] nodeArray) {
            return nodeArray.length > 0;
        }

        protected boolean asynchronous() {
            return false;
        }

        protected synchronized void performAction(Node[] nodeArray) {
            CatalogRootNode.mountCatalog(nodeArray);
        }
    }

    private static class RootChildren
    extends Children.Keys
    implements Comparator,
    PropertyChangeListener {
        private final TreeSet keys = new TreeSet(this);

        private RootChildren() {
        }

        public synchronized void addNotify() {
            CatalogSettings catalogSettings = CatalogSettings.getDefault();
            catalogSettings.addPropertyChangeListener(this);
            this.createKeys(catalogSettings);
        }

        public synchronized void removeNotify() {
            CatalogSettings catalogSettings = CatalogSettings.getDefault();
            if (catalogSettings != null) {
                catalogSettings.removePropertyChangeListener(this);
            }
            this.keys.clear();
            this.setKeys(this.keys);
        }

        public Node[] createNodes(Object object) {
            try {
                return new Node[]{new CatalogNode((CatalogReader)object)};
            }
            catch (IntrospectionException introspectionException) {
                return new Node[0];
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("catalogs".equals(propertyChangeEvent.getPropertyName())) {
                this.createKeys((CatalogSettings)propertyChangeEvent.getSource());
            }
        }

        private void createKeys(CatalogSettings catalogSettings) {
            this.keys.clear();
            if (catalogSettings != null) {
                Iterator iterator = catalogSettings.getCatalogs(new Class[]{CatalogReader.class});
                while (iterator.hasNext()) {
                    this.keys.add(iterator.next());
                }
            }
            this.setKeys(this.keys);
        }

        public boolean equals(Object object) {
            return object.getClass().equals(this.getClass());
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object instanceof SystemCatalogReader) {
                return -1;
            }
            if (object2 instanceof SystemCatalogReader) {
                return 1;
            }
            if (object instanceof CatalogDescriptor && object2 instanceof CatalogDescriptor) {
                int n = ((CatalogDescriptor)object).getDisplayName().compareTo(((CatalogDescriptor)object2).getDisplayName());
                if (n != 0) {
                    return n;
                }
            } else {
                if (object instanceof CatalogDescriptor) {
                    return -1;
                }
                if (object2 instanceof CatalogDescriptor) {
                    return 1;
                }
            }
            return (long)object.hashCode() - (long)object2.hashCode() > 0L ? 1 : -1;
        }
    }
}

