/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JDialog;
import javax.swing.event.ChangeListener;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.ExitDialog;
import org.netbeans.core.HtmlBrowserComponent;
import org.netbeans.core.IDESettings;
import org.netbeans.core.NbLoaderPool;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ModuleLifecycleManager;
import org.netbeans.core.startup.ModuleSystem;
import org.netbeans.core.startup.layers.SessionManager;
import org.netbeans.core.ui.SwingBrowser;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NbTopManager {
    public static final int IL_MAIN_WINDOW = 1;
    public static final int IL_WINDOWS = 2;
    public static final int IL_WORKSPACES = 4;
    public static final int IL_ALL = 65535;
    private static NbTopManager defaultTopManager;
    private static boolean doingExit;
    private static final Runnable DO_EXIT;

    public NbTopManager() {
        assert (defaultTopManager == null) : "Only one instance allowed";
        defaultTopManager = this;
        Lookup lookup = Lookup.getDefault();
        if (!(lookup instanceof MainLookup)) {
            throw new ClassCastException("Wrong Lookup impl found: " + lookup);
        }
        MainLookup.startedNbTopManager();
    }

    public static NbTopManager get() {
        assert (defaultTopManager != null) : "Must be initialized already";
        return defaultTopManager;
    }

    public static NbTopManager getUninitialized() {
        return NbTopManager.get();
    }

    public static synchronized boolean isInitialized() {
        return defaultTopManager != null;
    }

    public abstract boolean isInteractive(int var1);

    public final void register(Object object) {
        MainLookup.register((Object)object);
    }

    public final <T, R> void register(T t, InstanceContent.Convertor<T, R> convertor) {
        MainLookup.register(t, convertor);
    }

    public final void unregister(Object object) {
        MainLookup.unregister((Object)object);
    }

    public final <T, R> void unregister(T t, InstanceContent.Convertor<T, R> convertor) {
        MainLookup.unregister(t, convertor);
    }

    public void showHelp(HelpCtx helpCtx) {
        try {
            Class<?> clazz = ((ClassLoader)Lookup.getDefault().lookup(ClassLoader.class)).loadClass("org.netbeans.api.javahelp.Help");
            Object object = Lookup.getDefault().lookup(clazz);
            if (object != null) {
                Method method = clazz.getMethod("showHelp", HelpCtx.class);
                method.invoke(object, helpCtx);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            Logger.getLogger(NbTopManager.class.getName()).log(Level.WARNING, null, exception);
        }
        Toolkit.getDefaultToolkit().beep();
    }

    private static void saveAll() {
        SaveCookie saveCookie;
        DataObject dataObject = null;
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        DataObject[] dataObjectArray = DataObject.getRegistry().getModified();
        if (dataObjectArray.length == 0) {
            return;
        }
        for (int i = 0; i < dataObjectArray.length; ++i) {
            try {
                dataObject = dataObjectArray[i];
                saveCookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
                if (saveCookie == null) continue;
                StatusDisplayer.getDefault().setStatusText(MessageFormat.format(NbBundle.getBundle(NbTopManager.class).getString("CTL_FMT_SavingMessage"), dataObject.getName()));
                saveCookie.save();
                continue;
            }
            catch (IOException iOException) {
                Logger.getLogger(NbTopManager.class.getName()).log(Level.WARNING, null, iOException);
                arrayList.add(dataObject);
            }
        }
        saveCookie = arrayList.iterator();
        while (saveCookie.hasNext()) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle(NbTopManager.class).getString("CTL_Cannot_save"), ((DataObject)saveCookie.next()).getPrimaryFile().getName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getBundle(NbTopManager.class).getString("MSG_AllSaved"));
    }

    public static boolean isModalDialogPresent() {
        return NbTopManager.hasModalDialog(WindowManager.getDefault().getMainWindow()) || NbTopManager.hasModalDialog(new JDialog().getOwner());
    }

    private static boolean hasModalDialog(Window window) {
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i] instanceof Dialog && ((Dialog)windowArray[i]).isModal()) {
                return true;
            }
            if (!NbTopManager.hasModalDialog(windowArray[i])) continue;
            return true;
        }
        return false;
    }

    public static void exit() {
        Mutex.EVENT.readAccess(DO_EXIT);
    }

    public static boolean isExiting() {
        return doingExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doExit() {
        block9: {
            if (doingExit) {
                return;
            }
            doingExit = true;
            try {
                if (System.getProperty("netbeans.close") == null && !ExitDialog.showDialog() || !Main.getModuleSystem().shutDown((Runnable)new ExitActions(1))) break block9;
                try {
                    try {
                        NbLoaderPool.store();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(NbTopManager.class.getName()).log(Level.WARNING, null, iOException);
                    }
                    SessionManager.getDefault().close();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    Exceptions.printStackTrace((Throwable)throwable);
                }
                Task task = new Task((Runnable)new ExitActions(2));
                RequestProcessor.getDefault().post((Runnable)task);
                task.waitFinished();
            }
            finally {
                doingExit = false;
            }
        }
    }

    public abstract ModuleSystem getModuleSystem();

    public static Lookup getModuleLookup() {
        Lookup lookup = Lookup.getDefault();
        if (lookup instanceof MainLookup) {
            lookup = Main.getModuleSystem().getManager().getModuleLookup();
        }
        return lookup;
    }

    public static List<File> getModuleJars() {
        return Main.getModuleSystem().getModuleJars();
    }

    static {
        doingExit = false;
        DO_EXIT = new ExitActions(0);
    }

    private static class ExitActions
    implements Runnable {
        private final int type;

        ExitActions(int n) {
            this.type = n;
        }

        public void run() {
            switch (this.type) {
                case 0: {
                    NbTopManager.doExit();
                    break;
                }
                case 1: {
                    CLIHandler.stopServer();
                    WindowSystem windowSystem = (WindowSystem)Lookup.getDefault().lookup(WindowSystem.class);
                    boolean bl = CLIOptions.isGui();
                    if (windowSystem != null && bl) {
                        windowSystem.hide();
                        windowSystem.save();
                    }
                    if (!Boolean.getBoolean("netbeans.close.when.invisible")) break;
                    TopSecurityManager.exit((int)0);
                    break;
                }
                case 2: {
                    if (Boolean.getBoolean("netbeans.close.no.exit")) break;
                    TopSecurityManager.exit((int)0);
                    break;
                }
                default: {
                    throw new IllegalStateException("Type: " + this.type);
                }
            }
        }
    }

    public static class NbBrowser {
        private HtmlBrowserComponent brComp;
        private HtmlBrowserComponent externalBrowser;
        private PreferenceChangeListener idePCL;
        private static Lookup.Result factoryResult = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);

        public NbBrowser() {
            HtmlBrowser.Factory factory = IDESettings.getWWWBrowser();
            if (factory == null) {
                factory = new SwingBrowser();
            }
            if (factory.createHtmlBrowserImpl().getComponent() != null) {
                this.brComp = this.findOpenedBrowserComponent();
            }
            if (this.brComp == null) {
                this.brComp = new HtmlBrowserComponent(factory, true, true);
                this.brComp.putClientProperty("TabPolicy", "HideWhenAlone");
            }
            if ((factory = IDESettings.getExternalWWWBrowser()) == null) {
                factory = new SwingBrowser();
            }
            this.externalBrowser = new HtmlBrowserComponent(factory, true, true);
            this.setListener();
        }

        private HtmlBrowserComponent findOpenedBrowserComponent() {
            for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
                if (!(topComponent instanceof HtmlBrowserComponent)) continue;
                return (HtmlBrowserComponent)topComponent;
            }
            return null;
        }

        private void showUrl(URL uRL) {
            this.brComp.setURLAndOpen(uRL);
        }

        private void showUrlExternal(URL uRL) {
            this.externalBrowser.setURLAndOpen(uRL);
        }

        private void setListener() {
            if (this.idePCL != null) {
                return;
            }
            try {
                this.idePCL = new PreferenceChangeListener(){

                    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                        if ("WWWBrowser".equals(preferenceChangeEvent.getKey())) {
                            ((NbURLDisplayer)HtmlBrowser.URLDisplayer.getDefault()).htmlViewer = null;
                            if (NbBrowser.this.idePCL != null) {
                                IDESettings.getPreferences().removePreferenceChangeListener(NbBrowser.this.idePCL);
                                NbBrowser.this.idePCL = null;
                                NbBrowser.this.brComp = null;
                            }
                        }
                    }
                };
                IDESettings.getPreferences().addPreferenceChangeListener(this.idePCL);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        static {
            factoryResult.allItems();
            factoryResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ((NbURLDisplayer)HtmlBrowser.URLDisplayer.getDefault()).htmlViewer = null;
                }
            });
        }
    }

    public static final class NbLifecycleManager
    extends LifecycleManager {
        public void saveAll() {
            NbTopManager.saveAll();
        }

        public void exit() {
            NbTopManager.exit();
        }

        public void markForRestart() throws UnsupportedOperationException {
            new ModuleLifecycleManager().markForRestart();
        }
    }

    public static final class NbStatusDisplayer
    extends StatusDisplayer {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private List<WeakReference<MessageImpl>> messages = new ArrayList<WeakReference<MessageImpl>>(30);
        private static int SURVIVING_TIME = Integer.getInteger("org.openide.awt.StatusDisplayer.DISPLAY_TIME", 5000);

        public void setStatusText(String string) {
            this.add(string, 0).clear(SURVIVING_TIME);
        }

        public StatusDisplayer.Message setStatusText(String string, int n) {
            if (n <= 0) {
                throw new IllegalArgumentException("Invalid importance value: " + n);
            }
            return this.add(string, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized String getStatusText() {
            String string = null;
            NbStatusDisplayer nbStatusDisplayer = this;
            synchronized (nbStatusDisplayer) {
                MessageImpl messageImpl = this.getCurrent();
                string = null == messageImpl ? "" : messageImpl.text;
            }
            return string;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        private MessageImpl getCurrent() {
            while (!this.messages.isEmpty()) {
                WeakReference<MessageImpl> weakReference = this.messages.get(0);
                MessageImpl messageImpl = (MessageImpl)weakReference.get();
                if (null != messageImpl) {
                    return messageImpl;
                }
                this.messages.remove(0);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MessageImpl add(String string, int n) {
            MessageImpl messageImpl = new MessageImpl(string, n);
            WeakReference<MessageImpl> weakReference = new WeakReference<MessageImpl>(messageImpl);
            NbStatusDisplayer nbStatusDisplayer = this;
            synchronized (nbStatusDisplayer) {
                boolean bl = false;
                for (int i = 0; i < this.messages.size() && !bl; ++i) {
                    WeakReference<MessageImpl> weakReference2 = this.messages.get(0);
                    MessageImpl messageImpl2 = (MessageImpl)weakReference2.get();
                    if (messageImpl2 == null) continue;
                    if (messageImpl2.importance == n) {
                        this.messages.set(i, weakReference);
                        bl = true;
                        continue;
                    }
                    if (messageImpl2.importance >= n) continue;
                    this.messages.add(i, weakReference);
                    bl = true;
                }
                if (!bl) {
                    this.messages.add(weakReference);
                }
            }
            this.cs.fireChange();
            Logger.getLogger(NbStatusDisplayer.class.getName()).log(Level.FINE, "Status text updated: {0}, importance: {1}", new Object[]{string, n});
            return messageImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(MessageImpl messageImpl) {
            NbStatusDisplayer nbStatusDisplayer = this;
            synchronized (nbStatusDisplayer) {
                WeakReference<MessageImpl> weakReference = null;
                for (WeakReference<MessageImpl> weakReference2 : this.messages) {
                    if (messageImpl != weakReference2.get()) continue;
                    weakReference = weakReference2;
                    break;
                }
                if (null != weakReference) {
                    this.messages.remove(weakReference);
                }
            }
            this.cs.fireChange();
        }

        private class MessageImpl
        implements StatusDisplayer.Message,
        Runnable {
            private final String text;
            private final int importance;

            public MessageImpl(String string, int n) {
                this.text = string;
                this.importance = n;
            }

            public void clear(int n) {
                RequestProcessor.getDefault().post((Runnable)this, n);
            }

            protected void finalize() throws Throwable {
                this.run();
            }

            public void run() {
                NbStatusDisplayer.this.remove(this);
            }
        }
    }

    public static final class NbURLDisplayer
    extends HtmlBrowser.URLDisplayer {
        private NbBrowser htmlViewer;

        public void showURL(final URL uRL) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (NbURLDisplayer.this.htmlViewer == null) {
                        NbURLDisplayer.this.htmlViewer = new NbBrowser();
                    }
                    NbURLDisplayer.this.htmlViewer.showUrl(uRL);
                }
            });
        }

        public void showURLExternal(final URL uRL) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (NbURLDisplayer.this.htmlViewer == null) {
                        NbURLDisplayer.this.htmlViewer = new NbBrowser();
                    }
                    NbURLDisplayer.this.htmlViewer.showUrlExternal(uRL);
                }
            });
        }
    }

    public static interface WindowSystem {
        public void init();

        public void show();

        public void hide();

        public void load();

        public void save();

        public void clear();
    }
}

