/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.Reader;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.NbIOProvider;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.IOContainer;
import org.openide.windows.IOPosition;
import org.openide.windows.IOTab;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

class NbIO
implements InputOutput,
Lookup.Provider {
    private Boolean focusTaken = null;
    private boolean closed = false;
    private final String name;
    private Action[] actions;
    private NbWriter out = null;
    private IOContainer ioContainer;
    private Lookup lookup;
    private IOTabImpl ioTab;
    private IOColorsImpl ioColors;
    private boolean streamClosed = false;
    private IOReader in = null;

    NbIO(String string, Action[] actionArray, IOContainer iOContainer) {
        this(string);
        this.actions = actionArray;
        this.ioContainer = iOContainer != null ? iOContainer : IOContainer.getDefault();
    }

    NbIO(String string) {
        this.name = string;
    }

    public void closeInputOutput() {
        if (Controller.LOG) {
            Controller.log("CLOSE INPUT OUTPUT CALLED FOR " + this);
        }
        if (this.out != null) {
            if (Controller.LOG) {
                Controller.log(" - Its output is non null, calling close() on " + (Object)((Object)this.out));
            }
            this.out.close();
        }
        NbIO.post(this, 7, true);
    }

    String getName() {
        return this.name;
    }

    IOContainer getIOContainer() {
        return this.ioContainer;
    }

    public OutputWriter getErr() {
        return ((NbWriter)this.getOut()).getErr();
    }

    NbWriter writer() {
        return this.out;
    }

    void dispose() {
        if (Controller.LOG) {
            Controller.log(this + ": IO " + this.getName() + " is being disposed");
        }
        if (this.out != null) {
            if (Controller.LOG) {
                Controller.log(this + ": Still has an OutWriter.  Disposing it");
            }
            this.out().dispose();
            this.out = null;
            if (this.in != null) {
                this.in.eof();
                this.in = null;
            }
            this.focusTaken = null;
        }
        NbIOProvider.dispose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputWriter getOut() {
        NbIO nbIO = this;
        synchronized (nbIO) {
            if (this.out == null) {
                OutWriter outWriter = new OutWriter(this);
                this.out = new NbWriter(outWriter, this);
            }
        }
        return this.out;
    }

    OutWriter out() {
        return this.out == null ? null : this.out.out();
    }

    void setClosed(boolean bl) {
        this.closed = bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isErrSeparated() {
        return false;
    }

    public boolean isFocusTaken() {
        return Boolean.TRUE.equals(this.focusTaken);
    }

    boolean isStreamClosed() {
        return this.out == null ? true : this.streamClosed;
    }

    public void select() {
        if (Controller.LOG) {
            Controller.log(this + ": select");
        }
        NbIO.post(this, 6, true);
    }

    public void setErrSeparated(boolean bl) {
    }

    public void setErrVisible(boolean bl) {
    }

    public void setFocusTaken(boolean bl) {
        this.focusTaken = bl ? Boolean.TRUE : Boolean.FALSE;
        NbIO.post(this, 5, bl);
    }

    public void setInputVisible(boolean bl) {
        if (Controller.LOG) {
            Controller.log(this + ": SetInputVisible");
        }
        NbIO.post(this, 2, bl);
    }

    public void setOutputVisible(boolean bl) {
    }

    public void setStreamClosed(boolean bl) {
        if (this.streamClosed != bl) {
            this.streamClosed = bl;
            NbIO.post(this, 8, bl);
        }
    }

    public void setToolbarActions(Action[] actionArray) {
        this.actions = actionArray;
        NbIO.post(this, 10, actionArray);
    }

    Action[] getToolbarActions() {
        return this.actions;
    }

    public void reset() {
        if (Controller.LOG) {
            Controller.log(this + ": reset");
        }
        this.closed = false;
        this.streamClosed = false;
        if (this.in != null) {
            this.in.eof();
            this.in.reuse();
        }
        NbIO.post(this, 9, true);
    }

    private static void post(NbIO nbIO, int n, boolean bl) {
        IOEvent iOEvent = new IOEvent(nbIO, n, bl);
        NbIO.post(iOEvent);
    }

    private static void post(NbIO nbIO, int n, Object object) {
        IOEvent iOEvent = new IOEvent(nbIO, n, object);
        NbIO.post(iOEvent);
    }

    static void post(IOEvent iOEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (Controller.LOG) {
                Controller.log("Synchronously dispatching " + iOEvent + " from call on EQ");
            }
            iOEvent.dispatch();
        } else {
            if (Controller.LOG) {
                Controller.log("Asynchronously posting " + iOEvent + " to EQ");
            }
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eventQueue.postEvent(iOEvent);
        }
    }

    public String toString() {
        return "NbIO@" + System.identityHashCode(this) + " " + this.getName();
    }

    IOReader in() {
        return this.in;
    }

    public Reader getIn() {
        if (this.in == null) {
            this.in = new IOReader();
        }
        return this.in;
    }

    public Reader flushReader() {
        return this.getIn();
    }

    public synchronized Lookup getLookup() {
        if (this.lookup == null) {
            this.ioTab = new IOTabImpl();
            this.ioColors = new IOColorsImpl();
            this.lookup = Lookups.fixed((Object[])new Object[]{this.ioTab, this.ioColors, new IOPositionImpl(), new IOColorLinesImpl(), new IOColorPrintImpl()});
        }
        return this.lookup;
    }

    Icon getIcon() {
        return this.ioTab != null ? this.ioTab.getIcon() : null;
    }

    String getToolTipText() {
        return this.ioTab != null ? this.ioTab.getToolTipText() : null;
    }

    Color getColor(IOColors.OutputType outputType) {
        return this.ioColors != null ? this.ioColors.getColor(outputType) : AbstractLines.DEF_COLORS[outputType.ordinal()];
    }

    private class IOColorLinesImpl
    extends IOColorLines {
        private IOColorLinesImpl() {
        }

        protected void println(CharSequence charSequence, OutputListener outputListener, boolean bl, Color color) throws IOException {
            OutWriter outWriter = NbIO.this.out();
            if (outWriter != null) {
                outWriter.print(charSequence, outputListener, bl, color, false, true);
            }
        }
    }

    private class IOColorPrintImpl
    extends IOColorPrint {
        private IOColorPrintImpl() {
        }

        protected void print(CharSequence charSequence, OutputListener outputListener, boolean bl, Color color) throws IOException {
            OutWriter outWriter = NbIO.this.out();
            if (outWriter != null) {
                outWriter.print(charSequence, outputListener, bl, color, false, false);
            }
        }
    }

    private class IOColorsImpl
    extends IOColors {
        Color[] clrs = new Color[4];

        private IOColorsImpl() {
        }

        protected Color getColor(IOColors.OutputType outputType) {
            return this.clrs[outputType.ordinal()] != null ? this.clrs[outputType.ordinal()] : AbstractLines.DEF_COLORS[outputType.ordinal()];
        }

        protected void setColor(IOColors.OutputType outputType, Color color) {
            this.clrs[outputType.ordinal()] = color;
            NbIO.post(NbIO.this, 14, outputType);
        }
    }

    private class IOPositionImpl
    extends IOPosition {
        private IOPositionImpl() {
        }

        protected IOPosition.Position currentPosition() {
            OutWriter outWriter = NbIO.this.out();
            int n = 0;
            if (outWriter != null) {
                n = outWriter.getLines().getCharCount();
            }
            return new PositionImpl(n);
        }
    }

    class IOReader
    extends Reader {
        private boolean pristine;
        private boolean inputClosed;

        IOReader() {
            super(new StringBuffer());
            this.pristine = true;
            this.inputClosed = false;
        }

        void reuse() {
            this.pristine = true;
            this.inputClosed = false;
        }

        private StringBuffer buffer() {
            return (StringBuffer)this.lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pushText(String string) {
            if (Controller.LOG) {
                Controller.log(NbIO.this + ": Input text: " + string);
            }
            Object object = this.lock;
            synchronized (object) {
                this.buffer().append(string);
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eof() {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }

        private void checkPristine() throws IOException {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IOException("Cannot call read() from the event thread, it will deadlock");
            }
            if (this.pristine) {
                NbIO.this.setInputVisible(true);
                this.pristine = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(char[] cArray, int n, int n2) throws IOException {
            if (Controller.LOG) {
                Controller.log(NbIO.this + ":Input read: " + n + " len " + n2);
            }
            this.checkPristine();
            Object object = this.lock;
            synchronized (object) {
                while (!this.inputClosed && this.buffer().length() == 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw (IOException)new IOException("Interrupted: " + interruptedException.getMessage()).initCause(interruptedException);
                    }
                }
                if (this.inputClosed) {
                    this.reuse();
                    return -1;
                }
                int n3 = Math.min(this.buffer().length(), n2);
                this.buffer().getChars(0, n3, cArray, n);
                this.buffer().delete(0, n3);
                return n3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            if (Controller.LOG) {
                Controller.log(NbIO.this + ": Input read one char");
            }
            this.checkPristine();
            Object object = this.lock;
            synchronized (object) {
                while (!this.inputClosed && this.buffer().length() == 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw (IOException)new IOException("Interrupted: " + interruptedException.getMessage()).initCause(interruptedException);
                    }
                }
                if (this.inputClosed) {
                    this.reuse();
                    return -1;
                }
                char c = this.buffer().charAt(0);
                this.buffer().deleteCharAt(0);
                return c;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ready() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.inputClosed) {
                    this.reuse();
                    return false;
                }
                return this.buffer().length() > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long l) throws IOException {
            if (Controller.LOG) {
                Controller.log(NbIO.this + ": Input skip " + l);
            }
            this.checkPristine();
            Object object = this.lock;
            synchronized (object) {
                while (!this.inputClosed && this.buffer().length() == 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw (IOException)new IOException("Interrupted: " + interruptedException.getMessage()).initCause(interruptedException);
                    }
                }
                if (this.inputClosed) {
                    this.reuse();
                    return 0L;
                }
                int n = Math.min(this.buffer().length(), (int)l);
                this.buffer().delete(0, n);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (Controller.LOG) {
                Controller.log(NbIO.this + ": Input close");
            }
            NbIO.this.setInputVisible(false);
            Object object = this.lock;
            synchronized (object) {
                this.inputClosed = true;
                this.buffer().setLength(0);
                this.lock.notifyAll();
            }
        }

        public boolean isClosed() {
            return this.inputClosed;
        }
    }

    private class IOTabImpl
    extends IOTab {
        Icon icon;
        String toolTip;

        private IOTabImpl() {
        }

        protected Icon getIcon() {
            return this.icon;
        }

        protected String getToolTipText() {
            return this.toolTip;
        }

        protected void setIcon(Icon icon) {
            this.icon = icon;
            NbIO.post(NbIO.this, 11, this.icon);
        }

        protected void setToolTipText(String string) {
            this.toolTip = string;
            NbIO.post(NbIO.this, 12, this.toolTip);
        }
    }

    private class PositionImpl
    implements IOPosition.Position {
        private int pos;

        public PositionImpl(int n) {
            this.pos = n;
        }

        public void scrollTo() {
            NbIO.post(NbIO.this, 13, new Integer(this.pos));
        }
    }
}

