/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.util.Vector;
import org.apache.tomcat.logging.LogHelper;
import org.apache.tomcat.util.ThreadPoolRunnable;

public class ThreadPool {
    public static final int MAX_THREADS = 100;
    public static final int MAX_SPARE_THREADS = 50;
    public static final int MIN_SPARE_THREADS = 10;
    public static final int WORK_WAIT_TIMEOUT = 60000;
    protected Vector pool;
    protected MonitorRunnable monitor;
    protected int maxThreads = 100;
    protected int minSpareThreads = 10;
    protected int maxSpareThreads = 50;
    protected int currentThreadCount = 0;
    protected int currentThreadsBusy = 0;
    protected boolean stopThePool = false;
    static int debug = 0;
    LogHelper loghelper = new LogHelper("tc_log", "ThreadPool");

    protected void adjustLimits() {
        if (this.maxThreads <= 0) {
            this.maxThreads = 100;
        }
        if (this.maxSpareThreads >= this.maxThreads) {
            this.maxSpareThreads = this.maxThreads;
        }
        if (this.maxSpareThreads <= 0) {
            this.maxSpareThreads = this.maxThreads == 1 ? 1 : this.maxThreads / 2;
        }
        if (this.minSpareThreads > this.maxSpareThreads) {
            this.minSpareThreads = this.maxSpareThreads;
        }
        if (this.minSpareThreads <= 0) {
            this.minSpareThreads = this.maxSpareThreads == 1 ? 1 : this.maxSpareThreads / 2;
        }
    }

    protected synchronized void checkSpareControllers() {
        if (this.stopThePool) {
            return;
        }
        if (this.currentThreadCount - this.currentThreadsBusy > this.maxSpareThreads) {
            int toFree = this.currentThreadCount - this.currentThreadsBusy - this.maxSpareThreads;
            int i = 0;
            while (i < toFree) {
                ControlRunnable c = (ControlRunnable)this.pool.firstElement();
                this.pool.removeElement(c);
                c.terminate();
                --this.currentThreadCount;
                ++i;
            }
        }
    }

    public int getMaxSpareThreads() {
        return this.maxSpareThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    void log(String s) {
        this.loghelper.log(s);
    }

    protected synchronized void notifyThreadEnd(ControlRunnable c) {
        --this.currentThreadsBusy;
        --this.currentThreadCount;
        this.notify();
    }

    protected void openThreads(int toOpen) {
        if (toOpen > this.maxThreads) {
            toOpen = this.maxThreads;
        }
        if (this.currentThreadCount == 0) {
            this.pool = new Vector(toOpen);
        }
        int i = this.currentThreadCount;
        while (i < toOpen) {
            this.pool.addElement(new ControlRunnable(this));
            ++i;
        }
        this.currentThreadCount = toOpen;
    }

    protected synchronized void returnController(ControlRunnable c) {
        if (this.currentThreadCount == 0 || this.stopThePool) {
            c.terminate();
            return;
        }
        --this.currentThreadsBusy;
        this.pool.addElement(c);
        this.notify();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runIt(ThreadPoolRunnable r) {
        if (r == null) {
            throw new NullPointerException();
        }
        if (this.currentThreadCount == 0 || this.stopThePool) {
            throw new IllegalStateException();
        }
        ControlRunnable c = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.currentThreadsBusy == this.currentThreadCount) {
                if (this.currentThreadCount < this.maxThreads) {
                    int toOpen = this.currentThreadCount + this.minSpareThreads;
                    this.openThreads(toOpen);
                } else {
                    while (this.currentThreadsBusy == this.currentThreadCount) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            this.loghelper.log("Unexpected exception", e);
                        }
                        if (this.currentThreadCount != 0 && !this.stopThePool) continue;
                        throw new IllegalStateException();
                    }
                }
            }
            c = (ControlRunnable)this.pool.lastElement();
            this.pool.removeElement(c);
            ++this.currentThreadsBusy;
        }
        c.runIt(r);
    }

    public void setMaxSpareThreads(int maxSpareThreads) {
        this.maxSpareThreads = maxSpareThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public synchronized void shutdown() {
        if (!this.stopThePool) {
            this.stopThePool = true;
            this.monitor.terminate();
            this.monitor = null;
            int i = 0;
            while (i < this.currentThreadCount - this.currentThreadsBusy) {
                try {
                    ((ControlRunnable)this.pool.elementAt(i)).terminate();
                }
                catch (Throwable t) {
                    this.loghelper.log("Ignored exception while shutting down thread pool", t, 1);
                }
                ++i;
            }
            this.currentThreadCount = 0;
            this.currentThreadsBusy = 0;
            this.pool = null;
            this.notifyAll();
        }
    }

    public synchronized void start() {
        this.adjustLimits();
        this.openThreads(this.minSpareThreads);
        this.monitor = new MonitorRunnable(this);
    }

    class ControlRunnable
    implements Runnable {
        ThreadPool p;
        Thread t;
        ThreadPoolRunnable toRun = null;
        boolean shouldTerminate = false;
        boolean shouldRun = false;
        boolean noThData;
        Object[] thData = null;

        ControlRunnable(ThreadPool p) {
            this.p = p;
            this.t = new Thread(this);
            this.t.start();
            this.noThData = true;
            this.thData = null;
        }

        public void run() {
            block9: while (true) {
                try {
                    do {
                        Object var2_4;
                        ControlRunnable controlRunnable = this;
                        synchronized (controlRunnable) {
                            if (!this.shouldRun && !this.shouldTerminate) {
                                this.wait();
                            }
                        }
                        if (this.toRun == null && debug > 0) {
                            this.p.log("No toRun ???");
                        }
                        if (this.shouldTerminate) {
                            if (debug <= 0) break block9;
                            this.p.log("Terminate");
                            break block9;
                        }
                        try {
                            try {
                                if (this.noThData) {
                                    if (debug > 0) {
                                        this.p.log("Getting new thread data");
                                    }
                                    this.thData = this.toRun.getInitData();
                                    this.noThData = false;
                                }
                                if (this.shouldRun) {
                                    this.toRun.runIt(this.thData);
                                }
                            }
                            catch (Throwable t) {
                                ThreadPool.this.loghelper.log("Caught exception executing " + this.toRun.toString() + ", terminating thread", t);
                                this.shouldTerminate = true;
                                this.shouldRun = false;
                                this.p.notifyThreadEnd(this);
                            }
                            var2_4 = null;
                            if (!this.shouldRun) continue;
                            this.shouldRun = false;
                            this.p.returnController(this);
                        }
                        catch (Throwable throwable) {
                            var2_4 = null;
                            if (this.shouldRun) {
                                this.shouldRun = false;
                                this.p.returnController(this);
                            }
                            throw throwable;
                        }
                    } while (!this.shouldTerminate);
                }
                catch (InterruptedException ie) {
                    ThreadPool.this.loghelper.log("Unexpected exception", ie);
                    continue;
                }
                break;
            }
        }

        public synchronized void runIt(ThreadPoolRunnable toRun) {
            if (toRun == null) {
                throw new NullPointerException("No Runnable");
            }
            this.toRun = toRun;
            this.shouldRun = true;
            this.notify();
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }
    }

    class MonitorRunnable
    implements Runnable {
        ThreadPool p;
        Thread t;
        boolean shouldTerminate = false;

        MonitorRunnable(ThreadPool p) {
            this.p = p;
            this.t = new Thread(this);
            this.t.start();
        }

        public void run() {
            block5: while (true) {
                try {
                    while (true) {
                        MonitorRunnable monitorRunnable = this;
                        synchronized (monitorRunnable) {
                            this.wait(60000L);
                        }
                        if (this.shouldTerminate) break block5;
                        this.p.checkSpareControllers();
                    }
                }
                catch (Throwable t) {
                    ThreadPool.this.loghelper.log("Unexpected exception", t, 1);
                    continue;
                }
                break;
            }
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }
    }
}

