/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.proxy.Base64Encoder;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.turbo.CacheIndex;
import org.netbeans.modules.turbo.TurboProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiskMapTurboProvider
implements TurboProvider {
    static final String ATTR_STATUS_MAP = "subversion.STATUS_MAP";
    private static final int STATUS_VALUABLE = -10;
    private static final String CACHE_DIRECTORY = "svncache";
    private File cacheStore;
    private int storeSerial;
    private CacheIndex index = DiskMapTurboProvider.createCacheIndex();
    private CacheIndex conflictedIndex = DiskMapTurboProvider.createCacheIndex();

    DiskMapTurboProvider() {
        this.initCacheStore();
    }

    File[] getIndexValues(File file, int n) {
        if (n == 64) {
            return this.conflictedIndex.get(file);
        }
        return this.index.get(file);
    }

    File[] getAllIndexValues() {
        return this.index.getAllValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeIndex() {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        long l3 = 0L;
        try {
            File[] fileArray;
            if (!this.cacheStore.isDirectory()) {
                this.cacheStore.mkdirs();
            }
            DiskMapTurboProvider diskMapTurboProvider = this;
            synchronized (diskMapTurboProvider) {
                fileArray = this.cacheStore.listFiles();
            }
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                DiskMapTurboProvider diskMapTurboProvider2 = this;
                synchronized (diskMapTurboProvider2) {
                    if (!file.getName().endsWith(".bin")) {
                        continue;
                    }
                    boolean bl = false;
                    int n = -1;
                    FilterInputStream filterInputStream = null;
                    try {
                        int n2 = 0;
                        while (true) {
                            try {
                                filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                            }
                            catch (IOException iOException) {
                                if (++n2 > 7) {
                                    throw iOException;
                                }
                                Thread.sleep(n2 * 30);
                                continue;
                            }
                            break;
                        }
                        n = 0;
                        block31: while (true) {
                            int n3;
                            ++n;
                            try {
                                n3 = ((DataInputStream)filterInputStream).readInt();
                            }
                            catch (EOFException eOFException) {
                                break;
                            }
                            ((DataInputStream)filterInputStream).readInt();
                            String string = this.readChars((DataInputStream)filterInputStream, n3);
                            Map<File, FileInformation> map = this.readValue((DataInputStream)filterInputStream, string);
                            Iterator<File> iterator = map.keySet().iterator();
                            while (true) {
                                if (!iterator.hasNext()) continue block31;
                                ++l2;
                                File file2 = iterator.next();
                                FileInformation fileInformation = map.get(file2);
                                if (fileInformation.getStatus() == 64) {
                                    this.conflictedIndex.add(file2);
                                }
                                if ((fileInformation.getStatus() & 0xFFFFFFF6) == 0) continue;
                                this.index.add(file2);
                            }
                            break;
                        }
                    }
                    catch (EOFException eOFException) {
                        this.logCorruptedCacheFile(file, n, eOFException);
                        bl = true;
                    }
                    catch (Exception exception) {
                        Subversion.LOG.log(Level.SEVERE, null, exception);
                    }
                    finally {
                        if (filterInputStream != null) {
                            try {
                                filterInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (bl) {
                        file.delete();
                        ++l3;
                    }
                    continue;
                }
            }
        }
        finally {
            Subversion.LOG.info("Finished indexing svn cache with " + l2 + " entries. Elapsed time: " + (System.currentTimeMillis() - l) + " ms.");
            if (l3 > 0L) {
                Subversion.LOG.info(" read failed " + l3 + " times.");
            }
        }
    }

    public boolean recognizesAttribute(String string) {
        return ATTR_STATUS_MAP.equals(string);
    }

    public boolean recognizesEntity(Object object) {
        return object instanceof File;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object readEntry(Object object, String string, TurboProvider.MemoryCache memoryCache) {
        assert (object instanceof File);
        assert (string != null);
        boolean bl = false;
        File file = (File)object;
        File file2 = this.getStore(file);
        if (!file2.isFile()) {
            return null;
        }
        String string2 = file.getAbsolutePath();
        int n = string2.length();
        FilterInputStream filterInputStream = null;
        int n2 = -1;
        try {
            int n3 = 0;
            while (true) {
                try {
                    filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
                }
                catch (IOException iOException) {
                    if (++n3 > 7) {
                        throw iOException;
                    }
                    Thread.sleep(n3 * 30);
                    continue;
                }
                break;
            }
            n2 = 0;
            while (true) {
                int n4;
                ++n2;
                try {
                    n4 = ((DataInputStream)filterInputStream).readInt();
                }
                catch (EOFException eOFException) {
                    break;
                }
                int n5 = ((DataInputStream)filterInputStream).readInt();
                if (n4 != n) {
                    this.skip(filterInputStream, n4 * 2 + n5);
                    continue;
                }
                String string3 = this.readChars((DataInputStream)filterInputStream, n4);
                if (string2.equals(string3)) {
                    Map<File, FileInformation> map = this.readValue((DataInputStream)filterInputStream, string3);
                    return map;
                }
                this.skip(filterInputStream, n5);
            }
        }
        catch (EOFException eOFException) {
            this.logCorruptedCacheFile(file2, n2, eOFException);
            bl = true;
        }
        catch (Exception exception) {
            Subversion.LOG.log(Level.INFO, exception.getMessage(), exception);
            bl = true;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bl) {
            file2.delete();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeEntry(Object object, String string, Object object2) {
        boolean bl;
        File file;
        File file2;
        File file3;
        block46: {
            assert (object instanceof File);
            assert (string != null);
            if (object2 != null) {
                if (!(object2 instanceof Map)) {
                    return false;
                }
                if (!this.isValuable(object2)) {
                    object2 = null;
                }
            }
            file3 = (File)object;
            String string2 = file3.getAbsolutePath();
            int n = string2.length();
            file2 = this.getStore(file3);
            if (object2 == null && !file2.exists()) {
                return true;
            }
            file = new File(file2.getParentFile(), file2.getName() + ".new");
            if (!this.cacheStore.isDirectory()) {
                this.cacheStore.mkdirs();
            }
            FilterOutputStream filterOutputStream = null;
            FilterInputStream filterInputStream = null;
            bl = false;
            int n2 = -1;
            try {
                filterOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                if (object2 != null) {
                    this.writeEntry((DataOutputStream)filterOutputStream, string2, object2);
                }
                if (!file2.exists()) break block46;
                int n3 = 0;
                while (true) {
                    try {
                        filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
                    }
                    catch (IOException iOException) {
                        if (++n3 > 7) {
                            throw iOException;
                        }
                        Thread.sleep(n3 * 30);
                        continue;
                    }
                    break;
                }
                n2 = 0;
                while (true) {
                    int n4;
                    ++n2;
                    try {
                        n4 = ((DataInputStream)filterInputStream).readInt();
                    }
                    catch (EOFException eOFException) {
                        break;
                    }
                    int n5 = ((DataInputStream)filterInputStream).readInt();
                    if (n4 == n) {
                        String string3 = this.readChars((DataInputStream)filterInputStream, n4);
                        if (string2.equals(string3)) {
                            this.skip(filterInputStream, n5);
                            continue;
                        }
                        ((DataOutputStream)filterOutputStream).writeInt(n4);
                        ((DataOutputStream)filterOutputStream).writeInt(n5);
                        ((DataOutputStream)filterOutputStream).writeChars(string3);
                        DiskMapTurboProvider.copyStreams(filterOutputStream, filterInputStream, n5);
                        continue;
                    }
                    ((DataOutputStream)filterOutputStream).writeInt(n4);
                    ((DataOutputStream)filterOutputStream).writeInt(n5);
                    DiskMapTurboProvider.copyStreams(filterOutputStream, filterInputStream, n5 + n4 * 2);
                }
            }
            catch (EOFException eOFException) {
                this.logCorruptedCacheFile(file2, n2, eOFException);
                bl = true;
            }
            catch (Exception exception) {
                Subversion.LOG.log(Level.SEVERE, "Copy: " + file2.getAbsolutePath() + " to: " + file.getAbsolutePath(), exception);
                boolean bl2 = true;
                return bl2;
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (filterInputStream != null) {
                    try {
                        filterInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.adjustIndex(file3, object2);
        ++this.storeSerial;
        if (bl) {
            file2.delete();
            return true;
        }
        try {
            FileUtils.renameFile(file, file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Subversion.LOG.log(Level.INFO, "File could not be renamed, check if you are running only a single instance of netbeans for this userdir", fileNotFoundException);
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.SEVERE, null, iOException);
        }
        return true;
    }

    private void adjustIndex(File file, Object object) {
        Map map = (Map)object;
        Set set = map != null ? map.keySet() : null;
        HashSet<File> hashSet = new HashSet<File>();
        HashSet<File> hashSet2 = new HashSet<File>();
        if (set != null) {
            for (File file2 : set) {
                FileInformation fileInformation = (FileInformation)map.get(file2);
                if (fileInformation.getStatus() == 64) {
                    hashSet.add(file2);
                }
                if ((fileInformation.getStatus() & 0xFFFFFFF6) == 0) continue;
                hashSet2.add(file2);
            }
        }
        this.index.add(file, set);
        this.conflictedIndex.add(file, hashSet);
    }

    private void logCorruptedCacheFile(File file, int n, EOFException eOFException) {
        try {
            File file2 = File.createTempFile("svn_", ".bin");
            Subversion.LOG.log(Level.INFO, "Corrupted cache file " + file.getAbsolutePath() + " at position " + n, eOFException);
            FileUtils.copyFile(file, file2);
            byte[] byArray = FileUtils.getFileContentsAsByteArray(file2);
            Subversion.LOG.log(Level.INFO, "Corrupted cache file length: " + byArray.length);
            String string = Base64Encoder.encode((byte[])byArray);
            Subversion.LOG.log(Level.INFO, "Corrupted cache file content:\n" + string + "\n");
            Exception exception = new Exception("Corrupted cache file \"" + file.getAbsolutePath() + "\", please report in subversion module issues and attach " + file2.getAbsolutePath() + " plus the IDE message log", eOFException);
            Subversion.LOG.log(Level.SEVERE, null, exception);
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.SEVERE, null, iOException);
        }
    }

    private void skip(InputStream inputStream, long l) throws IOException {
        while (l > 0L) {
            long l2 = inputStream.skip(l);
            if (l2 < 0L) {
                throw new EOFException("Missing " + l + " bytes.");
            }
            l -= l2;
        }
    }

    private String readChars(DataInputStream dataInputStream, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(n);
        while (n-- > 0) {
            stringBuffer.append(dataInputStream.readChar());
        }
        return stringBuffer.toString();
    }

    private Map<File, FileInformation> readValue(DataInputStream dataInputStream, String string) throws IOException {
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>();
        int n = dataInputStream.readInt();
        while (n-- > 0) {
            int n2;
            int n3 = dataInputStream.readInt();
            String string2 = this.readChars(dataInputStream, n3);
            File file = new File(string, string2);
            FileInformation fileInformation = new FileInformation(n2 & 0xFFFF, (n2 = dataInputStream.readInt()) > 65535);
            hashMap.put(file, fileInformation);
        }
        return hashMap;
    }

    private void writeEntry(DataOutputStream dataOutputStream, String string, Object object) throws IOException {
        Map map = (Map)object;
        Set set = map.keySet();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(set.size() * 50);
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeInt(set.size());
        for (File file : set) {
            FileInformation fileInformation = (FileInformation)map.get(file);
            dataOutputStream2.writeInt(file.getName().length());
            dataOutputStream2.writeChars(file.getName());
            dataOutputStream2.writeInt(fileInformation.getStatus() + (fileInformation.isDirectory() ? 65536 : 0));
        }
        dataOutputStream2.close();
        Object object2 = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeInt(string.length());
        dataOutputStream.writeInt(((Object)object2).length);
        dataOutputStream.writeChars(string);
        dataOutputStream.write((byte[])object2);
    }

    private boolean isValuable(Object object) {
        Map map = (Map)object;
        for (FileInformation fileInformation : map.values()) {
            if ((fileInformation.getStatus() & 0xFFFFFFF6) == 0) continue;
            return true;
        }
        return false;
    }

    private File getStore(File file) {
        String string = file.getAbsolutePath();
        int n = string.hashCode();
        return new File(this.cacheStore, Integer.toString(n % 173 + 172) + ".bin");
    }

    private void initCacheStore() {
        String string = System.getProperty("netbeans.user");
        if (string != null) {
            this.cacheStore = new File(new File(new File(string, "var"), "cache"), CACHE_DIRECTORY);
        } else {
            File file = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            this.cacheStore = new File(file, CACHE_DIRECTORY);
        }
        this.cacheStore.mkdirs();
    }

    private static void copyStreams(OutputStream outputStream, InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        int n3 = n;
        do {
            n2 = n <= 4096 ? n : 4096;
            if ((n2 = inputStream.read(byArray, 0, n2)) < 0) {
                throw new EOFException("Missing " + n + " bytes from total " + n3 + " bytes.");
            }
            outputStream.write(byArray, 0, n2);
        } while ((n -= n2) != 0);
        outputStream.flush();
    }

    private static CacheIndex createCacheIndex() {
        return new CacheIndex(){

            protected boolean isManaged(File file) {
                return SvnUtils.isManaged(file);
            }
        };
    }
}

