/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.subversion.DiskMapTurboProvider;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatusCache {
    public static final Object EVENT_FILE_STATUS_CHANGED = new Object();
    public static final String PROP_CACHE_READY = "subversion.cache.ready";
    private static final Map<File, FileInformation> NOT_MANAGED_MAP = new NotManagedMap();
    public static final ISVNStatus REPOSITORY_STATUS_UNKNOWN = null;
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED_DIRECTORY = new FileInformation(2, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE_DIRECTORY = new FileInformation(8, true);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private static final Pattern auxConflictPattern = Pattern.compile("(.*?)\\.((r\\d+)|(mine)|(working)|(merge-right\\.r\\d+)|((merge-left.r\\d+)))$");
    private final Turbo turbo;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.subversion.FileStatusCache");
    private boolean ready = false;
    private final String FILE_STATUS_MAP = "subversion.STATUS_MAP";
    private DiskMapTurboProvider cacheProvider;
    private Subversion svn;
    private RequestProcessor rp = new RequestProcessor("Subversion - file status refresh", 1);
    private final LinkedHashSet<File> filesToRefresh = new LinkedHashSet();
    private RequestProcessor.Task refreshTask;
    private final FileLabelCache labelsCache;
    private long refreshedFilesCount;
    PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    FileStatusCache() {
        this.svn = Subversion.getInstance();
        this.cacheProvider = new DiskMapTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(FileStatusCache.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)200, (int)5000);
        this.refreshTask = this.rp.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                File file;
                if (DelayScanRegistry.getInstance().isDelayed(FileStatusCache.this.refreshTask, LOG, "FileStatusCache.refreshTask")) {
                    return;
                }
                long l = 0L;
                long l2 = 0L;
                boolean bl = LOG.isLoggable(Level.FINE);
                if (bl) {
                    l = System.currentTimeMillis();
                }
                do {
                    file = null;
                    LinkedHashSet linkedHashSet = FileStatusCache.this.filesToRefresh;
                    synchronized (linkedHashSet) {
                        Iterator iterator = FileStatusCache.this.filesToRefresh.iterator();
                        if (iterator.hasNext()) {
                            file = (File)iterator.next();
                            iterator.remove();
                        }
                    }
                    if (file == null) continue;
                    FileStatusCache.this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
                    if (!bl) continue;
                    ++l2;
                    ++FileStatusCache.this.refreshedFilesCount;
                } while (file != null);
                if (bl) {
                    LOG.log(Level.FINE, "refreshTask lasted {0} ms for {1} files, {2} files refreshed so far", new Object[]{new Long(System.currentTimeMillis() - l), new Long(l2), new Long(FileStatusCache.this.refreshedFilesCount)});
                }
            }
        });
        this.labelsCache = new FileLabelCache(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFiles(Context context, int n, boolean bl) {
        long l = System.currentTimeMillis();
        try {
            File[] fileArray = context.getRootFiles();
            boolean bl2 = this.containsFiles(fileArray, n, bl);
            return bl2;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(" containsFiles(Context, int) took " + (System.currentTimeMillis() - l));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFiles(Set<File> set, int n, boolean bl) {
        long l = System.currentTimeMillis();
        try {
            File[] fileArray = set.toArray(new File[set.size()]);
            boolean bl2 = this.containsFiles(fileArray, n, bl);
            return bl2;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(" containsFiles(Set<File>, int) took " + (System.currentTimeMillis() - l));
            }
        }
    }

    private boolean containsFiles(File[] fileArray, int n, boolean bl) {
        for (File file : fileArray) {
            if (!this.containsFilesIntern(this.cacheProvider.getIndexValues(file, n), n, !VersioningSupport.isFlat((File)file), bl)) continue;
            return true;
        }
        return this.containsFilesIntern(fileArray, n, false, bl);
    }

    private boolean containsFilesIntern(File[] fileArray, int n, boolean bl, boolean bl2) {
        Object object;
        if (fileArray == null || fileArray.length == 0) {
            return false;
        }
        for (File file : fileArray) {
            object = this.cacheProvider.getIndexValues(file, n);
            if (!bl || !this.containsFilesIntern((File[])object, n, bl, bl2)) continue;
            return true;
        }
        for (File file : fileArray) {
            object = this.getCachedStatus(file);
            if (object == null || (((FileInformation)object).getStatus() & n) == 0 || !bl2 && SvnModuleConfig.getDefault().isExcludedFromCommit(file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public File[] listFiles(File file) {
        Set<File> set = this.getScannedFiles(file).keySet();
        return set.toArray(new File[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] listFiles(File[] fileArray, int n) {
        long l = System.currentTimeMillis();
        try {
            HashSet<File> hashSet = new HashSet<File>();
            for (File file : fileArray) {
                Set<File> set = this.listFilesIntern(this.cacheProvider.getIndexValues(file, n), n, !VersioningSupport.isFlat((File)file));
                hashSet.addAll(set);
            }
            hashSet.addAll(this.listFilesIntern(fileArray, n, false));
            File[] fileArray2 = hashSet.toArray(new File[hashSet.size()]);
            return fileArray2;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(" listFiles(File[], int, boolean) took " + (System.currentTimeMillis() - l));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] listFiles(Context context, int n) {
        long l = System.currentTimeMillis();
        try {
            HashSet<File> hashSet = new HashSet<File>();
            File[] fileArray = context.getRootFiles();
            hashSet.addAll(Arrays.asList(this.listFiles(fileArray, n)));
            if (context.getExclusions().size() > 0) {
                for (File file : context.getExclusions()) {
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        File file2 = (File)iterator.next();
                        if (!SvnUtils.isParentOrEqual(file, file2)) continue;
                        iterator.remove();
                    }
                }
            }
            File[] fileArray2 = hashSet.toArray(new File[hashSet.size()]);
            return fileArray2;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(" listFiles(Context, int) took " + (System.currentTimeMillis() - l));
            }
        }
    }

    private Set<File> listFilesIntern(File[] fileArray, int n, boolean bl) {
        if (fileArray == null || fileArray.length == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<File> hashSet = new HashSet<File>();
        for (File file : fileArray) {
            FileInformation fileInformation;
            if (bl) {
                hashSet.addAll(this.listFilesIntern(this.cacheProvider.getIndexValues(file, n), n, bl));
            }
            if ((fileInformation = this.getCachedStatus(file)) == null || (fileInformation.getStatus() & n) == 0) continue;
            hashSet.add(file);
        }
        return hashSet;
    }

    public FileInformation getStatus(File file) {
        if (SvnUtils.isAdministrative(file)) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> map = this.getScannedFiles(file2);
        if (map == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fileInformation = map.get(file);
        if (fileInformation != null) {
            return fileInformation;
        }
        if (!this.exists(file)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            return this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
        return new FileInformation(8, false);
    }

    public FileInformation getCachedStatus(File file) {
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        Map map = (Map)this.turbo.readEntry((Object)file2, "subversion.STATUS_MAP");
        return map != null ? (FileInformation)map.get(file) : null;
    }

    public void refreshAsync(List<File> list) {
        this.refreshAsync(false, list.toArray(new File[list.size()]));
    }

    public void refreshAsync(File ... fileArray) {
        this.refreshAsync(false, fileArray);
    }

    public void refreshAsync(final boolean bl, final File ... fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LinkedHashSet linkedHashSet = FileStatusCache.this.filesToRefresh;
                synchronized (linkedHashSet) {
                    for (File file : fileArray) {
                        if (bl) {
                            FileStatusCache.this.filesToRefresh.addAll(SvnUtils.listRecursively(file));
                            continue;
                        }
                        FileStatusCache.this.filesToRefresh.add(file);
                    }
                }
                FileStatusCache.this.refreshTask.schedule(200);
            }
        });
    }

    public FileInformation refresh(File file, ISVNStatus iSVNStatus) {
        return this.refresh(file, iSVNStatus, false);
    }

    public void refreshCached(Context context) {
        File[] fileArray = this.listFiles(context, -1);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    public void refreshRecursively(File file) {
        List<File> list = SvnUtils.listRecursively(file);
        for (File file2 : list) {
            this.refresh(file2, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInformation refresh(File file, ISVNStatus iSVNStatus, boolean bl) {
        boolean bl2 = false;
        FileInformation fileInformation = null;
        FileInformation fileInformation2 = null;
        File[] fileArray = null;
        FileStatusCache fileStatusCache = this;
        synchronized (fileStatusCache) {
            Object object;
            ISVNStatus iSVNStatus2;
            Map<File, FileInformation> map;
            File file2;
            block24: {
                file2 = file.getParentFile();
                if (file2 == null) {
                    return FILE_INFORMATION_NOTMANAGED;
                }
                map = this.getScannedFiles(file2);
                if (map == NOT_MANAGED_MAP && iSVNStatus == REPOSITORY_STATUS_UNKNOWN) {
                    return FILE_INFORMATION_NOTMANAGED;
                }
                fileInformation = map.get(file);
                iSVNStatus2 = null;
                try {
                    object = Subversion.getInstance().getClient(false);
                    iSVNStatus2 = object.getSingleStatus(file);
                    if (iSVNStatus2 != null && SVNStatusKind.UNVERSIONED.equals((Object)iSVNStatus2.getTextStatus())) {
                        iSVNStatus2 = null;
                    }
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage()) || SvnClientExceptionHandler.isTooOldClientForWC(sVNClientException.getMessage())) break block24;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
            }
            fileInformation2 = this.createFileInformation(file, iSVNStatus2, iSVNStatus);
            if (FileStatusCache.equivalent(fileInformation2, fileInformation)) {
                bl2 = true;
            }
            if (!bl2 && fileInformation == null && !fileInformation2.isDirectory() && fileInformation2.getStatus() == 8) {
                bl2 = true;
            }
            if (!bl2) {
                if (fileInformation2.getStatus() == 0 && fileInformation != null && fileInformation.isDirectory() && (fileInformation.getStatus() == 2048 || fileInformation.getStatus() == 256)) {
                    fileArray = this.listFiles(new File[]{file}, -1);
                }
                file = FileUtil.normalizeFile((File)file);
                file2 = FileUtil.normalizeFile((File)file2);
                object = new HashMap<File, FileInformation>(map);
                if (fileInformation2.getStatus() == 0) {
                    object.remove(file);
                    this.turbo.writeEntry((Object)file, "subversion.STATUS_MAP", null);
                } else if (fileInformation2.getStatus() == 8 && file.isFile()) {
                    object.remove(file);
                } else {
                    object.put(file, fileInformation2);
                }
                assert (!object.containsKey(file2));
                this.turbo.writeEntry((Object)file2, "subversion.STATUS_MAP", object.size() == 0 ? null : object);
            }
        }
        if (!bl2) {
            if (fileArray == null && file.isDirectory() && this.needRecursiveRefresh(fileInformation2, fileInformation)) {
                fileArray = this.listFiles(file);
            }
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.refresh(fileArray[i], REPOSITORY_STATUS_UNKNOWN);
                }
            }
            this.fireFileStatusChanged(file, fileInformation, fileInformation2);
        } else {
            if (fileInformation2.isDirectory() && !"false".equals(System.getProperty("org.netbeans.modules.subversion.FileStatusCache.recursiveScan", "true")) && (fileInformation2.getStatus() & 3) == 0 && this.turbo.readEntry((Object)file, "subversion.STATUS_MAP") == null) {
                this.refreshAsync(file.listFiles());
            }
            if (bl) {
                this.fireFileStatusChanged(file, fileInformation, fileInformation2);
            }
        }
        return fileInformation2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patchRevision(File[] fileArray, SVNRevision.Number number) {
        for (File file : fileArray) {
            FileStatusCache fileStatusCache = this;
            synchronized (fileStatusCache) {
                ISVNStatus iSVNStatus;
                FileInformation fileInformation = this.getCachedStatus(file);
                ISVNStatus iSVNStatus2 = iSVNStatus = fileInformation != null ? fileInformation.getEntry(file) : null;
                if (iSVNStatus != null) {
                    SVNRevision.Number number2 = iSVNStatus.getRevision();
                    if (number2 == null) {
                        continue;
                    }
                    if (number2.getNumber() != number.getNumber()) {
                        FileInformation fileInformation2 = this.createFileInformation(file, new FakeRevisionStatus(iSVNStatus, number), REPOSITORY_STATUS_UNKNOWN);
                        File file2 = file.getParentFile();
                        Map<File, FileInformation> map = this.getScannedFiles(file2);
                        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(map);
                        hashMap.put(file, fileInformation2);
                        this.turbo.writeEntry((Object)file2, "subversion.STATUS_MAP", hashMap.size() == 0 ? null : hashMap);
                    }
                }
            }
        }
    }

    private static boolean equivalent(FileInformation fileInformation, FileInformation fileInformation2) {
        ISVNStatus iSVNStatus;
        if (fileInformation2 == null || fileInformation.getStatus() != fileInformation2.getStatus() || fileInformation.isDirectory() != fileInformation2.isDirectory()) {
            return false;
        }
        ISVNStatus iSVNStatus2 = fileInformation.getEntry(null);
        return iSVNStatus2 == (iSVNStatus = fileInformation2.getEntry(null)) || iSVNStatus2 == null || iSVNStatus == null || FileStatusCache.equal(iSVNStatus2, iSVNStatus);
    }

    private static boolean equal(ISVNStatus iSVNStatus, ISVNStatus iSVNStatus2) {
        long l = -1L;
        if (iSVNStatus != null) {
            SVNRevision.Number number = iSVNStatus.getRevision();
            l = number != null ? iSVNStatus.getRevision().getNumber() : l;
        }
        long l2 = -2L;
        if (iSVNStatus2 != null) {
            SVNRevision.Number number = iSVNStatus2.getRevision();
            long l3 = l2 = number != null ? iSVNStatus2.getRevision().getNumber() : l2;
        }
        if (l != l2) {
            return false;
        }
        if (iSVNStatus.isCopied() != iSVNStatus2.isCopied()) {
            return false;
        }
        return iSVNStatus.getUrl() == iSVNStatus2.getUrl() || iSVNStatus.getUrl() != null && iSVNStatus.getUrl().equals((Object)iSVNStatus2.getUrl());
    }

    private boolean needRecursiveRefresh(FileInformation fileInformation, FileInformation fileInformation2) {
        if (fileInformation.getStatus() == 2 || fileInformation2 != null && fileInformation2.getStatus() == 2) {
            return true;
        }
        if (fileInformation.getStatus() == 1 || fileInformation2 != null && fileInformation2.getStatus() == 1) {
            return true;
        }
        return fileInformation.getStatus() == 4 || fileInformation2 != null && fileInformation2.getStatus() == 4096;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    boolean ready() {
        return this.ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeIndex() {
        try {
            this.cacheProvider.computeIndex();
            Subversion.getInstance().refreshAllAnnotations();
        }
        finally {
            this.ready = true;
            this.propertySupport.firePropertyChange(PROP_CACHE_READY, false, true);
        }
    }

    void cleanUp() {
        File[] fileArray;
        for (File file : fileArray = this.cacheProvider.getAllIndexValues()) {
            FileInformation fileInformation = this.getCachedStatus(file);
            if (fileInformation != null && (fileInformation.getStatus() & 0x19D4) != 0) {
                this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
                continue;
            }
            if (fileInformation != null && fileInformation.getStatus() != 2 || this.exists(file)) continue;
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    void directoryContentChanged(File file) {
        Map map = (Map)this.turbo.readEntry((Object)file, "subversion.STATUS_MAP");
        if (map != null) {
            for (File file2 : map.keySet()) {
                this.refresh(file2, REPOSITORY_STATUS_UNKNOWN);
            }
        }
    }

    private Map<File, FileInformation> getScannedFiles(File file) {
        if (SvnUtils.isAdministrative(file)) {
            return NOT_MANAGED_MAP;
        }
        File file2 = file.getParentFile();
        if (file2 != null && SvnUtils.isAdministrative(file2)) {
            return NOT_MANAGED_MAP;
        }
        Map<File, FileInformation> map = (Map<File, FileInformation>)this.turbo.readEntry((Object)file, "subversion.STATUS_MAP");
        if (map != null) {
            return map;
        }
        if (this.isNotManagedByDefault(file)) {
            return NOT_MANAGED_MAP;
        }
        file = FileUtil.normalizeFile((File)file);
        map = this.scanFolder(file);
        assert (!map.containsKey(file));
        this.turbo.writeEntry((Object)file, "subversion.STATUS_MAP", map);
        for (File file3 : map.keySet()) {
            FileInformation fileInformation = map.get(file3);
            if ((fileInformation.getStatus() & 0x19D6) == 0) continue;
            this.fireFileStatusChanged(file3, null, fileInformation);
        }
        return map;
    }

    private boolean isNotManagedByDefault(File file) {
        return !file.exists();
    }

    private Map<File, FileInformation> scanFolder(File file) {
        Object object;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(fileArray.length);
        ISVNStatus[] iSVNStatusArray = null;
        try {
            if (SvnUtils.isManaged(file)) {
                object = Subversion.getInstance().getClient(true);
                iSVNStatusArray = object.getStatus(file, false, true);
            }
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
        }
        if (iSVNStatusArray == null) {
            for (int i = 0; i < fileArray.length; ++i) {
                FileInformation fileInformation;
                File file2 = fileArray[i];
                if (SvnUtils.isAdministrative(file2) || !(fileInformation = this.createFileInformation(file2, null, REPOSITORY_STATUS_UNKNOWN)).isDirectory() && fileInformation.getStatus() == 8) continue;
                hashMap.put(file2, fileInformation);
            }
        } else {
            Serializable serializable;
            Object object2;
            object = new HashSet<File>(Arrays.asList(fileArray));
            for (int i = 0; i < iSVNStatusArray.length; ++i) {
                FileInformation fileInformation;
                object2 = iSVNStatusArray[i];
                serializable = new File(object2.getPath());
                if (((File)serializable).equals(file)) continue;
                object.remove(serializable);
                if (SvnUtils.isAdministrative((File)serializable) || !(fileInformation = this.createFileInformation((File)serializable, (ISVNStatus)object2, REPOSITORY_STATUS_UNKNOWN)).isDirectory() && fileInformation.getStatus() == 8) continue;
                hashMap.put((File)serializable, fileInformation);
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = (File)iterator.next();
                serializable = this.createFileInformation((File)object2, null, REPOSITORY_STATUS_UNKNOWN);
                if (!((FileInformation)serializable).isDirectory() && ((FileInformation)serializable).getStatus() == 8) continue;
                hashMap.put((File)object2, (FileInformation)serializable);
            }
        }
        return hashMap;
    }

    private FileInformation createFileInformation(File file, ISVNStatus iSVNStatus, ISVNStatus iSVNStatus2) {
        if (iSVNStatus == null || iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
            if (!SvnUtils.isManaged(file)) {
                return file.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
            }
            return this.createMissingEntryFileInformation(file, iSVNStatus2);
        }
        return this.createVersionedFileInformation(file, iSVNStatus, iSVNStatus2);
    }

    private FileInformation createVersionedFileInformation(File file, ISVNStatus iSVNStatus, ISVNStatus iSVNStatus2) {
        SVNStatusKind sVNStatusKind = iSVNStatus.getTextStatus();
        SVNStatusKind sVNStatusKind2 = iSVNStatus.getPropStatus();
        int n = 0;
        if (iSVNStatus2 != REPOSITORY_STATUS_UNKNOWN) {
            if (iSVNStatus2.getRepositoryTextStatus() == SVNStatusKind.MODIFIED || iSVNStatus2.getRepositoryPropStatus() == SVNStatusKind.MODIFIED) {
                n = 32;
            } else if (iSVNStatus2.getRepositoryTextStatus() == SVNStatusKind.DELETED) {
                n = 1024;
            } else if (!(iSVNStatus2.getRepositoryTextStatus() == SVNStatusKind.ADDED || iSVNStatus2.getRepositoryTextStatus() == null && iSVNStatus2.getRepositoryPropStatus() == null || iSVNStatus2.getRepositoryTextStatus() == SVNStatusKind.NONE && iSVNStatus2.getRepositoryPropStatus() == SVNStatusKind.NONE)) {
                Subversion.LOG.warning("SVN.FSC: unhandled repository status: " + file.getAbsolutePath() + "\n" + "\ttext: " + iSVNStatus2.getRepositoryTextStatus() + "\n" + "\tprop: " + iSVNStatus2.getRepositoryPropStatus());
            }
        }
        if (iSVNStatus.getLockOwner() != null) {
            n = 0x2000 | n;
        }
        if (!SVNStatusKind.NONE.equals((Object)sVNStatusKind2) && !SVNStatusKind.NORMAL.equals((Object)sVNStatusKind2)) {
            if (SVNStatusKind.MODIFIED.equals((Object)sVNStatusKind2)) {
                if (SVNStatusKind.NORMAL.equals((Object)sVNStatusKind)) {
                    return new FileInformation(0x10 | n, iSVNStatus);
                }
            } else {
                if (SVNStatusKind.CONFLICTED.equals((Object)sVNStatusKind2)) {
                    return new FileInformation(0x40 | n, iSVNStatus);
                }
                throw new IllegalArgumentException("Unknown prop status: " + iSVNStatus.getPropStatus());
            }
        }
        if (SVNStatusKind.NONE.equals((Object)sVNStatusKind)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (SVNStatusKind.NORMAL.equals((Object)sVNStatusKind)) {
            return new FileInformation(8 | n, iSVNStatus);
        }
        if (SVNStatusKind.MODIFIED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x10 | n, iSVNStatus);
        }
        if (SVNStatusKind.ADDED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x1000 | n, iSVNStatus);
        }
        if (SVNStatusKind.DELETED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x100 | n, iSVNStatus);
        }
        if (SVNStatusKind.UNVERSIONED.equals((Object)sVNStatusKind)) {
            return new FileInformation(4 | n, iSVNStatus);
        }
        if (SVNStatusKind.MISSING.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x800 | n, iSVNStatus);
        }
        if (SVNStatusKind.REPLACED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x1000 | n, iSVNStatus);
        }
        if (SVNStatusKind.MERGED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x80 | n, iSVNStatus);
        }
        if (SVNStatusKind.CONFLICTED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x40 | n, iSVNStatus);
        }
        if (SVNStatusKind.OBSTRUCTED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x40 | n, iSVNStatus);
        }
        if (SVNStatusKind.IGNORED.equals((Object)sVNStatusKind)) {
            return new FileInformation(2 | n, iSVNStatus);
        }
        if (SVNStatusKind.INCOMPLETE.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x40 | n, iSVNStatus);
        }
        if (SVNStatusKind.EXTERNAL.equals((Object)sVNStatusKind)) {
            return new FileInformation(8 | n, iSVNStatus);
        }
        throw new IllegalArgumentException("Unknown text status: " + iSVNStatus.getTextStatus());
    }

    static String statusText(ISVNStatus iSVNStatus) {
        return "file: " + iSVNStatus.getTextStatus().toString() + " copied: " + iSVNStatus.isCopied() + " prop: " + iSVNStatus.getPropStatus().toString();
    }

    private FileInformation createMissingEntryFileInformation(File file, ISVNStatus iSVNStatus) {
        String string;
        File file2;
        File file3;
        boolean bl = file.exists();
        boolean bl2 = bl && file.isDirectory();
        int n = this.getStatus(file.getParentFile()).getStatus();
        if (n == 2) {
            return bl2 ? FILE_INFORMATION_EXCLUDED_DIRECTORY : FILE_INFORMATION_EXCLUDED;
        }
        if (bl && n == 1) {
            if (bl2) {
                return SvnUtils.isPartOfSubversionMetadata(file) ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_UPTODATE_DIRECTORY;
            }
            return FILE_INFORMATION_NOTMANAGED;
        }
        String string2 = file.getName();
        Matcher matcher = auxConflictPattern.matcher(string2);
        if (matcher.matches() && (file3 = file.getParentFile()) != null && (file2 = new File(file3, string = matcher.group(1))).isFile()) {
            return FILE_INFORMATION_EXCLUDED;
        }
        if (bl) {
            if (Subversion.getInstance().isIgnored(file)) {
                return new FileInformation(2, file.isDirectory());
            }
            return new FileInformation(4, file.isDirectory());
        }
        if (iSVNStatus != REPOSITORY_STATUS_UNKNOWN && iSVNStatus.getRepositoryTextStatus() == SVNStatusKind.ADDED) {
            boolean bl3 = iSVNStatus.getNodeKind() == SVNNodeKind.DIR;
            return new FileInformation(512, bl3);
        }
        return FILE_INFORMATION_UNKNOWN;
    }

    private boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getAbsolutePath().equals(FileUtil.normalizeFile((File)file).getAbsolutePath());
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }

    private void fireFileStatusChanged(File file, FileInformation fileInformation, FileInformation fileInformation2) {
        this.getLabelsCache().remove(file);
        this.listenerSupport.fireVersioningEvent(EVENT_FILE_STATUS_CHANGED, new Object[]{file, fileInformation, fileInformation2});
    }

    public void setCommand(int n) {
    }

    public void logCommandLine(String string) {
    }

    public void logMessage(String string) {
    }

    public void logError(String string) {
    }

    public void logRevision(long l, String string) {
    }

    public void logCompleted(String string) {
    }

    public FileLabelCache getLabelsCache() {
        return this.labelsCache;
    }

    private class FakeRevisionStatus
    implements ISVNStatus {
        private ISVNStatus value;
        private SVNRevision.Number revision;

        public FakeRevisionStatus(ISVNStatus iSVNStatus, SVNRevision.Number number) {
            this.value = iSVNStatus;
            this.revision = number;
        }

        public boolean isWcLocked() {
            return this.value.isWcLocked();
        }

        public boolean isSwitched() {
            return this.value.isSwitched();
        }

        public boolean isCopied() {
            return this.value.isCopied();
        }

        public String getUrlString() {
            return this.value.getUrlString();
        }

        public SVNUrl getUrlCopiedFrom() {
            return this.value.getUrlCopiedFrom();
        }

        public SVNUrl getUrl() {
            return this.value.getUrl();
        }

        public SVNStatusKind getTextStatus() {
            return this.value.getTextStatus();
        }

        public SVNRevision.Number getRevision() {
            return this.revision;
        }

        public SVNStatusKind getRepositoryTextStatus() {
            return this.value.getRepositoryTextStatus();
        }

        public SVNStatusKind getRepositoryPropStatus() {
            return this.value.getRepositoryPropStatus();
        }

        public SVNStatusKind getPropStatus() {
            return this.value.getPropStatus();
        }

        public String getPath() {
            return this.value.getPath();
        }

        public SVNNodeKind getNodeKind() {
            return this.value.getNodeKind();
        }

        public String getLockOwner() {
            return this.value.getLockOwner();
        }

        public Date getLockCreationDate() {
            return this.value.getLockCreationDate();
        }

        public String getLockComment() {
            return this.value.getLockComment();
        }

        public String getLastCommitAuthor() {
            return this.value.getLastCommitAuthor();
        }

        public SVNRevision.Number getLastChangedRevision() {
            return this.value.getLastChangedRevision();
        }

        public Date getLastChangedDate() {
            return this.value.getLastChangedDate();
        }

        public File getFile() {
            return this.value.getFile();
        }

        public File getConflictWorking() {
            return this.value.getConflictWorking();
        }

        public File getConflictOld() {
            return this.value.getConflictOld();
        }

        public File getConflictNew() {
            return this.value.getConflictNew();
        }

        public boolean hasTreeConflict() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public SVNConflictDescriptor getConflictDescriptor() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isFileExternal() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class FileLabelCache {
        private static final Logger LABELS_CACHE_LOG = Logger.getLogger("org.netbeans.modules.subversion.FileLabelsCache");
        private final LinkedHashMap<File, FileLabelInfo> fileLabels;
        private static final long VALID_LABEL_PERIOD = 20000L;
        private static final FileLabelInfo FAKE_LABEL_INFO = new FileLabelInfo("", "", "");
        private final Set<File> filesForLabelRefresh = new HashSet<File>();
        private final RequestProcessor.Task labelInfoRefreshTask;
        private boolean mimeTypeFlag;
        private final FileStatusCache master;

        private FileLabelCache(FileStatusCache fileStatusCache) {
            this.master = fileStatusCache;
            this.labelInfoRefreshTask = fileStatusCache.rp.create((Runnable)((Object)new LabelInfoRefreshTask()));
            this.fileLabels = new LinkedHashMap(100);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushFileLabels(File ... fileArray) {
            LinkedHashMap<File, FileLabelInfo> linkedHashMap = this.fileLabels;
            synchronized (linkedHashMap) {
                for (File file : fileArray) {
                    if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                        LABELS_CACHE_LOG.fine("Removing from cache: " + file.getAbsolutePath());
                    }
                    this.fileLabels.remove(file);
                }
            }
        }

        void setMimeTypeFlag(boolean bl) {
            this.mimeTypeFlag = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FileLabelInfo getLabelInfo(File file, boolean bl) {
            FileLabelInfo fileLabelInfo;
            boolean bl2 = false;
            LinkedHashMap<File, FileLabelInfo> linkedHashMap = this.fileLabels;
            synchronized (linkedHashMap) {
                fileLabelInfo = this.fileLabels.get(file);
                if (fileLabelInfo == null || !fileLabelInfo.isValid(bl, true)) {
                    if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                        if (fileLabelInfo == null && LABELS_CACHE_LOG.isLoggable(Level.FINER)) {
                            LABELS_CACHE_LOG.finer("No item in cache for : " + file.getAbsolutePath());
                        } else if (fileLabelInfo != null) {
                            LABELS_CACHE_LOG.fine("Too old item in cache for : " + file.getAbsolutePath());
                        }
                    }
                    if (fileLabelInfo == null) {
                        fileLabelInfo = FAKE_LABEL_INFO;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                this.scheduleLabelRefresh(file);
            }
            return fileLabelInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleLabelRefresh(File file) {
            Set<File> set = this.filesForLabelRefresh;
            synchronized (set) {
                this.filesForLabelRefresh.add(file);
            }
            this.labelInfoRefreshTask.schedule(200);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(File file) {
            LinkedHashMap<File, FileLabelInfo> linkedHashMap = this.fileLabels;
            synchronized (linkedHashMap) {
                this.fileLabels.remove(file);
            }
        }

        static class FileLabelInfo {
            private final String revisionString;
            private final String binaryString;
            private final String stickyString;
            private boolean pickedUp;
            private long timestamp;

            private FileLabelInfo(String string, String string2, String string3) {
                this.revisionString = string;
                this.binaryString = string2;
                this.stickyString = string3;
                this.updateTimestamp();
            }

            private void updateTimestamp() {
                this.timestamp = System.currentTimeMillis();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private boolean isValid(boolean bl, boolean bl2) {
                block3: {
                    long l;
                    block2: {
                        l = System.currentTimeMillis() - this.timestamp;
                        if (!bl2 || this.pickedUp) break block2;
                        this.pickedUp = true;
                        if (true) break block3;
                    }
                    if (l > 20000L) return false;
                }
                boolean bl3 = true;
                boolean bl4 = bl3;
                if (!bl4) return false;
                if (!bl) return true;
                if (this.binaryString == null) return false;
                return true;
            }

            String getRevisionString() {
                return this.revisionString != null ? this.revisionString : "";
            }

            String getBinaryString() {
                return this.binaryString != null ? this.binaryString : "";
            }

            String getStickyString() {
                return this.stickyString != null ? this.stickyString : "";
            }

            public boolean equals(Object object) {
                if (object instanceof FileLabelInfo) {
                    FileLabelInfo fileLabelInfo = (FileLabelInfo)object;
                    return this.getRevisionString().equals(fileLabelInfo.getRevisionString()) && this.getBinaryString().equals(fileLabelInfo.getBinaryString()) && this.getStickyString().equals(fileLabelInfo.getStickyString());
                }
                return super.equals(object);
            }

            public int hashCode() {
                int n = 3;
                n = 53 * n + (this.revisionString != null ? this.revisionString.hashCode() : 0);
                n = 53 * n + (this.binaryString != null ? this.binaryString.hashCode() : 0);
                n = 53 * n + (this.stickyString != null ? this.stickyString.hashCode() : 0);
                return n;
            }
        }

        private class LabelInfoRefreshTask
        extends Task {
            private LabelInfoRefreshTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashSet hashSet;
                File[] fileArray = FileLabelCache.this.filesForLabelRefresh;
                synchronized (fileArray) {
                    hashSet = new HashSet(FileLabelCache.this.filesForLabelRefresh);
                    FileLabelCache.this.filesForLabelRefresh.clear();
                }
                if (!hashSet.isEmpty()) {
                    Serializable serializable;
                    Object object;
                    Object object2;
                    fileArray = hashSet.toArray(new File[hashSet.size()]);
                    try {
                        object2 = Subversion.getInstance().getClient(false);
                        object = object2.getStatus(fileArray);
                        serializable = new HashMap(hashSet.size());
                        for (Object object3 : object) {
                            String string;
                            File file = object3.getFile();
                            SVNRevision.Number number = object3.getRevision();
                            String string2 = null;
                            String string3 = string = number != null && !"-1".equals(number.toString()) ? number.toString() : "";
                            if (FileLabelCache.this.mimeTypeFlag) {
                                FileInformation fileInformation = FileLabelCache.this.master.getCachedStatus(file);
                                string2 = fileInformation == null || (fileInformation.getStatus() & 6) == 0 ? this.getMimeType((SvnClient)object2, file) : "";
                            }
                            String string4 = object3 != null && object3.getUrl() != null ? SvnUtils.getCopy(object3.getUrl()) : SvnUtils.getCopy(file);
                            ((HashMap)serializable).put(file, new FileLabelInfo(string, string2, string4));
                        }
                        LinkedHashMap linkedHashMap = FileLabelCache.this.fileLabels;
                        synchronized (linkedHashMap) {
                            for (Map.Entry entry : ((HashMap)serializable).entrySet()) {
                                Object object3;
                                ((FileLabelInfo)entry.getValue()).updateTimestamp();
                                object3 = (FileLabelInfo)FileLabelCache.this.fileLabels.remove(entry.getKey());
                                FileLabelCache.this.fileLabels.put(entry.getKey(), entry.getValue());
                                if (!((FileLabelInfo)entry.getValue()).equals(object3)) continue;
                                hashSet.remove(entry.getKey());
                            }
                        }
                    }
                    catch (SVNClientException sVNClientException) {
                        if (SvnClientExceptionHandler.isTooOldClientForWC(sVNClientException.getMessage())) {
                            try {
                                WorkingCopyAttributesCache.getInstance().logUnsupportedWC(sVNClientException, fileArray[0]);
                            }
                            catch (SVNClientException sVNClientException2) {}
                        }
                        LABELS_CACHE_LOG.log(Level.WARNING, "LabelInfoRefreshTask: failed getting status and info for " + ((Object)hashSet).toString());
                        LABELS_CACHE_LOG.log(Level.INFO, null, sVNClientException);
                    }
                    Subversion.getInstance().refreshAnnotations(hashSet.toArray(new File[hashSet.size()]));
                    object2 = FileLabelCache.this.fileLabels;
                    synchronized (object2) {
                        if (FileLabelCache.this.fileLabels.size() > 50) {
                            if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                                LABELS_CACHE_LOG.fine("Cache contains : " + FileLabelCache.this.fileLabels.size() + " entries before a cleanup");
                            }
                            object = FileLabelCache.this.fileLabels.keySet().iterator();
                            while (object.hasNext()) {
                                serializable = (File)object.next();
                                if (((FileLabelInfo)FileLabelCache.this.fileLabels.get(serializable)).isValid(FileLabelCache.this.mimeTypeFlag, false)) break;
                                object.remove();
                            }
                            if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                                LABELS_CACHE_LOG.fine("Cache contains : " + FileLabelCache.this.fileLabels.size() + " entries after a cleanup");
                            }
                        }
                    }
                }
            }

            private String getMimeType(SvnClient svnClient, File file) {
                try {
                    ISVNProperty iSVNProperty = svnClient.propertyGet(file, "svn:mime-type");
                    if (iSVNProperty != null) {
                        String string = iSVNProperty.getValue();
                        return string != null ? string : "";
                    }
                }
                catch (SVNClientException sVNClientException) {
                    if (LABELS_CACHE_LOG.isLoggable(Level.FINE)) {
                        LABELS_CACHE_LOG.log(Level.FINE, null, sVNClientException);
                    }
                    return "";
                }
                return "";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NotManagedMap
    extends AbstractMap<File, FileInformation> {
        private NotManagedMap() {
        }

        @Override
        public Set<Map.Entry<File, FileInformation>> entrySet() {
            return Collections.emptySet();
        }
    }
}

