/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parser {
    private static Parser instance;
    private LinePattern[] patterns = new LinePattern[]{new LinePattern("([CGU ])([CGU ])   (.+)", 2, -1), new LinePattern("D    ([^ ].+)", 0, -1), new LinePattern("A    ([^ ].+)", 0, -1), new LinePattern("A  \\(bin\\)  ([^ ].+)", 0, -1), new LinePattern("A         ([^ ].+)", 0, -1), new LinePattern("D         ([^ ].+)", 0, -1), new LinePattern("Sending        (.+)", 0, -1), new LinePattern("Adding  \\(bin\\)  (.+)", 0, -1), new LinePattern("Adding         (.+)", 0, -1), new LinePattern("Deleting       (.+)", 0, -1), new LinePattern("Updated to revision (\\d+)\\.", -1, 0), new LinePattern("Update complete\\."), new LinePattern("Updated external to revision (\\d+)\\.", -1, 0), new LinePattern("Committed revision (\\d+)\\.", -1, 0), new LinePattern("External update complete\\."), new LinePattern("Checked out revision (\\d+)\\.", -1, 0), new LinePattern("Checkout complete\\."), new LinePattern("Checked out external at revision (\\d+)\\.", -1, 0), new LinePattern("Restored '(.+)'", 0, -1), new LinePattern("Reverted '(.+)'", 0, -1), new LinePattern("Failed to revert '(.+)' -- try updating instead\\.", 0, -1), new LinePattern("Resolved conflicted state of '(.+)'", 0, -1), new LinePattern("Skipped missing target: '(.+)'", 0, -1), new LinePattern("Skipped '(.+)'", 0, -1), new LinePattern("Fetching external item into '(.+)'", 0, -1), new LinePattern("Exported external at revision (\\d+)\\.", -1, 0), new LinePattern("Exported revision (\\d+)\\.", -1, 0), new LinePattern("External at revision (\\d+)\\.", -1, 0), new LinePattern("At revision (\\d+)\\.", -1, 0), new LinePattern("External export complete\\."), new LinePattern("Export complete\\."), new LinePattern("External checkout complete\\."), new LinePattern("Performing status on external item at '(.+)'", 0, -1), new LinePattern("Status against revision:  *(\\d+)", -1, 0), new LinePattern("Replacing      (.+)", 0, -1), new LinePattern("Transmitting file data \\.*"), new LinePattern("'(.+)' locked by user.*", 0, -1), new LinePattern("'(.+)' unlocked.*", 0, -1)};

    private Parser() {
    }

    public static Parser getInstance() {
        if (instance == null) {
            instance = new Parser();
        }
        return instance;
    }

    public Line parse(String string) {
        for (LinePattern linePattern : this.patterns) {
            Line line = linePattern.parse(string);
            if (line == null) continue;
            return line;
        }
        return null;
    }

    public class Line {
        private final String path;
        private final long revision;

        public Line(String string, long l) {
            this.path = string;
            this.revision = l;
        }

        public String getPath() {
            return this.path;
        }

        public long getRevision() {
            return this.revision;
        }
    }

    private class LinePattern {
        private final int pathIdx;
        private final int revisionIdx;
        private final Pattern pattern;

        public LinePattern(String string) {
            this(string, -1, -1);
        }

        public LinePattern(String string, int n, int n2) {
            this.pattern = Pattern.compile(string);
            this.pathIdx = n;
            this.revisionIdx = n2;
        }

        Line parse(String string) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                String string2 = null;
                long l = -1L;
                if (this.pathIdx > -1) {
                    string2 = matcher.group(this.pathIdx + 1);
                }
                if (this.revisionIdx > -1) {
                    l = Long.parseLong(matcher.group(this.revisionIdx + 1));
                }
                return new Line(string2, l);
            }
            return null;
        }
    }
}

