/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatCommand
extends SvnCommand {
    private final CatType type;
    private SVNUrl url;
    private File file;
    private SVNRevision rev;
    private final SVNRevision pegRevision;
    private byte[] bytes;

    public CatCommand(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        this.url = sVNUrl;
        this.rev = sVNRevision;
        this.file = null;
        this.pegRevision = sVNRevision2;
        this.type = CatType.url;
    }

    public CatCommand(File file, SVNRevision sVNRevision) {
        this.file = file;
        this.rev = sVNRevision;
        this.url = null;
        this.pegRevision = null;
        this.type = CatType.file;
    }

    public InputStream getOutput() {
        return new ByteArrayInputStream(this.bytes == null ? new byte[]{} : this.bytes);
    }

    @Override
    public List<String> getCmdError() {
        return null;
    }

    @Override
    protected boolean hasBinaryOutput() {
        return true;
    }

    @Override
    protected boolean notifyOutput() {
        return false;
    }

    @Override
    public void output(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    protected int getCommand() {
        return 18;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("cat");
        switch (this.type) {
            case url: {
                if (this.pegRevision == null) {
                    arguments.add(this.url);
                    break;
                }
                arguments.add(this.url, this.pegRevision);
                break;
            }
            case file: {
                arguments.add(this.file);
                this.setCommandWorkingDirectory(this.file);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal cattype: " + (Object)((Object)this.type));
            }
        }
        arguments.add(this.rev);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CatType {
        url,
        file;

    }
}

