/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MoveCommand
extends SvnCommand {
    private final MoveType type;
    private final SVNUrl fromUrl;
    private final SVNUrl toUrl;
    private final File fromFile;
    private final File toFile;
    private final String msg;
    private final SVNRevision rev;
    private final boolean force;

    public MoveCommand(SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, SVNRevision sVNRevision) {
        this.fromUrl = sVNUrl;
        this.toUrl = sVNUrl2;
        this.msg = string;
        this.rev = sVNRevision;
        this.fromFile = null;
        this.toFile = null;
        this.force = false;
        this.type = MoveType.url2url;
    }

    public MoveCommand(File file, File file2, boolean bl) {
        this.fromFile = file;
        this.toFile = file2;
        this.force = bl;
        this.toUrl = null;
        this.fromUrl = null;
        this.msg = null;
        this.rev = null;
        this.type = MoveType.file2file;
    }

    protected int getCommand() {
        return 5;
    }

    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("move");
        switch (this.type) {
            case url2url: {
                arguments.add(this.fromUrl);
                arguments.add(this.toUrl);
                arguments.add(this.rev);
                arguments.addMessage(this.msg);
                this.setCommandWorkingDirectory(new File("."));
                break;
            }
            case file2file: {
                arguments.add(this.fromFile);
                arguments.add(this.toFile);
                if (this.force) {
                    arguments.add("--force");
                }
                this.setCommandWorkingDirectory(this.fromFile, this.toFile);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal copytype: " + (Object)((Object)this.type));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MoveType {
        url2url,
        file2file;

    }
}

