/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.parser.SvnWcUtils;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntriesCache {
    private static final String SVN_THIS_DIR = "svn:this_dir";
    private static final String EMPTY_STRING = "";
    private static final String DELIMITER = "\f";
    static String[] entryFileAttributes = new String[]{"name", "kind", "revision", "url", "repos", "schedule", "text-time", "checksum", "committed-date", "committed-rev", "last-author", "has-props", "has-prop-mods", "cachable-props", "present-props", "prop-reject-file", "conflict-old", "conflict-new", "conflict-wrk", "copied", "copyfrom-url", "copyfrom-rev", "deleted", "absent", "incomplete", "uuid", "lock-token", "lock-owner", "lock-comment", "lock-creation-date"};
    private static final Set<String> BOOLEAN_ATTRIBUTES = new HashSet<String>();
    private Entries entries;
    private static EntriesCache instance;

    private EntriesCache() {
    }

    static EntriesCache getInstance() {
        if (instance == null) {
            instance = new EntriesCache();
        }
        return instance;
    }

    Map<String, String> getFileAttributes(File file) throws IOException, SAXException {
        File file2 = SvnWcUtils.getEntriesFile(file);
        if (file2 == null) {
            return null;
        }
        return this.getFileAttributes(file2, file);
    }

    private synchronized Map<String, String> getFileAttributes(File file, File file2) throws IOException, SAXException {
        Map<String, Map<String, String>> map;
        EntriesFile entriesFile = (EntriesFile)this.getEntries().get(file.getAbsolutePath());
        long l = file.lastModified();
        long l2 = file.length();
        if (entriesFile == null || entriesFile.ts != l || entriesFile.size != l2) {
            map = this.getAttributesFromEntriesFile(file);
            entriesFile = new EntriesFile(this.getMergedAttributes((EntryAttributes)map), l, l2);
            this.getEntries().put(file.getAbsolutePath(), entriesFile);
        }
        if (entriesFile.attributes.get(file2.getName()) == null) {
            map = this.mergeThisDirAttributes(file2.isDirectory(), file2.getName(), entriesFile.attributes);
        }
        return (Map)entriesFile.attributes.get(file2.isDirectory() ? SVN_THIS_DIR : file2.getName());
    }

    private EntryAttributes getMergedAttributes(EntryAttributes entryAttributes) throws SAXException {
        for (String string : entryAttributes.keySet()) {
            String string2 = (String)((Map)entryAttributes.get(string)).get("kind");
            if (string2 == null) {
                Subversion.LOG.log(Level.INFO, "File " + string + " is missing - metadata: " + entryAttributes.get(string));
                Subversion.LOG.log(Level.WARNING, "File " + string + " probably does not exist on the hard drive, please check your working copy.");
                string2 = "file";
                ((Map)entryAttributes.get(string)).put("kind", string2);
            }
            boolean bl = string2.equals("dir");
            Map<String, String> map = this.mergeThisDirAttributes(bl, string, entryAttributes);
            if (bl) {
                map.put("handled", EMPTY_STRING + (((Map)entryAttributes.get(SVN_THIS_DIR)).get("deleted") == null));
                continue;
            }
            if (entryAttributes.get(string) != null) {
                for (Map.Entry entry : ((Map)entryAttributes.get(string)).entrySet()) {
                    map.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            map.put("handled", EMPTY_STRING + (entryAttributes.containsKey(string) && entryAttributes.get("deleted") == null));
        }
        return entryAttributes;
    }

    private Map<String, String> mergeThisDirAttributes(boolean bl, String string, EntryAttributes entryAttributes) {
        HashMap<String, String> hashMap = (HashMap<String, String>)entryAttributes.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
            entryAttributes.put(string, hashMap);
        }
        for (Map.Entry entry : ((Map)entryAttributes.get(SVN_THIS_DIR)).entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (bl) {
                hashMap.put(string2, string3);
                continue;
            }
            if (string2.equals("url")) {
                if (hashMap.get(string2) != null) continue;
                hashMap.put(string2, string3 + "/" + string);
                continue;
            }
            if (!string2.equals("uuid") && !string2.equals("repos") && !string2.equals("revision") && !string2.equals("wc-version") || hashMap.get(string2) != null) continue;
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryAttributes getAttributesFromEntriesFile(File file) throws IOException, SAXException {
        boolean bl = false;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
        try {
            String string = bufferedReader.readLine();
            try {
                Integer.valueOf(string);
                bl = false;
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (bl) {
                EntryAttributes entryAttributes = this.loadAttributesFromXml(file);
                return entryAttributes;
            }
            EntryAttributes entryAttributes = this.loadAttributesFromPlainText(bufferedReader, file.getAbsolutePath());
            return entryAttributes;
        }
        finally {
            bufferedReader.close();
        }
    }

    private EntryAttributes loadAttributesFromXml(File file) throws IOException, SAXException {
        XMLReader xMLReader = XMLUtil.createXMLReader();
        XmlEntriesHandler xmlEntriesHandler = new XmlEntriesHandler();
        xMLReader.setContentHandler(xmlEntriesHandler);
        xMLReader.setErrorHandler(xmlEntriesHandler);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            xMLReader.parse(new InputSource(fileInputStream));
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        return xmlEntriesHandler.getEntryAttributes();
    }

    private EntryAttributes loadAttributesFromPlainText(BufferedReader bufferedReader, String string) throws IOException {
        EntryAttributes entryAttributes = new EntryAttributes();
        int n = 0;
        String string2 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = bufferedReader.readLine();
        while (string3 != null) {
            if (n == 0 && (string2 = string3).equals(EMPTY_STRING)) {
                string2 = SVN_THIS_DIR;
            }
            if (!EMPTY_STRING.equals(string3)) {
                if (EntriesCache.isBooleanValue(entryFileAttributes[n])) {
                    string3 = "true";
                }
                hashMap.put(entryFileAttributes[n], string3);
            }
            if ((string3 = bufferedReader.readLine()) != null && ++n > entryFileAttributes.length - 1) {
                Subversion.LOG.fine("Skipping attribute from position " + n + " in entry file " + string);
                while (string3 != null && !DELIMITER.equals(string3)) {
                    string3 = bufferedReader.readLine();
                }
            }
            if (!DELIMITER.equals(string3)) continue;
            hashMap.put("wc-version", "1.4");
            entryAttributes.put(string2, hashMap);
            hashMap = new HashMap();
            n = 0;
            string3 = bufferedReader.readLine();
        }
        return entryAttributes;
    }

    private static boolean isBooleanValue(String string) {
        return BOOLEAN_ATTRIBUTES.contains(string);
    }

    private Entries getEntries() {
        if (this.entries == null) {
            this.entries = new Entries();
        }
        return this.entries;
    }

    static {
        BOOLEAN_ATTRIBUTES.add("has-props");
        BOOLEAN_ATTRIBUTES.add("has-prop-mods");
        BOOLEAN_ATTRIBUTES.add("copied");
        BOOLEAN_ATTRIBUTES.add("deleted");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entries
    extends HashMap<String, EntriesFile> {
        private Entries() {
        }
    }

    private class EntriesFile {
        long ts;
        long size;
        EntryAttributes attributes;

        EntriesFile(EntryAttributes entryAttributes, long l, long l2) {
            this.ts = l;
            this.size = l2;
            this.attributes = entryAttributes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryAttributes
    extends HashMap<String, Map<String, String>> {
        private EntryAttributes() {
        }
    }

    private class XmlEntriesHandler
    extends DefaultHandler {
        private static final String ENTRY_ELEMENT_NAME = "entry";
        private static final String NAME_ATTRIBUTE = "name";
        private EntryAttributes entryAttributes;

        private XmlEntriesHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (ENTRY_ELEMENT_NAME.equals(string3)) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string4 = attributes.getQName(i);
                    String string5 = attributes.getValue(i);
                    hashMap.put(string4, string5);
                }
                String string6 = (String)hashMap.get(NAME_ATTRIBUTE);
                if (string6 == null || EntriesCache.EMPTY_STRING.equals(string6)) {
                    string6 = EntriesCache.SVN_THIS_DIR;
                }
                if (this.entryAttributes == null) {
                    this.entryAttributes = new EntryAttributes();
                }
                hashMap.put("wc-version", "1.3");
                this.entryAttributes.put(string6, hashMap);
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public EntryAttributes getEntryAttributes() {
            return this.entryAttributes;
        }
    }
}

