/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.subversion.ui.browser.ControlPanel;
import org.netbeans.modules.subversion.ui.browser.RepositoryPathNode;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public class BrowserPanel
extends JPanel
implements ExplorerManager.Provider {
    private final BrowserOutlineView outlineView;
    private final ExplorerManager manager;
    private ControlPanel controlPanel;

    public BrowserPanel(String string, String string2, String string3, boolean bl) {
        this.setName(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("CTL_Browser_Prompt"));
        this.manager = new ExplorerManager();
        this.setLayout(new GridBagLayout());
        this.outlineView = new BrowserOutlineView();
        this.outlineView.setDragSource(true);
        this.outlineView.setDropTarget(true);
        this.outlineView.setBorder(UIManager.getBorder("Nb.ScrollPane.border"));
        this.outlineView.getAccessibleContext().setAccessibleDescription(string3);
        this.outlineView.getAccessibleContext().setAccessibleName(string2);
        if (bl) {
            this.outlineView.getOutline().setSelectionMode(1);
        }
        this.outlineView.setPopupAllowed(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        JLabel jLabel = new JLabel();
        jLabel.setLabelFor((Component)((Object)this.outlineView));
        jLabel.setToolTipText(string3);
        if (string != null && !string.trim().equals("")) {
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
        } else {
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)NbBundle.getMessage(BrowserPanel.class, (String)"BK2003"));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)((Object)this.outlineView), gridBagConstraints);
        this.controlPanel = new ControlPanel();
        this.controlPanel.warningLabel.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.controlPanel, gridBagConstraints);
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
        this.setPreferredSize(new Dimension(800, 400));
    }

    void expandNode(RepositoryPathNode repositoryPathNode) {
        this.outlineView.expandNode((Node)repositoryPathNode);
    }

    void warning(String string) {
        if (string != null) {
            this.controlPanel.warningLabel.setText(string);
            this.controlPanel.warningLabel.setVisible(true);
        } else {
            this.controlPanel.warningLabel.setText("");
            this.controlPanel.warningLabel.setVisible(false);
        }
    }

    public void setActions(AbstractAction[] abstractActionArray) {
        if (abstractActionArray != null) {
            this.controlPanel.buttonPanel.removeAll();
            for (int i = 0; i < abstractActionArray.length; ++i) {
                JButton jButton = new JButton();
                jButton.setAction(abstractActionArray[i]);
                jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowserPanel.class, (String)"CTL_Action_MakeDir"));
                Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(BrowserPanel.class, (String)"CTL_Action_MakeDir"));
                this.controlPanel.buttonPanel.add(jButton);
            }
            this.revalidate();
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.outlineView.addTreeExpansionListener(treeExpansionListener);
    }

    void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.outlineView.removeTreeExpansionListener(treeExpansionListener);
    }

    private class BrowserOutlineView
    extends OutlineView {
        BrowserOutlineView() {
            this.setupColumns();
        }

        public void startEditingAtPath(TreePath treePath) {
            this.startEditingAtPath(treePath);
        }

        public void addNotify() {
            super.addNotify();
            this.setDefaultColumnSizes();
        }

        private void setupColumns() {
            ResourceBundle resourceBundle = NbBundle.getBundle(BrowserPanel.class);
            Node.Property[] propertyArray = new Node.Property[]{new ColumnDescriptor<String>("revision", String.class, resourceBundle.getString("LBL_BrowserTree_Column_Revision"), resourceBundle.getString("LBL_BrowserTree_Column_Revision_Desc")), new ColumnDescriptor<String>("date", String.class, resourceBundle.getString("LBL_BrowserTree_Column_Date"), resourceBundle.getString("LBL_BrowserTree_Column_Date_Desc")), new ColumnDescriptor<String>("author", String.class, resourceBundle.getString("LBL_BrowserTree_Column_Author"), resourceBundle.getString("LBL_BrowserTree_Column_Author_Desc")), new ColumnDescriptor<String>("history", String.class, resourceBundle.getString("LBL_BrowserTree_Column_History"), resourceBundle.getString("LBL_BrowserTree_Column_History_Desc"))};
            this.setProperties(propertyArray);
        }

        private void setDefaultColumnSizes() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n = BrowserOutlineView.this.getWidth();
                    BrowserOutlineView.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(n * 50 / 100);
                    BrowserOutlineView.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(n * 10 / 100);
                    BrowserOutlineView.this.getOutline().getColumnModel().getColumn(2).setPreferredWidth(n * 20 / 100);
                    BrowserOutlineView.this.getOutline().getColumnModel().getColumn(3).setPreferredWidth(n * 10 / 100);
                    BrowserOutlineView.this.getOutline().getColumnModel().getColumn(4).setPreferredWidth(n * 10 / 100);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String string, Class<T> clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

