/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.copy.CopyDialog;
import org.netbeans.modules.subversion.ui.copy.CreateCopy;
import org.netbeans.modules.subversion.ui.copy.MergeOneFolderPanel;
import org.netbeans.modules.subversion.ui.copy.MergePanel;
import org.netbeans.modules.subversion.ui.copy.MergeSinceOriginPanel;
import org.netbeans.modules.subversion.ui.copy.MergeTwoFoldersPanel;
import org.netbeans.modules.subversion.ui.copy.OneFolderPreviewPanel;
import org.netbeans.modules.subversion.ui.copy.SinceOriginPreviewPanel;
import org.netbeans.modules.subversion.ui.copy.TwoFoldersPreviewPanel;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Merge
extends CopyDialog
implements ItemListener {
    private String MERGE_START_URL_HISTORY_KEY = Merge.class.getName() + "_merge_from";
    private String MERGE_END_URL_HISTORY_KEY = Merge.class.getName() + "_merge_after";
    private String lastSelectedUrl;

    public Merge(RepositoryFile repositoryFile, File file) {
        super(new MergePanel(), NbBundle.getMessage(Merge.class, (String)"CTL_Merge_Prompt", (Object)file.getName()), NbBundle.getMessage(Merge.class, (String)"CTL_Merge_Title"));
        MergePanel mergePanel = this.getMergePanel();
        mergePanel.typeComboBox.setModel(new DefaultComboBoxModel<MergeType>(new MergeType[]{new MergeSinceOriginType(repositoryFile, file), new MergeOneFolderType(repositoryFile, file), new MergeTwoFoldersType(repositoryFile, file)}));
        mergePanel.typeComboBox.setRenderer(this.createTypeRenderer());
        mergePanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Merge.class, (String)"CTL_Merge_Title"));
        mergePanel.typeComboBox.addItemListener(this);
        this.mergeTypeSelected((MergeType)mergePanel.typeComboBox.getSelectedItem());
    }

    RepositoryFile getMergeStartRepositoryFile() {
        return this.getSelectedType().getMergeStartRepositoryFile();
    }

    RepositoryFile getMergeEndRepositoryFile() {
        return this.getSelectedType().getMergeEndRepositoryFile();
    }

    SVNRevision getMergeStartRevision() {
        return this.getSelectedType().getMergeStartRevision();
    }

    SVNRevision getMergeEndRevision() {
        return this.getSelectedType().getMergeEndRevision();
    }

    private MergeType getSelectedType() {
        return (MergeType)this.getMergePanel().typeComboBox.getSelectedItem();
    }

    private MergePanel getMergePanel() {
        return (MergePanel)this.getPanel();
    }

    private ListCellRenderer createTypeRenderer() {
        return new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof MergeType) {
                    this.setText(((MergeType)object).getDisplayName());
                }
                return this;
            }
        };
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        MergeType mergeType = (MergeType)itemEvent.getItem();
        JTextComponent jTextComponent = mergeType instanceof MergeSinceOriginType ? (JTextComponent)mergeType.getEndUrlComboBox().getEditor().getEditorComponent() : (JTextComponent)mergeType.getStartUrlComboBox().getEditor().getEditorComponent();
        if (itemEvent.getStateChange() == 1) {
            this.mergeTypeSelected(mergeType);
            if (jTextComponent.getText().trim().equals("") && this.lastSelectedUrl != null) {
                jTextComponent.setText(this.lastSelectedUrl);
            }
        } else if (itemEvent.getStateChange() == 2 && !jTextComponent.getText().trim().equals("")) {
            this.lastSelectedUrl = jTextComponent.getText();
        }
    }

    private void mergeTypeSelected(MergeType mergeType) {
        MergePanel mergePanel = this.getMergePanel();
        mergePanel.typeDescriptionLabel.setText(mergeType.getDescription());
        mergePanel.previewPanel.removeAll();
        mergePanel.previewPanel.setLayout(new BorderLayout());
        mergePanel.previewPanel.add((Component)mergeType.getPreviewPanel(), "Center");
        mergePanel.mergeFieldsPanel.removeAll();
        mergePanel.mergeFieldsPanel.setLayout(new BorderLayout());
        mergePanel.mergeFieldsPanel.add((Component)mergeType.getFieldsPanel(), "Center");
        mergeType.setPreviewLabels();
        mergePanel.repaint();
        this.resetUrlComboBoxes();
        this.setupUrlComboBox(mergeType.getStartUrlComboBox(), this.MERGE_START_URL_HISTORY_KEY);
        this.setupUrlComboBox(mergeType.getEndUrlComboBox(), this.MERGE_END_URL_HISTORY_KEY);
    }

    private class MergeOneFolderType
    extends MergeType {
        private RepositoryPaths mergeEndRepositoryPaths;
        private MergeOneFolderPanel panel;
        private OneFolderPreviewPanel previewPanel;

        public MergeOneFolderType(RepositoryFile repositoryFile, File file) {
            super(repositoryFile);
            this.panel = new MergeOneFolderPanel();
            this.previewPanel = new OneFolderPreviewPanel();
            RepositoryPaths repositoryPaths = new RepositoryPaths(repositoryFile, (JTextComponent)this.panel.mergeStartUrlComboBox.getEditor().getEditorComponent(), null, this.panel.mergeStartRevisionTextField, this.panel.mergeStartSearchButton);
            this.mergeEndRepositoryPaths = new RepositoryPaths(repositoryFile, (JTextComponent)this.panel.mergeStartUrlComboBox.getEditor().getEditorComponent(), this.panel.mergeStartBrowseButton, this.panel.mergeEndRevisionTextField, this.panel.mergeEndSearchButton);
            this.init(repositoryPaths, this.panel.mergeStartRepositoryFolderLabel, this.mergeEndRepositoryPaths, null, file);
            this.previewPanel.localFolderTextField.setText(file.getAbsolutePath());
            ((JTextComponent)this.panel.mergeStartUrlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        }

        public RepositoryFile getMergeStartRepositoryFile() {
            return this.getMergeEndRepositoryFile();
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_OneRepositoryFolder");
        }

        public String getDescription() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_OneRepositoryFolderDesc");
        }

        public JPanel getFieldsPanel() {
            return this.panel;
        }

        public JPanel getPreviewPanel() {
            return this.previewPanel;
        }

        public JComboBox getStartUrlComboBox() {
            return this.panel.mergeStartUrlComboBox;
        }

        public JComboBox getEndUrlComboBox() {
            return null;
        }

        protected void setPreviewLabels() {
            this.previewPanel.repositoryFolderTextField.setText(this.getRepositoryFile().getRepositoryUrl() + NbBundle.getMessage(Merge.class, (String)"/") + this.panel.mergeStartUrlComboBox.getEditor().getItem().toString());
        }
    }

    private class MergeSinceOriginType
    extends MergeType {
        private MergeSinceOriginPanel panel;
        private RepositoryPaths mergeEndRepositoryPaths;
        private SinceOriginPreviewPanel previewPanel;

        public MergeSinceOriginType(RepositoryFile repositoryFile, File file) {
            super(repositoryFile);
            this.panel = new MergeSinceOriginPanel();
            this.previewPanel = new SinceOriginPreviewPanel();
            this.mergeEndRepositoryPaths = new RepositoryPaths(repositoryFile, (JTextComponent)this.panel.mergeEndUrlComboBox.getEditor().getEditorComponent(), this.panel.mergeEndBrowseButton, this.panel.mergeEndRevisionTextField, this.panel.mergeEndSearchButton);
            this.init(null, null, this.mergeEndRepositoryPaths, this.panel.mergeEndRepositoryFolderLabel, file);
            this.previewPanel.localFolderTextField.setText(file.getAbsolutePath());
            ((JTextComponent)this.panel.mergeEndUrlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_OneRepositoryFolderSinceOrigin");
        }

        public String getDescription() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_OneRepositoryFolderSinceOriginDesc");
        }

        public JPanel getFieldsPanel() {
            return this.panel;
        }

        public JPanel getPreviewPanel() {
            return this.previewPanel;
        }

        public RepositoryFile getMergeStartRepositoryFile() {
            return null;
        }

        public SVNRevision getMergeStartRevision() {
            return null;
        }

        public SVNUrl getMergeEndUrl() {
            try {
                return this.mergeEndRepositoryPaths.getRepositoryFiles()[0].getFileUrl();
            }
            catch (MalformedURLException malformedURLException) {
                Subversion.LOG.log(Level.INFO, null, malformedURLException);
                return null;
            }
        }

        public SVNRevision getMergeEndRevision() {
            try {
                return this.mergeEndRepositoryPaths.getRepositoryFiles()[0].getRevision();
            }
            catch (MalformedURLException malformedURLException) {
                Subversion.LOG.log(Level.INFO, null, malformedURLException);
                return null;
            }
        }

        RepositoryPaths getMergeStartRepositoryPath() {
            return null;
        }

        RepositoryPaths getMergeEndRepositoryPath() {
            return this.mergeEndRepositoryPaths;
        }

        public JComboBox getStartUrlComboBox() {
            return null;
        }

        public JComboBox getEndUrlComboBox() {
            return this.panel.mergeEndUrlComboBox;
        }

        protected void setPreviewLabels() {
            this.previewPanel.repositoryFolderTextField.setText(this.getRepositoryFile().getRepositoryUrl() + "/" + this.panel.mergeEndUrlComboBox.getEditor().getItem().toString());
        }
    }

    private class MergeTwoFoldersType
    extends MergeType {
        private MergeTwoFoldersPanel panel;
        private TwoFoldersPreviewPanel previewPanel;

        public MergeTwoFoldersType(RepositoryFile repositoryFile, File file) {
            super(repositoryFile);
            this.panel = new MergeTwoFoldersPanel();
            this.previewPanel = new TwoFoldersPreviewPanel();
            RepositoryPaths repositoryPaths = new RepositoryPaths(repositoryFile, (JTextComponent)this.panel.mergeStartUrlComboBox.getEditor().getEditorComponent(), this.panel.mergeStartBrowseButton, this.panel.mergeStartRevisionTextField, this.panel.mergeStartSearchButton);
            RepositoryPaths repositoryPaths2 = new RepositoryPaths(repositoryFile, (JTextComponent)this.panel.mergeEndUrlComboBox.getEditor().getEditorComponent(), this.panel.mergeEndBrowseButton, this.panel.mergeEndRevisionTextField, this.panel.mergeEndSearchButton);
            this.init(repositoryPaths, this.panel.mergeStartRepositoryFolderLabel, repositoryPaths2, this.panel.mergeEndRepositoryFolderLabel, file);
            this.previewPanel.localFolderTextField.setText(file.getAbsolutePath());
            ((JTextComponent)this.panel.mergeStartUrlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
            ((JTextComponent)this.panel.mergeEndUrlComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_TwoRepositoryFolders");
        }

        public String getDescription() {
            return NbBundle.getMessage(Merge.class, (String)"CTL_Merge_TwoFoldersDesc");
        }

        public JPanel getFieldsPanel() {
            return this.panel;
        }

        public JPanel getPreviewPanel() {
            return this.previewPanel;
        }

        public JComboBox getStartUrlComboBox() {
            return this.panel.mergeStartUrlComboBox;
        }

        public JComboBox getEndUrlComboBox() {
            return this.panel.mergeEndUrlComboBox;
        }

        protected void setPreviewLabels() {
            this.previewPanel.repositoryFolderTextField1.setText(this.getRepositoryFile().getRepositoryUrl() + "/" + this.panel.mergeStartUrlComboBox.getEditor().getItem().toString());
            this.previewPanel.repositoryFolderTextField2.setText(this.getRepositoryFile().getRepositoryUrl() + "/" + this.panel.mergeEndUrlComboBox.getEditor().getItem().toString());
        }
    }

    private abstract class MergeType
    implements DocumentListener,
    PropertyChangeListener {
        private RepositoryPaths mergeStartRepositoryPaths;
        private RepositoryPaths mergeEndRepositoryPaths;
        private RepositoryFile repositoryFile;
        private boolean startPathValid = false;
        private boolean endPathValid = false;

        MergeType(RepositoryFile repositoryFile) {
            this.repositoryFile = repositoryFile;
        }

        protected void init(RepositoryPaths repositoryPaths, JLabel jLabel, RepositoryPaths repositoryPaths2, JLabel jLabel2, File file) {
            if (repositoryPaths != null) {
                this.mergeStartRepositoryPaths = repositoryPaths;
                this.init(repositoryPaths, jLabel, file);
            } else {
                this.startPathValid = true;
            }
            if (repositoryPaths2 != null) {
                this.mergeEndRepositoryPaths = repositoryPaths2;
                this.init(repositoryPaths2, jLabel2, file);
            } else {
                this.endPathValid = true;
            }
        }

        private void init(RepositoryPaths repositoryPaths, JLabel jLabel, File file) {
            int n;
            String string;
            if (file.isFile()) {
                if (jLabel != null) {
                    jLabel.setText(NbBundle.getMessage(Merge.class, (String)"CTL_Merge_RepositoryFile"));
                }
                string = NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageMergeFile");
                n = 7;
            } else {
                string = NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageMergeFolder");
                n = 2;
            }
            repositoryPaths.setupBehavior(string, n, "org.netbeans.modules.subversion.ui.browser.merge", "org.netbeans.modules.subversion.ui.search.merge");
            repositoryPaths.addPropertyChangeListener(this);
        }

        protected abstract JPanel getFieldsPanel();

        protected abstract JPanel getPreviewPanel();

        protected abstract String getDisplayName();

        protected abstract String getDescription();

        protected abstract JComboBox getStartUrlComboBox();

        protected abstract JComboBox getEndUrlComboBox();

        protected abstract void setPreviewLabels();

        public RepositoryFile getMergeStartRepositoryFile() {
            try {
                return this.mergeStartRepositoryPaths.getRepositoryFiles()[0];
            }
            catch (MalformedURLException malformedURLException) {
                Subversion.LOG.log(Level.INFO, null, malformedURLException);
                return null;
            }
        }

        public RepositoryFile getMergeEndRepositoryFile() {
            try {
                return this.mergeEndRepositoryPaths.getRepositoryFiles()[0];
            }
            catch (MalformedURLException malformedURLException) {
                Subversion.LOG.log(Level.INFO, null, malformedURLException);
                return null;
            }
        }

        public SVNRevision getMergeStartRevision() {
            try {
                return this.mergeStartRepositoryPaths.getRepositoryFiles()[0].getRevision();
            }
            catch (MalformedURLException malformedURLException) {
                Subversion.LOG.log(Level.INFO, null, malformedURLException);
                return null;
            }
        }

        public SVNRevision getMergeEndRevision() {
            try {
                return this.mergeEndRepositoryPaths.getRepositoryFiles()[0].getRevision();
            }
            catch (MalformedURLException malformedURLException) {
                Subversion.LOG.log(Level.INFO, null, malformedURLException);
                return null;
            }
        }

        RepositoryPaths getMergeStartRepositoryPath() {
            return this.mergeStartRepositoryPaths;
        }

        RepositoryPaths getMergeEndRepositoryPath() {
            return this.mergeEndRepositoryPaths;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.setPreviewLabels();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.setPreviewLabels();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.setPreviewLabels();
        }

        protected RepositoryFile getRepositoryFile() {
            return this.repositoryFile;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("valid")) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (propertyChangeEvent.getSource() == this.getMergeStartRepositoryPath()) {
                    this.startPathValid = bl;
                } else if (propertyChangeEvent.getSource() == this.getMergeEndRepositoryPath()) {
                    this.endPathValid = bl;
                }
                Merge.this.getOKButton().setEnabled(this.startPathValid && this.endPathValid);
            }
        }
    }
}

