/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.diff.DiffNode;
import org.netbeans.modules.subversion.ui.diff.DiffStreamSource;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public final class Setup {
    public static final int DIFFTYPE_LOCAL = 0;
    public static final int DIFFTYPE_REMOTE = 1;
    public static final int DIFFTYPE_ALL = 2;
    public static final String REVISION_PRISTINE = "PRISTINE";
    public static final String REVISION_BASE = "BASE";
    public static final String REVISION_CURRENT = "LOCAL";
    public static final String REVISION_HEAD = "HEAD";
    private final File baseFile;
    private final String propertyName;
    private String firstRevision;
    private final String secondRevision;
    private FileInformation info;
    private DiffStreamSource firstSource;
    private DiffStreamSource secondSource;
    private DiffController view;
    private DiffNode node;
    private String title;

    public Setup(File file, String string, int n) {
        String string2;
        String string3;
        this.baseFile = file;
        this.propertyName = string;
        this.info = Subversion.getInstance().getStatusCache().getStatus(file);
        int n2 = this.info.getStatus();
        ResourceBundle resourceBundle = NbBundle.getBundle(Setup.class);
        switch (n) {
            case 0: 
            case 1: {
                if (Setup.match(n2, 4100)) {
                    this.firstRevision = REVISION_BASE;
                    string3 = resourceBundle.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(n2, 512)) {
                    this.firstRevision = null;
                    string3 = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(n2, 2304)) {
                    this.firstRevision = REVISION_BASE;
                    string3 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                    break;
                }
                this.firstRevision = REVISION_BASE;
                string3 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                break;
            }
            case 2: {
                if (Setup.match(n2, 512)) {
                    this.firstRevision = REVISION_HEAD;
                    string3 = resourceBundle.getString("MSG_DiffPanel_RemoteNew");
                    break;
                }
                if (Setup.match(n2, 4100)) {
                    this.firstRevision = null;
                    string3 = resourceBundle.getString("MSG_DiffPanel_NoBaseRevision");
                    break;
                }
                if (Setup.match(n2, 1024)) {
                    this.firstRevision = null;
                    string3 = resourceBundle.getString("MSG_DiffPanel_RemoteDeleted");
                    break;
                }
                this.firstRevision = REVISION_HEAD;
                string3 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_RemoteModified"), this.firstRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + n);
            }
        }
        switch (n) {
            case 0: 
            case 2: {
                if (Setup.match(n2, 64)) {
                    this.secondRevision = REVISION_CURRENT;
                    string2 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_LocalConflict"), this.secondRevision);
                    break;
                }
                if (Setup.match(n2, 4100)) {
                    this.secondRevision = REVISION_CURRENT;
                    string2 = resourceBundle.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(n2, 512)) {
                    this.secondRevision = null;
                    string2 = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(n2, 2304)) {
                    this.secondRevision = null;
                    string2 = resourceBundle.getString("MSG_DiffPanel_LocalDeleted");
                    break;
                }
                this.secondRevision = REVISION_CURRENT;
                string2 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_LocalModified"), this.secondRevision);
                break;
            }
            case 1: {
                if (Setup.match(n2, 4100)) {
                    this.secondRevision = null;
                    string2 = resourceBundle.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(n2, 512)) {
                    this.secondRevision = REVISION_HEAD;
                    string2 = resourceBundle.getString("MSG_DiffPanel_RemoteNew");
                    break;
                }
                if (Setup.match(n2, 1024)) {
                    this.secondRevision = null;
                    string2 = resourceBundle.getString("MSG_DiffPanel_RemoteDeleted");
                    break;
                }
                this.secondRevision = REVISION_HEAD;
                string2 = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_RemoteModified"), this.secondRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + n);
            }
        }
        if (string != null && REVISION_HEAD.equals(this.firstRevision)) {
            this.firstRevision = REVISION_BASE;
        }
        this.firstSource = new DiffStreamSource(file, string, this.firstRevision, string3);
        this.secondSource = new DiffStreamSource(file, string, this.secondRevision, string2);
        this.title = "<html>" + Subversion.getInstance().getAnnotator().annotateNameHtml(file, this.info);
    }

    public Setup(File file, String string, String string2) {
        this.baseFile = file;
        this.propertyName = null;
        this.firstRevision = string;
        this.secondRevision = string2;
        this.firstSource = new DiffStreamSource(file, this.propertyName, string, string);
        this.secondSource = new DiffStreamSource(file, this.propertyName, string2, string2);
    }

    public Setup(File file, ISVNStatus iSVNStatus) {
        String string;
        this.baseFile = file;
        this.propertyName = null;
        this.secondRevision = null;
        ResourceBundle resourceBundle = NbBundle.getBundle(Setup.class);
        if (iSVNStatus.getRepositoryTextStatus().equals((Object)SVNStatusKind.ADDED)) {
            this.firstRevision = REVISION_HEAD;
            string = resourceBundle.getString("MSG_DiffPanel_RemoteNew");
        } else if (iSVNStatus.getRepositoryTextStatus().equals((Object)SVNStatusKind.DELETED)) {
            this.firstRevision = null;
            string = resourceBundle.getString("MSG_DiffPanel_RemoteDeleted");
        } else if (iSVNStatus.getRepositoryTextStatus().equals((Object)SVNStatusKind.MODIFIED)) {
            this.firstRevision = REVISION_HEAD;
            string = MessageFormat.format(resourceBundle.getString("MSG_DiffPanel_RemoteModified"), this.firstRevision);
        } else {
            this.firstRevision = REVISION_HEAD;
            string = REVISION_HEAD.toString();
        }
        this.firstSource = new DiffStreamSource(file, this.propertyName, REVISION_HEAD, string);
        this.secondSource = new DiffStreamSource(file, this.propertyName, REVISION_CURRENT, REVISION_CURRENT);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public FileInformation getInfo() {
        return this.info;
    }

    public void setView(DiffController diffController) {
        this.view = diffController;
    }

    public DiffController getView() {
        return this.view;
    }

    public StreamSource getFirstSource() {
        return this.firstSource;
    }

    public StreamSource getSecondSource() {
        return this.secondSource;
    }

    public void setNode(DiffNode diffNode) {
        this.node = diffNode;
    }

    public DiffNode getNode() {
        return this.node;
    }

    public String toString() {
        return this.title;
    }

    void initSources() throws IOException {
        if (this.firstSource != null) {
            this.firstSource.init();
        }
        if (this.secondSource != null) {
            this.secondSource.init();
        }
    }

    private static boolean match(int n, int n2) {
        return (n & n2) != 0;
    }
}

