/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.RevisionNode;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class DiffTreeTable
extends OutlineView {
    private RevisionsRootNode rootNode;
    private List results;
    private final SearchHistoryPanel master;
    private static final Icon NO_ICON = new NoIcon();

    public DiffTreeTable(SearchHistoryPanel searchHistoryPanel) {
        this.master = searchHistoryPanel;
        this.getOutline().setShowHorizontalLines(true);
        this.getOutline().setShowVerticalLines(false);
        this.getOutline().setRootVisible(false);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setupColumns();
        this.getOutline().setRenderDataProvider((RenderDataProvider)new NoLeafIconRenderDataProvider(this.getOutline().getRenderDataProvider()));
    }

    private void setupColumns() {
        Node.Property[] propertyArray = new Node.Property[3];
        ResourceBundle resourceBundle = NbBundle.getBundle(DiffTreeTable.class);
        propertyArray[0] = new ColumnDescriptor<String>("date", String.class, resourceBundle.getString("LBL_DiffTree_Column_Time"), resourceBundle.getString("LBL_DiffTree_Column_Time_Desc"));
        propertyArray[1] = new ColumnDescriptor<String>("username", String.class, resourceBundle.getString("LBL_DiffTree_Column_Username"), resourceBundle.getString("LBL_DiffTree_Column_Username_Desc"));
        propertyArray[2] = new ColumnDescriptor<String>("message", String.class, resourceBundle.getString("LBL_DiffTree_Column_Message"), resourceBundle.getString("LBL_DiffTree_Column_Message_Desc"));
        this.setProperties(propertyArray);
    }

    private void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = DiffTreeTable.this.getWidth();
                DiffTreeTable.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(n * 25 / 100);
                DiffTreeTable.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(n * 15 / 100);
                DiffTreeTable.this.getOutline().getColumnModel().getColumn(2).setPreferredWidth(n * 10 / 100);
                DiffTreeTable.this.getOutline().getColumnModel().getColumn(3).setPreferredWidth(n * 50 / 100);
            }
        });
    }

    void setSelection(int n) {
        this.getOutline().getSelectionModel().setValueIsAdjusting(false);
        this.getOutline().scrollRectToVisible(this.getOutline().getCellRect(n, 1, true));
        this.getOutline().getSelectionModel().setSelectionInterval(n, n);
    }

    void setSelection(RepositoryRevision repositoryRevision) {
        RevisionNode revisionNode = (RevisionNode)this.getNode((Node)this.rootNode, repositoryRevision);
        if (revisionNode == null) {
            return;
        }
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        try {
            explorerManager.setSelectedNodes(new Node[]{revisionNode});
        }
        catch (PropertyVetoException propertyVetoException) {
            Subversion.LOG.log(Level.SEVERE, null, propertyVetoException);
        }
    }

    void setSelection(RepositoryRevision.Event event) {
        RevisionNode revisionNode = (RevisionNode)this.getNode((Node)this.rootNode, event);
        if (revisionNode == null) {
            return;
        }
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        try {
            explorerManager.setSelectedNodes(new Node[]{revisionNode});
        }
        catch (PropertyVetoException propertyVetoException) {
            Subversion.LOG.log(Level.SEVERE, null, propertyVetoException);
        }
    }

    private Node getNode(Node node, Object object) {
        Object object2 = node.getLookup().lookup(object.getClass());
        if (object.equals(object2)) {
            return node;
        }
        Enumeration enumeration = node.getChildren().nodes();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            Node node3 = this.getNode(node2, object);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    public int[] getSelection() {
        return this.getOutline().getSelectedRows();
    }

    public int getRowCount() {
        return this.getOutline().getRowCount();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        explorerManager.setRootContext((Node)this.rootNode);
        this.setDefaultColumnSizes();
    }

    public void setResults(List list) {
        this.results = list;
        this.rootNode = new RevisionsRootNode();
        ExplorerManager explorerManager = ExplorerManager.find((Component)((Object)this));
        if (explorerManager != null) {
            explorerManager.setRootContext((Node)this.rootNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String string, Class<T> clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }

    private static class NoIcon
    implements Icon {
        private NoIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 0;
        }

        public int getIconHeight() {
            return 0;
        }
    }

    private class NoLeafIconRenderDataProvider
    implements RenderDataProvider {
        private RenderDataProvider delegate;

        public NoLeafIconRenderDataProvider(RenderDataProvider renderDataProvider) {
            this.delegate = renderDataProvider;
        }

        public String getDisplayName(Object object) {
            return this.delegate.getDisplayName(object);
        }

        public boolean isHtmlDisplayName(Object object) {
            return this.delegate.isHtmlDisplayName(object);
        }

        public Color getBackground(Object object) {
            return this.delegate.getBackground(object);
        }

        public Color getForeground(Object object) {
            return this.delegate.getForeground(object);
        }

        public String getTooltipText(Object object) {
            return this.delegate.getTooltipText(object);
        }

        public Icon getIcon(Object object) {
            if (DiffTreeTable.this.getOutline().getOutlineModel().isLeaf(object)) {
                return NO_ICON;
            }
            return null;
        }
    }

    private class RevisionsRootNode
    extends AbstractNode {
        public RevisionsRootNode() {
            super((Children)new RevisionsRootNodeChildren(), Lookups.singleton((Object)DiffTreeTable.this.results));
        }

        public String getName() {
            return "revision";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name");
        }

        public String getShortDescription() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name_Desc");
        }
    }

    private class RevisionsRootNodeChildren
    extends Children.Keys {
        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        private void refreshKeys() {
            this.setKeys(DiffTreeTable.this.results);
        }

        protected Node[] createNodes(Object object) {
            RevisionNode revisionNode = object instanceof RepositoryRevision ? new RevisionNode((RepositoryRevision)object, DiffTreeTable.this.master) : new RevisionNode((RepositoryRevision.Event)object, DiffTreeTable.this.master);
            return new Node[]{revisionNode};
        }
    }
}

