/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openide.util.NbBundle;

class Divider
extends JPanel {
    public static final int DIVIDER_CLICKED = 1;
    public static final int DOWN = 0;
    public static final int UP = 1;
    private Color bkg;
    private Color sbkg;
    private Color arrowColor;
    private Color selectedArrowColor;
    private ActionListener listener;
    private int arrowDirection;

    public Divider(ActionListener actionListener) {
        this.listener = actionListener;
        this.enableEvents(509L);
        this.bkg = this.getBackground();
        this.sbkg = UIManager.getColor("TextField.selectionBackground");
        this.selectedArrowColor = UIManager.getColor("TextField.selectionForeground");
        this.arrowColor = UIManager.getColor("TextField.inactiveForeground");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Divider.class, (String)"ACSN_Divider"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Divider.class, (String)"ACSD_Divider"));
    }

    public Dimension getPreferredSize() {
        return new Dimension(Integer.MAX_VALUE, 6);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, 6);
    }

    public void setArrowDirection(int n) {
        this.arrowDirection = n;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 504) {
            this.setBackground(this.sbkg);
            this.repaint();
        }
        if (mouseEvent.getID() == 505) {
            this.setBackground(this.bkg);
            this.repaint();
        }
        if (mouseEvent.getID() == 500) {
            this.listener.actionPerformed(new ActionEvent(this, 1, ""));
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        if (this.getBackground().equals(this.bkg)) {
            graphics.setColor(this.arrowColor);
        } else {
            graphics.setColor(this.selectedArrowColor);
        }
        int n = dimension.width / 2;
        if (this.arrowDirection == 0) {
            graphics.drawLine(n - 4, 1, n + 4, 1);
            graphics.drawLine(n - 3, 2, n + 3, 2);
            graphics.drawLine(n - 2, 3, n + 2, 3);
            graphics.drawLine(n - 1, 4, n + 1, 4);
        } else if (this.arrowDirection == 1) {
            graphics.drawLine(n - 4, 4, n + 4, 4);
            graphics.drawLine(n - 3, 3, n + 3, 3);
            graphics.drawLine(n - 2, 2, n + 2, 2);
            graphics.drawLine(n - 1, 1, n + 1, 1);
        }
    }
}

