/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.properties.PropertiesTable;
import org.netbeans.modules.subversion.ui.properties.SvnProperties;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertiesPanel
extends JPanel
implements DocumentListener,
ItemListener,
PreferenceChangeListener,
TableModelListener {
    final JButton btnAdd = new JButton(){
        private Dimension prefSize;

        public Dimension getPreferredSize() {
            if (this.prefSize == null) {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)AddButtonState.ADD.getLabel());
                Dimension dimension = super.getPreferredSize();
                int n = dimension.width;
                int n2 = dimension.height;
                Mnemonics.setLocalizedText((AbstractButton)this, (String)AddButtonState.ADD_UPDATE.getLabel());
                dimension = super.getPreferredSize();
                n = Math.max(n, dimension.width);
                n2 = Math.max(n2, dimension.height);
                Mnemonics.setLocalizedText((AbstractButton)this, (String)AddButtonState.UPDATE.getLabel());
                dimension = super.getPreferredSize();
                n = Math.max(n, dimension.width);
                n2 = Math.max(n2, dimension.height);
                this.prefSize = new Dimension(n, n2);
            }
            return this.prefSize;
        }
    };
    final JButton btnBrowse = new JButton();
    final JButton btnRefresh = new JButton();
    final JButton btnRemove = new JButton();
    final JCheckBox cbxRecursively = new JCheckBox();
    final JComboBox comboName = new JComboBox();
    final JTextArea txtAreaValue = new JTextArea();
    final JPanel propsPanel = new DerivedHeightPanel(this.txtAreaValue, 2.0f);
    final JLabel labelForTable = new JLabel();
    private static final Object EVENT_SETTINGS_CHANGED = new Object();
    private PropertiesTable propertiesTable;
    private ListenersSupport listenerSupport = new ListenersSupport((Object)this);
    private final JLabel lblErrMessage = new JLabel();
    private final Document propNameDocument = ((JTextField)this.comboName.getEditor().getEditorComponent()).getDocument();
    private final Document propValueDocument = this.txtAreaValue.getDocument();
    private String propertyName;
    private String propertyValue;
    private String illegalPropErrMsgKey;
    private boolean recursive;
    private String[] existingProperties;
    private String[] illegalProperties;
    private SvnProperties propValueChangeListener;
    private boolean interactionInitialized;

    public PropertiesPanel() {
        this.initComponents();
    }

    String getPropertyName() {
        return this.propertyName;
    }

    String getPropertyValue() {
        return this.propertyValue;
    }

    void setPropertiesTable(PropertiesTable propertiesTable) {
        this.propertiesTable = propertiesTable;
    }

    public void addNotify() {
        super.addNotify();
        SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.propertiesTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        this.txtAreaValue.selectAll();
    }

    public void removeNotify() {
        this.propertiesTable.getTableModel().removeTableModelListener(this);
        SvnModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        super.removeNotify();
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("commitExclusions")) {
            this.propertiesTable.dataChanged();
            this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        }
    }

    void setPredefinedPropertyNames(String[] stringArray) {
        this.comboName.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.comboName.getEditor().setItem("");
    }

    void setExistingPropertyNames(String[] stringArray) {
        this.existingProperties = stringArray;
        if (this.interactionInitialized) {
            this.existingPropertiesChanged();
        }
    }

    void setIllegalPropertyNames(String[] stringArray, String string) {
        this.illegalProperties = stringArray;
        this.illegalPropErrMsgKey = string;
        if (this.interactionInitialized) {
            this.illegalPropertiesChanged();
        }
    }

    void setForDirectory(boolean bl) {
        if (bl) {
            this.cbxRecursively.setEnabled(true);
        } else {
            this.cbxRecursively.setEnabled(false);
            this.cbxRecursively.setSelected(false);
        }
    }

    void initInteraction() {
        this.updatePropertyName();
        this.updatePropertyValue();
        this.updateIsRecursive();
        this.propNameDocument.addDocumentListener(this);
        this.propValueDocument.addDocumentListener(this);
        this.cbxRecursively.addItemListener(this);
        this.refreshAddButtonText();
        this.refreshAddButtonState();
        this.interactionInitialized = true;
    }

    void setPropertyValueChangeListener(SvnProperties svnProperties) {
        this.propValueChangeListener = svnProperties;
    }

    void removePropertyValueChangeListener() {
        this.propValueChangeListener = null;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        jLabel.setLabelFor(this.comboName);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)PropertiesPanel.getString("PropertiesPanel.jLabel2.text"));
        JLabel jLabel2 = new JLabel();
        jLabel2.setLabelFor(this.txtAreaValue);
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)PropertiesPanel.getString("PropertiesPanel.jLabel1.text"));
        this.txtAreaValue.setColumns(20);
        this.txtAreaValue.setRows(5);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.txtAreaValue);
        this.lblErrMessage.setForeground(Color.RED);
        this.lblErrMessage.setVisible(false);
        this.lblErrMessage.setText(" ");
        Mnemonics.setLocalizedText((AbstractButton)this.btnBrowse, (String)PropertiesPanel.getString("PropertiesPanel.btnBrowse.text"));
        this.btnBrowse.setActionCommand(PropertiesPanel.getString("btnBrowse.actionCommand"));
        JSeparator jSeparator = new JSeparator();
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)PropertiesPanel.getString("PropertiesPanel.btnAdd.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbxRecursively, (String)PropertiesPanel.getString("PropertiesPanel.cbxRecursively.text"));
        this.cbxRecursively.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)PropertiesPanel.getString("PropertiesPanel.btnRemove.text"));
        this.btnRemove.setActionCommand(PropertiesPanel.getString("btnRemove.actionCommand"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRefresh, (String)PropertiesPanel.getString("PropertiesPanel.btnRefresh.text"));
        this.btnRefresh.setActionCommand(PropertiesPanel.getString("btnRefresh.actionCommand"));
        Mnemonics.setLocalizedText((JLabel)this.labelForTable, (String)PropertiesPanel.getString("jLabel3.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)jLabel).add((Component)jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.comboName, 0, -1, -1).add((Component)jScrollPane))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblErrMessage, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnBrowse)).add((Component)jSeparator).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.btnAdd, -2, -1, -1).addPreferredGap(0).add((Component)this.cbxRecursively).addPreferredGap((JComponent)this.cbxRecursively, (JComponent)this.btnRemove, 0, true).add((Component)this.btnRemove).addPreferredGap(0).add((Component)this.btnRefresh)).add((Component)this.labelForTable).add((Component)this.propsPanel)).addContainerGap());
        groupLayout.linkSize(new Component[]{this.btnBrowse, this.btnRefresh, this.btnRemove}, 1);
        groupLayout.setHonorsVisibility(false);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)jLabel).add((Component)this.comboName)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel2).add((Component)jScrollPane, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblErrMessage).add((Component)this.btnBrowse)).addPreferredGap(0).add((Component)jSeparator, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnAdd).add((Component)this.cbxRecursively).add((Component)this.btnRemove).add((Component)this.btnRefresh)).add(18).add((Component)this.labelForTable).addPreferredGap(0).add((Component)this.propsPanel, -1, -1, Short.MAX_VALUE).addContainerGap());
        jLabel.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("jLabel2.AccessibleContext.accessibleDescription"));
        jLabel2.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("jLabel1.AccessibleContext.accessibleDescription"));
        this.comboName.getAccessibleContext().setAccessibleName(PropertiesPanel.getString("comboName.AccessibleContext.accessibleName"));
        this.comboName.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("comboName.AccessibleContext.accessibleDescription"));
        this.txtAreaValue.getAccessibleContext().setAccessibleName(PropertiesPanel.getString("txtAreaValue.AccessibleContext.accessibleName"));
        this.txtAreaValue.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("txtAreaValue.AccessibleContext.accessibleDescription"));
        this.btnBrowse.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("btnBrowse.AccessibleContext.accessibleDescription"));
        this.btnAdd.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("btnAdd.AccessibleContext.accessibleDescription"));
        this.cbxRecursively.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("cbxRecursively.AccessibleContext.accessibleDescription"));
        this.btnRemove.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("btnRemove.AccessibleContext.accessibleDescription"));
        this.btnRefresh.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("btnRefresh.AccessibleContext.accessibleDescription"));
        this.labelForTable.getAccessibleContext().setAccessibleDescription(PropertiesPanel.getString("labelForTable.AccessibleContext.accessibleDescription"));
    }

    private void setErrMessage(String string) {
        if (string == null) {
            this.lblErrMessage.setText(" ");
            this.lblErrMessage.setVisible(false);
        } else {
            this.lblErrMessage.setText(string);
            this.lblErrMessage.setVisible(true);
            int n = this.lblErrMessage.getSize().width - this.lblErrMessage.getPreferredSize().width;
            if (n < 0) {
                this.makeDialogWider(-n);
            }
        }
    }

    private void makeDialogWider(int n) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            Dimension dimension = window.getSize();
            dimension.width += n;
            window.setSize(dimension);
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(PropertiesPanel.class, (String)string);
    }

    private void refreshAddButtonText() {
        AddButtonState addButtonState;
        if (this.recursive) {
            addButtonState = AddButtonState.ADD_UPDATE;
        } else {
            boolean bl = false;
            if (this.existingProperties != null) {
                for (int i = 0; i < this.existingProperties.length; ++i) {
                    if (!this.existingProperties[i].equals(this.propertyName)) continue;
                    bl = true;
                    break;
                }
            }
            addButtonState = bl ? AddButtonState.UPDATE : AddButtonState.ADD;
        }
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)addButtonState.getLabel());
    }

    private void refreshAddButtonState() {
        String string;
        boolean bl;
        if (this.propertyName.length() == 0) {
            bl = false;
            string = null;
        } else if (!this.isPropertyNameLegal()) {
            bl = false;
            string = NbBundle.getMessage(PropertiesPanel.class, (String)this.illegalPropErrMsgKey, (Object)this.propertyName);
        } else if (this.propertyName.indexOf(32) != -1) {
            bl = false;
            string = NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.errPropNameInvalid");
        } else {
            bl = this.propertyValue.length() != 0;
            string = null;
        }
        this.btnAdd.setEnabled(bl);
        this.setErrMessage(string);
    }

    private boolean isPropertyNameLegal() {
        for (int i = 0; i < this.illegalProperties.length; ++i) {
            if (!this.propertyName.equals(this.illegalProperties[i])) continue;
            return false;
        }
        return true;
    }

    private void propNameChanged() {
        if (!this.recursive) {
            this.refreshAddButtonText();
        }
        this.refreshAddButtonState();
    }

    private void propValueChanged() {
        this.refreshAddButtonState();
        if (this.propValueChangeListener != null) {
            this.propValueChangeListener.propertyValueChanged();
        }
    }

    private void recursiveToggled() {
        this.refreshAddButtonText();
    }

    private void existingPropertiesChanged() {
        this.refreshAddButtonText();
    }

    private void illegalPropertiesChanged() {
        this.refreshAddButtonState();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent.getDocument());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent.getDocument());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        assert (itemEvent.getSource() == this.cbxRecursively);
        this.updateIsRecursive();
        this.recursiveToggled();
    }

    private void textChanged(Document document) {
        if (document == this.propNameDocument) {
            this.updatePropertyName();
            this.propNameChanged();
        } else {
            assert (document == this.propValueDocument);
            this.updatePropertyValue();
            this.propValueChanged();
        }
    }

    private void updatePropertyName() {
        try {
            this.propertyName = this.propNameDocument.getText(0, this.propNameDocument.getLength()).trim();
        }
        catch (BadLocationException badLocationException) {
            assert (false);
            this.propertyName = "";
        }
    }

    private void updatePropertyValue() {
        this.propertyValue = this.txtAreaValue.getText().trim();
    }

    private void updateIsRecursive() {
        this.recursive = this.cbxRecursively.isSelected();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AddButtonState {
        ADD("PropertiesPanel.btnAdd.text"),
        ADD_UPDATE("PropertiesPanel.btnAddUpdate.text"),
        UPDATE("PropertiesPanel.btnUpdate.text");

        private final String btnLabel;

        private AddButtonState(String string2) {
            this.btnLabel = NbBundle.getMessage(PropertiesPanel.class, (String)string2);
        }

        String getLabel() {
            return this.btnLabel;
        }
    }

    private final class DerivedHeightPanel
    extends JPanel {
        private final Component deriveFrom;
        private final float ratio;
        private Dimension prefSize = null;

        private DerivedHeightPanel(Component component, float f) {
            this.deriveFrom = component;
            this.ratio = f;
        }

        public Dimension getPreferredSize() {
            if (this.prefSize == null) {
                this.prefSize = this.computePrefSize();
            }
            return this.prefSize;
        }

        private Dimension computePrefSize() {
            int n = Math.round(this.ratio * (float)this.deriveFrom.getPreferredSize().height);
            return new Dimension(0, n);
        }
    }
}

