/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.repository;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.diff.options.AccessibleJFileChooser;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.netbeans.modules.subversion.ui.repository.HttpPanel;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.ui.repository.SvnSSHCliPanel;
import org.netbeans.modules.subversion.ui.repository.SvnSSHJhlPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class ConnectionType
implements ActionListener,
DocumentListener,
FocusListener {
    private static final String LOCAL_URL_HELP = "file:///repository_path[@REV]";
    private static final String HTTP_URL_HELP = "http://hostname/repository_path[@REV]";
    private static final String HTTPS_URL_HELP = "https://hostname/repository_path[@REV]";
    private static final String SVN_URL_HELP = "svn://hostname/repository_path[@REV]";
    private static final String SVN_SSH_URL_HELP = "svn+{0}://hostname/repository_path[@REV]";
    protected final Repository repository;
    private List<JTextField> selectOnFocusFields = null;

    public ConnectionType(Repository repository) {
        this.repository = repository;
    }

    abstract String getTip(String var1);

    abstract JPanel getPanel();

    abstract void setEditable(boolean var1);

    protected void refresh(RepositoryConnection repositoryConnection) {
    }

    protected void setEnabled(boolean bl) {
    }

    protected void textChanged(Document document) {
    }

    protected void storeConfigValues() {
    }

    protected void onSelectedRepositoryChange(String string) {
    }

    protected void showHints(boolean bl) {
    }

    protected void fillRC(RepositoryConnection repositoryConnection) {
    }

    protected void updateVisibility(String string) {
    }

    boolean savePassword() {
        return true;
    }

    boolean isValid(RepositoryConnection repositoryConnection) {
        return true;
    }

    protected void addSelectOnFocusFields(JTextField ... jTextFieldArray) {
        if (this.selectOnFocusFields == null) {
            this.selectOnFocusFields = new ArrayList<JTextField>();
        }
        for (JTextField jTextField : jTextFieldArray) {
            this.selectOnFocusFields.add(jTextField);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    private void textChanged(final DocumentEvent documentEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                ConnectionType.this.textChanged(documentEvent.getDocument());
                ConnectionType.this.repository.validateSvnUrl();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.selectOnFocusFields == null) {
            return;
        }
        for (JTextField jTextField : this.selectOnFocusFields) {
            if (focusEvent.getSource() != jTextField) continue;
            jTextField.selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected void onBrowse(JTextField jTextField) {
        File file = FileUtil.normalizeFile((File)new File(jTextField.getText()));
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(Repository.class, (String)"ACSD_BrowseCertFile"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(Repository.class, (String)"Browse_title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        accessibleJFileChooser.setFileSelectionMode(0);
        accessibleJFileChooser.showDialog(this.getPanel(), NbBundle.getMessage(Repository.class, (String)"OK_Button"));
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            jTextField.setText(file2.getAbsolutePath());
        }
    }

    static class FileUrl
    extends ConnectionType {
        private JPanel panel = new JPanel();

        public FileUrl(Repository repository) {
            super(repository);
        }

        JPanel getPanel() {
            return this.panel;
        }

        String getTip(String string) {
            return ConnectionType.LOCAL_URL_HELP;
        }

        void setEditable(boolean bl) {
        }
    }

    static class Http
    extends ConnectionType {
        private HttpPanel panel = new HttpPanel();

        public Http(Repository repository) {
            super(repository);
            this.panel.proxySettingsButton.addActionListener(this);
            this.panel.savePasswordCheckBox.addActionListener(this);
            this.addSelectOnFocusFields(this.panel.userPasswordField);
            this.panel.browseButton.addActionListener(this);
            this.panel.userPasswordField.getDocument().addDocumentListener(this);
            this.panel.certPasswordField.getDocument().addDocumentListener(this);
            this.panel.userPasswordField.addFocusListener(this);
            this.panel.certPasswordField.addFocusListener(this);
            this.panel.userTextField.getDocument().addDocumentListener(this);
            this.panel.certFileTextField.getDocument().addDocumentListener(this);
        }

        JPanel getPanel() {
            return this.panel;
        }

        protected void refresh(RepositoryConnection repositoryConnection) {
            this.panel.userTextField.setText(repositoryConnection.getUsername());
            this.panel.userPasswordField.setText(repositoryConnection.getPassword());
            this.panel.savePasswordCheckBox.setSelected(repositoryConnection.getSavePassword());
            this.panel.certFileTextField.setText(repositoryConnection.getCertFile());
            this.panel.certPasswordField.setText(repositoryConnection.getCertPassword());
        }

        public void setEnabled(boolean bl) {
            this.panel.proxySettingsButton.setEnabled(bl);
            this.panel.userPasswordField.setEnabled(bl);
            this.panel.userTextField.setEnabled(bl);
            this.panel.savePasswordCheckBox.setEnabled(bl);
            this.panel.certFileTextField.setEnabled(bl);
            this.panel.certPasswordField.setEnabled(bl);
            this.panel.browseButton.setEnabled(bl);
        }

        public void setEditable(boolean bl) {
            this.panel.userPasswordField.setEditable(bl);
            this.panel.userTextField.setEditable(bl);
            this.panel.proxySettingsButton.setEnabled(bl);
            this.panel.savePasswordCheckBox.setEnabled(bl);
            this.panel.certFileTextField.setEnabled(bl);
            this.panel.certPasswordField.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.panel.proxySettingsButton) {
                this.onProxyConfiguration();
            } else if (actionEvent.getSource() == this.panel.savePasswordCheckBox) {
                this.onSavePasswordChange();
            } else if (actionEvent.getSource() == this.panel.browseButton) {
                this.onBrowse(this.panel.certFileTextField);
            } else {
                super.actionPerformed(actionEvent);
            }
        }

        private void onProxyConfiguration() {
            OptionsDisplayer.getDefault().open("General");
        }

        private void onSavePasswordChange() {
            Runnable runnable = new Runnable(){

                public void run() {
                    RepositoryConnection repositoryConnection = Http.this.repository.getSelectedRCIntern();
                    if (repositoryConnection != null) {
                        repositoryConnection.setSavePassword(((Http)Http.this).panel.savePasswordCheckBox.isSelected());
                    }
                    Http.this.repository.validateSvnUrl();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        protected void storeConfigValues() {
        }

        protected boolean savePassword() {
            return this.panel.savePasswordCheckBox.isSelected();
        }

        public void onSelectedRepositoryChange(String string) {
        }

        protected void textChanged(Document document) {
            if (document == this.panel.userTextField.getDocument()) {
                this.onUsernameChange(this.repository.getSelectedRCIntern());
            } else if (document == this.panel.userPasswordField.getDocument()) {
                this.onPasswordChange(this.repository.getSelectedRCIntern());
            } else if (document == this.panel.certFileTextField.getDocument()) {
                this.onCertFileChange(this.repository.getSelectedRCIntern());
            } else if (document == this.panel.certPasswordField.getDocument()) {
                this.onCertPasswordChange(this.repository.getSelectedRCIntern());
            }
        }

        private void onUsernameChange(RepositoryConnection repositoryConnection) {
            if (repositoryConnection != null) {
                repositoryConnection.setUsername(this.panel.userTextField.getText());
            }
            this.repository.setValid(true, "");
        }

        private void onPasswordChange(RepositoryConnection repositoryConnection) {
            if (repositoryConnection != null) {
                repositoryConnection.setPassword(new String(this.panel.userPasswordField.getPassword()));
            }
            this.repository.setValid(true, "");
        }

        private void onCertPasswordChange(RepositoryConnection repositoryConnection) {
            if (repositoryConnection != null) {
                repositoryConnection.setCertPassword(new String(this.panel.certPasswordField.getPassword()));
            }
        }

        private void onCertFileChange(RepositoryConnection repositoryConnection) {
            if (repositoryConnection != null) {
                repositoryConnection.setCertFile(this.panel.certFileTextField.getText());
            }
        }

        protected void fillRC(RepositoryConnection repositoryConnection) {
            repositoryConnection.setUsername(this.panel.userTextField.getText());
            repositoryConnection.setPassword(new String(this.panel.userPasswordField.getPassword()));
            repositoryConnection.setSavePassword(this.panel.savePasswordCheckBox.isSelected());
            repositoryConnection.setCertFile(this.panel.certFileTextField.getText());
            repositoryConnection.setCertPassword(new String(this.panel.certPasswordField.getPassword()));
        }

        String getTip(String string) {
            if (string.startsWith("http:")) {
                return ConnectionType.HTTP_URL_HELP;
            }
            if (string.startsWith("https:")) {
                return ConnectionType.HTTPS_URL_HELP;
            }
            if (string.startsWith("svn:")) {
                return ConnectionType.SVN_URL_HELP;
            }
            return null;
        }

        protected void updateVisibility(String string) {
            this.panel.sslPanel.setVisible(string.startsWith("https:"));
        }
    }

    static class InvalidUrl
    extends FileUrl {
        public InvalidUrl(Repository repository) {
            super(repository);
        }

        String getTip(String string) {
            return NbBundle.getMessage(Repository.class, (String)"MSG_Repository_Url_Help", (Object[])new Object[]{ConnectionType.LOCAL_URL_HELP, ConnectionType.HTTP_URL_HELP, ConnectionType.HTTPS_URL_HELP, ConnectionType.SVN_URL_HELP, ConnectionType.SVN_SSH_URL_HELP});
        }
    }

    static class SvnSSHCli
    extends ConnectionType {
        private SvnSSHCliPanel panel = new SvnSSHCliPanel();

        public SvnSSHCli(Repository repository) {
            super(repository);
            this.panel.tunnelCommandTextField.getDocument().addDocumentListener(this);
        }

        JPanel getPanel() {
            return this.panel;
        }

        protected void refresh(RepositoryConnection repositoryConnection) {
            this.panel.tunnelCommandTextField.setText(repositoryConnection.getExternalCommand());
        }

        void setEditable(boolean bl) {
            this.panel.tunnelCommandTextField.setEditable(bl);
        }

        protected void showHints(boolean bl) {
            this.panel.tunnelHelpLabel.setVisible(bl);
        }

        protected void textChanged(Document document) {
            if (document == this.panel.tunnelCommandTextField.getDocument()) {
                this.onTunnelCommandChange(this.repository.getSelectedRCIntern());
            }
        }

        private void onTunnelCommandChange(RepositoryConnection repositoryConnection) {
            if (repositoryConnection != null) {
                repositoryConnection.setExternalCommand(this.panel.tunnelCommandTextField.getText());
            }
        }

        protected void storeConfigValues() {
            RepositoryConnection repositoryConnection = this.repository.getSelectedRCIntern();
            if (repositoryConnection == null) {
                return;
            }
            try {
                SVNUrl sVNUrl = repositoryConnection.getSvnUrl();
                if (sVNUrl.getProtocol().startsWith("svn+")) {
                    SvnConfigFiles.getInstance().setExternalCommand(SvnUtils.getTunnelName(sVNUrl.getProtocol()), this.panel.tunnelCommandTextField.getText());
                }
            }
            catch (MalformedURLException malformedURLException) {
                Subversion.LOG.log(Level.INFO, null, malformedURLException);
            }
        }

        protected boolean savePassword() {
            return true;
        }

        protected boolean isValid(RepositoryConnection repositoryConnection) {
            return !repositoryConnection.getUrl().startsWith("svn+") || !this.panel.tunnelCommandTextField.getText().trim().equals("");
        }

        public void onSelectedRepositoryChange(String string) {
            if (string.startsWith("svn+")) {
                String string2 = SvnUtils.getTunnelName(string).trim();
                if (this.panel.tunnelCommandTextField.getText().trim().equals("") && string2 != null && !string2.equals("")) {
                    this.panel.tunnelCommandTextField.setText(SvnConfigFiles.getInstance().getExternalCommand(string2));
                }
            }
        }

        protected void fillRC(RepositoryConnection repositoryConnection) {
            repositoryConnection.setExternalCommand(this.panel.tunnelCommandTextField.getText());
        }

        String getTip(String string) {
            String string2 = SvnUtils.getTunnelName(string);
            return MessageFormat.format(ConnectionType.SVN_SSH_URL_HELP, string2).trim();
        }
    }

    static class SvnSSHJhl
    extends ConnectionType {
        private SvnSSHJhlPanel panel = new SvnSSHJhlPanel();

        public SvnSSHJhl(Repository repository) {
            super(repository);
            this.panel.passwordField.getDocument().addDocumentListener(this);
            this.panel.certPasswordField.getDocument().addDocumentListener(this);
            this.panel.certFileTextField.getDocument().addDocumentListener(this);
            this.panel.passwordField.addFocusListener(this);
            this.panel.certPasswordField.addFocusListener(this);
            this.panel.passwordRadioButton.addActionListener(this);
            this.panel.privateKeyRadioButton.addActionListener(this);
            this.panel.browseButton.addActionListener(this);
            this.addSelectOnFocusFields(this.panel.certPasswordField, this.panel.passwordField);
        }

        JPanel getPanel() {
            return this.panel;
        }

        protected void refresh(RepositoryConnection repositoryConnection) {
            this.panel.passwordField.setText(repositoryConnection.getPassword());
            this.panel.certPasswordField.setText(repositoryConnection.getCertPassword());
            this.panel.certFileTextField.setText(repositoryConnection.getCertFile());
        }

        void setEditable(boolean bl) {
            this.panel.passwordField.setEditable(bl);
            this.panel.certPasswordField.setEditable(bl);
            this.panel.certFileTextField.setEditable(bl);
        }

        protected void storeConfigValues() {
        }

        protected boolean savePassword() {
            return true;
        }

        protected void setEnabled(boolean bl) {
            if (this.panel.passwordRadioButton.isSelected()) {
                this.panel.passwordField.setEnabled(bl);
                this.panel.certPasswordField.setEnabled(false);
                this.panel.certFileTextField.setEnabled(false);
            } else if (this.panel.privateKeyRadioButton.isSelected()) {
                this.panel.passwordField.setEnabled(false);
                this.panel.certPasswordField.setEnabled(bl);
                this.panel.certFileTextField.setEnabled(bl);
            }
            this.panel.browseButton.setEnabled(bl);
            this.panel.passwordRadioButton.setEnabled(bl);
            this.panel.privateKeyRadioButton.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.panel.passwordRadioButton || actionEvent.getSource() == this.panel.privateKeyRadioButton) {
                this.setEnabled(true);
            } else if (actionEvent.getSource() == this.panel.browseButton) {
                this.onBrowse(this.panel.certFileTextField);
            } else {
                super.actionPerformed(actionEvent);
            }
        }

        public void onSelectedRepositoryChange(String string) {
        }

        protected void fillRC(RepositoryConnection repositoryConnection) {
            repositoryConnection.setPassword(new String(this.panel.passwordField.getPassword()));
            repositoryConnection.setCertPassword(new String(this.panel.certPasswordField.getPassword()));
            repositoryConnection.setCertFile(this.panel.certFileTextField.getText());
        }

        String getTip(String string) {
            String string2 = this.getTunnelName(string);
            return MessageFormat.format(ConnectionType.SVN_SSH_URL_HELP, string2).trim();
        }

        private String getTunnelName(String string) {
            int n = string.indexOf(":", 4);
            if (n < 0) {
                n = string.length();
            }
            return string.substring(4, n);
        }
    }
}

