/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.kenai;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.kenai.ui.spi.BuildHandle;
import org.openide.util.RequestProcessor;

class BuildHandleImpl
extends BuildHandle {
    private final HudsonJob job;

    public BuildHandleImpl(HudsonJob hudsonJob) {
        this.job = hudsonJob;
    }

    public String getDisplayName() {
        return this.job.getDisplayName();
    }

    public BuildHandle.Status getStatus() {
        switch (this.job.getColor()) {
            case blue_anime: 
            case yellow_anime: 
            case red_anime: 
            case aborted_anime: 
            case grey_anime: {
                return BuildHandle.Status.RUNNING;
            }
            case blue: {
                return BuildHandle.Status.STABLE;
            }
            case yellow: {
                return BuildHandle.Status.UNSTABLE;
            }
            case red: {
                return BuildHandle.Status.FAILED;
            }
        }
        return BuildHandle.Status.UNKNOWN;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public Action getDefaultAction() {
        return new AbstractAction(){

            public void actionPerformed(final ActionEvent actionEvent) {
                final int n = BuildHandleImpl.this.job.getLastBuild();
                if (n == -1) {
                    UI.selectNode((String[])new String[]{BuildHandleImpl.this.job.getInstance().getUrl(), BuildHandleImpl.this.job.getName()});
                } else {
                    UI.selectNode((String[])new String[]{BuildHandleImpl.this.job.getInstance().getUrl(), BuildHandleImpl.this.job.getName(), Integer.toString(n)});
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (n == -1) {
                            BuildHandleImpl.this.job.start();
                            return;
                        }
                        block8: for (HudsonJobBuild hudsonJobBuild : BuildHandleImpl.this.job.getBuilds()) {
                            if (hudsonJobBuild.getNumber() != n) continue;
                            switch (hudsonJobBuild.getResult()) {
                                case FAILURE: 
                                case ABORTED: {
                                    UI.showConsoleAction((HudsonJobBuild)hudsonJobBuild).actionPerformed(actionEvent);
                                    break;
                                }
                                case UNSTABLE: {
                                    if (hudsonJobBuild.getMavenModules().isEmpty()) {
                                        UI.showFailuresAction((HudsonJobBuild)hudsonJobBuild).actionPerformed(actionEvent);
                                        break;
                                    }
                                    for (HudsonMavenModuleBuild hudsonMavenModuleBuild : hudsonJobBuild.getMavenModules()) {
                                        switch (hudsonMavenModuleBuild.getColor()) {
                                            case yellow_anime: 
                                            case yellow: {
                                                UI.showFailuresAction((HudsonMavenModuleBuild)hudsonMavenModuleBuild).actionPerformed(actionEvent);
                                            }
                                        }
                                    }
                                    break block8;
                                }
                                case SUCCESS: 
                                case NOT_BUILT: {
                                    UI.showChangesAction((HudsonJobBuild)hudsonJobBuild).actionPerformed(actionEvent);
                                }
                            }
                            break;
                        }
                    }
                });
            }
        };
    }
}

