/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SourceCodeCommentParser {
    private SourceParser parser;

    public SourceCodeCommentParser() {
        this.parser = new SourceParser();
    }

    public SourceCodeCommentParser(String string, String string2, String string3) {
        this.parser = new CommentParser(string, string2, string3);
    }

    public void setText(String string) {
        this.parser.setText(string);
    }

    public boolean nextRegion(CommentRegion commentRegion) throws IOException {
        return this.parser.nextRegion(commentRegion);
    }

    private static class CommentParser
    extends SourceParser {
        protected String lineComment;
        protected String blockStart;
        protected String blockEnd;

        public CommentParser(String string) {
            this(string, null, null);
        }

        public CommentParser(String string, String string2, String string3) {
            this.lineComment = string;
            this.blockStart = string2;
            this.blockEnd = string3;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (string != null) {
                this.appendEncodedChars(stringBuffer, string);
                bl = true;
            }
            if (string2 != null) {
                if (bl) {
                    stringBuffer.append('|');
                }
                this.appendEncodedChars(stringBuffer, string2);
            }
            this.pattern = Pattern.compile(stringBuffer.toString());
            this.matcher = null;
        }

        public boolean nextRegion(CommentRegion commentRegion) throws IOException {
            boolean bl = false;
            if (this.matcher != null && this.matcher.find(this.curr)) {
                String string = this.text.substring(this.matcher.start(), this.matcher.end());
                commentRegion.start = this.matcher.start();
                if (this.lineComment != null && this.lineComment.equals(string)) {
                    int n = this.text.indexOf("\n", commentRegion.start);
                    commentRegion.stop = n != -1 ? n : this.text.length();
                } else if (this.blockStart != null) {
                    int n = this.text.indexOf(this.blockEnd, commentRegion.start);
                    commentRegion.stop = n != -1 ? n + this.blockEnd.length() : this.text.length();
                } else {
                    return false;
                }
                this.curr = commentRegion.stop + 1;
                bl = true;
            }
            return bl;
        }
    }

    static class CommentRegion {
        public int start = 0;
        public int stop = 0;
    }

    private static class SourceParser {
        protected String text = null;
        protected int curr = 0;
        protected Matcher matcher = null;
        protected Pattern pattern;

        public boolean nextRegion(CommentRegion commentRegion) throws IOException {
            if (this.text == null) {
                return false;
            }
            commentRegion.start = this.curr;
            commentRegion.stop = this.text.length();
            if (commentRegion.start == commentRegion.stop) {
                return false;
            }
            this.curr = commentRegion.stop;
            return true;
        }

        public void setText(String string) {
            this.text = string;
            if (this.pattern != null) {
                this.matcher = this.pattern.matcher(string);
            }
        }

        protected void appendEncodedChars(StringBuffer stringBuffer, String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                String string2 = Integer.toHexString(string.charAt(i));
                stringBuffer.append("\\u");
                int n2 = 4 - string2.length();
                for (int j = 0; j < n2; ++j) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
            }
        }
    }
}

