/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo.settings;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.tasklist.todo.settings.Settings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ToDoCustomizer
extends JPanel {
    private boolean changed = false;
    private boolean isUpdating = false;
    private JButton btnAdd;
    private JButton btnChange;
    private JButton btnRemove;
    private JCheckBox checkScanCommentsOnly;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable table;

    public ToDoCustomizer() {
        this.initComponents();
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ToDoCustomizer.this.enableButtons();
            }
        });
        this.jScrollPane1.getViewport().setOpaque(false);
        this.enableButtons();
    }

    private void enableButtons() {
        int n = this.table.getSelectedRow();
        this.btnChange.setEnabled(n >= 0);
        this.btnRemove.setEnabled(n >= 0);
    }

    void update() {
        this.isUpdating = true;
        Collection<String> collection = Settings.getDefault().getPatterns();
        this.table.setModel(this.createModel(collection));
        this.table.setTableHeader(null);
        this.checkScanCommentsOnly.setSelected(Settings.getDefault().isScanCommentsOnly());
        this.changed = false;
        this.isUpdating = false;
    }

    void applyChanges() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        ArrayList<String> arrayList = new ArrayList<String>(defaultTableModel.getRowCount());
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            arrayList.add(defaultTableModel.getValueAt(i, 0).toString());
        }
        Settings.getDefault().setPatterns(arrayList);
        Settings.getDefault().setScanCommentsOnly(this.checkScanCommentsOnly.isSelected());
    }

    boolean isDataValid() {
        return this.table.getRowCount() > 0;
    }

    boolean isChanged() {
        return this.changed;
    }

    private DefaultTableModel createModel(Collection<String> collection) {
        DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.TableHeader")}, collection.size());
        int n = 0;
        for (String string : collection) {
            defaultTableModel.setValueAt(string, n++, 0);
        }
        return defaultTableModel;
    }

    private void initComponents() {
        this.btnAdd = new JButton();
        this.btnChange = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new MyTable();
        this.checkScanCommentsOnly = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.btnRemove = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.btnAdd.text"));
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToDoCustomizer.this.btnAddActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnChange, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.btnChange.text"));
        this.btnChange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToDoCustomizer.this.btnChangeActionPerformed(actionEvent);
            }
        });
        this.jScrollPane1.setOpaque(false);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setOpaque(false);
        this.table.setTableHeader(null);
        this.jScrollPane1.setViewportView(this.table);
        Mnemonics.setLocalizedText((AbstractButton)this.checkScanCommentsOnly, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.checkScanCommentsOnly.text"));
        this.checkScanCommentsOnly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkScanCommentsOnly.setMargin(new Insets(0, 0, 0, 0));
        this.checkScanCommentsOnly.setOpaque(false);
        this.checkScanCommentsOnly.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ToDoCustomizer.this.scanCommentsOnlyChanged(itemEvent);
            }
        });
        this.jLabel1.setLabelFor(this.table);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.TableHeader"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.btnRemove.text"));
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ToDoCustomizer.this.btnRemoveActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 257, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.btnAdd, -1, -1, Short.MAX_VALUE).add((Component)this.btnChange, -1, -1, Short.MAX_VALUE).add((Component)this.btnRemove, -1, 81, Short.MAX_VALUE))).add((Component)this.jLabel1).add((Component)this.checkScanCommentsOnly));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.btnAdd).addPreferredGap(0).add((Component)this.btnChange).addPreferredGap(0).add((Component)this.btnRemove)).add((Component)this.jScrollPane1, -1, 171, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.checkScanCommentsOnly)));
    }

    private void btnRemoveActionPerformed(ActionEvent actionEvent) {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (null != tableCellEditor) {
            tableCellEditor.cancelCellEditing();
        }
        boolean bl = this.isDataValid();
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        defaultTableModel.removeRow(n);
        if (n > defaultTableModel.getRowCount() - 1) {
            --n;
        }
        if (n >= 0) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        }
        boolean bl2 = this.changed;
        this.changed = true;
        this.firePropertyChange("changed", new Boolean(bl2), Boolean.TRUE);
        this.firePropertyChange("valid", new Boolean(bl), new Boolean(this.isDataValid()));
    }

    private void btnChangeActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        final boolean bl = this.changed;
        this.table.editCellAt(n, 0);
        final TableCellEditor tableCellEditor = this.table.getCellEditor();
        tableCellEditor.addCellEditorListener(new CellEditorListener(){

            public void editingStopped(ChangeEvent changeEvent) {
                tableCellEditor.removeCellEditorListener(this);
                ToDoCustomizer.this.changed = true;
                ToDoCustomizer.this.firePropertyChange("changed", new Boolean(bl), Boolean.TRUE);
                ToDoCustomizer.this.firePropertyChange("valid", null, null);
            }

            public void editingCanceled(ChangeEvent changeEvent) {
                tableCellEditor.removeCellEditorListener(this);
            }
        });
    }

    private void btnAddActionPerformed(ActionEvent actionEvent) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        defaultTableModel.addRow(new Object[]{NbBundle.getMessage(ToDoCustomizer.class, (String)"ToDoCustomizer.DefaultPattern")});
        this.table.getSelectionModel().setSelectionInterval(defaultTableModel.getRowCount() - 1, defaultTableModel.getRowCount() - 1);
        final boolean bl = this.changed;
        this.table.editCellAt(defaultTableModel.getRowCount() - 1, 0);
        final TableCellEditor tableCellEditor = this.table.getCellEditor();
        tableCellEditor.addCellEditorListener(new CellEditorListener(){

            public void editingStopped(ChangeEvent changeEvent) {
                tableCellEditor.removeCellEditorListener(this);
                ToDoCustomizer.this.changed = true;
                ToDoCustomizer.this.firePropertyChange("changed", new Boolean(bl), Boolean.TRUE);
                ToDoCustomizer.this.firePropertyChange("valid", null, null);
            }

            public void editingCanceled(ChangeEvent changeEvent) {
                tableCellEditor.removeCellEditorListener(this);
            }
        });
    }

    private void scanCommentsOnlyChanged(ItemEvent itemEvent) {
        if (this.isUpdating) {
            return;
        }
        boolean bl = this.changed;
        this.changed = true;
        this.firePropertyChange("changed", new Boolean(bl), Boolean.TRUE);
    }

    private static class MyTable
    extends JTable {
        private MyTable() {
        }

        public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
            Component component = super.prepareEditor(tableCellEditor, n, n2);
            if (component instanceof JTextComponent) {
                final JTextComponent jTextComponent = (JTextComponent)component;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jTextComponent.selectAll();
                        jTextComponent.requestFocusInWindow();
                    }
                });
            }
            return component;
        }
    }
}

