/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.reglib.Enumerations;
import org.netbeans.modules.reglib.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NbBundle {
    private static final boolean USE_DEBUG_LOADER = Boolean.getBoolean("org.openide.util.NbBundle.DEBUG");
    private static String brandingToken = null;
    static final Map<ClassLoader, Map<String, URL>> localizedFileCache = new WeakHashMap<ClassLoader, Map<String, URL>>();
    static final Map<ClassLoader, Map<String, Reference<ResourceBundle>>> bundleCache = new WeakHashMap<ClassLoader, Map<String, Reference<ResourceBundle>>>();

    @Deprecated
    public NbBundle() {
    }

    public static String getBranding() {
        return brandingToken;
    }

    public static void setBranding(String string) throws IllegalArgumentException {
        if (string != null && !string.matches("[a-z][a-z0-9]*(_[a-z][a-z0-9]*)*")) {
            throw new IllegalArgumentException("Malformed branding token: " + string);
        }
        brandingToken = string;
    }

    @Deprecated
    public static synchronized URL getLocalizedFile(String string, String string2) throws MissingResourceException {
        return NbBundle.getLocalizedFile(string, string2, Locale.getDefault(), NbBundle.getLoader());
    }

    @Deprecated
    public static synchronized URL getLocalizedFile(String string, String string2, Locale locale) throws MissingResourceException {
        return NbBundle.getLocalizedFile(string, string2, locale, NbBundle.getLoader());
    }

    @Deprecated
    public static synchronized URL getLocalizedFile(String string, String string2, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        URL uRL = null;
        Iterator<String> iterator = new LocaleIterator(locale);
        ArrayList<String> arrayList = new ArrayList<String>(10);
        String string3 = string.replace('.', '/');
        Map<String, URL> map = localizedFileCache.get(classLoader);
        if (map == null) {
            map = new HashMap<String, URL>();
            localizedFileCache.put(classLoader, map);
        }
        String string4 = string2 != null ? string3 + '.' + string2 : string3;
        uRL = map.get(string4);
        URL uRL2 = uRL == null ? classLoader.getResource(string4) : null;
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            string4 = string2 != null ? string3 + string5 + '.' + string2 : string3 + string5;
            uRL = map.get(string4);
            if (uRL != null) break;
            arrayList.add(string4);
            uRL = string5.length() == 0 ? uRL2 : classLoader.getResource(string4);
            if (uRL == null) continue;
            break;
        }
        if (uRL == null) {
            string4 = string.replace('.', '/');
            if (string2 != null) {
                string4 = string4 + '.' + string2;
            }
            throw new MissingResourceException("Cannot find localized resource " + string4 + " in " + classLoader, classLoader.toString(), string4);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            map.put(iterator.next(), uRL);
        }
        return uRL;
    }

    public static <T> T getLocalizedValue(Map<String, T> map, String string, Locale locale) {
        for (String string2 : NbCollections.iterable(new LocaleIterator(locale))) {
            String string3 = string + string2;
            T t = map.get(string3);
            if (t == null) continue;
            if (USE_DEBUG_LOADER && t instanceof String) {
                String string4 = (String)t + " (?:" + string3 + ")";
                return (T)string4;
            }
            return t;
        }
        return null;
    }

    public static <T> T getLocalizedValue(Map<String, T> map, String string) {
        return NbBundle.getLocalizedValue(map, string, Locale.getDefault());
    }

    public static String getLocalizedValue(Attributes attributes, Attributes.Name name, Locale locale) {
        return NbBundle.getLocalizedValue(NbBundle.attr2Map(attributes), name.toString().toLowerCase(Locale.US), locale);
    }

    public static String getLocalizedValue(Attributes attributes, Attributes.Name name) {
        return NbBundle.getLocalizedValue(NbBundle.attr2Map(attributes), name.toString().toLowerCase(Locale.US));
    }

    private static Map<String, String> attr2Map(Attributes attributes) {
        return new AttributesMap(attributes);
    }

    public static final ResourceBundle getBundle(String string) throws MissingResourceException {
        return NbBundle.getBundle(string, Locale.getDefault(), NbBundle.getLoader());
    }

    public static ResourceBundle getBundle(Class clazz) throws MissingResourceException {
        String string = NbBundle.findName(clazz);
        return NbBundle.getBundle(string, Locale.getDefault(), clazz.getClassLoader());
    }

    private static String findName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n + 1);
            return string + "Bundle";
        }
        return "Bundle";
    }

    public static final ResourceBundle getBundle(String string, Locale locale) throws MissingResourceException {
        return NbBundle.getBundle(string, locale, NbBundle.getLoader());
    }

    public static final ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        ResourceBundle resourceBundle;
        if (USE_DEBUG_LOADER) {
            classLoader = DebugLoader.get(classLoader);
        }
        if ((resourceBundle = NbBundle.getBundleFast(string, locale, classLoader)) != null) {
            return resourceBundle;
        }
        MissingResourceException missingResourceException = new MissingResourceException("No such bundle " + string, string, null);
        throw missingResourceException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getBundleFast(String string, Locale locale, ClassLoader classLoader) {
        Map<String, Reference<ResourceBundle>> map;
        Object object = bundleCache;
        synchronized (object) {
            map = bundleCache.get(classLoader);
            if (map == null) {
                map = new HashMap<String, Reference<ResourceBundle>>();
                bundleCache.put(classLoader, map);
            }
        }
        object = locale.toString();
        char[] cArray = new char[string.length() + (brandingToken != null ? brandingToken.length() : 1) + 2 + ((String)object).length()];
        string.getChars(0, string.length(), cArray, 0);
        cArray[string.length()] = 47;
        int n = string.length() + 1;
        if (brandingToken == null) {
            cArray[n] = 45;
            ++n;
        } else {
            brandingToken.getChars(0, brandingToken.length(), cArray, n);
            n += brandingToken.length();
        }
        cArray[n] = 47;
        ((String)object).getChars(0, ((String)object).length(), cArray, ++n);
        String string2 = new String(cArray);
        Map<String, Reference<ResourceBundle>> map2 = map;
        synchronized (map2) {
            ResourceBundle resourceBundle = NbBundle.loadBundle(string, locale, classLoader);
            return resourceBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle loadBundle(String string, Locale locale, ClassLoader classLoader) {
        String string2 = string.replace('.', '/');
        LocaleIterator localeIterator = new LocaleIterator(locale);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (localeIterator.hasNext()) {
            linkedList.addFirst((String)localeIterator.next());
        }
        Properties properties = new Properties();
        for (String string3 : linkedList) {
            URL uRL;
            String string4 = string2 + string3 + ".properties";
            URL uRL2 = uRL = classLoader != null ? classLoader.getResource(string4) : ClassLoader.getSystemResource(string4);
            if (uRL != null) {
                try {
                    InputStream inputStream = USE_DEBUG_LOADER ? (classLoader != null ? classLoader.getResourceAsStream(string4) : ClassLoader.getSystemResourceAsStream(string4)) : uRL.openStream();
                    try {
                        properties.load(inputStream);
                        continue;
                    }
                    finally {
                        inputStream.close();
                        continue;
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(NbBundle.class.getName()).log(Level.WARNING, null, iOException);
                    return null;
                }
            }
            if (string3.length() != 0) continue;
            return NbBundle.loadBundleClass(string, string2, locale, linkedList, classLoader);
        }
        return new PBundle(NbCollections.checkedMapByFilter(properties, String.class, String.class, true), locale);
    }

    private static ResourceBundle loadBundleClass(String string, String string2, Locale locale, List<String> list, ClassLoader classLoader) {
        if (classLoader != null && classLoader.getResource(string2 + ".class") == null) {
            return null;
        }
        ResourceBundle resourceBundle = null;
        for (String string3 : list) {
            try {
                Class<ResourceBundle> clazz = Class.forName(string + string3, true, classLoader).asSubclass(ResourceBundle.class);
                ResourceBundle resourceBundle2 = clazz.newInstance();
                if (resourceBundle == null) {
                    resourceBundle = resourceBundle2;
                    continue;
                }
                resourceBundle = new MergedBundle(locale, resourceBundle2, resourceBundle);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                Logger.getLogger(NbBundle.class.getName()).log(Level.WARNING, null, exception);
            }
            catch (LinkageError linkageError) {
                Logger.getLogger(NbBundle.class.getName()).log(Level.WARNING, null, linkageError);
            }
        }
        return resourceBundle;
    }

    public static String getMessage(Class clazz, String string) throws MissingResourceException {
        return NbBundle.getBundle(clazz).getString(string);
    }

    public static String getMessage(Class clazz, String string, Object object) throws MissingResourceException {
        return NbBundle.getMessage(clazz, string, new Object[]{object});
    }

    public static String getMessage(Class clazz, String string, Object object, Object object2) throws MissingResourceException {
        return NbBundle.getMessage(clazz, string, new Object[]{object, object2});
    }

    public static String getMessage(Class clazz, String string, Object object, Object object2, Object object3) throws MissingResourceException {
        return NbBundle.getMessage(clazz, string, new Object[]{object, object2, object3});
    }

    public static String getMessage(Class clazz, String string, Object[] objectArray) throws MissingResourceException {
        return MessageFormat.format(NbBundle.getMessage(clazz, string), objectArray);
    }

    private static ClassLoader getLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static Iterator<String> getLocalizingSuffixes() {
        return new LocaleIterator(Locale.getDefault());
    }

    @Deprecated
    public static void setClassLoaderFinder(ClassLoaderFinder classLoaderFinder) {
        throw new Error();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributesMap
    extends HashMap<String, String> {
        private Attributes attrs;

        public AttributesMap(Attributes attributes) {
            super(7);
            this.attrs = attributes;
        }

        @Override
        public String get(Object object) {
            Attributes.Name name;
            if (!(object instanceof String)) {
                return null;
            }
            String string = (String)object;
            try {
                name = new Attributes.Name(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            return this.attrs.getValue(name);
        }
    }

    @Deprecated
    public static interface ClassLoaderFinder {
        @Deprecated
        public ClassLoader find();
    }

    static final class DebugLoader
    extends ClassLoader {
        private static int count = 0;
        private static final Map<String, Integer> knownIDs = new HashMap<String, Integer>();
        private static final Map<ClassLoader, Reference<ClassLoader>> existing = new WeakHashMap<ClassLoader, Reference<ClassLoader>>();

        private DebugLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int getID(String string) {
            Map<String, Integer> map = knownIDs;
            synchronized (map) {
                Integer n = knownIDs.get(string);
                if (n == null) {
                    n = ++count;
                    knownIDs.put(string, n);
                    System.err.println("NbBundle trace: #" + n + " = " + string);
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ClassLoader get(ClassLoader classLoader) {
            Map<ClassLoader, Reference<ClassLoader>> map = existing;
            synchronized (map) {
                ClassLoader classLoader2;
                Reference<ClassLoader> reference = existing.get(classLoader);
                if (reference != null && (classLoader2 = reference.get()) != null) {
                    return classLoader2;
                }
                classLoader2 = new DebugLoader(classLoader);
                existing.put(classLoader, new WeakReference<ClassLoader>(classLoader2));
                return classLoader2;
            }
        }

        public InputStream getResourceAsStream(String string) {
            InputStream inputStream = super.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            if (string.endsWith(".properties")) {
                int n = DebugLoader.getID(string);
                boolean bl = string.indexOf("Bundle") != -1;
                return new DebugInputStream(inputStream, n, bl);
            }
            return inputStream;
        }

        static final class DebugInputStream
        extends InputStream {
            private static final int WAITING_FOR_KEY = 0;
            private static final int IN_COMMENT = 1;
            private static final int IN_KEY = 2;
            private static final int IN_KEY_BACKSLASH = 3;
            private static final int AFTER_KEY = 4;
            private static final int WAITING_FOR_VALUE = 5;
            private static final int IN_VALUE = 6;
            private static final int IN_VALUE_BACKSLASH = 7;
            private final InputStream base;
            private final int id;
            private final boolean localizable;
            private int line = 0;
            private int keyLine = 0;
            private int state = 0;
            private boolean twixtCrAndNl = false;
            private String toInsert = null;
            private boolean reverseLocalizable = false;
            private StringBuffer lastComment = null;

            public DebugInputStream(InputStream inputStream, int n, boolean bl) {
                this.base = inputStream;
                this.id = n;
                this.localizable = bl;
            }

            public int read() throws IOException {
                if (this.toInsert != null) {
                    char c = this.toInsert.charAt(0);
                    this.toInsert = this.toInsert.length() > 1 ? this.toInsert.substring(1) : null;
                    return c;
                }
                int n = this.base.read();
                if (n == 10) {
                    this.twixtCrAndNl = false;
                    ++this.line;
                } else if (n == 13) {
                    if (this.twixtCrAndNl) {
                        ++this.line;
                    } else {
                        this.twixtCrAndNl = true;
                    }
                } else {
                    this.twixtCrAndNl = false;
                }
                switch (this.state) {
                    case 0: {
                        switch (n) {
                            case 33: 
                            case 35: {
                                this.state = 1;
                                this.lastComment = new StringBuffer();
                                this.lastComment.append((char)n);
                                return n;
                            }
                            case -1: 
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                return n;
                            }
                            case 92: {
                                this.state = 3;
                                return n;
                            }
                        }
                        this.state = 2;
                        this.keyLine = this.line + 1;
                        return n;
                    }
                    case 1: {
                        switch (n) {
                            case 10: 
                            case 13: {
                                String string = this.lastComment.toString();
                                this.lastComment = null;
                                if (this.localizable && string.equals("#NOI18N")) {
                                    this.reverseLocalizable = true;
                                } else if (this.localizable && string.equals("#PARTNOI18N")) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): #PARTNOI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && string.equals("#I18N")) {
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && string.equals("#PARTI18N")) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): #PARTI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = false;
                                } else if (this.localizable && (string.equals("#I18N") || string.equals("#PARTI18N")) || !this.localizable && (string.equals("#NOI18N") || string.equals("#PARTNOI18N"))) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): incongruous comment " + string + " found for bundle");
                                    this.reverseLocalizable = false;
                                }
                                this.state = 0;
                                return n;
                            }
                        }
                        this.lastComment.append((char)n);
                        return n;
                    }
                    case 2: {
                        switch (n) {
                            case 92: {
                                this.state = 3;
                                return n;
                            }
                            case 9: 
                            case 32: {
                                this.state = 4;
                                return n;
                            }
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return n;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return n;
                            }
                        }
                        return n;
                    }
                    case 3: {
                        this.state = 2;
                        return n;
                    }
                    case 4: {
                        switch (n) {
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return n;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return n;
                            }
                        }
                        return n;
                    }
                    case 5: {
                        switch (n) {
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return n;
                            }
                            case 9: 
                            case 32: {
                                return n;
                            }
                            case 92: {
                                this.state = 7;
                                return n;
                            }
                        }
                        this.state = 6;
                        return n;
                    }
                    case 6: {
                        switch (n) {
                            case 92: {
                                this.state = 7;
                                return n;
                            }
                            case -1: 
                            case 10: 
                            case 13: {
                                boolean bl = this.reverseLocalizable;
                                this.reverseLocalizable = false;
                                this.state = 0;
                                if (this.localizable ^ bl) {
                                    assert (this.keyLine > 0);
                                    this.toInsert = "(" + this.id + ":" + this.keyLine + ")";
                                    if (n != -1) {
                                        this.toInsert = this.toInsert + new Character((char)n);
                                    }
                                    this.keyLine = 0;
                                    return 32;
                                }
                                return n;
                            }
                        }
                        return n;
                    }
                    case 7: {
                        this.state = 6;
                        return n;
                    }
                }
                throw new IOException("should never happen");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleIterator
    implements Iterator<String> {
        private boolean defaultInProgress = false;
        private boolean empty = false;
        private Locale locale;
        private Locale initLocale;
        private String current;
        private String branding;

        public LocaleIterator(Locale locale) {
            this.locale = this.initLocale = locale;
            if (locale.equals(Locale.getDefault())) {
                this.defaultInProgress = true;
            }
            this.current = '_' + locale.toString();
            this.branding = brandingToken == null ? null : "_" + brandingToken;
        }

        @Override
        public String next() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            String string = this.branding == null ? this.current : this.branding + this.current;
            int n = this.current.lastIndexOf(95);
            if (n == 0) {
                if (this.empty) {
                    this.reset();
                } else {
                    this.current = "";
                    this.empty = true;
                }
            } else if (n == -1) {
                if (this.defaultInProgress) {
                    this.reset();
                } else {
                    this.locale = Locale.getDefault();
                    this.current = '_' + this.locale.toString();
                    this.defaultInProgress = true;
                }
            } else {
                this.current = this.current.substring(0, n);
            }
            return string;
        }

        private void reset() {
            if (this.branding != null) {
                this.current = '_' + this.initLocale.toString();
                int n = this.branding.lastIndexOf(95);
                this.branding = n == 0 ? null : this.branding.substring(0, n);
                this.empty = false;
            } else {
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MergedBundle
    extends ResourceBundle {
        private Locale loc;
        private ResourceBundle sub1;
        private ResourceBundle sub2;

        public MergedBundle(Locale locale, ResourceBundle resourceBundle, ResourceBundle resourceBundle2) {
            this.loc = locale;
            this.sub1 = resourceBundle;
            this.sub2 = resourceBundle2;
        }

        @Override
        public Locale getLocale() {
            return this.loc;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Enumerations.removeDuplicates(Enumerations.concat(this.sub1.getKeys(), this.sub2.getKeys()));
        }

        @Override
        protected Object handleGetObject(String string) throws MissingResourceException {
            try {
                return this.sub1.getObject(string);
            }
            catch (MissingResourceException missingResourceException) {
                return this.sub2.getObject(string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PBundle
    extends ResourceBundle {
        private final Map<String, String> m;
        private final Locale locale;

        public PBundle(Map<String, String> map, Locale locale) {
            this.m = map;
            this.locale = locale;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.m.keySet());
        }

        @Override
        protected Object handleGetObject(String string) {
            return this.m.get(string);
        }

        @Override
        public Locale getLocale() {
            return this.locale;
        }
    }
}

