/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.reglib.Enumerations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NbCollections {
    private static final Logger LOG = Logger.getLogger(NbCollections.class.getName());

    private NbCollections() {
    }

    public static <E> Set<E> checkedSetByCopy(Set set, Class<E> clazz, boolean bl) throws ClassCastException {
        HashSet<E> hashSet = new HashSet<E>(set.size() * 4 / 3 + 1);
        for (Object e : set) {
            try {
                hashSet.add(clazz.cast(e));
            }
            catch (ClassCastException classCastException) {
                if (bl) {
                    throw classCastException;
                }
                LOG.log(Level.WARNING, "Element {0} not assignable to {1}", new Object[]{e, clazz});
            }
        }
        return hashSet;
    }

    public static <E> List<E> checkedListByCopy(List list, Class<E> clazz, boolean bl) throws ClassCastException {
        AbstractList abstractList = list instanceof RandomAccess ? new ArrayList(list.size()) : new LinkedList();
        for (Object e : list) {
            try {
                abstractList.add(clazz.cast(e));
            }
            catch (ClassCastException classCastException) {
                if (bl) {
                    throw classCastException;
                }
                LOG.log(Level.WARNING, "Element {0} not assignable to {1}", new Object[]{e, clazz});
            }
        }
        return abstractList;
    }

    public static <K, V> Map<K, V> checkedMapByCopy(Map map, Class<K> clazz, Class<V> clazz2, boolean bl) throws ClassCastException {
        HashMap<K, V> hashMap = new HashMap<K, V>(map.size() * 4 / 3 + 1);
        for (Map.Entry entry : map.entrySet()) {
            try {
                hashMap.put(clazz.cast(entry.getKey()), clazz2.cast(entry.getValue()));
            }
            catch (ClassCastException classCastException) {
                if (bl) {
                    throw classCastException;
                }
                LOG.log(Level.WARNING, "Entry {0} not assignable to <{1},{2}>", new Object[]{entry, clazz, clazz2});
            }
        }
        return hashMap;
    }

    public static <E> Iterator<E> checkedIteratorByFilter(Iterator iterator, final Class<E> clazz, final boolean bl) {
        return new CheckedIterator<E>(iterator){

            @Override
            protected boolean accept(Object object) {
                if (object == null) {
                    return true;
                }
                if (clazz.isInstance(object)) {
                    return true;
                }
                if (bl) {
                    throw new ClassCastException(object + " was not a " + clazz.getName());
                }
                return false;
            }
        };
    }

    public static <E> Set<E> checkedSetByFilter(Set set, Class<E> clazz, boolean bl) {
        return new CheckedSet<E>(set, clazz, bl);
    }

    public static <K, V> Map<K, V> checkedMapByFilter(Map map, Class<K> clazz, Class<V> clazz2, boolean bl) {
        return new CheckedMap<K, V>(map, clazz, clazz2, bl);
    }

    public static <E> Enumeration<E> checkedEnumerationByFilter(Enumeration enumeration, final Class<E> clazz, final boolean bl) {
        Enumeration enumeration2 = enumeration;
        return Enumerations.filter(enumeration2, new Enumerations.Processor<Object, E>(){

            @Override
            public E process(Object object, Collection<Object> collection) {
                if (object == null) {
                    return null;
                }
                try {
                    return clazz.cast(object);
                }
                catch (ClassCastException classCastException) {
                    if (bl) {
                        throw classCastException;
                    }
                    return null;
                }
            }
        });
    }

    public static <E> Iterable<E> iterable(final Iterator<E> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return iterator;
            }
        };
    }

    public static <E> Iterable<E> iterable(final Enumeration<E> enumeration) {
        if (enumeration == null) {
            throw new NullPointerException();
        }
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return enumeration.hasMoreElements();
                    }

                    @Override
                    public E next() {
                        return enumeration.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CheckedIterator<E>
    implements Iterator<E> {
        private static final Object WAITING = new Object();
        private final Iterator it;
        private Object next = WAITING;

        public CheckedIterator(Iterator iterator) {
            this.it = iterator;
        }

        protected abstract boolean accept(Object var1);

        @Override
        public boolean hasNext() {
            if (this.next != WAITING) {
                return true;
            }
            while (this.it.hasNext()) {
                this.next = this.it.next();
                if (!this.accept(this.next)) continue;
                return true;
            }
            this.next = WAITING;
            return false;
        }

        @Override
        public E next() {
            if (this.next == WAITING && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.next != WAITING);
            Object object = this.next;
            this.next = WAITING;
            return (E)object;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CheckedMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map rawMap;
        private final Class<K> keyType;
        private final Class<V> valueType;
        private final boolean strict;

        public CheckedMap(Map map, Class<K> clazz, Class<V> clazz2, boolean bl) {
            this.rawMap = map;
            this.keyType = clazz;
            this.valueType = clazz2;
            this.strict = bl;
        }

        private boolean acceptKey(Object object) {
            if (object == null) {
                return true;
            }
            if (this.keyType.isInstance(object)) {
                return true;
            }
            if (this.strict) {
                throw new ClassCastException(object + " was not a " + this.keyType.getName());
            }
            return false;
        }

        private boolean acceptValue(Object object) {
            if (object == null) {
                return true;
            }
            if (this.valueType.isInstance(object)) {
                return true;
            }
            if (this.strict) {
                throw new ClassCastException(object + " was not a " + this.valueType.getName());
            }
            return false;
        }

        private boolean acceptEntry(Map.Entry entry) {
            return this.acceptKey(entry.getKey()) && this.acceptValue(entry.getValue());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet();
        }

        @Override
        public V get(Object object) {
            Object v = this.rawMap.get(this.keyType.cast(object));
            if (this.acceptValue(v)) {
                Object v2 = v;
                return v2;
            }
            return null;
        }

        @Override
        public V put(K k, V v) {
            V v2 = this.rawMap.put(this.keyType.cast(k), this.valueType.cast(v));
            if (this.acceptValue(v2)) {
                return v2;
            }
            return null;
        }

        @Override
        public V remove(Object object) {
            Object v = this.rawMap.remove(this.keyType.cast(object));
            if (this.acceptValue(v)) {
                Object v2 = v;
                return v2;
            }
            return null;
        }

        @Override
        public boolean containsKey(Object object) {
            return this.rawMap.containsKey(this.keyType.cast(object)) && this.acceptValue(this.rawMap.get(object));
        }

        @Override
        public boolean containsValue(Object object) {
            return super.containsValue(this.valueType.cast(object));
        }

        @Override
        public int size() {
            int n = 0;
            Iterator iterator = this.rawMap.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!this.acceptEntry(iterator.next())) continue;
                ++n;
            }
            return n;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new CheckedIterator<Map.Entry<K, V>>(CheckedMap.this.rawMap.entrySet().iterator()){

                    @Override
                    protected boolean accept(Object object) {
                        return CheckedMap.this.acceptEntry((Map.Entry)object);
                    }
                };
            }

            @Override
            public int size() {
                int n = 0;
                Iterator iterator = CheckedMap.this.rawMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (!CheckedMap.this.acceptEntry(iterator.next())) continue;
                    ++n;
                }
                return n;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CheckedSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Set rawSet;
        private final Class<E> type;
        private final boolean strict;

        public CheckedSet(Set set, Class<E> clazz, boolean bl) {
            this.rawSet = set;
            this.type = clazz;
            this.strict = bl;
        }

        private boolean acceptEntry(Object object) {
            if (object == null) {
                return true;
            }
            if (this.type.isInstance(object)) {
                return true;
            }
            if (this.strict) {
                throw new ClassCastException(object + " was not a " + this.type.getName());
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new CheckedIterator<E>(this.rawSet.iterator()){

                @Override
                protected boolean accept(Object object) {
                    return CheckedSet.this.acceptEntry(object);
                }
            };
        }

        @Override
        public int size() {
            int n = 0;
            Iterator iterator = this.rawSet.iterator();
            while (iterator.hasNext()) {
                if (!this.acceptEntry(iterator.next())) continue;
                ++n;
            }
            return n;
        }

        @Override
        public boolean add(E e) {
            return this.rawSet.add(this.type.cast(e));
        }

        @Override
        public boolean contains(Object object) {
            return this.rawSet.contains(this.type.cast(object));
        }
    }
}

