/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlCaretAwareSourceTask
extends ParserResultTask<HtmlParserResult> {
    private static final String SOURCE_DOCUMENT_PROPERTY_NAME = Source.class.getName();

    public static synchronized Source forDocument(Document document) {
        Source source = (Source)document.getProperty(SOURCE_DOCUMENT_PROPERTY_NAME);
        if (source == null) {
            source = new Source();
            document.putProperty(SOURCE_DOCUMENT_PROPERTY_NAME, source);
        }
        return source;
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public void run(HtmlParserResult htmlParserResult, SchedulerEvent schedulerEvent) {
        if (schedulerEvent == null) {
            Logger.global.warning("HtmlCaretAwareSourceTask.run() called with null SchedulerEvent argument.");
            return;
        }
        Document document = htmlParserResult.getSnapshot().getSource().getDocument(false);
        if (document != null) {
            HtmlCaretAwareSourceTask.forDocument(document).parsed((Parser.Result)htmlParserResult, schedulerEvent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            String string = snapshot.getMimeType();
            if (string.equals("text/html")) {
                return Collections.singletonList(new HtmlCaretAwareSourceTask());
            }
            return Collections.emptyList();
        }
    }

    public static class Source {
        private Vector<SourceListener> listeners = new Vector();

        protected void parsed(Parser.Result result, SchedulerEvent schedulerEvent) {
            for (SourceListener sourceListener : this.listeners) {
                sourceListener.parsed(result, schedulerEvent);
            }
        }

        public void addChangeListener(SourceListener sourceListener) {
            this.listeners.add(sourceListener);
        }

        public void removeChangeListener(SourceListener sourceListener) {
            this.listeners.remove(sourceListener);
        }
    }

    public static interface SourceListener {
        public void parsed(Parser.Result var1, SchedulerEvent var2);
    }
}

