/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.javadoc;

import java.util.Hashtable;
import org.netbeans.modules.html.editor.javadoc.TagHelpItem;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SAXHelpHandler
extends DefaultHandler {
    private TagHelpItem tag;
    private TagHelpItem attribute;
    private static final int HELP_CODE = "help".hashCode();
    private static final int TAG_CODE = "tag".hashCode();
    private static final int ATTRIBUTE_CODE = "attribute".hashCode();
    private static final int LOCATION_CODE = "location".hashCode();
    private static final int START_TEXT_CODE = "start-text".hashCode();
    private static final int END_TEXT_CODE = "end-text".hashCode();
    private static final int ADD_TEXT_CODE = "add-text".hashCode();
    private static final int BEFORE_CODE = "before".hashCode();
    private static final int AFTER_CODE = "after".hashCode();
    private static final String NAME_STRING = "name";
    private static final String LOCATION_STRING = "location";
    private static final String FILE_STRING = "file";
    private static final String IDENTICAL_STRING = "identical";
    private static final String TEXT_STRING = "text";
    private static final String OFFSET_STRING = "offset";
    private static final String BEFORE_STRING = "before";
    private static final String AFTER_STRING = "after";
    private static final int TAG_STATE = 1;
    private static final int ATTRIBUTE_STATE = 2;
    private static final int BEFORE_STATE = 10;
    private static final int AFTER_STATE = 11;
    private int state;
    private int textState;
    private Hashtable<String, TagHelpItem> map = new Hashtable();
    private String file;

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n = string3.hashCode();
        if (n == TAG_CODE) {
            String string4 = attributes.getValue(NAME_STRING);
            this.tag = new TagHelpItem(string4);
            this.map.put(this.tag.getName().toUpperCase(), this.tag);
            this.state = 1;
            string4 = attributes.getValue(IDENTICAL_STRING);
            if (string4 != null) {
                this.tag.setIdentical(string4);
            }
        } else if (n == ATTRIBUTE_CODE) {
            String string5 = attributes.getValue(NAME_STRING);
            this.attribute = new TagHelpItem(string5);
            this.state = 2;
            this.map.put((this.tag.getName() + "#" + this.attribute.getName()).toUpperCase(), this.attribute);
            string5 = attributes.getValue(IDENTICAL_STRING);
            if (string5 != null) {
                this.attribute.setIdentical(string5);
            }
        } else if (n == LOCATION_CODE) {
            String string6 = attributes.getValue(FILE_STRING);
            switch (this.state) {
                case 1: {
                    this.tag.setFile(string6);
                    break;
                }
                case 2: {
                    this.attribute.setFile(string6);
                }
            }
        } else if (n == START_TEXT_CODE) {
            String string7 = attributes.getValue(OFFSET_STRING);
            int n2 = 0;
            if (string7 != null) {
                try {
                    n2 = new Integer(string7);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string7 = attributes.getValue(TEXT_STRING);
            switch (this.state) {
                case 1: {
                    this.tag.setStartText(string7);
                    this.tag.setStartTextOffset(n2);
                    break;
                }
                case 2: {
                    this.attribute.setStartText(string7);
                    this.attribute.setStartTextOffset(n2);
                }
            }
        } else if (n == END_TEXT_CODE) {
            String string8 = attributes.getValue(OFFSET_STRING);
            int n3 = 0;
            if (string8 != null) {
                try {
                    n3 = new Integer(string8);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string8 = attributes.getValue(TEXT_STRING);
            switch (this.state) {
                case 1: {
                    this.tag.setEndText(string8);
                    this.tag.setEndTextOffset(n3);
                    break;
                }
                case 2: {
                    this.attribute.setEndText(string8);
                    this.attribute.setEndTextOffset(n3);
                }
            }
        } else if (n == ADD_TEXT_CODE) {
            String string9 = attributes.getValue(BEFORE_STRING);
            String string10 = attributes.getValue(AFTER_STRING);
            switch (this.state) {
                case 1: {
                    this.tag.setTextBefore(string9);
                    this.tag.setTextAfter(string10);
                    break;
                }
                case 2: {
                    this.attribute.setTextBefore(string9);
                    this.attribute.setTextAfter(string10);
                }
            }
        } else if (n != START_TEXT_CODE) {
            if (n == BEFORE_CODE) {
                this.textState = 10;
            } else if (n == AFTER_CODE) {
                this.textState = 11;
            } else if (n == HELP_CODE) {
                this.file = attributes.getValue(FILE_STRING);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2).trim();
        if (string != null && string.length() > 0) {
            TagHelpItem tagHelpItem = null;
            switch (this.state) {
                case 1: {
                    tagHelpItem = this.tag;
                    break;
                }
                case 2: {
                    tagHelpItem = this.attribute;
                }
            }
            if (tagHelpItem != null) {
                switch (this.textState) {
                    case 10: {
                        if (tagHelpItem.getTextBefore() != null) {
                            tagHelpItem.setTextBefore(tagHelpItem.getTextBefore() + string);
                            break;
                        }
                        tagHelpItem.setTextBefore(string);
                        break;
                    }
                    case 11: {
                        if (tagHelpItem.getTextAfter() != null) {
                            tagHelpItem.setTextAfter(tagHelpItem.getTextAfter() + string);
                            break;
                        }
                        tagHelpItem.setTextAfter(string);
                    }
                }
            }
        }
    }

    public String getHelpFile() {
        return this.file;
    }

    public Hashtable getMap() {
        return this.map;
    }
}

