/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.text.BadLocationException;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.FunctionAstElement;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstUtilities {
    public static final String DOT_PROTOTYPE = ".prototype";

    private AstUtilities() {
    }

    public static int getAstOffset(Parser.Result result, int n) {
        JsParseResult jsParseResult = AstUtilities.getParseResult(result);
        if (jsParseResult != null) {
            return jsParseResult.getSnapshot().getEmbeddedOffset(n);
        }
        return n;
    }

    public static OffsetRange getAstOffsets(Parser.Result result, OffsetRange offsetRange) {
        JsParseResult jsParseResult = AstUtilities.getParseResult(result);
        if (jsParseResult != null) {
            int n = offsetRange.getStart();
            int n2 = jsParseResult.getSnapshot().getEmbeddedOffset(n);
            if (n2 == n) {
                return offsetRange;
            }
            if (n2 == -1) {
                return OffsetRange.NONE;
            }
            return new OffsetRange(n2, n2 + offsetRange.getLength());
        }
        return offsetRange;
    }

    public static boolean isGlobalVar(Parser.Result result, Node node) {
        if (!AstUtilities.isNameNode(node)) {
            return false;
        }
        JsParseResult jsParseResult = AstUtilities.getParseResult(result);
        if (jsParseResult == null) {
            return false;
        }
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        List<Node> list = variableVisitor.getVarOccurrences(node);
        if (list == null) {
            return true;
        }
        return list.contains(node);
    }

    public static TokenSequence<? extends JsCommentTokenId> getCommentFor(JsParseResult jsParseResult, Node node) {
        int n = node.getSourceStart();
        CharSequence charSequence = jsParseResult.getSnapshot().getText();
        try {
            int n2 = GsfUtilities.getRowStart((CharSequence)charSequence, (int)Math.min(n, charSequence.length()));
            if (n2 > 0) {
                n = GsfUtilities.getRowEnd((CharSequence)charSequence, (int)Math.min(n2 - 1, charSequence.length()));
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return LexUtilities.getCommentFor(jsParseResult.getSnapshot(), n);
    }

    public static Node getFirstChild(Node node) {
        return node.getFirstChild();
    }

    public static Node getSecondChild(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        return node2.getNext();
    }

    public static JsParseResult getParseResult(Parser.Result result) {
        assert (result instanceof JsParseResult) : "Expecting JsParseResult, but have " + result;
        return (JsParseResult)result;
    }

    private static boolean isJavascript(String string) {
        return string.equals("text/javascript") || string.equals("text/x-json");
    }

    private static Parser.Result findJsParserResult(ResultIterator resultIterator) throws ParseException {
        if (AstUtilities.isJavascript(resultIterator.getSnapshot().getMimeType())) {
            return resultIterator.getParserResult();
        }
        for (Embedding embedding : resultIterator.getEmbeddings()) {
            Parser.Result result = AstUtilities.findJsParserResult(resultIterator.getResultIterator(embedding));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Node getForeignNode(IndexedElement indexedElement, JsParseResult[] jsParseResultArray) {
        boolean bl;
        Node node;
        FileObject fileObject = indexedElement.getFileObject();
        if (fileObject == null) {
            return null;
        }
        Source source = Source.create((FileObject)fileObject);
        final Parser.Result[] resultArray = new Parser.Result[1];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    resultArray[0] = AstUtilities.findJsParserResult(resultIterator);
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
            return null;
        }
        if (resultArray[0] == null) {
            return null;
        }
        JsParseResult jsParseResult = AstUtilities.getParseResult(resultArray[0]);
        if (jsParseResultArray != null) {
            jsParseResultArray[0] = jsParseResult;
        }
        if ((node = jsParseResult.getRootNode()) == null) {
            return null;
        }
        String string = indexedElement.getSignature();
        if (string == null) {
            return null;
        }
        boolean bl2 = bl = indexedElement.getKind() == ElementKind.CONSTRUCTOR || indexedElement.getKind() == ElementKind.METHOD;
        if (bl) {
            for (AstElement astElement : jsParseResult.getStructure().getElements()) {
                FunctionAstElement functionAstElement;
                if (!(astElement instanceof FunctionAstElement) || !string.equals((functionAstElement = (FunctionAstElement)astElement).getSignature())) continue;
                return functionAstElement.getNode();
            }
        }
        for (AstElement astElement : jsParseResult.getStructure().getElements()) {
            if (!string.equals(astElement.getSignature())) continue;
            return astElement.getNode();
        }
        return null;
    }

    public static OffsetRange getRange(Node node) {
        return new OffsetRange(node.getSourceStart(), node.getSourceEnd());
    }

    public static OffsetRange getNameRange(Node node) {
        int n = node.getType();
        switch (n) {
            case 108: {
                if (node.hasChildren()) {
                    for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                        if (node2.getType() != 164) continue;
                        return AstUtilities.getNameRange(node2);
                    }
                }
                return AstUtilities.getRange(node);
            }
            case 39: 
            case 49: 
            case 163: 
            case 164: 
            case 165: {
                int n2 = node.getSourceStart();
                String string = node.getString();
                return new OffsetRange(n2, n2 + string.length());
            }
            case 38: {
                Node node3 = AstUtilities.findCallNameNode(node);
                if (node3 == null) break;
                return AstUtilities.getNameRange(node3);
            }
        }
        return AstUtilities.getRange(node);
    }

    public static int findArgumentIndex(Node node, int n, AstPath astPath) {
        assert (node.getType() == 38 || node.getType() == 30);
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return 0;
        }
        if ((node2 = node2.getNext()) == null || n < node2.getSourceStart()) {
            return -1;
        }
        int n2 = 0;
        while (node2 != null) {
            if (node2.getSourceEnd() >= n) {
                return n2;
            }
            if ((node2 = node2.getNext()) == null) continue;
            ++n2;
        }
        return n2;
    }

    private static Node findCallNameNode(Node node) {
        if (node.hasChildren()) {
            Node node2 = node.getFirstChild();
            if (node2 != null) {
                if (node2.getType() == 39) {
                    return node2;
                }
                if (node2.getType() == 33) {
                    Node node3 = node2.getFirstChild();
                    assert (node3.getNext().getNext() == null) : node3.getNext().getNext();
                    return node3.getNext();
                }
            } else assert (false) : "Unexpected call firstchild - " + node2;
        }
        return null;
    }

    @NonNull
    public static String getCallName(Node node, boolean bl) {
        Node node2;
        assert (node.getType() == 38 || node.getType() == 30);
        if (!bl) {
            Node node3 = AstUtilities.findCallNameNode(node);
            if (node3 != null) {
                return node3.getString();
            }
        } else if (node.hasChildren() && (node2 = node.getFirstChild()) != null) {
            if (node2.getType() == 36 && (node2 = node2.getNext()) == null) {
                return "";
            }
            if (node2.getType() == 39) {
                return node2.getString();
            }
            if (node2.getType() == 33) {
                Node node4 = node2.getFirstChild();
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder();
                    AstUtilities.addName(stringBuilder, node2);
                    return stringBuilder.toString();
                }
                return node4.getNext().getString();
            }
        }
        return "";
    }

    public static FunctionNode findMethodAtOffset(Node node, int n) {
        AstPath astPath = new AstPath(node, n);
        ListIterator<Node> listIterator = astPath.leafToRoot();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (node2.getType() != 108) continue;
            return (FunctionNode)node2;
        }
        return null;
    }

    public static Node findLocalScope(Node node, AstPath astPath) {
        ListIterator<Node> listIterator = astPath.leafToRoot();
        while (listIterator.hasNext()) {
            Node node2 = (Node)listIterator.next();
            if (node2.getType() != 108) continue;
            return node2;
        }
        return astPath.root();
    }

    public static boolean isNameNode(Node node) {
        int n = node.getType();
        return n == 39 || n == 49 || n == 163 || n == 164 || n == 165;
    }

    public static void addNodesByType(Node node, int[] nArray, List<Node> list) {
        for (int i = 0; i < nArray.length; ++i) {
            if (node.getType() != nArray[i]) continue;
            list.add(node);
            break;
        }
        if (node.hasChildren()) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                AstUtilities.addNodesByType(node2, nArray, list);
            }
        }
    }

    public static boolean isLabelledFunction(Node node) {
        assert (node.getType() == 165);
        Node.LabelledNode labelledNode = (Node.LabelledNode)node;
        Node node2 = labelledNode.getLabelledNode();
        return node2.getType() == 108;
    }

    public static FunctionNode getLabelledFunction(Node node) {
        assert (node.getType() == 165);
        Node.LabelledNode labelledNode = (Node.LabelledNode)node;
        Node node2 = labelledNode.getLabelledNode();
        if (node2.getType() == 108) {
            return (FunctionNode)node2;
        }
        return null;
    }

    public static Node getLabelledNode(Node node) {
        assert (node.getType() == 165);
        Node.LabelledNode labelledNode = (Node.LabelledNode)node;
        Node node2 = labelledNode.getLabelledNode();
        return node2;
    }

    public static String getFunctionFqn(Node node, boolean[] blArray) {
        if (blArray != null) {
            blArray[0] = true;
        }
        FunctionNode functionNode = (FunctionNode)node;
        Object object = node.getParentNode();
        int n = object != null ? object.getType() : 0;
        String string = functionNode.getFunctionName();
        if (string == null || string.length() == 0) {
            String string2;
            int n2;
            String string3 = null;
            boolean bl = false;
            if (n == 38 && functionNode.getNext() == null && object.getParentNode() != null && object.getFirstChild() == functionNode && ((n2 = (string2 = object.getParentNode()).getType()) == 35 || n2 == 8)) {
                object = string2;
                n = object.getType();
            }
            if (n == 39) {
                string2 = object.getString();
                if (Character.isUpperCase(string2.charAt(0))) {
                    string3 = string2;
                }
            } else if (n != 66 && (n == 35 || n == 8)) {
                StringBuilder stringBuilder;
                string2 = object.getFirstChild();
                if (string2.getType() == 43) {
                    bl = true;
                    Node node2 = object.getFirstChild().getNext();
                    if (node2.getType() == 41) {
                        String string4 = node2.getString();
                        for (Object object2 = object; object2 != null; object2 = object2.getParentNode()) {
                            String string5;
                            if (object2.getType() != 108 || (string5 = AstUtilities.getFunctionFqn(object2, null)) == null) continue;
                            int n3 = string5.lastIndexOf(46);
                            if (n3 != -1 && Character.isUpperCase(string5.charAt(n3 + 1))) {
                                return string5 + '.' + string4;
                            }
                            if (!Character.isUpperCase(string5.charAt(0))) continue;
                            return string5 + '.' + string4;
                        }
                    }
                } else if (string2.getType() == 33 && string2.hasChildren() && string2.getFirstChild().getType() == 43) {
                    bl = true;
                    Node node3 = object.getFirstChild().getNext();
                    if (node3.getType() == 41) {
                        String string6 = AstUtilities.getJoinedName(object);
                        for (Object object3 = object; object3 != null; object3 = object3.getParentNode()) {
                            String string7;
                            if (object3.getType() != 108 || (string7 = AstUtilities.getFunctionFqn(object3, null)) == null) continue;
                            int n4 = string7.lastIndexOf(46);
                            if (n4 != -1 && Character.isUpperCase(string7.charAt(n4 + 1))) {
                                return string7 + '.' + string6;
                            }
                            if (!Character.isUpperCase(string7.charAt(0))) continue;
                            return string7 + '.' + string6;
                        }
                    }
                }
                if (AstUtilities.addName(stringBuilder = new StringBuilder(), object)) {
                    string3 = stringBuilder.toString();
                }
            }
            if (string3 != null) {
                string2 = AstUtilities.getSurroundingWith(object);
                if (string2 != null) {
                    string3 = string2 + "." + string3;
                }
                int n5 = n2 = bl || string3.indexOf(46) == -1 ? 1 : 0;
                if (string3.indexOf(DOT_PROTOTYPE) != -1) {
                    string3 = string3.replace(DOT_PROTOTYPE, "");
                    n2 = 1;
                }
                if (blArray != null) {
                    blArray[0] = n2;
                }
            }
            return string3;
        }
        return string;
    }

    @NonNull
    public static String[] getObjectLitFqn(Node node) {
        String string;
        Object object;
        int n;
        assert (node.getType() == 66);
        Node node2 = node.getParentNode();
        String string2 = null;
        String string3 = null;
        int n2 = n = node2 != null ? node2.getType() : 0;
        if (n == 4) {
            for (object = node2.getParentNode(); object != null; object = object.getParentNode()) {
                if (object.getType() == 108) {
                    string = AstUtilities.getFunctionFqn((Node)object, null);
                    if (string == null) break;
                    if (!Character.isUpperCase(string.charAt(0))) {
                        return new String[]{null, null};
                    }
                    return new String[]{string, null};
                }
                if (object.getType() != 165) continue;
                return AstUtilities.getObjectLitFqn((Node)object);
            }
        }
        if (n == 39) {
            string2 = node2.getString();
        } else if (n == 35 || n == 8) {
            object = new StringBuilder();
            if (AstUtilities.addName((StringBuilder)object, node2)) {
                string2 = object.toString();
            }
        } else if (n == 38 && node2.getParentNode() != null && (node2.getParentNode().getType() == 35 || node2.getParentNode().getType() == 39)) {
            object = node2.getFirstChild();
            if (object != null && object.getType() == 33) {
                Node node3;
                string = object.getFirstChild();
                Node node4 = node3 = string != null ? string.getNext() : null;
                if (string != null && node3 != null) {
                    Node node5;
                    String string4;
                    if (string.getType() == 39 && "Object".equals(string.getString()) && node3.getType() == 41 && "extend".equals(node3.getString())) {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (AstUtilities.addName(stringBuilder, node2.getParentNode())) {
                            StringBuilder stringBuilder2;
                            string2 = stringBuilder.toString();
                            Node node6 = node2.getFirstChild().getNext();
                            if (node6 != null && node6.getType() == 30 && node6.getFirstChild() != null && AstUtilities.addName(stringBuilder2 = new StringBuilder(), node6.getFirstChild()) && (string3 = stringBuilder2.toString()).length() == 0) {
                                string3 = null;
                            }
                        }
                    } else if (string.getType() == 39 && "Class".equals(string.getString()) && node3.getType() == 41 && "create".equals(node3.getString())) {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (AstUtilities.addName(stringBuilder, node2.getParentNode())) {
                            StringBuilder stringBuilder3;
                            string2 = stringBuilder.toString();
                            Node node7 = object.getNext();
                            if ((node7.getType() == 39 || node7.getType() == 33) && AstUtilities.addName(stringBuilder3 = new StringBuilder(), node7) && (string3 = stringBuilder3.toString()).length() == 0) {
                                string3 = null;
                            }
                        }
                    } else if (string.getType() == 39 && "Ext".equals(string.getString()) && node3.getType() == 41 && "extend".equals(node3.getString())) {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (AstUtilities.addName(stringBuilder, node2.getParentNode())) {
                            StringBuilder stringBuilder4;
                            string2 = stringBuilder.toString();
                            Node node8 = object.getNext();
                            if ((node8.getType() == 39 || node8.getType() == 33) && AstUtilities.addName(stringBuilder4 = new StringBuilder(), node8) && (string3 = stringBuilder4.toString()).length() == 0) {
                                string3 = null;
                            }
                        }
                    } else if (n == 38 && node2.getParentNode() != null && node2.getFirstChild().getType() == 33 && node2.getFirstChild().getNext() != null && node2.getFirstChild().getNext().getType() == 33 && node2.getFirstChild().getNext().getNext() == node && (string4 = AstUtilities.getJoinedName(node5 = node2.getFirstChild())).endsWith(".extend") && string4.indexOf("dojo") != -1) {
                        string2 = AstUtilities.getJoinedName(node5.getNext());
                    }
                }
            }
        } else if (n == 38 && (object = node2.getFirstChild()) != null && object.getType() == 33) {
            Node node9;
            string = object.getFirstChild();
            Node node10 = node9 = string != null ? string.getNext() : null;
            if (string != null && node9 != null) {
                Node node11;
                String string5;
                if (string.getType() == 39 && "Ext".equals(string.getString()) && node9.getType() == 41 && "extend".equals(node9.getString())) {
                    StringBuilder stringBuilder;
                    Node node12;
                    Node node13 = object.getNext();
                    if (!(node13 == null || node13.getType() != 39 && node13.getType() != 33 || (node12 = node13.getNext()) == null || node12.getType() != 39 && node12.getType() != 33 || !AstUtilities.addName(stringBuilder = new StringBuilder(), node13))) {
                        string2 = stringBuilder.toString();
                        StringBuilder stringBuilder5 = new StringBuilder();
                        if (AstUtilities.addName(stringBuilder5, node12) && (string3 = stringBuilder5.toString()).length() == 0) {
                            string3 = null;
                        }
                    }
                } else if (node9.getType() == 41 && "declare".equals(node9.getString()) && (string.getType() == 39 && "dojo".equals(string.getString()) || string.getType() == 33 && AstUtilities.getJoinedName((Node)string).endsWith("dojo"))) {
                    Node node14 = object.getNext();
                    if (node14 != null) {
                        string2 = AstUtilities.getJoinedName(node14);
                        Node node15 = node14.getNext();
                        if (node15 != null && (string3 = AstUtilities.getJoinedName(node15)).length() == 0) {
                            string3 = null;
                        }
                    }
                } else if (node2.getParentNode() != null && node2.getFirstChild().getType() == 33 && node2.getFirstChild().getNext() != null && node2.getFirstChild().getNext().getType() == 33 && node2.getFirstChild().getNext().getNext() == node && (string5 = AstUtilities.getJoinedName(node11 = node2.getFirstChild())).endsWith(".extend") && string5.indexOf("dojo") != -1) {
                    string2 = AstUtilities.getJoinedName(node11.getNext());
                }
            }
        }
        object = new String[]{string2, string3};
        return object;
    }

    public static String getJoinedName(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        AstUtilities.addName(stringBuilder, node);
        return stringBuilder.toString();
    }

    public static boolean addName(StringBuilder stringBuilder, Node node) {
        switch (node.getType()) {
            case 39: 
            case 41: 
            case 49: {
                String string = node.getString();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('.');
                }
                stringBuilder.append(string);
                return true;
            }
            case 35: {
                if (!node.hasChildren()) break;
                Node node2 = node.getFirstChild();
                AstUtilities.addName(stringBuilder, node2);
                node2 = node2.getNext();
                if (node2 != null) {
                    AstUtilities.addName(stringBuilder, node2);
                }
                return true;
            }
            case 8: 
            case 33: {
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    AstUtilities.addName(stringBuilder, node3);
                }
                break;
            }
        }
        return true;
    }

    public static String getFqn(AstPath astPath, boolean[] blArray, String[] stringArray) {
        Node node = astPath.leaf();
        return AstUtilities.getFqn(node, blArray, stringArray);
    }

    public static String getFqn(Node node, boolean[] blArray, String[] stringArray) {
        Node node2 = null;
        while (node != null) {
            String string;
            if (node.getType() == 108) {
                string = AstUtilities.getFunctionFqn(node, blArray);
                if (string != null && node2 == null) {
                    node2 = node;
                }
                if (string != null && Character.isUpperCase(string.charAt(0))) {
                    int n = string.lastIndexOf(46);
                    if (n != -1 && n < string.length() - 1 && !Character.isUpperCase(string.charAt(n + 1))) {
                        if (stringArray != null) {
                            stringArray[0] = string.substring(n + 1);
                        }
                        string = string.substring(0, n);
                    }
                    return string;
                }
            } else if (node.getType() == 66 && (string = AstUtilities.getObjectLitFqn(node)[0]) != null) {
                if (string.endsWith(DOT_PROTOTYPE)) {
                    string = string.substring(0, string.length() - DOT_PROTOTYPE.length());
                }
                if (stringArray != null && node2 != null) {
                    for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                        Node node4;
                        if (node3.getType() != 165 || (node4 = AstUtilities.getLabelledNode(node3)) != node2) continue;
                        stringArray[0] = node3.getString();
                        break;
                    }
                }
                return string;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static String getExpressionType(Node node) {
        String string;
        switch (node.getType()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 44: 
            case 45: 
            case 103: 
            case 104: {
                string = "Boolean";
                break;
            }
            case 40: {
                string = "Number";
                break;
            }
            case 41: {
                if ("undefined".equals(node.getString())) {
                    string = Node.UNKNOWN_TYPE;
                    break;
                }
                string = "String";
                break;
            }
            case 48: {
                string = "RegExp";
                break;
            }
            case 65: {
                string = "Array";
                break;
            }
            case 108: {
                string = "Function";
                break;
            }
            case 173: {
                string = "Undefined";
                break;
            }
            case 125: {
                string = "void";
                break;
            }
            case 30: {
                Node node2 = AstUtilities.getFirstChild(node);
                if (node2 != null) {
                    string = AstUtilities.getJoinedName(node2);
                    break;
                }
                string = Node.UNKNOWN_TYPE;
                break;
            }
            case 33: {
                string = AstUtilities.getJoinedName(node);
                int n = string.lastIndexOf(46);
                if (n == -1 || Character.isUpperCase(string.charAt(n + 1))) break;
                string = null;
                break;
            }
            default: {
                string = Node.UNKNOWN_TYPE;
            }
        }
        return string;
    }

    public static String getSurroundingWith(Node node) {
        int n;
        for (Node node2 = node; node2 != null && (n = node2.getType()) != 108; node2 = node2.getParentNode()) {
            String string;
            Node node3;
            if (n != 122) continue;
            for (node3 = node2.getParentNode().getFirstChild(); node3 != null && node3.getNext() != node2; node3 = node3.getNext()) {
            }
            if (node3 == null || node3.getType() != 2 || node3.getFirstChild() == null || (string = AstUtilities.getJoinedName(node3.getFirstChild())) == null || string.length() <= 0) break;
            return string;
        }
        return null;
    }
}

