/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.BrowserVersion;
import org.netbeans.modules.javascript.editing.ClassCache;
import org.netbeans.modules.javascript.editing.FunctionAstElement;
import org.netbeans.modules.javascript.editing.FunctionCache;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.lexer.JsCommentLexer;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class JsIndexer
extends EmbeddingIndexer {
    private static final Logger LOG = Logger.getLogger(JsIndexer.class.getName());
    static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    static final String FIELD_FQN = "fqn";
    static final String FIELD_BASE = "base";
    static final String FIELD_EXTEND = "extend";
    static final String FIELD_CLASS = "clz";
    static final String FIELD_SDOC_URL = "sdocurl";
    private static String clusterUrl = null;
    private static final String CLUSTER_URL = "cluster:";

    public void index(Indexable indexable, Parser.Result result, Context context) {
        IndexingSupport indexingSupport;
        LOG.fine("Indexing: " + indexable.getRelativePath() + ", fullPath: " + result.getSnapshot().getSource().getFileObject().getPath());
        JsParseResult jsParseResult = AstUtilities.getParseResult(result);
        if (jsParseResult == null) {
            return;
        }
        Node node = jsParseResult.getRootNode();
        if (node == null && !jsParseResult.getSnapshot().getSource().getFileObject().getExt().equals("sdoc")) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Indexable " + indexable.getRelativePath() + " has parser errors and is not sdoc");
            }
            return;
        }
        try {
            indexingSupport = IndexingSupport.getInstance((Context)context);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Analyzing: " + indexable.getRelativePath());
        }
        TreeAnalyzer treeAnalyzer = new TreeAnalyzer(jsParseResult, indexingSupport, indexable);
        treeAnalyzer.analyze();
        for (IndexDocument indexDocument : treeAnalyzer.getDocuments()) {
            indexingSupport.addDocument(indexDocument);
        }
    }

    public File getPreindexedData() {
        return null;
    }

    public FileObject getPreindexedDb() {
        return null;
    }

    static void setClusterUrl(String string) {
        clusterUrl = string;
    }

    private static String getPreindexUrl(String string) {
        String string2 = JsIndexer.getClusterUrl();
        if (string.startsWith(string2)) {
            return CLUSTER_URL + string.substring(string2.length());
        }
        return string;
    }

    public static FileObject getFileObject(String string) {
        try {
            if (string.startsWith(CLUSTER_URL)) {
                string = JsIndexer.getClusterUrl() + string.substring(CLUSTER_URL.length());
            }
            return URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    private static String getClusterUrl() {
        if (clusterUrl == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-javascript-editing.jar", null, false);
            if (file == null) {
                throw new RuntimeException("Can't find cluster");
            }
            file = new File(file.getParentFile().getParentFile().getAbsolutePath());
            try {
                file = file.getCanonicalFile();
                clusterUrl = file.toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return clusterUrl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "javascript";
        public static final int VERSION = 8;
        private FileObject cachedFo;
        private boolean cachedIndexable;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            boolean bl = this.isIndexable(indexable, snapshot);
            if (LOG.isLoggable(Level.FINE)) {
                if (bl) {
                    LOG.fine("Creating indexer for: " + indexable.getRelativePath());
                } else {
                    LOG.fine("Ignoring indexable: " + indexable.getRelativePath());
                }
            }
            if (bl) {
                return new JsIndexer();
            }
            return null;
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 8;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            String string = snapshot.getSource().getFileObject().getNameExt();
            if (string.endsWith(".js")) {
                String string2;
                if (string.equals("utilities.js") && (string2 = indexable.getRelativePath()) != null && string2.indexOf("yui") != -1) {
                    return false;
                }
                string2 = snapshot.getSource().getFileObject();
                if (string.endsWith("min.js") && string.length() > 6 && !Character.isLetter(string.charAt(string.length() - 7))) {
                    string = string.substring(0, string.length() - 7);
                    if (string2.getParent().getFileObject(string, "js") != null) {
                        return false;
                    }
                } else {
                    String string3;
                    FileObject fileObject = string2.getParent();
                    if (fileObject == null) {
                        return true;
                    }
                    if (!string.endsWith(".uncompressed.js") && fileObject.getFileObject((string3 = string.substring(0, string.length() - 3)) + ".uncompressed", "js") != null) {
                        return false;
                    }
                    if (!string.endsWith("-debug.js") && fileObject.getFileObject((string3 = string.substring(0, string.length() - 3)) + "-debug", "js") != null) {
                        return false;
                    }
                    if (fileObject == this.cachedFo) {
                        return this.cachedIndexable;
                    }
                    this.cachedFo = fileObject;
                    if (fileObject.getFileObject("everything", "sdoc") != null) {
                        this.cachedIndexable = false;
                        return false;
                    }
                    for (int i = 0; i <= 3 && fileObject != null; ++i, fileObject = fileObject.getParent()) {
                        if (!fileObject.getName().equals(NAME)) continue;
                        FileObject fileObject2 = fileObject.getParent();
                        if (fileObject2 == null || fileObject2.getFileObject("javascript_uncompressed") == null) break;
                        this.cachedIndexable = false;
                        return false;
                    }
                    this.cachedIndexable = true;
                    return true;
                }
            }
            return true;
        }

        public void filesDeleted(Iterable<? extends Indexable> iterable, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : iterable) {
                    indexingSupport.removeDocuments(indexable);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }

        public void rootsRemoved(Iterable<? extends URL> iterable) {
        }

        public void filesDirty(Iterable<? extends Indexable> iterable, Context context) {
            try {
                IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : iterable) {
                    indexingSupport.markDirtyDocuments(indexable);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, null, iOException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeAnalyzer {
        private final JsParseResult result;
        private final FileObject file;
        private final IndexingSupport indexingSupport;
        private final Indexable indexable;
        private final List<IndexDocument> documents = new ArrayList<IndexDocument>();
        private String url;
        private static FileObject sdocsRoot;
        private static String sdocsRootUrl;

        private TreeAnalyzer(JsParseResult jsParseResult, IndexingSupport indexingSupport, Indexable indexable) {
            this.result = jsParseResult;
            this.file = jsParseResult.getSnapshot().getSource().getFileObject();
            this.indexingSupport = indexingSupport;
            this.indexable = indexable;
        }

        public List<IndexDocument> getDocuments() {
            return this.documents;
        }

        public void analyze() {
            String string;
            String string2;
            boolean bl;
            try {
                this.url = this.file.getURL().toExternalForm();
                this.url = JsIndexer.getPreindexUrl(this.url);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (this.file.getExt().equals("sdoc")) {
                this.indexScriptDoc(this.result.getSnapshot(), null);
                return;
            }
            if (this.url.endsWith(".js") && (bl = this.indexRelatedScriptDocs())) {
                return;
            }
            IndexDocument indexDocument = this.indexingSupport.createDocument(this.indexable);
            this.documents.add(indexDocument);
            JsAnalyzer.AnalysisResult analysisResult = this.result.getStructure();
            List<? extends AstElement> list = analysisResult.getElements();
            for (AstElement object : list) {
                ElementKind elementKind = object.getKind();
                if (elementKind == ElementKind.CONSTRUCTOR || elementKind == ElementKind.METHOD) {
                    string2 = this.computeSignature(object);
                    this.indexFuncOrProperty(object, indexDocument, string2);
                    string = object.getName();
                    if (Character.isUpperCase(string.charAt(0))) {
                        this.indexClass(object, indexDocument, string2);
                    }
                } else if (elementKind == ElementKind.GLOBAL || elementKind == ElementKind.PROPERTY || elementKind == ElementKind.CLASS) {
                    this.indexFuncOrProperty(object, indexDocument, this.computeSignature(object));
                } else assert (false) : elementKind;
                assert (object.getChildren().size() == 0);
            }
            Map<String, String> map = analysisResult.getExtendsMap();
            if (map != null && map.size() > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    string2 = (String)entry.getKey();
                    string = (String)entry.getValue();
                    indexDocument.addPair(JsIndexer.FIELD_EXTEND, string2.toLowerCase() + ";" + string2 + ";" + string, true, true);
                }
                ClassCache.INSTANCE.refresh();
            }
        }

        private void indexClass(AstElement astElement, IndexDocument indexDocument, String string) {
            String string2 = astElement.getName();
            indexDocument.addPair(JsIndexer.FIELD_CLASS, string2 + ";" + string, true, true);
        }

        private String computeSignature(AstElement astElement) {
            int n;
            Object object;
            OffsetRange offsetRange = this.getDocumentationOffset(astElement);
            int n2 = -1;
            if (offsetRange != OffsetRange.NONE) {
                n2 = offsetRange.getStart();
            }
            Map<String, String> map = astElement.getDocProps();
            int n3 = 3;
            String string = "";
            if (this.file.getNameExt().startsWith("stub_")) {
                int n4 = astElement.getNode().getSourceStart();
                CharSequence charSequence = this.result.getSnapshot().getText();
                try {
                    object = ((Object)charSequence.subSequence(n4, GsfUtilities.getRowEnd((CharSequence)charSequence, (int)n4))).toString();
                    n = ((String)object).indexOf("COMPAT=");
                    if (n != -1) {
                        EnumSet<BrowserVersion> enumSet = BrowserVersion.fromFlags(((String)object).substring(n += "COMPAT=".length()));
                        string = BrowserVersion.toCompactFlags(enumSet);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            assert (n3 == 3);
            StringBuilder stringBuilder = new StringBuilder();
            int n5 = IndexedElement.getFlags(astElement);
            if (map != null && map.get("@ignore") != null) {
                n5 |= 0x20;
            }
            if (n2 != -1) {
                n5 |= 1;
            }
            stringBuilder.append(IndexedElement.encode(n5));
            stringBuilder.append(';');
            assert (++n3 == 4);
            if (astElement instanceof FunctionAstElement) {
                object = (FunctionAstElement)astElement;
                n = 0;
                for (String string2 : ((FunctionAstElement)object).getParameters()) {
                    String string3;
                    if (n == 0 && "$super".equals(string2)) {
                        ++n;
                        continue;
                    }
                    if (n > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string2);
                    if (map != null && (string3 = map.get(string2)) != null) {
                        stringBuilder.append(':');
                        stringBuilder.append(string3);
                    }
                    ++n;
                }
            }
            stringBuilder.append(';');
            assert (++n3 == 5);
            stringBuilder.append('0');
            stringBuilder.append(';');
            assert (++n3 == 6);
            if (n2 != -1) {
                stringBuilder.append(IndexedElement.encode(n2));
            }
            stringBuilder.append(';');
            assert (++n3 == 7);
            stringBuilder.append(string);
            stringBuilder.append(';');
            assert (++n3 == 8);
            object = astElement.getType();
            if (object == Node.UNKNOWN_TYPE) {
                object = null;
            }
            if (object == null) {
                Object object2 = object = map != null ? map.get("@return") : null;
            }
            if (object != null) {
                stringBuilder.append((String)object);
            }
            stringBuilder.append(';');
            String string4 = stringBuilder.toString();
            return string4;
        }

        private void indexFuncOrProperty(AstElement astElement, IndexDocument indexDocument, String string) {
            String string2 = astElement.getIn();
            String string3 = astElement.getName();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string3.toLowerCase());
            stringBuilder.append(';');
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(';');
            stringBuilder.append(string3);
            stringBuilder.append(';');
            stringBuilder.append(string);
            indexDocument.addPair(JsIndexer.FIELD_BASE, stringBuilder.toString(), true, true);
            StringBuilder stringBuilder2 = new StringBuilder();
            if (string2 != null && string2.length() > 0) {
                stringBuilder2.append(string2.toLowerCase());
                stringBuilder2.append('.');
            }
            stringBuilder2.append(string3.toLowerCase());
            stringBuilder2.append(';');
            stringBuilder2.append(';');
            if (string2 != null && string2.length() > 0) {
                stringBuilder2.append(string2);
                stringBuilder2.append('.');
            }
            stringBuilder2.append(string3);
            stringBuilder2.append(';');
            stringBuilder2.append(string);
            indexDocument.addPair(JsIndexer.FIELD_FQN, stringBuilder2.toString(), true, true);
            FunctionCache functionCache = FunctionCache.INSTANCE;
            if (!functionCache.isEmpty()) {
                functionCache.wipe(string2 != null && string2.length() > 0 ? string2 + "." + string3 : string3);
            }
        }

        private OffsetRange getDocumentationOffset(AstElement astElement) {
            int n = astElement.getNode().getSourceStart();
            try {
                if (n > this.result.getSnapshot().getText().length()) {
                    return OffsetRange.NONE;
                }
                n = GsfUtilities.getRowStart((CharSequence)this.result.getSnapshot().getText(), (int)n);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            OffsetRange offsetRange = LexUtilities.getCommentBlock(this.result.getSnapshot(), n, true);
            if (offsetRange != OffsetRange.NONE) {
                offsetRange = LexUtilities.getLexerOffsets(this.result, offsetRange);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.fine("DocOffset: elementStart=" + IndexedElement.encode(astElement.getNode().getSourceStart()) + ", rowStart=" + IndexedElement.encode(n) + ", rowStart-in-doc=" + IndexedElement.encode(this.result.getSnapshot().getOriginalOffset(n)) + " doc=<" + IndexedElement.encode(offsetRange.getStart()) + ", " + IndexedElement.encode(offsetRange.getEnd()) + ">," + " text='" + this.result.getSnapshot().getText().subSequence(offsetRange.getStart(), offsetRange.getEnd()) + "'");
                }
                return offsetRange;
            }
            return OffsetRange.NONE;
        }

        private void indexScriptDoc(Snapshot snapshot, String string) {
            TokenSequence tokenSequence;
            assert (string == null || string.endsWith(".sdoc")) : string;
            IndexDocument indexDocument = this.indexingSupport.createDocument(this.indexable);
            this.documents.add(indexDocument);
            if (string != null) {
                indexDocument.addPair(JsIndexer.FIELD_SDOC_URL, string, true, true);
            }
            if ((tokenSequence = snapshot.getTokenHierarchy().tokenSequence(JsTokenId.language())) == null) {
                return;
            }
            tokenSequence.moveStart();
            while (tokenSequence.moveNext()) {
                CharSequence charSequence;
                CharSequence charSequence2;
                CharSequence charSequence3;
                Object object;
                JsTokenId jsTokenId = (JsTokenId)tokenSequence.token().id();
                if (jsTokenId != JsTokenId.BLOCK_COMMENT) continue;
                int n = tokenSequence.offset();
                TokenSequence tokenSequence2 = tokenSequence.embedded(JsCommentTokenId.language());
                if (tokenSequence2 == null) continue;
                int n2 = 521;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = "";
                StringBuilder stringBuilder = new StringBuilder();
                tokenSequence2.moveStart();
                while (tokenSequence2.moveNext()) {
                    object = tokenSequence2.token();
                    TokenId tokenId = object.id();
                    if (tokenId != JsCommentTokenId.COMMENT_TAG) continue;
                    charSequence3 = object.text();
                    if (TokenUtilities.textEquals((CharSequence)"@id", (CharSequence)charSequence3)) {
                        string2 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@name", (CharSequence)charSequence3)) {
                        string8 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@param", (CharSequence)charSequence3)) {
                        int n3 = tokenSequence2.index() + 1;
                        charSequence2 = JsCommentLexer.nextType((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        if (charSequence2 == null) {
                            tokenSequence2.moveIndex(n3);
                            tokenSequence2.moveNext();
                        }
                        if ((charSequence = JsCommentLexer.nextIdent((TokenSequence<? extends JsCommentTokenId>)tokenSequence2)) != null) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(',');
                            }
                            stringBuilder.append((String)charSequence);
                            if (string3 == null) continue;
                            stringBuilder.append(':');
                            stringBuilder.append((String)charSequence2);
                            continue;
                        }
                        tokenSequence2.moveIndex(n3);
                        tokenSequence2.moveNext();
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@return", (CharSequence)charSequence3)) {
                        String string10 = JsCommentLexer.nextType((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        if (string10 == null) continue;
                        string3 = string10;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@constructor", (CharSequence)charSequence3)) {
                        n2 |= 0x80;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@static", (CharSequence)charSequence3)) {
                        n2 |= 0x10;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@deprecated", (CharSequence)charSequence3)) {
                        n2 |= 0x100;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@final", (CharSequence)charSequence3)) {
                        n2 |= 0x400;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@type", (CharSequence)charSequence3)) {
                        string3 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@private", (CharSequence)charSequence3) || TokenUtilities.textEquals((CharSequence)"@protected", (CharSequence)charSequence3)) {
                        n2 |= 4;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@namespace", (CharSequence)charSequence3)) {
                        string7 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@class", (CharSequence)charSequence3)) {
                        string4 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@memberOf", (CharSequence)charSequence3)) {
                        string4 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@compat", (CharSequence)charSequence3)) {
                        string9 = JsCommentLexer.getCompat((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@method", (CharSequence)charSequence3)) {
                        n2 |= 8;
                        string5 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@function", (CharSequence)charSequence3)) {
                        n2 |= 8;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@global", (CharSequence)charSequence3)) {
                        n2 &= 0xFFFFFFF7;
                        n2 |= 0x40;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@property", (CharSequence)charSequence3) || TokenUtilities.textEquals((CharSequence)"@attribute", (CharSequence)charSequence3)) {
                        n2 &= 0xFFFFFFF7;
                        string5 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (!TokenUtilities.textEquals((CharSequence)"@extends", (CharSequence)charSequence3)) continue;
                    string6 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                }
                if (string8 != null && string2 == null) {
                    string2 = string8;
                    string4 = null;
                }
                if (string2 == null && string4 != null && string5 == null) {
                    string2 = string7 != null ? string7 + "." + string4 + "." + string5 : string4 + "." + string5;
                }
                if (string6 != null && string4 != null) {
                    if (string4.indexOf(46) == -1) {
                        if (string7 != null) {
                            object = string7 + "." + string4;
                        } else if (string2 != null && string2.indexOf(46) != -1) {
                            int n4 = string2.lastIndexOf(46);
                            object = string2.substring(0, n4 + 1) + string4;
                        } else {
                            object = string4;
                        }
                    } else {
                        object = string4;
                    }
                    if (string6.indexOf(46) == -1 && string7 != null) {
                        string6 = string7 + "." + string6;
                    }
                    indexDocument.addPair(JsIndexer.FIELD_EXTEND, ((String)object).toLowerCase() + ";" + (String)object + ";" + string6, true, true);
                }
                if (string2 == null) continue;
                if (string4 == null || string5 == null) {
                    int n5 = string2.lastIndexOf(46);
                    if (n5 != -1) {
                        string4 = string2.substring(0, n5);
                        string5 = string2.substring(n5 + 1);
                    } else {
                        string4 = null;
                        string5 = string2;
                    }
                }
                int n6 = 3;
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(IndexedElement.encode(n2));
                stringBuilder2.append(';');
                assert (++n6 == 4);
                if (stringBuilder.length() > 0) {
                    stringBuilder2.append((CharSequence)stringBuilder);
                }
                stringBuilder2.append(';');
                assert (++n6 == 5);
                stringBuilder2.append('0');
                stringBuilder2.append(';');
                assert (++n6 == 6);
                if (n != -1) {
                    stringBuilder2.append(IndexedElement.encode(n));
                }
                stringBuilder2.append(';');
                assert (++n6 == 7);
                stringBuilder2.append(string9);
                stringBuilder2.append(';');
                assert (++n6 == 8);
                if (string3 != null) {
                    stringBuilder2.append(string3);
                }
                stringBuilder2.append(';');
                charSequence3 = stringBuilder2.toString();
                String string11 = string4;
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append(string5.toLowerCase());
                ((StringBuilder)charSequence2).append(';');
                if (string11 != null) {
                    ((StringBuilder)charSequence2).append(string11);
                }
                ((StringBuilder)charSequence2).append(';');
                ((StringBuilder)charSequence2).append(string5);
                ((StringBuilder)charSequence2).append(';');
                ((StringBuilder)charSequence2).append((String)charSequence3);
                indexDocument.addPair(JsIndexer.FIELD_BASE, ((StringBuilder)charSequence2).toString(), true, true);
                charSequence = new StringBuilder();
                if (string11 != null && string11.length() > 0) {
                    ((StringBuilder)charSequence).append(string11.toLowerCase());
                    ((StringBuilder)charSequence).append('.');
                }
                ((StringBuilder)charSequence).append(string5.toLowerCase());
                ((StringBuilder)charSequence).append(';');
                ((StringBuilder)charSequence).append(';');
                if (string11 != null && string11.length() > 0) {
                    ((StringBuilder)charSequence).append(string11);
                    ((StringBuilder)charSequence).append('.');
                }
                ((StringBuilder)charSequence).append(string5);
                ((StringBuilder)charSequence).append(';');
                ((StringBuilder)charSequence).append((String)charSequence3);
                indexDocument.addPair(JsIndexer.FIELD_FQN, ((StringBuilder)charSequence).toString(), true, true);
            }
        }

        private boolean indexRelatedScriptDocs() {
            int n = this.url.lastIndexOf(47);
            if (this.url.startsWith("jquery-", n + 1)) {
                this.indexScriptDoc("jquery.sdoc", false);
                return true;
            }
            if (this.url.startsWith("dojo.js", n + 1)) {
                this.indexScriptDoc("dojo.sdoc", false);
                return true;
            }
            if (this.url.startsWith("yahoo.js", n + 1) || this.url.startsWith("yahoo-debug.js", n + 1) || this.url.startsWith("yahoo-min.js", n + 1)) {
                int n2 = n - "yahoo".length();
                if (this.url.startsWith("yahoo/yahoo", n2)) {
                    this.indexScriptDoc("yui/" + this.url.substring(n2), false);
                } else {
                    this.indexScriptDoc("yui", true);
                }
                return true;
            }
            int n3 = this.url.indexOf("/yui/build/");
            if (n3 != -1) {
                this.indexScriptDoc("yui/" + this.url.substring(n3 + "/yui/build/".length()), false);
                return true;
            }
            return false;
        }

        private void indexScriptDocRecursively(FileObject fileObject, String string) {
            if (fileObject.isFolder()) {
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    this.indexScriptDocRecursively(fileObject2, string + "/" + fileObject2.getNameExt());
                }
                return;
            }
            if (fileObject.getExt().equals("sdoc")) {
                Source source = Source.create((FileObject)fileObject);
                this.indexScriptDoc(source.createSnapshot(), string);
            }
        }

        private void indexScriptDoc(String string, boolean bl) {
            if (string != null) {
                URL uRL;
                String string2;
                File file;
                if (sdocsRootUrl == null) {
                    file = InstalledFileLocator.getDefault().locate("jsstubs/sdocs.zip", "org-netbeans-modules-javascript-editing.jar", false);
                    if (file == null) {
                        sdocsRootUrl = "";
                    } else if (file.exists()) {
                        try {
                            string2 = file.toURI().toURL().toExternalForm() + "!/sdocs";
                            uRL = new URL("jar:" + string2);
                            sdocsRoot = URLMapper.findFileObject((URL)uRL);
                            sdocsRootUrl = uRL.toExternalForm();
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                        }
                    }
                    if (sdocsRoot == null) {
                        sdocsRootUrl = "";
                        return;
                    }
                }
                if (sdocsRootUrl.length() > 0) {
                    if (string.endsWith("-debug.js")) {
                        string = string.substring(0, string.length() - "-debug.js".length()) + ".sdoc";
                    } else if (string.endsWith("-min.js")) {
                        string = string.substring(0, string.length() - "-min.js".length()) + ".sdoc";
                    } else if (string.endsWith(".js")) {
                        string = string.substring(0, string.length() - 2) + "sdoc";
                    }
                    assert (sdocsRoot != null);
                    file = sdocsRoot.getFileObject(string);
                    if (file != null) {
                        string2 = sdocsRootUrl + "/" + string;
                        if (bl) {
                            this.indexScriptDocRecursively((FileObject)file, string2);
                        } else {
                            uRL = Source.create((FileObject)file);
                            this.indexScriptDoc(uRL.createSnapshot(), string2);
                        }
                    }
                }
            }
        }
    }
}

