/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.netbeans.lib.cvsclient.util.ByteArray;
import org.netbeans.lib.cvsclient.util.Logger;

public class LoggedDataInputStream
extends FilterInputStream {
    private long counter;

    public LoggedDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public String readLine() throws IOException {
        return this.readLineBytes().getStringFromBytes();
    }

    public ByteArray readLineBytes() throws IOException {
        boolean bl = true;
        ByteArray byteArray = new ByteArray();
        block6: while (true) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                break;
            }
            if (this.in.available() == 0) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            int n = this.in.read();
            ++this.counter;
            switch (n) {
                case -1: {
                    if (bl) {
                        throw new EOFException();
                    }
                }
                case 10: {
                    break block6;
                }
                default: {
                    byteArray.add((byte)n);
                    bl = false;
                    continue block6;
                }
            }
            break;
        }
        byte[] byArray = byteArray.getBytes();
        Logger.logInput(byArray);
        Logger.logInput('\n');
        return byteArray;
    }

    public byte[] readBytes(int n) throws IOException {
        ByteArray byteArray = new ByteArray();
        block5: while (n != 0) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                break;
            }
            if (this.in.available() == 0) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            int n2 = this.in.read();
            ++this.counter;
            switch (n2) {
                case -1: {
                    break block5;
                }
                default: {
                    byteArray.add((byte)n2);
                    --n;
                    continue block5;
                }
            }
        }
        byte[] byArray = byteArray.getBytes();
        Logger.logInput(byArray);
        return byArray;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n != -1) {
            Logger.logInput(byArray, 0, n);
            this.counter += (long)n;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 != -1) {
            Logger.logInput(byArray, n, n3);
            this.counter += (long)n3;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        if (l2 > 0L) {
            Logger.logInput(new String("<skipped " + l2 + " bytes>").getBytes("utf8"));
            this.counter += l2;
        }
        return l2;
    }

    public int read() throws IOException {
        while (this.in.available() == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
        int n = super.read();
        if (n != -1) {
            Logger.logInput((char)n);
            ++this.counter;
        }
        return n;
    }

    public InputStream getUnderlyingStream() {
        return this.in;
    }

    public void setUnderlyingStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public long getCounter() {
        return this.counter;
    }
}

