/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.dtd.grammar;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.openide.util.Enumerations;

abstract class ContentModel {
    ContentModel() {
    }

    public static final ContentModel parseContentModel(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        PushbackStringTokenizer pushbackStringTokenizer = new PushbackStringTokenizer(string, "|,*?+() \t\n", true);
        String string2 = pushbackStringTokenizer.nextToken();
        if (string2.charAt(0) != '(') {
            throw new IllegalStateException();
        }
        return ContentModel.parseContentModel(pushbackStringTokenizer);
    }

    private static ContentModel parseContentModel(PushbackStringTokenizer pushbackStringTokenizer) {
        String string;
        char c;
        ContentModel contentModel = null;
        ArrayList<ContentModel> arrayList = new ArrayList<ContentModel>(7);
        int n = 69;
        do {
            if ((c = (string = pushbackStringTokenizer.nextToken()).charAt(0)) == ' ' || c == '\t' || c == '\n') continue;
            if (c == '#') {
                while ((c = pushbackStringTokenizer.nextToken().charAt(0)) == ' ' || c == '\t' || c == '\n') {
                }
                if (c == '|') continue;
                throw new IllegalStateException();
            }
            if (c == '(') {
                arrayList.add(ContentModel.parseContentModel(pushbackStringTokenizer));
                continue;
            }
            if (c == '|') {
                n = 124;
                continue;
            }
            if (c == ',') {
                n = 44;
                continue;
            }
            if (c == ')') break;
            contentModel = new Element(string);
            while ((c = (string = pushbackStringTokenizer.nextToken()).charAt(0)) == ' ' || c == '\t' || c == '\n') {
            }
            if (c == '+') {
                contentModel = new MultiplicityGroup(contentModel, 1, -1);
            } else if (c == '?') {
                contentModel = new MultiplicityGroup(contentModel, 0, 1);
            } else if (c == '*') {
                contentModel = new MultiplicityGroup(contentModel, 0, -1);
            } else if (c != ')') {
                pushbackStringTokenizer.pushback(string);
            }
            arrayList.add(contentModel);
        } while (c != ')');
        if (n == 124) {
            contentModel = new Choice(arrayList.toArray(new ContentModel[0]));
        } else if (n == 44) {
            contentModel = new Sequence(arrayList.toArray(new ContentModel[0]));
        }
        while (pushbackStringTokenizer.hasMoreTokens() && ((c = (string = pushbackStringTokenizer.nextToken()).charAt(0)) == ' ' || c == '\t' || c == '\n')) {
        }
        if (c == '?') {
            contentModel = new MultiplicityGroup(contentModel, 0, 1);
        } else if (c == '*') {
            contentModel = new MultiplicityGroup(contentModel, 0, -1);
        } else if (c == '+') {
            contentModel = new MultiplicityGroup(contentModel, 1, -1);
        } else {
            pushbackStringTokenizer.pushback(string);
        }
        if (contentModel == null && arrayList.size() == 1) {
            return (ContentModel)arrayList.get(0);
        }
        return contentModel;
    }

    public final Enumeration whatCanFollow(Enumeration enumeration) {
        this.reset();
        Food food = new Food(enumeration);
        if (this.eat(food)) {
            return this.possibilities();
        }
        return null;
    }

    protected void reset() {
    }

    protected abstract boolean eat(Food var1);

    protected abstract Enumeration possibilities();

    protected boolean terminated() {
        return false;
    }

    protected boolean isOptional() {
        return false;
    }

    private static class Choice
    extends ContentModel {
        private ContentModel[] models;
        private boolean[] modelsThatNotAcceptedAtLeastOne;
        private boolean terminated = false;
        private int current = 0;

        public Choice(ContentModel[] contentModelArray) {
            this.models = contentModelArray;
            this.modelsThatNotAcceptedAtLeastOne = new boolean[contentModelArray.length];
        }

        protected void reset() {
            if (this.models == null) {
                return;
            }
            for (int i = 0; i < this.models.length; ++i) {
                this.models[i].reset();
                this.modelsThatNotAcceptedAtLeastOne[i] = false;
            }
            this.current = 0;
            this.terminated = false;
        }

        protected boolean eat(Food food) {
            boolean bl;
            boolean bl2 = !food.hasNext();
            int n = food.mark();
            boolean bl3 = bl = !food.hasNext();
            while (food.hasNext() && this.current != this.models.length) {
                int n2 = food.mark();
                boolean bl4 = this.models[this.current].eat(food);
                if (bl4) {
                    bl2 = true;
                    if (n2 == food.mark()) {
                        this.modelsThatNotAcceptedAtLeastOne[this.current] = true;
                    }
                    if (!food.hasNext()) {
                        bl |= !this.models[this.current].terminated();
                    }
                    n = Math.max(n, food.mark());
                } else {
                    this.modelsThatNotAcceptedAtLeastOne[this.current] = true;
                }
                ++this.current;
                food.reset(n2);
            }
            food.reset(n);
            this.terminated = !bl;
            return bl2;
        }

        protected boolean terminated() {
            return this.terminated;
        }

        protected boolean isOptional() {
            boolean bl = false;
            for (int i = 0; i < this.models.length; ++i) {
                if (!this.models[i].isOptional()) continue;
                bl = true;
                break;
            }
            return bl;
        }

        protected Enumeration possibilities() {
            if (!this.terminated()) {
                Enumeration enumeration = Enumerations.empty();
                for (int i = 0; i < this.models.length; ++i) {
                    if (this.modelsThatNotAcceptedAtLeastOne[i]) continue;
                    ContentModel contentModel = this.models[i];
                    enumeration = Enumerations.concat((Enumeration)enumeration, (Enumeration)contentModel.possibilities());
                }
                return enumeration;
            }
            return Enumerations.empty();
        }

        public String toString() {
            String string = "Choice[";
            for (int i = 0; i < this.models.length; ++i) {
                string = string + this.models[i].toString() + ", ";
            }
            return string + " current=" + this.current + "]";
        }
    }

    private static class Element
    extends ContentModel {
        private final String name;
        private boolean full = false;

        public Element(String string) {
            this.name = string;
        }

        protected void reset() {
            this.full = false;
        }

        protected boolean eat(Food food) {
            if (!food.hasNext()) {
                return true;
            }
            String string = food.next();
            if (this.name.equals(string)) {
                this.full = true;
                return true;
            }
            return false;
        }

        protected Enumeration possibilities() {
            if (!this.terminated()) {
                return Enumerations.singleton((Object)this.name);
            }
            return Enumerations.empty();
        }

        protected boolean terminated() {
            return this.full;
        }

        public String toString() {
            return "Element[" + this.name + "]";
        }
    }

    private static class Food {
        private final List list = new LinkedList();
        private final Enumeration en;
        private int current;

        public Food(Enumeration enumeration) {
            this.en = enumeration;
            this.current = 0;
        }

        public int mark() {
            return this.current;
        }

        public void reset(int n) {
            this.current = n;
        }

        public String next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            String string = (String)this.list.get(this.current);
            ++this.current;
            return string;
        }

        public boolean hasNext() {
            if (this.list.size() > this.current) {
                return true;
            }
            if (this.en.hasMoreElements()) {
                String string = (String)this.en.nextElement();
                return this.list.add(string);
            }
            return false;
        }
    }

    private static class MultiplicityGroup
    extends ContentModel {
        private final int min;
        private final int max;
        private final ContentModel peer;
        private int current = 0;

        public MultiplicityGroup(ContentModel contentModel, int n, int n2) {
            this.peer = contentModel;
            this.min = n;
            this.max = n2;
            this.current = 0;
        }

        protected void reset() {
            this.current = 0;
            if (this.peer != null) {
                this.peer.reset();
            }
        }

        protected boolean eat(Food food) {
            boolean bl;
            boolean bl2 = bl = this.current == this.min;
            while (food.hasNext()) {
                boolean bl3;
                if (this.current == this.max) {
                    return true;
                }
                int n = food.mark();
                boolean bl4 = bl3 = this.peer == null ? false : this.peer.eat(food);
                if (!bl3) {
                    food.reset(n);
                    return bl;
                }
                if (food.hasNext()) {
                    if (++this.current >= this.max && this.max > -1) {
                        return true;
                    }
                    this.peer.reset();
                } else if (this.peer.terminated()) {
                    ++this.current;
                }
                bl = true;
            }
            return true;
        }

        public Enumeration possibilities() {
            if (this.peer == null || this.terminated()) {
                return Enumerations.empty();
            }
            if (this.peer.terminated()) {
                this.peer.reset();
            }
            return this.peer.possibilities();
        }

        protected boolean terminated() {
            if (this.current != this.max) {
                return false;
            }
            return this.peer.terminated();
        }

        protected boolean isOptional() {
            if (this.min <= this.current) {
                return true;
            }
            return this.peer.isOptional();
        }

        public String toString() {
            return "MultiplicityGroup[peer=" + this.peer + ", min=" + this.min + ", max=" + this.max + ", current=" + this.current + "]";
        }
    }

    private static class PushbackStringTokenizer
    extends StringTokenizer {
        private String pushback = null;

        public PushbackStringTokenizer(String string, String string2, boolean bl) {
            super(string, string2, bl);
        }

        public String nextToken() {
            String string;
            if (this.pushback != null) {
                string = this.pushback;
                this.pushback = null;
            } else {
                string = super.nextToken();
            }
            return string;
        }

        public boolean hasMoreTokens() {
            if (this.pushback != null) {
                return true;
            }
            return super.hasMoreTokens();
        }

        public void pushback(String string) {
            if (this.pushback != null) {
                throw new IllegalStateException();
            }
            this.pushback = string;
        }
    }

    private static class Sequence
    extends ContentModel {
        private ContentModel[] models;
        private int current = 0;

        public Sequence(ContentModel[] contentModelArray) {
            this.models = contentModelArray;
        }

        protected void reset() {
            if (this.models == null) {
                return;
            }
            for (int i = 0; i < this.models.length; ++i) {
                this.models[i].reset();
            }
            this.current = 0;
        }

        protected boolean eat(Food food) {
            while (food.hasNext()) {
                if (this.current == this.models.length) {
                    return true;
                }
                int n = food.mark();
                boolean bl = this.models[this.current].eat(food);
                boolean bl2 = food.hasNext();
                boolean bl3 = this.models[this.current].terminated();
                if (!bl) {
                    return false;
                }
                if (bl2) {
                    ++this.current;
                    continue;
                }
                if (!bl3 && n != food.mark()) {
                    int n2 = food.mark();
                    for (int i = this.current + 1; i < this.models.length; ++i) {
                        food.reset(n);
                        if (!this.models[i].eat(food)) {
                            this.models[i].reset();
                            if (this.models[i].isOptional()) continue;
                            break;
                        }
                        if (n != food.mark()) continue;
                        this.models[i].reset();
                    }
                    food.reset(n2);
                    assert (!food.hasNext()) : "Food mark/reset invariant is broken!";
                    continue;
                }
                if (!bl3) continue;
                ++this.current;
            }
            return true;
        }

        protected boolean terminated() {
            if (this.current == this.models.length) {
                return true;
            }
            if (this.current < this.models.length - 1) {
                return false;
            }
            return this.models[this.current].terminated();
        }

        protected boolean isOptional() {
            for (int i = 0; i < this.models.length; ++i) {
                if (this.models[i].isOptional()) continue;
                return false;
            }
            return true;
        }

        protected Enumeration possibilities() {
            if (!this.terminated()) {
                Enumeration enumeration = Enumerations.empty();
                for (int i = this.current; i < this.models.length; ++i) {
                    ContentModel contentModel = this.models[i];
                    enumeration = Enumerations.concat((Enumeration)enumeration, (Enumeration)contentModel.possibilities());
                    if (!contentModel.isOptional()) break;
                }
                return enumeration;
            }
            return Enumerations.empty();
        }

        public String toString() {
            String string = "Sequence[";
            for (int i = 0; i < this.models.length; ++i) {
                string = string + this.models[i].toString() + ", ";
            }
            return string + " current=" + this.current + "]";
        }
    }
}

