/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediawriter.flv;

import com.wowza.util.AMFUtils;
import com.wowza.util.FLVUtils;
import com.wowza.util.FileUtils;
import com.wowza.util.IFLVWriterAdjustTimecode;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaWriter;
import com.wowza.wms.stream.MediaWriterItem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;

public class MediaWriterFLV
implements IMediaWriter {
    protected IMediaStream parent = null;
    protected MediaWriterItem mediaWriterItem = null;
    protected long[] currentTCs = new long[3];
    protected long duration = 0L;
    protected Map extraMetadata = new HashMap();
    protected boolean versionFile = false;
    protected boolean waitForVideoKeyFrame = false;
    protected boolean audioWaitForVideoKeyFrame = false;
    protected boolean hitVideoKeyFrame = false;
    protected boolean waitForKeyFrameMode = false;
    protected long waitForKeyDuration = 0L;
    protected long waitForKeyStartTC = 0L;
    protected boolean hitFirstRealFrame = false;
    protected AMFPacket audioCodecConfig = null;
    protected AMFPacket videoCodecConfig = null;
    private long timecodeOffset = 0L;

    public void setMediaWriterItem(MediaWriterItem mediaWriterItem) {
        this.mediaWriterItem = mediaWriterItem;
    }

    public void setParent(IMediaStream iMediaStream) {
        this.parent = iMediaStream;
    }

    public void writePackets(List list, List list2, List list3, List list4, List list5, List list6, List list7, boolean bl, boolean bl2) {
        File file = this.parent.getStreamFileForWrite();
        boolean bl3 = this.parent.isAppend();
        if (bl) {
            long l = 0L;
            if (file.exists()) {
                if (bl3) {
                    l = FLVUtils.getLastTC((File)file);
                } else if (this.versionFile) {
                    FileUtils.versionFile((File)file);
                } else {
                    try {
                        file.delete();
                    }
                    catch (Exception exception) {}
                }
            } else {
                bl3 = false;
            }
            this.currentTCs[0] = l;
            this.currentTCs[1] = l;
            this.currentTCs[2] = l;
            this.waitForKeyStartTC = l;
        } else {
            bl3 = true;
        }
        if (bl && this.waitForVideoKeyFrame) {
            this.audioWaitForVideoKeyFrame = list2.size() > 2;
            this.waitForKeyFrameMode = true;
        }
        try {
            int n;
            AMFData[] bl6;
            if (file.getParentFile() == null) {
                WMSLoggerFactory.getLogger(MediaWriterFLV.class).warn("MediaWriterFLV: File path does not exist: " + file.getPath());
            } else if (!file.getParentFile().exists()) {
                WMSLoggerFactory.getLogger(MediaWriterFLV.class).warn("MediaWriterFLV: Folder does not exist: " + file.getParentFile().getPath());
            } else if (file.exists() && !file.canWrite()) {
                WMSLoggerFactory.getLogger(MediaWriterFLV.class).warn("MediaWriterFLV: Cannot write to file (permission error): " + file.getPath());
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file, bl3);
            if (bl && !bl3) {
                Object object;
                boolean bl4 = true;
                if (list3.size() > 0) {
                    try {
                        String string;
                        ByteBuffer byteBuffer = (ByteBuffer)list3.get(0);
                        if (byteBuffer != null && (object = new AMFDataList(byteBuffer)) != null && object.size() >= 2 && (string = object.getString(0)) != null) {
                            AMFDataMixedArray aMFDataMixedArray;
                            if (string.equalsIgnoreCase("@setDataFrame")) {
                                object.remove(0);
                                string = object.getString(0);
                            }
                            if (string.equalsIgnoreCase("onMetaData") && (aMFDataMixedArray = (AMFDataMixedArray)object.get(1)) != null) {
                                Iterator iterator;
                                if (!aMFDataMixedArray.containsKey("duration")) {
                                    aMFDataMixedArray.put("duration", (AMFData)new AMFDataItem(0.0));
                                }
                                if (!aMFDataMixedArray.containsKey("creationdate")) {
                                    Date objectArray = new Date();
                                    iterator = "EEE MMM d HH:mm:ss";
                                    Object object2 = FastDateFormat.getInstance((String)((Object)iterator));
                                    bl6 = object2.format(objectArray);
                                    aMFDataMixedArray.put("creationdate", (AMFData)new AMFDataItem((String)bl6));
                                }
                                if (this.extraMetadata != null) {
                                    Object[] by = new Object[1];
                                    for (Object object2 : this.extraMetadata.keySet()) {
                                        by[0] = this.extraMetadata.get(object2);
                                        bl6 = AMFUtils.convertParams((Object[])by);
                                        if (bl6 == null) continue;
                                        aMFDataMixedArray.put((String)object2, bl6[0]);
                                    }
                                }
                                byte by = 18;
                                iterator = (Iterator)object.serialize();
                                n = ((Object)iterator).length;
                                FLVUtils.writeShortHeader((OutputStream)fileOutputStream);
                                FLVUtils.writeChunk((OutputStream)fileOutputStream, (ByteBuffer)ByteBuffer.wrap(iterator), (int)n, (long)0L, (byte)by);
                                bl4 = false;
                                list3.remove(0);
                                list6.remove(0);
                                if (list7 != null) {
                                    list7.remove(0);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl4) {
                    FLVUtils.writeHeader((OutputStream)fileOutputStream, (double)0.0, (Map)this.extraMetadata);
                }
                boolean bl5 = true;
                if (list.size() != 0) {
                    object = (ByteBuffer)list.get(0);
                    long l = (Long)list4.get(0);
                    if (l == 0L && ((Buffer)object).limit() == 0) {
                        bl5 = false;
                    }
                }
                if (bl5) {
                    FLVUtils.writeChunk((OutputStream)fileOutputStream, null, (int)0, (long)this.currentTCs[0], (byte)8);
                }
            }
            if (this.waitForKeyFrameMode) {
                List list8 = FLVUtils.interleavePackets((List)list, (List)list2, (List)list3, (List)list4, (List)list5, (List)list6, (List)list7, (long[])this.currentTCs);
                list.clear();
                list2.clear();
                list3.clear();
                list4.clear();
                list5.clear();
                list6.clear();
                if (list7 != null) {
                    list7.clear();
                }
                for (Object object : list8) {
                    int n2;
                    long l = object.getAbsTimecode() - this.timecodeOffset;
                    if (l < 0L) {
                        l = 0L;
                    }
                    int n3 = object.getSize();
                    int n4 = object.getType();
                    int n5 = n = n3 > 0 ? object.getFirstByte() : 0;
                    if (n4 == 8) {
                        if (this.audioWaitForVideoKeyFrame) {
                            if (n3 <= 1) continue;
                            int n6 = FLVUtils.getAudioCodec((int)n);
                            n2 = object.getSecondByte();
                            if (n6 != 10 || n2 != 0) continue;
                            this.audioCodecConfig = object;
                            continue;
                        }
                        if (!this.hitFirstRealFrame) {
                            this.timecodeOffset = l;
                            l = 0L;
                            this.hitFirstRealFrame = true;
                        }
                        if (this.audioCodecConfig != null) {
                            this.writePacket(fileOutputStream, this.audioCodecConfig, l + this.waitForKeyStartTC);
                            this.audioCodecConfig = null;
                        }
                        this.writePacket(fileOutputStream, (AMFPacket)object, l + this.waitForKeyStartTC);
                        this.waitForKeyDuration = Math.max(l + this.waitForKeyStartTC, this.waitForKeyDuration);
                        continue;
                    }
                    if (n4 == 9) {
                        if (n3 >= 2) {
                            int n7 = object.getSecondByte();
                            if (n3 == 2 && (n & 0x50) == 80 && (n7 == 0 || n7 == 1)) continue;
                        }
                        boolean bl4 = FLVUtils.isVideoKeyFrame((AMFPacket)object);
                        if (this.waitForVideoKeyFrame && !this.hitVideoKeyFrame) {
                            if (bl4) {
                                this.hitVideoKeyFrame = true;
                                this.audioWaitForVideoKeyFrame = false;
                            } else {
                                if (n3 <= 1) continue;
                                n2 = FLVUtils.getVideoCodec((int)n);
                                int n8 = object.getSecondByte();
                                if (n2 != 7 || n8 != 0) continue;
                                this.videoCodecConfig = object;
                                continue;
                            }
                        }
                        if (!this.hitFirstRealFrame) {
                            this.timecodeOffset = l;
                            l = 0L;
                            this.hitFirstRealFrame = true;
                        }
                        if (this.videoCodecConfig != null) {
                            this.writePacket(fileOutputStream, this.videoCodecConfig, l + this.waitForKeyStartTC);
                            this.videoCodecConfig = null;
                        }
                        this.writePacket(fileOutputStream, (AMFPacket)object, l + this.waitForKeyStartTC);
                        this.waitForKeyDuration = Math.max(l + this.waitForKeyStartTC, this.waitForKeyDuration);
                        continue;
                    }
                    if (n4 != 18 && n4 != 15) continue;
                    if (!this.hitFirstRealFrame) {
                        this.timecodeOffset = l;
                        l = 0L;
                        this.hitFirstRealFrame = true;
                    }
                    if ((bl6 = FLVUtils.updateOnCuePointTimecode((AMFPacket)object, (long)(l + this.waitForKeyStartTC))) != null) {
                        object = bl6;
                    }
                    this.writePacket(fileOutputStream, (AMFPacket)object, l + this.waitForKeyStartTC);
                    this.waitForKeyDuration = Math.max(l + this.waitForKeyStartTC, this.waitForKeyDuration);
                }
            } else {
                class MyTimecodeFixer
                implements IFLVWriterAdjustTimecode {
                    MyTimecodeFixer() {
                    }

                    public ByteBuffer adjustDataTimecode(ByteBuffer byteBuffer, int n, long l) {
                        return FLVUtils.updateOnCuePointTimecode((ByteBuffer)byteBuffer, (int)n, (long)l);
                    }
                }
                FLVUtils.writePackets((OutputStream)fileOutputStream, (List)list, (List)list2, (List)list3, (List)list4, (List)list5, (List)list6, (List)list7, (long[])this.currentTCs, (IFLVWriterAdjustTimecode)new MyTimecodeFixer());
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaWriterFLV.class).error("MediaWriterFLV: Error writing to file: " + file.getPath() + " :" + exception.toString());
            exception.printStackTrace();
        }
        if (bl2) {
            this.duration = this.waitForKeyFrameMode ? this.waitForKeyDuration : Math.max(Math.max(this.currentTCs[0], this.currentTCs[1]), this.currentTCs[2]);
            double d = (double)this.duration / 1000.0;
            FLVUtils.writeDuration((File)file, (double)d);
        }
    }

    private void writePacket(OutputStream outputStream, AMFPacket aMFPacket, long l) {
        ByteBuffer byteBuffer = aMFPacket.getDataBuffer();
        FLVUtils.writeChunk((OutputStream)outputStream, (ByteBuffer)byteBuffer, (int)byteBuffer.limit(), (long)l, (byte)((byte)aMFPacket.getType()));
    }

    public Map getExtraMetadata() {
        return this.extraMetadata;
    }

    public void setExtraMetadata(Map map) {
        this.extraMetadata = map;
    }

    public boolean isVersionFile() {
        return this.versionFile;
    }

    public void setVersionFile(boolean bl) {
        this.versionFile = bl;
    }

    public void putMetaData(String string, AMFData aMFData) {
        this.extraMetadata.put(string, aMFData);
    }

    public boolean isWaitForVideoKeyFrame() {
        return this.waitForVideoKeyFrame;
    }

    public void setWaitForVideoKeyFrame(boolean bl) {
        this.waitForVideoKeyFrame = bl;
    }
}

