/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ini4j.Config;
import org.ini4j.IniHandler;
import org.ini4j.IniParser;
import org.ini4j.InvalidIniFormatException;
import org.ini4j.MultiMap;
import org.ini4j.MultiMapImpl;
import org.ini4j.OptionMapImpl;
import org.ini4j.spi.AbstractBeanInvocationHandler;
import org.ini4j.spi.IniFormatter;
import org.ini4j.spi.XMLFormatter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ini
extends MultiMapImpl<String, Section> {
    private static final String SECTION_SYSTEM_PROPERTIES = "@prop";
    private static final String SECTION_ENVIRONMENT = "@env";
    private static final Pattern EXPRESSION = Pattern.compile("(?<!\\\\)\\$\\{(([^\\[]+)(\\[([0-9]+)\\])?/)?([^\\[]+)(\\[(([0-9]+))\\])?\\}");
    private static final int G_SECTION = 2;
    private static final int G_SECTION_IDX = 4;
    private static final int G_OPTION = 5;
    private static final int G_OPTION_IDX = 7;
    private Map<Class, Object> _beans;
    private Config _config = Config.getGlobal();

    public Ini() {
    }

    public Ini(Reader input) throws IOException, InvalidIniFormatException {
        this();
        this.load(input);
    }

    public Ini(InputStream input) throws IOException, InvalidIniFormatException {
        this();
        this.load(input);
    }

    public Ini(URL input) throws IOException, InvalidIniFormatException {
        this();
        this.load(input);
    }

    public void setConfig(Config value) {
        this._config = value;
    }

    public Section add(String name) {
        Section s = new Section(name);
        if (this.getConfig().isMultiSection()) {
            this.add(name, s);
        } else {
            this.put(name, s);
        }
        return s;
    }

    public <T> T as(Class<T> clazz) {
        return clazz.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new BeanInvocationHandler()));
    }

    public void load(InputStream input) throws IOException, InvalidIniFormatException {
        IniParser.newInstance(this.getConfig()).parse(input, (IniHandler)new Builder());
    }

    public void load(Reader input) throws IOException, InvalidIniFormatException {
        IniParser.newInstance(this.getConfig()).parse(input, (IniHandler)new Builder());
    }

    public void load(URL input) throws IOException, InvalidIniFormatException {
        IniParser.newInstance(this.getConfig()).parse(input, (IniHandler)new Builder());
    }

    public void loadFromXML(InputStream input) throws IOException, InvalidIniFormatException {
        this.loadFromXML(new InputStreamReader(input));
    }

    public void loadFromXML(Reader input) throws IOException, InvalidIniFormatException {
        Builder builder = new Builder();
        IniParser.newInstance(this.getConfig()).parseXML(input, (IniHandler)builder);
    }

    public void loadFromXML(URL input) throws IOException, InvalidIniFormatException {
        Builder builder = new Builder();
        IniParser.newInstance(this.getConfig()).parseXML(input, (IniHandler)builder);
    }

    public Section remove(Section section) {
        return (Section)this.remove(section.getName());
    }

    public void store(OutputStream output) throws IOException {
        this.store(IniFormatter.newInstance(output, this.getConfig()));
    }

    public void store(Writer output) throws IOException {
        this.store(IniFormatter.newInstance(output, this.getConfig()));
    }

    public void storeToXML(OutputStream output) throws IOException {
        this.store(XMLFormatter.newInstance(output));
    }

    public void storeToXML(Writer output) throws IOException {
        this.store(XMLFormatter.newInstance(output));
    }

    @Deprecated
    public synchronized <T> T to(Class<T> clazz) {
        Object bean = null;
        if (this._beans == null) {
            this._beans = new HashMap<Class, Object>();
        } else {
            bean = this._beans.get(clazz);
        }
        if (bean == null) {
            bean = this.as(clazz);
            this._beans.put(clazz, bean);
        }
        return clazz.cast(bean);
    }

    protected Config getConfig() {
        return this._config;
    }

    protected void resolve(StringBuffer buffer, Section owner) {
        Matcher m = EXPRESSION.matcher(buffer);
        while (m.find()) {
            String sectionName = m.group(2);
            String optionName = m.group(5);
            int optionIndex = this.parseOptionIndex(m);
            Section section = this.parseSection(m, owner);
            String value = null;
            if (SECTION_ENVIRONMENT.equals(sectionName)) {
                value = System.getenv(optionName);
            } else if (SECTION_SYSTEM_PROPERTIES.equals(sectionName)) {
                value = System.getProperty(optionName);
            } else if (section != null) {
                String string = value = optionIndex == -1 ? section.fetch(optionName) : section.fetch(optionName, optionIndex);
            }
            if (value == null) continue;
            buffer.replace(m.start(), m.end(), value);
            m.reset(buffer);
        }
    }

    protected void store(IniHandler formatter) throws IOException {
        formatter.startIni();
        for (Section s : this.values()) {
            formatter.startSection(s.getName());
            for (String name : s.keySet()) {
                int n = this.getConfig().isMultiOption() ? s.length(name) : 1;
                for (int i = 0; i < n; ++i) {
                    formatter.handleOption(name, (String)s.get(name, i));
                }
            }
            formatter.endSection();
        }
        formatter.endIni();
    }

    private int parseOptionIndex(Matcher m) {
        return m.group(7) == null ? -1 : Integer.parseInt(m.group(7));
    }

    private Section parseSection(Matcher m, Section owner) {
        String sectionName = m.group(2);
        int sectionIndex = this.parseSectionIndex(m);
        return sectionName == null ? owner : (sectionIndex == -1 ? (Section)this.get(sectionName) : (Section)this.get(sectionName, sectionIndex));
    }

    private int parseSectionIndex(Matcher m) {
        return m.group(4) == null ? -1 : Integer.parseInt(m.group(4));
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanInvocationHandler
    extends AbstractBeanInvocationHandler {
        private final MultiMap<String, Object> _sectionBeans = new MultiMapImpl<String, Object>();

        private BeanInvocationHandler() {
        }

        @Override
        protected Object getPropertySpi(String property, Class<?> clazz) {
            Object o = null;
            if (clazz.isArray()) {
                int i;
                if (!this._sectionBeans.containsKey(property) && Ini.this.containsKey(property)) {
                    for (i = 0; i < Ini.this.length(property); ++i) {
                        this._sectionBeans.add(property, ((Section)Ini.this.get(property, i)).as(clazz.getComponentType()));
                    }
                }
                if (this._sectionBeans.containsKey(property)) {
                    o = Array.newInstance(clazz.getComponentType(), this._sectionBeans.length(property));
                    for (i = 0; i < this._sectionBeans.length(property); ++i) {
                        Array.set(o, i, this._sectionBeans.get(property, i));
                    }
                }
            } else {
                Section section;
                o = this._sectionBeans.get(property);
                if (o == null && (section = (Section)Ini.this.get(property)) != null) {
                    o = section.as(clazz);
                    this._sectionBeans.put(property, o);
                }
            }
            return o;
        }

        @Override
        protected void setPropertySpi(String property, Object value, Class<?> clazz) {
            Ini.this.remove(property);
            if (value != null) {
                if (clazz.isArray()) {
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        Section sec = Ini.this.add(property);
                        sec.from(Array.get(value, i));
                    }
                } else {
                    Section sec = Ini.this.add(property);
                    sec.from(value);
                }
            }
        }

        @Override
        protected boolean hasPropertySpi(String property) {
            return Ini.this.containsKey(property);
        }
    }

    private class Builder
    implements IniHandler {
        private Section _currentSection;

        private Builder() {
        }

        public void endIni() {
        }

        public void endSection() {
            this._currentSection = null;
        }

        public void handleOption(String name, String value) {
            if (Ini.this.getConfig().isMultiOption()) {
                this._currentSection.add(name, value);
            } else {
                this._currentSection.put(name, value);
            }
        }

        public void startIni() {
        }

        public void startSection(String sectionName) {
            Section s;
            this._currentSection = Ini.this.getConfig().isMultiSection() ? Ini.this.add(sectionName) : ((s = (Section)Ini.this.get(sectionName)) == null ? Ini.this.add(sectionName) : s);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Section
    extends OptionMapImpl {
        private Map<Class, Object> _beans;
        private final String _name;

        public Section(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        @Deprecated
        public synchronized <T> T to(Class<T> clazz) {
            Object bean = null;
            if (this._beans == null) {
                this._beans = new HashMap<Class, Object>();
            } else {
                bean = this._beans.get(clazz);
            }
            if (bean == null) {
                bean = this.as(clazz);
                this._beans.put(clazz, bean);
            }
            return clazz.cast(bean);
        }

        @Override
        protected void resolve(StringBuffer buffer) {
            Ini.this.resolve(buffer, this);
        }
    }
}

