/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateModelListSequence;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.Constants;
import freemarker.template.utility.StringUtil;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

abstract class SequenceBuiltins {
    SequenceBuiltins() {
    }

    public static boolean modelsEqual(TemplateModel model1, TemplateModel model2, Environment env) throws TemplateModelException {
        if (env.isClassicCompatible()) {
            if (model1 == null) {
                model1 = TemplateScalarModel.EMPTY_STRING;
            }
            if (model2 == null) {
                model2 = TemplateScalarModel.EMPTY_STRING;
            }
        }
        int comp = -1;
        if (model1 instanceof TemplateNumberModel && model2 instanceof TemplateNumberModel) {
            Number first = ((TemplateNumberModel)model1).getAsNumber();
            Number second = ((TemplateNumberModel)model2).getAsNumber();
            ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : env.getTemplate().getArithmeticEngine();
            try {
                comp = ae.compareNumbers(first, second);
            }
            catch (TemplateException ex) {
                throw new TemplateModelException(ex);
            }
        } else if (model1 instanceof TemplateDateModel && model2 instanceof TemplateDateModel) {
            int rtype;
            TemplateDateModel ltdm = (TemplateDateModel)model1;
            TemplateDateModel rtdm = (TemplateDateModel)model2;
            int ltype = ltdm.getDateType();
            if (ltype != (rtype = rtdm.getDateType())) {
                throw new TemplateModelException("Can not compare dates of different type. Left date is of " + TemplateDateModel.TYPE_NAMES.get(ltype) + " type, right date is of " + TemplateDateModel.TYPE_NAMES.get(rtype) + " type.");
            }
            if (ltype == 0) {
                throw new TemplateModelException("Left date is of UNKNOWN type, and can not be compared.");
            }
            if (rtype == 0) {
                throw new TemplateModelException("Right date is of UNKNOWN type, and can not be compared.");
            }
            Date first = ltdm.getAsDate();
            Date second = rtdm.getAsDate();
            comp = first.compareTo(second);
        } else if (model1 instanceof TemplateScalarModel && model2 instanceof TemplateScalarModel) {
            String first = ((TemplateScalarModel)model1).getAsString();
            String second = ((TemplateScalarModel)model2).getAsString();
            comp = env.getCollator().compare(first, second);
        } else if (model1 instanceof TemplateBooleanModel && model2 instanceof TemplateBooleanModel) {
            boolean first = ((TemplateBooleanModel)model1).getAsBoolean();
            boolean second = ((TemplateBooleanModel)model2).getAsBoolean();
            comp = (first ? 1 : 0) - (second ? 1 : 0);
        }
        return comp == 0;
    }

    static abstract class SequenceBuiltIn
    extends BuiltIn {
        SequenceBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (!(model instanceof TemplateSequenceModel)) {
                throw SequenceBuiltIn.invalidTypeException(model, this.target, env, "sequence");
            }
            return this.calculateResult((TemplateSequenceModel)model);
        }

        abstract TemplateModel calculateResult(TemplateSequenceModel var1) throws TemplateModelException;
    }

    static class chunkBI
    extends SequenceBuiltIn {
        chunkBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            return new BIMethod(tsm);
        }

        private static class BIMethod
        implements TemplateMethodModelEx {
            private final TemplateSequenceModel tsm;

            private BIMethod(TemplateSequenceModel tsm) {
                this.tsm = tsm;
            }

            public Object exec(List args) throws TemplateModelException {
                int numArgs = args.size();
                if (numArgs != 1 && numArgs != 2) {
                    throw new TemplateModelException("?chunk(...) expects 1 or 2 arguments.");
                }
                Object chunkSize = args.get(0);
                if (!(chunkSize instanceof TemplateNumberModel)) {
                    throw new TemplateModelException("?chunk(...) expects a number as its 1st argument.");
                }
                return new ChunkedSequence(this.tsm, ((TemplateNumberModel)chunkSize).getAsNumber().intValue(), numArgs > 1 ? (TemplateModel)args.get(1) : null);
            }
        }

        private static class ChunkedSequence
        implements TemplateSequenceModel {
            private final TemplateSequenceModel wrappedTsm;
            private final int chunkSize;
            private final TemplateModel fillerItem;
            private final int numberOfChunks;

            private ChunkedSequence(TemplateSequenceModel wrappedTsm, int chunkSize, TemplateModel fillerItem) throws TemplateModelException {
                if (chunkSize < 1) {
                    throw new TemplateModelException("The 1st argument to ?chunk(...) must be at least 1.");
                }
                this.wrappedTsm = wrappedTsm;
                this.chunkSize = chunkSize;
                this.fillerItem = fillerItem;
                this.numberOfChunks = (wrappedTsm.size() + chunkSize - 1) / chunkSize;
            }

            public TemplateModel get(final int chunkIndex) throws TemplateModelException {
                if (chunkIndex >= this.numberOfChunks) {
                    return null;
                }
                return new TemplateSequenceModel(){
                    private final int baseIndex;
                    {
                        this.baseIndex = chunkIndex * ChunkedSequence.this.chunkSize;
                    }

                    public TemplateModel get(int relIndex) throws TemplateModelException {
                        int absIndex = this.baseIndex + relIndex;
                        if (absIndex < ChunkedSequence.this.wrappedTsm.size()) {
                            return ChunkedSequence.this.wrappedTsm.get(absIndex);
                        }
                        return absIndex < ChunkedSequence.this.numberOfChunks * ChunkedSequence.this.chunkSize ? ChunkedSequence.this.fillerItem : null;
                    }

                    public int size() throws TemplateModelException {
                        return ChunkedSequence.this.fillerItem != null || chunkIndex + 1 < ChunkedSequence.this.numberOfChunks ? ChunkedSequence.this.chunkSize : ChunkedSequence.this.wrappedTsm.size() - this.baseIndex;
                    }
                };
            }

            public int size() throws TemplateModelException {
                return this.numberOfChunks;
            }
        }
    }

    static class firstBI
    extends SequenceBuiltIn {
        firstBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            if (tsm.size() == 0) {
                return null;
            }
            return tsm.get(0);
        }
    }

    static class lastBI
    extends SequenceBuiltIn {
        lastBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            if (tsm.size() == 0) {
                return null;
            }
            return tsm.get(tsm.size() - 1);
        }
    }

    static class reverseBI
    extends SequenceBuiltIn {
        reverseBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) {
            if (tsm instanceof ReverseSequence) {
                return ((ReverseSequence)tsm).seq;
            }
            return new ReverseSequence(tsm);
        }

        private static class ReverseSequence
        implements TemplateSequenceModel {
            private final TemplateSequenceModel seq;

            ReverseSequence(TemplateSequenceModel seq) {
                this.seq = seq;
            }

            public int size() throws TemplateModelException {
                return this.seq.size();
            }

            public TemplateModel get(int index) throws TemplateModelException {
                return this.seq.get(this.seq.size() - 1 - index);
            }
        }
    }

    static class seq_containsBI
    extends BuiltIn {
        seq_containsBI() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateSequenceModel) {
                return new BIMethodForSequence((TemplateSequenceModel)model, env);
            }
            if (model instanceof TemplateCollectionModel) {
                return new BIMethodForCollection((TemplateCollectionModel)model, env);
            }
            throw seq_containsBI.invalidTypeException(model, this.target, env, "sequence or collection");
        }

        private class BIMethodForCollection
        implements TemplateMethodModelEx {
            private TemplateCollectionModel m_coll;
            private Environment m_env;

            private BIMethodForCollection(TemplateCollectionModel coll, Environment env) {
                this.m_coll = coll;
                this.m_env = env;
            }

            public Object exec(List args) throws TemplateModelException {
                if (args.size() != 1) {
                    throw new TemplateModelException("?seq_contains(...) expects one argument.");
                }
                TemplateModel arg = (TemplateModel)args.get(0);
                TemplateModelIterator it = this.m_coll.iterator();
                while (it.hasNext()) {
                    if (!SequenceBuiltins.modelsEqual(it.next(), arg, this.m_env)) continue;
                    return TemplateBooleanModel.TRUE;
                }
                return TemplateBooleanModel.FALSE;
            }
        }

        private class BIMethodForSequence
        implements TemplateMethodModelEx {
            private TemplateSequenceModel m_seq;
            private Environment m_env;

            private BIMethodForSequence(TemplateSequenceModel seq, Environment env) {
                this.m_seq = seq;
                this.m_env = env;
            }

            public Object exec(List args) throws TemplateModelException {
                if (args.size() != 1) {
                    throw new TemplateModelException("?seq_contains(...) expects one argument.");
                }
                TemplateModel arg = (TemplateModel)args.get(0);
                int size = this.m_seq.size();
                for (int i = 0; i < size; ++i) {
                    if (!SequenceBuiltins.modelsEqual(this.m_seq.get(i), arg, this.m_env)) continue;
                    return TemplateBooleanModel.TRUE;
                }
                return TemplateBooleanModel.FALSE;
            }
        }
    }

    static class seq_index_ofBI
    extends BuiltIn {
        private int m_dir;

        public seq_index_ofBI(int dir) {
            this.m_dir = dir;
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (!(model instanceof TemplateSequenceModel)) {
                throw seq_index_ofBI.invalidTypeException(model, this.target, env, "sequence");
            }
            return new BIMethod((TemplateSequenceModel)model, env);
        }

        private class BIMethod
        implements TemplateMethodModelEx {
            private TemplateSequenceModel m_seq;
            private Environment m_env;

            private BIMethod(TemplateSequenceModel seq, Environment env) {
                this.m_seq = seq;
                this.m_env = env;
            }

            public Object exec(List args) throws TemplateModelException {
                int startIndex;
                int argcnt = args.size();
                if (argcnt != 1 && argcnt != 2) {
                    throw new TemplateModelException(this.getBuiltinTemplate() + " expects 1 or 2 arguments.");
                }
                int seqSize = this.m_seq.size();
                TemplateModel arg = (TemplateModel)args.get(0);
                if (argcnt > 1) {
                    Object obj = args.get(1);
                    if (!(obj instanceof TemplateNumberModel)) {
                        throw new TemplateModelException(this.getBuiltinTemplate() + "expects a number as its second argument.");
                    }
                    startIndex = ((TemplateNumberModel)obj).getAsNumber().intValue();
                    if (seq_index_ofBI.this.m_dir == 1) {
                        if (startIndex >= seqSize) {
                            return Constants.MINUS_ONE;
                        }
                        if (startIndex < 0) {
                            startIndex = 0;
                        }
                    } else {
                        if (startIndex >= seqSize) {
                            startIndex = seqSize - 1;
                        }
                        if (startIndex < 0) {
                            return Constants.MINUS_ONE;
                        }
                    }
                } else {
                    startIndex = seq_index_ofBI.this.m_dir == 1 ? 0 : seqSize - 1;
                }
                if (seq_index_ofBI.this.m_dir == 1) {
                    for (int i = startIndex; i < seqSize; ++i) {
                        if (!SequenceBuiltins.modelsEqual(this.m_seq.get(i), arg, this.m_env)) continue;
                        return new SimpleNumber(i);
                    }
                } else {
                    for (int i = startIndex; i >= 0; --i) {
                        if (!SequenceBuiltins.modelsEqual(this.m_seq.get(i), arg, this.m_env)) continue;
                        return new SimpleNumber(i);
                    }
                }
                return Constants.MINUS_ONE;
            }

            private String getBuiltinTemplate() {
                if (seq_index_ofBI.this.m_dir == 1) {
                    return "?seq_indexOf(...)";
                }
                return "?seq_lastIndexOf(...)";
            }
        }
    }

    static class sortBI
    extends SequenceBuiltIn {
        static final int KEY_TYPE_STRING = 1;
        static final int KEY_TYPE_NUMBER = 2;
        static final int KEY_TYPE_DATE = 3;

        sortBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel seq) throws TemplateModelException {
            return sortBI.sort(seq, null);
        }

        static String startErrorMessage(Object keys) {
            return (keys == null ? "?sort" : "?sort_by(...)") + " failed: ";
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static TemplateSequenceModel sort(TemplateSequenceModel seq, String[] keys) throws TemplateModelException {
            int keyType;
            int i;
            int keyCnt;
            int ln = seq.size();
            if (ln == 0) {
                return seq;
            }
            ArrayList<Object> res = new ArrayList<Object>(ln);
            TemplateModel item = seq.get(0);
            if (keys != null) {
                keyCnt = keys.length;
                if (keyCnt == 0) {
                    keys = null;
                } else {
                    for (i = 0; i < keyCnt; ++i) {
                        if (!(item instanceof TemplateHashModel)) {
                            throw new TemplateModelException(sortBI.startErrorMessage(keys) + (i == 0 ? "You can't use ?sort_by when the sequence items are not hashes." : "The subvariable " + StringUtil.jQuote(keys[i - 1]) + " is not a hash, so ?sort_by " + "can't proceed by getting the " + StringUtil.jQuote(keys[i]) + " subvariable."));
                        }
                        if ((item = ((TemplateHashModel)item).get(keys[i])) != null) continue;
                        throw new TemplateModelException(sortBI.startErrorMessage(keys) + "The " + StringUtil.jQuote(keys[i]) + " subvariable " + (keyCnt == 1 ? "was not found." : "(specified by ?sort_by argument number " + (i + 1) + ") was not found."));
                    }
                }
            } else {
                keyCnt = 0;
            }
            if (item instanceof TemplateScalarModel) {
                keyType = 1;
            } else if (item instanceof TemplateNumberModel) {
                keyType = 2;
            } else {
                if (!(item instanceof TemplateDateModel)) throw new TemplateModelException(sortBI.startErrorMessage(keys) + "Values used for sorting must be numbers, strings, or date/time values.");
                keyType = 3;
            }
            if (keys == null) {
                if (keyType == 1) {
                    for (i = 0; i < ln; ++i) {
                        item = seq.get(i);
                        try {
                            res.add(new KVP(((TemplateScalarModel)item).getAsString(), item));
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            if (item instanceof TemplateScalarModel) throw classCastException;
                            throw new TemplateModelException(sortBI.startErrorMessage(keys) + "All values in the sequence must be " + "strings, because the first value " + "was a string. " + "The value at index " + i + " is not string.");
                        }
                    }
                } else if (keyType == 2) {
                    for (i = 0; i < ln; ++i) {
                        item = seq.get(i);
                        try {
                            res.add(new KVP(((TemplateNumberModel)item).getAsNumber(), item));
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            if (item instanceof TemplateNumberModel) throw classCastException;
                            throw new TemplateModelException(sortBI.startErrorMessage(keys) + "All values in the sequence must be " + "numbers, because the first value " + "was a number. " + "The value at index " + i + " is not number.");
                        }
                    }
                } else {
                    if (keyType != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
                    for (i = 0; i < ln; ++i) {
                        item = seq.get(i);
                        try {
                            res.add(new KVP(((TemplateDateModel)item).getAsDate(), item));
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            if (item instanceof TemplateNumberModel) throw classCastException;
                            throw new TemplateModelException(sortBI.startErrorMessage(keys) + "All values in the sequence must be " + "date/time values, because the first " + "value was a date/time. " + "The value at index " + i + " is not date/time.");
                        }
                    }
                }
            } else {
                for (i = 0; i < ln; ++i) {
                    void var8_11;
                    TemplateModel templateModel = item = seq.get(i);
                    for (int j = 0; j < keyCnt; ++j) {
                        TemplateModel templateModel2;
                        try {
                            templateModel2 = ((TemplateHashModel)var8_11).get(keys[j]);
                        }
                        catch (ClassCastException e) {
                            if (var8_11 instanceof TemplateHashModel) throw e;
                            throw new TemplateModelException(sortBI.startErrorMessage(keys) + "Problem with the sequence item at index " + i + ": " + "Can't get the " + StringUtil.jQuote(keys[j]) + " subvariable, because the value is not a hash.");
                        }
                        if (templateModel2 != null) continue;
                        throw new TemplateModelException(sortBI.startErrorMessage(keys) + "Problem with the sequence item at index " + i + ": " + "The " + StringUtil.jQuote(keys[j]) + " subvariable was not found.");
                    }
                    if (keyType == 1) {
                        try {
                            res.add(new KVP(((TemplateScalarModel)var8_11).getAsString(), item));
                            continue;
                        }
                        catch (ClassCastException e) {
                            if (var8_11 instanceof TemplateScalarModel) throw e;
                            throw new TemplateModelException(sortBI.startErrorMessage(keys) + "All key values in the sequence must be " + "date/time values, because the first key " + "value was a date/time. The key value at " + "index " + i + " is not a date/time.");
                        }
                    }
                    if (keyType == 2) {
                        try {
                            res.add(new KVP(((TemplateNumberModel)var8_11).getAsNumber(), item));
                            continue;
                        }
                        catch (ClassCastException e) {
                            if (var8_11 instanceof TemplateNumberModel) continue;
                            throw new TemplateModelException(sortBI.startErrorMessage(keys) + "All key values in the sequence must be " + "numbers, because the first key " + "value was a number. The key value at " + "index " + i + " is not a number.");
                        }
                    }
                    if (keyType != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
                    try {
                        res.add(new KVP(((TemplateDateModel)var8_11).getAsDate(), item));
                        continue;
                    }
                    catch (ClassCastException e) {
                        if (var8_11 instanceof TemplateDateModel) continue;
                        throw new TemplateModelException(sortBI.startErrorMessage(keys) + "All key values in the sequence must be " + "dates, because the first key " + "value was a date. The key value at " + "index " + i + " is not a date.");
                    }
                }
            }
            if (keyType == 1) {
                LexicalKVPComparator lexicalKVPComparator = new LexicalKVPComparator(Environment.getCurrentEnvironment().getCollator());
            } else if (keyType == 2) {
                NumericalKVPComparator numericalKVPComparator = new NumericalKVPComparator(Environment.getCurrentEnvironment().getArithmeticEngine());
            } else {
                if (keyType != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
                DateKVPComparator dateKVPComparator = new DateKVPComparator();
            }
            try {
                void var8_17;
                Collections.sort(res, var8_17);
            }
            catch (ClassCastException exc) {
                throw new TemplateModelException(sortBI.startErrorMessage(keys) + "Unexpected error while sorting:" + exc, exc);
            }
            for (i = 0; i < ln; ++i) {
                res.set(i, ((KVP)res.get(i)).value);
            }
            return new TemplateModelListSequence(res);
        }

        private static class DateKVPComparator
        implements Comparator {
            private DateKVPComparator() {
            }

            public int compare(Object arg0, Object arg1) {
                return ((Date)((KVP)arg0).key).compareTo((Date)((KVP)arg1).key);
            }
        }

        private static class KVP {
            private Object key;
            private Object value;

            private KVP(Object key, Object value) {
                this.key = key;
                this.value = value;
            }
        }

        private static class LexicalKVPComparator
        implements Comparator {
            private Collator collator;

            LexicalKVPComparator(Collator collator) {
                this.collator = collator;
            }

            public int compare(Object arg0, Object arg1) {
                return this.collator.compare(((KVP)arg0).key, ((KVP)arg1).key);
            }
        }

        private static class NumericalKVPComparator
        implements Comparator {
            private ArithmeticEngine ae;

            private NumericalKVPComparator(ArithmeticEngine ae) {
                this.ae = ae;
            }

            public int compare(Object arg0, Object arg1) {
                try {
                    return this.ae.compareNumbers((Number)((KVP)arg0).key, (Number)((KVP)arg1).key);
                }
                catch (TemplateException e) {
                    throw new ClassCastException("Failed to compare numbers: " + e);
                }
            }
        }
    }

    static class sort_byBI
    extends sortBI {
        sort_byBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel seq) {
            return new BIMethod(seq);
        }

        static class BIMethod
        implements TemplateMethodModelEx {
            TemplateSequenceModel seq;

            BIMethod(TemplateSequenceModel seq) {
                this.seq = seq;
            }

            public Object exec(List params) throws TemplateModelException {
                String[] subvars;
                if (params.size() == 0) {
                    throw new TemplateModelException("?sort_by(key) needs exactly 1 argument.");
                }
                Object obj = params.get(0);
                if (obj instanceof TemplateScalarModel) {
                    subvars = new String[]{((TemplateScalarModel)obj).getAsString()};
                } else if (obj instanceof TemplateSequenceModel) {
                    TemplateSequenceModel seq = (TemplateSequenceModel)obj;
                    int ln = seq.size();
                    subvars = new String[ln];
                    for (int i = 0; i < ln; ++i) {
                        TemplateModel item = seq.get(i);
                        try {
                            subvars[i] = ((TemplateScalarModel)item).getAsString();
                            continue;
                        }
                        catch (ClassCastException e) {
                            if (item instanceof TemplateScalarModel) continue;
                            throw new TemplateModelException("The argument to ?sort_by(key), when it is a sequence, must be a sequence of strings, but the item at index " + i + " is not a string.");
                        }
                    }
                } else {
                    throw new TemplateModelException("The argument to ?sort_by(key) must be a string (the name of the subvariable), or a sequence of strings (the \"path\" to the subvariable).");
                }
                return sortBI.sort(this.seq, subvars);
            }
        }
    }
}

