/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.navigation.Icons;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UiUtils {
    private static final Logger LOG = Logger.getLogger(UiUtils.class.getName());

    public static boolean open(Source source, ElementHandle elementHandle) {
        assert (source != null);
        assert (elementHandle != null);
        DeclarationFinder.DeclarationLocation declarationLocation = UiUtils.getElementLocation(source, elementHandle);
        if (declarationLocation != DeclarationFinder.DeclarationLocation.NONE) {
            return UiUtils.doOpen(declarationLocation.getFileObject(), declarationLocation.getOffset());
        }
        return false;
    }

    public static boolean open(final FileObject fileObject, final int n) {
        assert (fileObject != null);
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UiUtils.doOpen(fileObject, n);
                }
            });
            return true;
        }
        return UiUtils.doOpen(fileObject, n);
    }

    public static ImageIcon getElementIcon(ElementKind elementKind, Collection<Modifier> collection) {
        return Icons.getElementIcon(elementKind, collection);
    }

    private UiUtils() {
    }

    private static boolean doOpen(FileObject fileObject, int n) {
        try {
            Object object;
            EditorCookie editorCookie = DataLoadersBridge.getDefault().getCookie(fileObject, EditorCookie.class);
            LineCookie lineCookie = DataLoadersBridge.getDefault().getCookie(fileObject, LineCookie.class);
            if (editorCookie != null && lineCookie != null && n != -1 && (object = editorCookie.openDocument()) != null) {
                Line line;
                int n2 = NbDocument.findLineNumber((StyledDocument)object, (int)n);
                int n3 = NbDocument.findLineOffset((StyledDocument)object, (int)n2);
                int n4 = n - n3;
                if (n2 != -1 && (line = lineCookie.getLineSet().getCurrent(n2)) != null) {
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, n4);
                    return true;
                }
            }
            if ((object = DataLoadersBridge.getDefault().getCookie(fileObject, OpenCookie.class)) != null) {
                object.open();
                return true;
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
        return false;
    }

    private static DeclarationFinder.DeclarationLocation getElementLocation(Source source, final ElementHandle elementHandle) {
        if (source.getFileObject() == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        FileObject fileObject = elementHandle.getFileObject();
        if (fileObject != null && fileObject != source.getFileObject()) {
            return new DeclarationFinder.DeclarationLocation(fileObject, -1);
        }
        final DeclarationFinder.DeclarationLocation[] declarationLocationArray = new DeclarationFinder.DeclarationLocation[]{null};
        try {
            Future future = ParserManager.parseWhenScanFinished(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws ParseException {
                    ParserResult parserResult2;
                    OffsetRange offsetRange;
                    Object object;
                    if (resultIterator.getSnapshot().getMimeType().equals(elementHandle.getMimeType()) && (object = resultIterator.getParserResult()) instanceof ParserResult && (offsetRange = elementHandle.getOffsetRange(parserResult2 = (ParserResult)((Object)object))) != OffsetRange.NONE && offsetRange != null) {
                        declarationLocationArray[0] = new DeclarationFinder.DeclarationLocation(parserResult2.getSnapshot().getSource().getFileObject(), offsetRange.getStart());
                        return;
                    }
                    for (ParserResult parserResult2 : resultIterator.getEmbeddings()) {
                        this.run(resultIterator.getResultIterator((Embedding)parserResult2));
                        if (declarationLocationArray[0] == null) continue;
                        break;
                    }
                }
            });
            if (!future.isDone()) {
                future.cancel(true);
                return new DeclarationFinder.DeclarationLocation(source.getFileObject(), -1);
            }
        }
        catch (ParseException parseException) {
            LOG.log(Level.WARNING, null, parseException);
        }
        return declarationLocationArray[0] == null ? DeclarationFinder.DeclarationLocation.NONE : declarationLocationArray[0];
    }
}

