/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.semantic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.editor.semantic.SequenceElement;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsfSemanticLayer
extends AbstractHighlightsContainer
implements DocumentListener {
    private SortedSet<SequenceElement> colorings;
    private int version;
    private List<Edit> edits;
    private Map<Language, Map<ColoringAttributes.Coloring, AttributeSet>> CACHE = new HashMap<Language, Map<ColoringAttributes.Coloring, AttributeSet>>();
    private Document doc;
    private static final SortedSet<SequenceElement> EMPTY_TREE_SET = new TreeSet<SequenceElement>();

    public static GsfSemanticLayer getLayer(Class clazz, Document document) {
        GsfSemanticLayer gsfSemanticLayer = (GsfSemanticLayer)document.getProperty(clazz);
        if (gsfSemanticLayer == null) {
            gsfSemanticLayer = new GsfSemanticLayer(document);
            document.putProperty(clazz, gsfSemanticLayer);
        }
        return gsfSemanticLayer;
    }

    private GsfSemanticLayer(Document document) {
        this.doc = document;
        this.colorings = EMPTY_TREE_SET;
        this.version = -1;
    }

    void setColorings(final SortedSet<SequenceElement> sortedSet, final int n) {
        NbDocument.runAtomic((StyledDocument)((StyledDocument)this.doc), (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GsfSemanticLayer gsfSemanticLayer = GsfSemanticLayer.this;
                synchronized (gsfSemanticLayer) {
                    GsfSemanticLayer.this.colorings = sortedSet;
                    GsfSemanticLayer.this.edits = new ArrayList();
                    GsfSemanticLayer.this.version = n;
                    GsfSemanticLayer.this.fireHighlightsChange(0, GsfSemanticLayer.this.doc.getLength());
                    DocumentUtilities.removeDocumentListener((Document)GsfSemanticLayer.this.doc, (DocumentListener)GsfSemanticLayer.this, (DocumentListenerPriority)DocumentListenerPriority.LEXER);
                    DocumentUtilities.addDocumentListener((Document)GsfSemanticLayer.this.doc, (DocumentListener)GsfSemanticLayer.this, (DocumentListenerPriority)DocumentListenerPriority.LEXER);
                }
            }
        });
    }

    synchronized SortedSet<SequenceElement> getColorings() {
        return this.colorings;
    }

    synchronized int getVersion() {
        return this.version;
    }

    public synchronized HighlightsSequence getHighlights(int n, int n2) {
        if (this.colorings.isEmpty()) {
            return HighlightsSequence.EMPTY;
        }
        return new GsfHighlightSequence(this, this.doc, n, n2, this.colorings);
    }

    public synchronized void clearColoringCache() {
        this.CACHE.clear();
    }

    synchronized AttributeSet getColoring(ColoringAttributes.Coloring coloring, Language language) {
        Map<ColoringAttributes.Coloring, AttributeSet> map = this.CACHE.get(language);
        if (map == null) {
            AttributeSet attributeSet = language.getColoringManager().getColoringImpl(coloring);
            map = new HashMap<ColoringAttributes.Coloring, AttributeSet>();
            map.put(coloring, attributeSet);
            this.CACHE.put(language, map);
            return attributeSet;
        }
        AttributeSet attributeSet = map.get(coloring);
        if (attributeSet == null) {
            attributeSet = language.getColoringManager().getColoringImpl(coloring);
            map.put(coloring, attributeSet);
        }
        return attributeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        GsfSemanticLayer gsfSemanticLayer = this;
        synchronized (gsfSemanticLayer) {
            this.edits.add(new Edit(documentEvent.getOffset(), documentEvent.getLength(), true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        GsfSemanticLayer gsfSemanticLayer = this;
        synchronized (gsfSemanticLayer) {
            this.edits.add(new Edit(documentEvent.getOffset(), documentEvent.getLength(), false));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public int getShiftedPos(int n) {
        List<Edit> list = this.edits;
        int n2 = list.size();
        if (n2 == 0) {
            return n;
        }
        for (int i = 0; i < n2; ++i) {
            Edit edit = list.get(i);
            if (n <= edit.offset) continue;
            if (edit.insert) {
                n += edit.len;
                continue;
            }
            if (n < edit.offset + edit.len) {
                n = edit.offset;
                continue;
            }
            n -= edit.len;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    private class Edit {
        int offset;
        int len;
        boolean insert;

        public Edit(int n, int n2, boolean bl) {
            this.offset = n;
            this.len = n2;
            this.insert = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GsfHighlightSequence
    implements HighlightsSequence {
        private Iterator<SequenceElement> iterator;
        private SequenceElement element;
        private final GsfSemanticLayer layer;
        private final int endOffset;

        GsfHighlightSequence(GsfSemanticLayer gsfSemanticLayer, Document document, int n, int n2, SortedSet<SequenceElement> sortedSet) {
            this.layer = gsfSemanticLayer;
            this.endOffset = n2;
            SequenceElement.ComparisonItem comparisonItem = new SequenceElement.ComparisonItem(n);
            SortedSet<SequenceElement> sortedSet2 = sortedSet.tailSet(comparisonItem);
            this.iterator = sortedSet2.iterator();
        }

        public boolean moveNext() {
            if (this.iterator != null && this.iterator.hasNext()) {
                this.element = this.iterator.next();
                if (this.element.range.getStart() < this.endOffset) {
                    return true;
                }
                this.iterator = null;
                return false;
            }
            return false;
        }

        public int getStartOffset() {
            return this.layer.getShiftedPos(this.element.range.getStart());
        }

        public int getEndOffset() {
            return this.layer.getShiftedPos(this.element.range.getEnd());
        }

        public AttributeSet getAttributes() {
            ColoringAttributes.Coloring coloring = this.element.coloring;
            return this.layer.getColoring(coloring, this.element.language);
        }
    }
}

