/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.semantic;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.editor.semantic.ColoringManager;
import org.netbeans.modules.csl.editor.semantic.GsfSemanticLayer;
import org.netbeans.modules.csl.editor.semantic.SequenceElement;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticHighlighter
extends ParserResultTask<ParserResult> {
    private static final Logger LOG = Logger.getLogger(SemanticHighlighter.class.getName());
    private boolean cancelled;

    SemanticHighlighter() {
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public final synchronized void cancel() {
        this.cancelled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public void run(ParserResult parserResult, SchedulerEvent schedulerEvent) {
        this.resume();
        Document document = parserResult.getSnapshot().getSource().getDocument(false);
        if (document == null) {
            return;
        }
        long l = System.currentTimeMillis();
        Source source = parserResult.getSnapshot().getSource();
        final TreeSet treeSet = new TreeSet();
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    String string = resultIterator.getSnapshot().getMimeType();
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(string);
                    if (language != null) {
                        ColoringManager coloringManager = language.getColoringManager();
                        SemanticAnalyzer semanticAnalyzer = language.getSemanticAnalyzer();
                        if (coloringManager != null && semanticAnalyzer != null) {
                            Parser.Result result = resultIterator.getParserResult();
                            String string2 = result.getSnapshot().getMimeType();
                            if (!string2.equals(string)) {
                                throw new IllegalStateException("resultIterator.getSnapshot().getMimeType() [" + string + "] != resultIterator.getParserResult().getSnapshot().getMimeType() [" + string2 + "; mimepath = " + result.getSnapshot().getMimePath() + "]");
                            }
                            if (result instanceof ParserResult) {
                                SemanticHighlighter.this.process(language, (ParserResult)result, treeSet);
                            }
                        }
                    }
                    for (SemanticAnalyzer semanticAnalyzer : resultIterator.getEmbeddings()) {
                        if (SemanticHighlighter.this.isCancelled()) {
                            return;
                        }
                        this.run(resultIterator.getResultIterator((Embedding)semanticAnalyzer));
                    }
                }
            });
        }
        catch (ParseException parseException) {
            LOG.log(Level.WARNING, null, parseException);
            return;
        }
        long l2 = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Semantic (" + source.getMimeType() + ")", new Object[]{source.getFileObject(), l2 - l});
        if (this.isCancelled()) {
            return;
        }
        final GsfSemanticLayer gsfSemanticLayer = GsfSemanticLayer.getLayer(SemanticHighlighter.class, document);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                gsfSemanticLayer.setColorings(treeSet, -1);
            }
        });
    }

    private void process(Language language, ParserResult parserResult, Set<SequenceElement> set) throws ParseException {
        if (this.isCancelled()) {
            return;
        }
        ColoringManager coloringManager = language.getColoringManager();
        SemanticAnalyzer semanticAnalyzer = language.getSemanticAnalyzer();
        try {
            semanticAnalyzer.run(parserResult, null);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "SemanticAnalyzer = " + (Object)((Object)semanticAnalyzer) + "; Language = " + language + " (mimetype = " + language.getMimeType() + "; ParserResult = " + (Object)((Object)parserResult) + "(mimepath = " + parserResult.getSnapshot().getMimePath() + ")", exception);
        }
        if (this.isCancelled()) {
            semanticAnalyzer.cancel();
            return;
        }
        Map<OffsetRange, Set<ColoringAttributes>> map = semanticAnalyzer.getHighlights();
        if (map != null) {
            for (OffsetRange offsetRange : map.keySet()) {
                Set<ColoringAttributes> set2 = map.get(offsetRange);
                if (set2 == null) continue;
                ColoringAttributes.Coloring coloring = coloringManager.getColoring(set2);
                set.add(new SequenceElement(language, offsetRange, coloring));
                if (!this.isCancelled()) continue;
                return;
            }
        }
    }
}

