/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.navigation.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.csl.navigation.ClassMemberFilters;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public abstract class SortActionSupport
extends AbstractAction
implements Presenter.Popup {
    private JRadioButtonMenuItem menuItem;
    protected ClassMemberFilters filters;

    public SortActionSupport(ClassMemberFilters classMemberFilters) {
        this.filters = classMemberFilters;
    }

    public final JMenuItem getPopupPresenter() {
        JRadioButtonMenuItem jRadioButtonMenuItem = this.obtainMenuItem();
        this.updateMenuItem();
        return jRadioButtonMenuItem;
    }

    protected final JRadioButtonMenuItem obtainMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }
        return this.menuItem;
    }

    protected abstract void updateMenuItem();

    public static final class SortByNameAction
    extends SortActionSupport {
        public SortByNameAction(ClassMemberFilters classMemberFilters) {
            super(classMemberFilters);
            this.putValue("Name", NbBundle.getMessage(SortByNameAction.class, (String)"LBL_SortByName"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.filters.setNaturalSort(false);
            this.updateMenuItem();
        }

        protected void updateMenuItem() {
            JRadioButtonMenuItem jRadioButtonMenuItem = this.obtainMenuItem();
            jRadioButtonMenuItem.setSelected(!this.filters.isNaturalSort());
        }
    }

    public static final class SortBySourceAction
    extends SortActionSupport {
        public SortBySourceAction(ClassMemberFilters classMemberFilters) {
            super(classMemberFilters);
            this.putValue("Name", NbBundle.getMessage(SortBySourceAction.class, (String)"LBL_SortBySource"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.filters.setNaturalSort(true);
            this.updateMenuItem();
        }

        protected void updateMenuItem() {
            JRadioButtonMenuItem jRadioButtonMenuItem = this.obtainMenuItem();
            jRadioButtonMenuItem.setSelected(this.filters.isNaturalSort());
        }
    }
}

