/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.navigation.base;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.csl.navigation.base.FiltersDescription;

public final class FiltersManager {
    private FiltersComponent comp;

    static FiltersManager create(FiltersDescription filtersDescription) {
        return new FiltersManager(filtersDescription);
    }

    public boolean isSelected(String string) {
        return this.comp.isSelected(string);
    }

    public void setSelected(String string, boolean bl) {
        this.comp.setFilterSelected(string, bl);
    }

    public JComponent getComponent() {
        return this.comp;
    }

    public FiltersDescription getDescription() {
        return this.comp.getDescription();
    }

    public void hookChangeListener(FilterChangeListener filterChangeListener) {
        this.comp.hookFilterChangeListener(filterChangeListener);
    }

    private FiltersManager(FiltersDescription filtersDescription) {
        this.comp = new FiltersComponent(filtersDescription);
    }

    public static interface FilterChangeListener {
        public void filterStateChanged(ChangeEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FiltersComponent
    extends Box
    implements ActionListener {
        private List<JToggleButton> toggles;
        private final FiltersDescription filtersDesc;
        private Object L_LOCK;
        private FilterChangeListener clientL;
        private Object STATES_LOCK;
        private Map<String, Boolean> filterStates;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSelected(String string) {
            Boolean bl;
            Object object = this.STATES_LOCK;
            synchronized (object) {
                if (this.filterStates == null) {
                    int n = this.filterIndexForName(string);
                    if (n < 0) {
                        return false;
                    }
                    return this.filtersDesc.isSelected(n);
                }
                bl = this.filterStates.get(string);
            }
            if (bl == null) {
                throw new IllegalArgumentException("Filter " + string + " not found.");
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFilterSelected(String string, boolean bl) {
            assert (SwingUtilities.isEventDispatchThread());
            int n = this.filterIndexForName(string);
            if (n < 0) {
                throw new IllegalArgumentException("Filter " + string + " not found.");
            }
            this.toggles.get(n).setSelected(bl);
            Object object = this.STATES_LOCK;
            synchronized (object) {
                this.filterStates.put(string, bl);
            }
            this.fireChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hookFilterChangeListener(FilterChangeListener filterChangeListener) {
            Object object = this.L_LOCK;
            synchronized (object) {
                this.clientL = filterChangeListener;
            }
        }

        public FiltersDescription getDescription() {
            return this.filtersDesc;
        }

        FiltersComponent(FiltersDescription filtersDescription) {
            super(0);
            this.L_LOCK = new Object();
            this.STATES_LOCK = new Object();
            this.filtersDesc = filtersDescription;
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FiltersComponent.this.initPanel();
                    }
                });
            } else {
                this.initPanel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initPanel() {
            this.setBorder(new EmptyBorder(1, 2, 3, 5));
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.setRollover(true);
            jToolBar.setBorderPainted(false);
            int n = this.filtersDesc.getFilterCount();
            this.toggles = new ArrayList<JToggleButton>(n);
            JToggleButton jToggleButton = null;
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(n * 2);
            for (int i = 0; i < n; ++i) {
                jToggleButton = this.createToggle(hashMap, i);
                this.toggles.add(jToggleButton);
            }
            Dimension dimension = new Dimension(3, 0);
            for (int i = 0; i < this.toggles.size(); ++i) {
                JToggleButton jToggleButton2 = this.toggles.get(i);
                jToggleButton2.addActionListener(this);
                jToolBar.add(jToggleButton2);
                if (i == this.toggles.size() - 1) continue;
                jToolBar.addSeparator(dimension);
            }
            this.add(jToolBar);
            Object object = this.STATES_LOCK;
            synchronized (object) {
                this.filterStates = hashMap;
            }
        }

        private JToggleButton createToggle(Map<String, Boolean> map, int n) {
            boolean bl = this.filtersDesc.isSelected(n);
            Icon icon = this.filtersDesc.getSelectedIcon(n);
            JToggleButton jToggleButton = new JToggleButton(icon, bl);
            Dimension dimension = new Dimension(icon.getIconWidth() + 6, icon.getIconHeight() + 4);
            jToggleButton.setPreferredSize(dimension);
            jToggleButton.setMargin(new Insets(2, 3, 2, 3));
            jToggleButton.setToolTipText(this.filtersDesc.getTooltip(n));
            map.put(this.filtersDesc.getName(n), bl);
            return jToggleButton;
        }

        private int filterIndexForName(String string) {
            int n = this.filtersDesc.getFilterCount();
            for (int i = 0; i < n; ++i) {
                String string2 = this.filtersDesc.getName(i);
                if (!string.equals(string2)) continue;
                return i;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            int n = this.toggles.indexOf(actionEvent.getSource());
            Object object = this.STATES_LOCK;
            synchronized (object) {
                this.filterStates.put(this.filtersDesc.getName(n), jToggleButton.isSelected());
            }
            this.fireChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            FilterChangeListener filterChangeListener;
            Object object = this.L_LOCK;
            synchronized (object) {
                if (this.clientL == null) {
                    return;
                }
                filterChangeListener = this.clientL;
            }
            filterChangeListener.filterStateChanged(new ChangeEvent(FiltersManager.this));
        }
    }
}

