/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Comparator;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkVector;
import org.netbeans.editor.MultiMark;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public class Mark {
    private static final MarkComparator MARK_COMPARATOR = new MarkComparator();
    private BaseDocument doc;
    private MultiMark multiMark;
    private Position.Bias bias;

    public Mark() {
        this(Position.Bias.Forward);
    }

    public Mark(Position.Bias bias) {
        this.bias = bias;
    }

    public Mark(boolean bl) {
        this(bl ? Position.Bias.Backward : Position.Bias.Forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(BaseDocument baseDocument, int n) throws InvalidMarkException, BadLocationException {
        BaseDocument baseDocument2 = this.doc;
        if (baseDocument2 != null) {
            throw new InvalidMarkException("Mark already inserted: mark=" + this + ", class=" + this.getClass());
        }
        baseDocument2 = this.doc = baseDocument;
        MarkVector markVector = baseDocument.marksStorage;
        synchronized (markVector) {
            if (this.multiMark != null) {
                throw new IllegalStateException("Mark already inserted: mark=" + this + ", class=" + this.getClass());
            }
            if (n < 0 || n > baseDocument2.getLength() + 1) {
                throw new BadLocationException("Invalid offset", n);
            }
            if (n <= baseDocument2.getLength() && Character.isLowSurrogate(DocumentUtilities.getText((Document)baseDocument2).charAt(n))) {
                if (this.bias == Position.Bias.Forward && n < baseDocument2.getLength()) {
                    ++n;
                } else if (this.bias == Position.Bias.Backward && n > 0) {
                    --n;
                }
            }
            this.multiMark = baseDocument.marksStorage.createBiasMark(n, this.bias);
            baseDocument.marksStorage.insert(this.multiMark);
            baseDocument2.marks.put(this.multiMark, this);
        }
    }

    private void checkMarks(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            MultiMark multiMark = (MultiMark)entry.getKey();
            Mark mark = (Mark)entry.getValue();
            if (mark.multiMark == multiMark) continue;
            throw new IllegalStateException("m.class" + mark.getClass() + " mapped to wrong mark=" + multiMark);
        }
    }

    void move(BaseDocument baseDocument, int n) throws InvalidMarkException, BadLocationException {
        this.dispose();
        this.insert(baseDocument, n);
    }

    public final int getOffset() throws InvalidMarkException {
        BaseDocument baseDocument = this.doc;
        if (baseDocument != null) {
            MarkVector markVector = this.doc.marksStorage;
            synchronized (markVector) {
                if (this.multiMark != null) {
                    return this.multiMark.getOffset();
                }
                throw new InvalidMarkException();
            }
        }
        throw new InvalidMarkException();
    }

    public final int getLine() throws InvalidMarkException {
        BaseDocument baseDocument = this.doc;
        if (baseDocument != null) {
            MarkVector markVector = this.doc.marksStorage;
            synchronized (markVector) {
                if (this.multiMark != null) {
                    int n = this.multiMark.getOffset();
                    Element element = baseDocument.getParagraphElement(0).getParentElement();
                    return element.getElementIndex(n);
                }
                throw new InvalidMarkException();
            }
        }
        throw new InvalidMarkException();
    }

    public final boolean getInsertAfter() {
        return this.bias == Position.Bias.Backward;
    }

    public final boolean getBackwardBias() {
        return this.getInsertAfter();
    }

    public final Position.Bias getBias() {
        return this.bias;
    }

    int getBiasAsInt() {
        return this.bias == Position.Bias.Backward ? -1 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        BaseDocument baseDocument = this.doc;
        if (baseDocument != null) {
            MarkVector markVector = this.doc.marksStorage;
            synchronized (markVector) {
                if (this.multiMark != null) {
                    if (baseDocument.marks.remove(this.multiMark) != this) {
                        throw new IllegalStateException("Mark cannot be disposed mark=" + this + ", class=" + this.getClass());
                    }
                    this.multiMark.dispose();
                    this.multiMark = null;
                    this.doc = null;
                    return;
                }
            }
        }
        throw new IllegalStateException("Mark already disposed: mark=" + this + ", class=" + this.getClass());
    }

    public final void remove() throws InvalidMarkException {
        this.dispose();
    }

    public final int compare(int n) throws InvalidMarkException {
        return this.getOffset() - n;
    }

    protected void removeUpdateAction(int n, int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isValid() {
        BaseDocument baseDocument = this.doc;
        if (baseDocument != null) {
            MarkVector markVector = this.doc.marksStorage;
            synchronized (markVector) {
                return this.multiMark != null && this.multiMark.isValid();
            }
        }
        return false;
    }

    public String toString() {
        return "offset=" + (this.isValid() ? Integer.toString(this.multiMark.getOffset()) : "<invalid>") + ", bias=" + this.bias;
    }

    private static final class MarkComparator
    implements Comparator {
        private MarkComparator() {
        }

        public int compare(Object object, Object object2) {
            Mark mark = (Mark)object;
            Mark mark2 = (Mark)object2;
            try {
                int n = mark.getOffset() - mark2.getOffset();
                if (n != 0) {
                    return n;
                }
                return mark.getBiasAsInt() - mark2.getBiasAsInt();
            }
            catch (InvalidMarkException invalidMarkException) {
                throw new IllegalStateException(invalidMarkException.toString());
            }
        }
    }
}

