/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.DeepListener;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.MIMESupport;
import org.openide.filesystems.MemoryFileSystem;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.Ordering;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    private static final RequestProcessor REFRESH_RP = new RequestProcessor("FileUtil-Refresh-All");
    private static RequestProcessor.Task refreshTask = null;
    private static final Map<FileChangeListener, Map<File, Holder>> holders = new WeakHashMap<FileChangeListener, Map<File, Holder>>();
    private static final Logger LOG = Logger.getLogger(FileUtil.class.getName());
    private static byte[] ZIP_HEADER_1 = new byte[]{80, 75, 3, 4};
    private static byte[] ZIP_HEADER_2 = new byte[]{80, 75, 5, 6};
    static final Set<String> transientAttributes = new HashSet<String>();
    private static final Map<FileObject, Boolean> archiveFileCache;
    private static FileSystem diskFileSystem;

    private static FileSystem getDiskFileSystemFor(File ... fileArray) {
        FileSystem fileSystem = FileUtil.getDiskFileSystem();
        if (fileSystem == null) {
            for (File file : fileArray) {
                FileObject fileObject = FileUtil.toFileObject(file);
                fileSystem = FileUtil.getDiskFileSystem();
                if (fileSystem != null) break;
            }
        }
        return fileSystem;
    }

    private FileUtil() {
    }

    public static void refreshFor(File ... fileArray) {
        FileSystem fileSystem = FileUtil.getDiskFileSystemFor(fileArray);
        if (fileSystem != null) {
            try {
                fileSystem.getRoot().setAttribute("request_for_refreshing_files_be_aware_this_is_not_public_api", fileArray);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAll() {
        RequestProcessor.Task task;
        RequestProcessor requestProcessor = REFRESH_RP;
        synchronized (requestProcessor) {
            if (refreshTask != null) {
                refreshTask.cancel();
            } else {
                refreshTask = REFRESH_RP.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        LOG.fine("refreshAll - started");
                        FileUtil.refreshFor(File.listRoots());
                        try {
                            FileUtil.getConfigRoot().getFileSystem().refresh(true);
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                        }
                        finally {
                            LOG.fine("refreshAll - finished");
                            RequestProcessor requestProcessor = REFRESH_RP;
                            synchronized (requestProcessor) {
                                refreshTask = null;
                            }
                        }
                    }
                });
            }
            task = refreshTask;
            refreshTask.schedule(0);
            LOG.fine("refreshAll - scheduled");
        }
        task.waitFinished();
    }

    public static void addFileChangeListener(FileChangeListener fileChangeListener) {
        FileSystem fileSystem = FileUtil.getDiskFileSystem();
        if (fileSystem == null) {
            fileSystem = FileUtil.getDiskFileSystemFor(File.listRoots());
        }
        if (fileSystem != null) {
            fileSystem.addFileChangeListener(fileChangeListener);
        }
    }

    public static void removeFileChangeListener(FileChangeListener fileChangeListener) {
        FileSystem fileSystem = FileUtil.getDiskFileSystem();
        if (fileSystem == null) {
            fileSystem = FileUtil.getDiskFileSystemFor(File.listRoots());
        }
        if (fileSystem != null) {
            fileSystem.removeFileChangeListener(fileChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFileChangeListener(FileChangeListener fileChangeListener, File file) {
        assert (file.equals(FileUtil.normalizeFile(file))) : "Need to normalize " + file + "!";
        Map<FileChangeListener, Map<File, Holder>> map = holders;
        synchronized (map) {
            Map<File, Holder> map2 = holders.get(fileChangeListener);
            if (map2 == null) {
                map2 = new HashMap<File, Holder>();
                holders.put(fileChangeListener, map2);
            }
            if (map2.containsKey(file)) {
                throw new IllegalArgumentException("Already listening to " + file);
            }
            map2.put(file, new Holder(fileChangeListener, file));
        }
    }

    public static void removeFileChangeListener(FileChangeListener fileChangeListener, File file) {
        FileUtil.removeFileChangeListenerImpl(fileChangeListener, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileChangeListener removeFileChangeListenerImpl(FileChangeListener fileChangeListener, File file) {
        assert (file.equals(FileUtil.normalizeFile(file))) : "Need to normalize " + file + "!";
        Map<FileChangeListener, Map<File, Holder>> map = holders;
        synchronized (map) {
            Map<File, Holder> map2 = holders.get(fileChangeListener);
            if (map2 == null) {
                throw new IllegalArgumentException("Was not listening to " + file);
            }
            if (!map2.containsKey(file)) {
                throw new IllegalArgumentException(fileChangeListener + " was not listening to " + file + "; only to " + map2.keySet());
            }
            Holder holder = map2.remove(file);
            holder.run();
            return (FileChangeListener)holder.get();
        }
    }

    public static void addRecursiveListener(FileChangeListener fileChangeListener, File file) {
        FileUtil.addFileChangeListener(new DeepListener(fileChangeListener, file), file);
    }

    public static void removeRecursiveListener(FileChangeListener fileChangeListener, File file) {
        DeepListener deepListener = (DeepListener)FileUtil.removeFileChangeListenerImpl(new DeepListener(fileChangeListener, file), file);
        deepListener.run();
    }

    public static final void runAtomicAction(FileSystem.AtomicAction atomicAction) throws IOException {
        Repository.getDefault().getDefaultFileSystem().runAtomicAction(atomicAction);
    }

    public static final void runAtomicAction(final Runnable runnable) {
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            public void run() throws IOException {
                runnable.run();
            }
        };
        try {
            FileUtil.runAtomicAction(atomicAction);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public static FileObject createFolder(File file) throws IOException {
        File file2;
        for (file2 = file; file2 != null && !file2.isDirectory(); file2 = file2.getParentFile()) {
        }
        if (file2 == null) {
            throw new IOException(file.getAbsolutePath());
        }
        FileObject fileObject = null;
        FileObject fileObject2 = FileUtil.toFileObject(file2);
        assert (fileObject2 != null) : file2.getAbsolutePath();
        String string = FileUtil.getRelativePath(file2, file);
        try {
            fileObject = FileUtil.createFolder(fileObject2, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileObject == null || !fileObject.isValid()) {
            fileObject2.getFileSystem().refresh(false);
            fileObject = FileUtil.createFolder(fileObject2, string);
        }
        assert (fileObject != null);
        return fileObject;
    }

    public static FileObject createData(File file) throws IOException {
        File file2;
        for (file2 = file; file2 != null && !file2.isDirectory(); file2 = file2.getParentFile()) {
        }
        if (file2 == null) {
            throw new IOException(file.getAbsolutePath());
        }
        FileObject fileObject = null;
        FileObject fileObject2 = FileUtil.toFileObject(file2);
        assert (fileObject2 != null) : file2.getAbsolutePath();
        String string = FileUtil.getRelativePath(file2, file);
        try {
            fileObject = FileUtil.createData(fileObject2, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fileObject == null || !fileObject.isValid()) {
            fileObject2.getFileSystem().refresh(false);
            fileObject = FileUtil.createData(fileObject2, string);
        }
        assert (fileObject != null);
        return fileObject;
    }

    private static String getRelativePath(File file, File file2) {
        File file3;
        Stack<String> stack = new Stack<String>();
        for (file3 = file2; file3 != null && !file3.equals(file); file3 = file3.getParentFile()) {
            stack.push(file3.getName());
        }
        assert (file3 != null) : file2.getAbsolutePath() + "not found in " + file.getAbsolutePath();
        StringBuilder stringBuilder = new StringBuilder();
        while (!stack.isEmpty()) {
            stringBuilder.append((String)stack.pop());
            if (stack.isEmpty()) continue;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileObject copyFileImpl(FileObject fileObject, FileObject fileObject2, String string, String string2) throws IOException {
        FileObject fileObject3 = fileObject2.createData(string, string2);
        FileLock fileLock = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            fileLock = fileObject3.lock();
            inputStream = fileObject.getInputStream();
            outputStream = fileObject3 instanceof AbstractFileObject ? ((AbstractFileObject)fileObject3).getOutputStream(fileLock, false) : fileObject3.getOutputStream(fileLock);
            FileUtil.copy(inputStream, outputStream);
            FileUtil.copyAttributes(fileObject, fileObject3);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return fileObject3;
    }

    public static FileSystem createMemoryFileSystem() {
        return new MemoryFileSystem();
    }

    public static FileObject copyFile(FileObject fileObject, FileObject fileObject2, String string, String string2) throws IOException {
        return fileObject.copy(fileObject2, string, string2);
    }

    public static FileObject copyFile(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        return FileUtil.copyFile(fileObject, fileObject2, string, fileObject.getExt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject moveFile(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            FileObject fileObject3 = fileObject.move(fileLock, fileObject2, string, fileObject.getExt());
            return fileObject3;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public static FileObject createFolder(FileObject fileObject, String string) throws IOException {
        String string2 = File.separatorChar != '/' ? "/" + File.separatorChar : "/";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreElements()) {
            FileObject fileObject2;
            block4: {
                string = stringTokenizer.nextToken();
                if (string.length() <= 0) continue;
                fileObject2 = fileObject.getFileObject(string);
                if (fileObject2 == null) {
                    try {
                        LOG.finest("createFolder - before create folder if not exists.");
                        fileObject2 = fileObject.createFolder(string);
                    }
                    catch (IOException iOException) {
                        fileObject.refresh();
                        fileObject2 = fileObject.getFileObject(string);
                        if (fileObject2 != null) break block4;
                        throw iOException;
                    }
                }
            }
            fileObject = fileObject2;
        }
        return fileObject;
    }

    public static FileObject createData(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2;
        block10: {
            String string2;
            String string3;
            String string4;
            Parameters.notNull((CharSequence)"folder", (Object)fileObject);
            Parameters.notNull((CharSequence)"name", (Object)string);
            int n = string.lastIndexOf(47);
            if (n >= string.length()) {
                throw new IOException("Wrong file name.");
            }
            if (n != -1) {
                String string5 = string.substring(0, n);
                string4 = string.substring(n + 1);
                fileObject = FileUtil.createFolder(fileObject, string5);
                assert (fileObject != null);
            } else {
                string4 = string;
            }
            if ((n = string4.lastIndexOf(46)) != -1) {
                string3 = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            } else {
                string3 = string4;
                string2 = "";
            }
            fileObject2 = fileObject.getFileObject(string3, string2);
            if (fileObject2 == null) {
                try {
                    fileObject2 = fileObject.createData(string3, string2);
                    assert (fileObject2 != null) : "FileObject.createData cannot return null; called on " + fileObject + " + " + string3 + " + " + string2;
                }
                catch (SyncFailedException syncFailedException) {
                    fileObject.refresh();
                    fileObject2 = fileObject.getFileObject(string3, string2);
                    if (fileObject2 != null) break block10;
                    throw syncFailedException;
                }
            }
        }
        return fileObject2;
    }

    public static File toFile(FileObject fileObject) {
        File file = (File)fileObject.getAttribute("java.io.File");
        if (file == null) {
            URL uRL = URLMapper.findURL(fileObject, 0);
            if (uRL == null || !"file".equals(uRL.getProtocol())) {
                uRL = URLMapper.findURL(fileObject, 1);
            }
            if (uRL != null && "file".equals(uRL.getProtocol())) {
                file = new File(URI.create(uRL.toExternalForm()));
            }
            if (file != null) {
                file = FileUtil.normalizeFile(file);
            }
        }
        return file;
    }

    public static FileObject toFileObject(File file) {
        Serializable serializable;
        Serializable serializable2;
        Parameters.notNull((CharSequence)"file", (Object)file);
        if (file.getPath().equals("\\\\")) {
            return null;
        }
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl) {
            serializable2 = FileUtil.normalizeFile(file);
            if (!file.equals(serializable2)) {
                LOG.log(Level.WARNING, null, new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + serializable2));
            }
            file = serializable2;
        }
        serializable2 = null;
        try {
            serializable = file.toURI().toURL();
            if (serializable.getAuthority() != null && (Utilities.isWindows() || Utilities.getOperatingSystem() == 2048)) {
                return null;
            }
            serializable2 = URLMapper.findFileObject(serializable);
        }
        catch (MalformedURLException malformedURLException) {
            serializable2 = null;
        }
        if (serializable2 != null && FileUtil.getDiskFileSystem() == null) {
            try {
                serializable = ((FileObject)serializable2).getFileSystem();
                FileUtil.setDiskFileSystem((FileSystem)serializable);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        return serializable2;
    }

    @Deprecated
    public static FileObject[] fromFile(File file) {
        FileObject[] fileObjectArray;
        if (!file.equals(FileUtil.normalizeFile(file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile(file));
        }
        try {
            URL uRL = file.toURI().toURL();
            if (uRL.getAuthority() != null && (Utilities.isWindows() || Utilities.getOperatingSystem() == 2048)) {
                return null;
            }
            fileObjectArray = URLMapper.findFileObjects(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            fileObjectArray = null;
        }
        return fileObjectArray;
    }

    public static void copyAttributes(FileObject fileObject, FileObject fileObject2) throws IOException {
        Enumeration<String> enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = enumeration.nextElement();
            if (transientAttributes.contains(string) || FileUtil.isTransient(fileObject, string) || (object = fileObject.getAttribute(string)) == null || object instanceof MultiFileObject.VoidValue) continue;
            fileObject2.setAttribute(string, object);
        }
    }

    static boolean isTransient(FileObject fileObject, String string) {
        return XMLMapAttr.ModifiedAttribute.isTransient(fileObject, string);
    }

    @Deprecated
    public static void extractJar(final FileObject fileObject, final InputStream inputStream) throws IOException {
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileUtil.extractJarImpl(fileObject, inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractJarImpl(FileObject fileObject, InputStream inputStream) throws IOException {
        Object object;
        JarEntry jarEntry;
        HashMap<Object, DefaultAttributes.Table> hashMap = new HashMap<Object, DefaultAttributes.Table>(7);
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            String string = jarEntry.getName();
            if (string.toLowerCase().startsWith("meta-inf/")) continue;
            if (jarEntry.isDirectory()) {
                FileUtil.createFolder(fileObject, string);
                continue;
            }
            if (DefaultAttributes.acceptName(string)) {
                DefaultAttributes.Table table = DefaultAttributes.loadTable(jarInputStream, string);
                hashMap.put(string, table);
                continue;
            }
            FileObject fileObject2 = FileUtil.createData(fileObject, string);
            object = fileObject2.lock();
            try {
                OutputStream outputStream = fileObject2.getOutputStream((FileLock)object);
                try {
                    FileUtil.copy(jarInputStream, outputStream);
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                ((FileLock)object).releaseLock();
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            int n = ((String)object).lastIndexOf(47);
            String string = n != -1 ? ((String)object).substring(0, n + 1) : "";
            String string2 = fileObject.isRoot() ? string : fileObject.getPath() + '/' + string;
            DefaultAttributes.Table table = (DefaultAttributes.Table)entry.getValue();
            for (String string3 : table.keySet()) {
                String string4 = string2 + string3;
                FileObject fileObject3 = fileObject.getFileSystem().findResource(string4);
                if (fileObject3 == null) continue;
                Enumeration<String> enumeration = table.attrs(string3);
                while (enumeration.hasMoreElements()) {
                    String string5 = enumeration.nextElement();
                    Object object2 = table.getAttr(string3, string5);
                    if (object2 == null) continue;
                    fileObject3.setAttribute(string5, object2);
                }
            }
        }
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String findFreeFileName(FileObject fileObject, String string, String string2) {
        if (FileUtil.checkFreeName(fileObject, string, string2)) {
            return string;
        }
        int n = 1;
        String string3;
        while (!FileUtil.checkFreeName(fileObject, string3 = string + "_" + n, string2)) {
            ++n;
        }
        return string3;
    }

    public static String findFreeFolderName(FileObject fileObject, String string) {
        if (FileUtil.checkFreeName(fileObject, string, null)) {
            return string;
        }
        int n = 1;
        String string2;
        while (!FileUtil.checkFreeName(fileObject, string2 = string + "_" + n, null)) {
            ++n;
        }
        return string2;
    }

    public static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        if (!FileUtil.isParentOf(fileObject, fileObject2) && fileObject != fileObject2) {
            return null;
        }
        String string = fileObject2.getPath().substring(fileObject.getPath().length());
        if (string.startsWith("/") && !string.startsWith("//")) {
            string = string.substring(1);
        }
        return string;
    }

    private static boolean checkFreeName(FileObject fileObject, String string, String string2) {
        if (Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 || Utilities.isMac()) {
            Enumeration<? extends FileObject> enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                fileObject = enumeration.nextElement();
                String string3 = fileObject.getName();
                String string4 = fileObject.getExt();
                if (!string3.equalsIgnoreCase(string)) continue;
                if (!(string2 != null && string2.trim().length() != 0 || string4 != null && string4.trim().length() != 0)) {
                    return fileObject.isVirtual();
                }
                if (string2 == null || string4 == null || !string2.equalsIgnoreCase(string4)) continue;
                return fileObject.isVirtual();
            }
            return true;
        }
        if (string2 == null) {
            if ((fileObject = fileObject.getFileObject(string)) == null) {
                return true;
            }
            return fileObject.isVirtual();
        }
        if ((fileObject = fileObject.getFileObject(string, string2)) == null) {
            return true;
        }
        return fileObject.isVirtual();
    }

    public static FileObject findBrother(FileObject fileObject, String string) {
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null) {
            return null;
        }
        return fileObject2.getFileObject(fileObject.getName(), string);
    }

    @Deprecated
    public static String getMIMEType(String string) {
        assert (false) : "FileUtil.getMIMEType(String extension) is deprecated. Please, use FileUtil.getMIMEType(FileObject).";
        if (string.toLowerCase().equals("xml")) {
            return "text/xml";
        }
        return null;
    }

    public static String getMIMEType(FileObject fileObject) {
        return MIMESupport.findMIMEType(fileObject, new String[0]);
    }

    public static String getMIMEType(FileObject fileObject, String ... stringArray) {
        Parameters.notNull((CharSequence)"withinMIMETypes", (Object)stringArray);
        return MIMESupport.findMIMEType(fileObject, stringArray);
    }

    public static void setMIMEType(String string, String string2) {
        Parameters.notEmpty((CharSequence)"extension", (CharSequence)string);
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        FileObject fileObject = MIMEResolverImpl.getUserDefinedResolver();
        if (fileObject != null) {
            hashMap.putAll(MIMEResolverImpl.getMIMEToExtensions(fileObject));
            for (Set set : hashMap.values()) {
                set.remove(string);
            }
        }
        if (string2 != null) {
            Set set = (Set)hashMap.get(string2);
            if (set != null) {
                set.add(string);
            } else {
                hashMap.put(string2, Collections.singleton(string));
            }
        }
        MIMEResolverImpl.storeUserDefinedResolver(hashMap);
    }

    public static List<String> getMIMETypeExtensions(String string) {
        Parameters.notEmpty((CharSequence)"mimeType", (CharSequence)string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (FileObject object : MIMEResolverImpl.getOrderedResolvers().values()) {
            Map<String, Set<String>> map = MIMEResolverImpl.getMIMEToExtensions(object);
            for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
                String string2 = entry.getKey();
                Set<String> set = entry.getValue();
                for (String string3 : set) {
                    hashMap.put(string3, string2);
                }
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            if (!((String)entry.getValue()).equals(string)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    @Deprecated
    public static URLStreamHandler nbfsURLStreamHandler() {
        return new FileURL.Handler();
    }

    public static boolean isParentOf(FileObject fileObject, FileObject fileObject2) {
        Parameters.notNull((CharSequence)"folder", (Object)fileObject);
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject2);
        if (fileObject.isData()) {
            return false;
        }
        try {
            if (fileObject.getFileSystem() != fileObject2.getFileSystem()) {
                return false;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return false;
        }
        for (FileObject fileObject3 = fileObject2.getParent(); fileObject3 != null; fileObject3 = fileObject3.getParent()) {
            if (fileObject3 != fileObject) continue;
            return true;
        }
        return false;
    }

    public static FileChangeListener weakFileChangeListener(FileChangeListener fileChangeListener, Object object) {
        return (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)fileChangeListener, (Object)object);
    }

    public static FileStatusListener weakFileStatusListener(FileStatusListener fileStatusListener, Object object) {
        return (FileStatusListener)WeakListeners.create(FileStatusListener.class, (EventListener)fileStatusListener, (Object)object);
    }

    public static String getFileDisplayName(FileObject fileObject) {
        String string = null;
        File file = FileUtil.toFile(fileObject);
        if (file != null) {
            string = file.getAbsolutePath();
        } else {
            FileObject fileObject2 = FileUtil.getArchiveFile(fileObject);
            if (fileObject2 != null) {
                string = FileUtil.getArchiveDisplayName(fileObject, fileObject2);
            }
        }
        if (string == null) {
            try {
                string = fileObject.isRoot() ? fileObject.getFileSystem().getDisplayName() : NbBundle.getMessage(FileUtil.class, (String)"LBL_file_in_filesystem", (Object)fileObject.getPath(), (Object)fileObject.getFileSystem().getDisplayName());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                string = fileObject.getPath();
            }
        }
        return string;
    }

    private static String getArchiveDisplayName(FileObject fileObject, FileObject fileObject2) {
        String string = null;
        File file = FileUtil.toFile(fileObject2);
        if (file != null) {
            String string2 = file.getAbsolutePath();
            if (fileObject.isRoot()) {
                string = string2;
            } else {
                String string3 = fileObject.getPath();
                string = NbBundle.getMessage(FileUtil.class, (String)"LBL_file_in_filesystem", (Object)string3, (Object)string2);
            }
        }
        return string;
    }

    public static File normalizeFile(File file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        File file2 = Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 ? FileUtil.normalizeFileOnWindows(file) : (Utilities.isMac() ? FileUtil.normalizeFileOnMac(file) : FileUtil.normalizeFileOnUnixAlike(file));
        return file.getPath().equals(file2.getPath()) ? file : file2;
    }

    private static File normalizeFileOnUnixAlike(File file) {
        if ((file = new File(file.toURI().normalize()).getAbsoluteFile()).getAbsolutePath().equals("/..")) {
            file = new File("/");
        }
        return file;
    }

    private static File normalizeFileOnMac(File file) {
        File file2 = file;
        try {
            boolean bl;
            File file3 = new File(file.toURI().normalize());
            File file4 = file.getCanonicalFile();
            boolean bl2 = bl = !file4.getAbsolutePath().equalsIgnoreCase(file3.getAbsolutePath());
            file2 = bl ? FileUtil.normalizeSymLinkOnMac(file3) : file4;
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Normalization failed on file " + file, iOException);
            file2 = file.getAbsoluteFile();
        }
        return file2;
    }

    private static File normalizeSymLinkOnMac(File file) throws IOException {
        File file2;
        File file3 = file2 = File.listRoots()[0];
        String string = File.separator + ".." + File.separator;
        Object object = file.getAbsolutePath();
        int n = ((String)object).lastIndexOf(string);
        if (n > -1) {
            object = ((String)object).substring(n + string.length());
        }
        String string2 = object;
        object = new StringTokenizer(string2, File.separator);
        while (((StringTokenizer)object).hasMoreTokens()) {
            boolean bl;
            File file4 = new File(file3, ((StringTokenizer)object).nextToken());
            boolean bl2 = bl = !(file3 = file4.getCanonicalFile()).getAbsolutePath().equalsIgnoreCase(file4.getAbsolutePath());
            if (bl) {
                file2 = new File(file2, file4.getName());
                continue;
            }
            file2 = new File(file2, file3.getName());
        }
        return file2;
    }

    private static File normalizeFileOnWindows(File file) {
        File file2;
        block5: {
            file2 = null;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                String string = file.getPath();
                if (string.equals("\\\\") || "\\\\".equals(file.getParent())) break block5;
                LOG.log(Level.FINE, string, iOException);
            }
        }
        if ((Utilities.getOperatingSystem() & 0x40000) != 0) {
            String string;
            if (file2 == null) {
                file2 = file.getAbsoluteFile();
            }
            if ((string = file2.getAbsolutePath()).contains(":\\Documents and Settings")) {
                string = string.replaceFirst("Documents and Settings", "Users");
                string = string.replaceFirst("My Documents", "Documents");
                string = string.replaceFirst("My Pictures", "Pictures");
                string = string.replaceFirst("My Music", "Music");
                file2 = new File(string);
            }
        }
        return file2 != null ? file2 : file.getAbsoluteFile();
    }

    public static FileObject getArchiveRoot(FileObject fileObject) {
        URL uRL = URLMapper.findURL(fileObject, 1);
        if (uRL == null) {
            return null;
        }
        return URLMapper.findFileObject(FileUtil.getArchiveRoot(uRL));
    }

    public static URL getArchiveRoot(URL uRL) {
        try {
            return new URL("jar:" + uRL + "!/");
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    public static FileObject getArchiveFile(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fo", (Object)fileObject);
        try {
            FileSystem fileSystem = fileObject.getFileSystem();
            if (fileSystem instanceof JarFileSystem) {
                File file = ((JarFileSystem)fileSystem).getJarFile();
                return FileUtil.toFileObject(file);
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        return null;
    }

    public static URL getArchiveFile(URL uRL) {
        String string;
        int n;
        String string2 = uRL.getProtocol();
        if ("jar".equals(string2) && (n = (string = uRL.getPath()).indexOf("!/")) >= 0) {
            try {
                String string3 = string.substring(0, n);
                if (string3.indexOf("file://") > -1 && string3.indexOf("file:////") == -1) {
                    string3 = string3.replaceFirst("file://", "file:////");
                }
                return new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isArchiveFile(FileObject fileObject) {
        Object object;
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        if (!fileObject.isValid()) {
            return false;
        }
        if (fileObject.isVirtual()) {
            String string = fileObject.getPath();
            int n = string.lastIndexOf(46);
            if (n == -1) return false;
            if (n <= string.lastIndexOf(47) + 1) return false;
            return true;
        }
        if (fileObject.isFolder()) {
            return false;
        }
        Boolean bl = archiveFileCache.get(fileObject);
        if (bl != null) return bl;
        try {
            object = fileObject.getInputStream();
            try {
                byte[] byArray = new byte[4];
                int n = ((InputStream)object).read(byArray, 0, 4);
                if (n != 4) {
                    boolean bl2 = false;
                    return bl2;
                }
                bl = Arrays.equals(ZIP_HEADER_1, byArray) || Arrays.equals(ZIP_HEADER_2, byArray);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, null, iOException);
        }
        if (bl == null) {
            object = fileObject.getPath();
            int n = ((String)object).lastIndexOf(46);
            bl = n != -1 && n > ((String)object).lastIndexOf(47) + 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        archiveFileCache.put(fileObject, bl);
        return bl;
    }

    public static boolean isArchiveFile(URL uRL) {
        Parameters.notNull((CharSequence)"url", (Object)uRL);
        if ("jar".equals(uRL.getProtocol())) {
            return false;
        }
        FileObject fileObject = URLMapper.findFileObject(uRL);
        if (fileObject != null && !fileObject.isVirtual()) {
            return FileUtil.isArchiveFile(fileObject);
        }
        String string = uRL.getPath();
        int n = string.lastIndexOf(46);
        return n != -1 && n > string.lastIndexOf(47) + 1;
    }

    public static URL urlForArchiveOrDir(File file) {
        try {
            URL uRL = file.toURI().toURL();
            if (FileUtil.isArchiveFile(uRL) || file.isFile() && file.length() < 4L) {
                return FileUtil.getArchiveRoot(uRL);
            }
            if (file.isDirectory()) {
                return uRL;
            }
            if (!file.exists()) {
                if (!uRL.toString().endsWith("/")) {
                    uRL = new URL(uRL + "/");
                }
                return uRL;
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            assert (false) : malformedURLException;
            return null;
        }
    }

    public static File archiveOrDirForURL(URL uRL) {
        String string = uRL.toString();
        if (string.startsWith("jar:file:") && string.endsWith("!/")) {
            return new File(URI.create(string.substring(4, string.length() - 2)));
        }
        if (string.startsWith("file:")) {
            return new File(URI.create(string));
        }
        return null;
    }

    public static void preventFileChooserSymlinkTraversal(JFileChooser jFileChooser, File file) {
        if (!Utilities.isWindows() && Utilities.getOperatingSystem() != 2048 && System.getProperty("java.specification.version").startsWith("1.5")) {
            jFileChooser.setCurrentDirectory(FileUtil.wrapFileNoCanonicalize(file));
            jFileChooser.setFileSystemView(new NonCanonicalizingFileSystemView());
        } else {
            jFileChooser.setCurrentDirectory(file);
        }
    }

    public static List<FileObject> getOrder(Collection<FileObject> collection, boolean bl) throws IllegalArgumentException {
        return Ordering.getOrder(collection, bl);
    }

    public static void setOrder(List<FileObject> list) throws IllegalArgumentException, IOException {
        Ordering.setOrder(list);
    }

    public static boolean affectsOrder(FileAttributeEvent fileAttributeEvent) {
        return Ordering.affectsOrder(fileAttributeEvent);
    }

    public static FileObject getConfigFile(String string) {
        Parameters.notNull((CharSequence)"path", (Object)string);
        return Repository.getDefault().getDefaultFileSystem().findResource(string);
    }

    public static FileObject getConfigRoot() {
        return FileUtil.getConfigFile("");
    }

    private static File wrapFileNoCanonicalize(File file) {
        if (file instanceof NonCanonicalizingFile) {
            return file;
        }
        if (file != null) {
            return new NonCanonicalizingFile(file);
        }
        return null;
    }

    private static File[] wrapFilesNoCanonicalize(File[] fileArray) {
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i] = FileUtil.wrapFileNoCanonicalize(fileArray[i]);
            }
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem getDiskFileSystem() {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return diskFileSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setDiskFileSystem(FileSystem fileSystem) {
        Object object = fileSystem.getRoot().getAttribute("SupportsRefreshForNoPublicAPI");
        if (!(object instanceof Boolean) || !((Boolean)object).booleanValue()) return;
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            diskFileSystem = fileSystem;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static {
        transientAttributes.add("templateWizardURL");
        transientAttributes.add("templateWizardIterator");
        transientAttributes.add("templateWizardDescResource");
        transientAttributes.add("templateCategory");
        transientAttributes.add("instantiatingIterator");
        transientAttributes.add("instantiatingWizardURL");
        transientAttributes.add("SystemFileSystem.localizingBundle");
        transientAttributes.add("SystemFileSystem.icon");
        transientAttributes.add("SystemFileSystem.icon32");
        transientAttributes.add("displayName");
        transientAttributes.add("iconBase");
        transientAttributes.add("position");
        archiveFileCache = new WeakHashMap<FileObject, Boolean>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Holder
    extends WeakReference<FileChangeListener>
    implements FileChangeListener,
    Runnable {
        private final File path;
        private FileObject current;
        private File currentF;
        private boolean isOnTarget = false;

        public Holder(FileChangeListener fileChangeListener, File file) {
            super(fileChangeListener, Utilities.activeReferenceQueue());
            assert (file != null);
            this.path = file;
            this.locateCurrent();
        }

        private void locateCurrent() {
            FileObject fileObject;
            block4: {
                fileObject = this.current;
                this.currentF = FileUtil.normalizeFile(this.path);
                do {
                    this.current = FileUtil.toFileObject(this.currentF);
                    if (this.current != null) break block4;
                    this.currentF = this.currentF.getParentFile();
                } while (this.currentF != null);
                return;
            }
            this.isOnTarget = this.path.equals(this.currentF);
            assert (this.current != null);
            if (this.current != fileObject) {
                if (fileObject != null) {
                    fileObject.removeFileChangeListener(this);
                }
                this.current.addFileChangeListener(this);
                this.current.getChildren();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void someChange() {
            FileObject fileObject;
            boolean bl;
            FileChangeListener fileChangeListener;
            Holder holder = this;
            synchronized (holder) {
                if (this.current == null) {
                    return;
                }
                fileChangeListener = (FileChangeListener)this.get();
                if (fileChangeListener == null) {
                    return;
                }
                bl = this.isOnTarget;
                this.locateCurrent();
                fileObject = this.current;
            }
            if (this.isOnTarget && !bl) {
                if (fileObject.isFolder()) {
                    fileChangeListener.fileFolderCreated(new FileEvent(fileObject));
                } else {
                    fileChangeListener.fileDataCreated(new FileEvent(fileObject));
                }
            }
        }

        @Override
        public void fileChanged(FileEvent fileEvent) {
            if (fileEvent.getSource() == this.current) {
                if (this.isOnTarget) {
                    FileChangeListener fileChangeListener = (FileChangeListener)this.get();
                    if (fileChangeListener instanceof DeepListener) {
                        ((DeepListener)fileChangeListener).fileChanged(fileEvent, true);
                    } else if (fileChangeListener != null) {
                        fileChangeListener.fileChanged(fileEvent);
                    }
                } else {
                    this.someChange();
                }
            }
        }

        @Override
        public void fileDeleted(FileEvent fileEvent) {
            if (fileEvent.getSource() == this.current) {
                if (this.isOnTarget) {
                    FileChangeListener fileChangeListener = (FileChangeListener)this.get();
                    if (fileChangeListener instanceof DeepListener) {
                        ((DeepListener)fileChangeListener).fileDeleted(fileEvent, true);
                    } else if (fileChangeListener != null) {
                        fileChangeListener.fileDeleted(fileEvent);
                    }
                }
                this.someChange();
            }
        }

        @Override
        public void fileDataCreated(FileEvent fileEvent) {
            if (fileEvent.getSource() == this.current) {
                if (this.isOnTarget) {
                    FileChangeListener fileChangeListener = (FileChangeListener)this.get();
                    if (fileChangeListener instanceof DeepListener) {
                        ((DeepListener)fileChangeListener).fileDataCreated(fileEvent, true);
                    } else if (fileChangeListener != null) {
                        fileChangeListener.fileDataCreated(fileEvent);
                    }
                } else {
                    this.someChange();
                }
            }
        }

        @Override
        public void fileFolderCreated(FileEvent fileEvent) {
            if (fileEvent.getSource() == this.current) {
                if (this.isOnTarget) {
                    FileChangeListener fileChangeListener = (FileChangeListener)this.get();
                    if (fileChangeListener instanceof DeepListener) {
                        ((DeepListener)fileChangeListener).fileFolderCreated(fileEvent, true);
                    } else if (fileChangeListener != null) {
                        fileChangeListener.fileFolderCreated(fileEvent);
                    }
                } else {
                    this.someChange();
                }
            }
        }

        @Override
        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (fileRenameEvent.getSource() == this.current) {
                if (this.isOnTarget) {
                    FileChangeListener fileChangeListener = (FileChangeListener)this.get();
                    if (fileChangeListener instanceof DeepListener) {
                        ((DeepListener)fileChangeListener).fileRenamed(fileRenameEvent, true);
                    } else if (fileChangeListener != null) {
                        fileChangeListener.fileRenamed(fileRenameEvent);
                    }
                }
                this.someChange();
            }
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            FileChangeListener fileChangeListener;
            if (fileAttributeEvent.getSource() == this.current && this.isOnTarget && (fileChangeListener = (FileChangeListener)this.get()) != null) {
                fileChangeListener.fileAttributeChanged(fileAttributeEvent);
            }
        }

        @Override
        public synchronized void run() {
            if (this.current != null) {
                this.current.removeFileChangeListener(this);
                this.current = null;
            }
        }
    }

    private static final class NonCanonicalizingFile
    extends File {
        public NonCanonicalizingFile(File file) {
            this(file.getPath());
        }

        private NonCanonicalizingFile(String string) {
            super(string);
        }

        private NonCanonicalizingFile(URI uRI) {
            super(uRI);
        }

        public File getCanonicalFile() throws IOException {
            return FileUtil.wrapFileNoCanonicalize(FileUtil.normalizeFile(super.getAbsoluteFile()));
        }

        public String getCanonicalPath() throws IOException {
            return FileUtil.normalizeFile(super.getAbsoluteFile()).getAbsolutePath();
        }

        public File getParentFile() {
            return FileUtil.wrapFileNoCanonicalize(super.getParentFile());
        }

        public File getAbsoluteFile() {
            return FileUtil.wrapFileNoCanonicalize(super.getAbsoluteFile());
        }

        public File[] listFiles() {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles());
        }

        public File[] listFiles(FileFilter fileFilter) {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles(fileFilter));
        }

        public File[] listFiles(FilenameFilter filenameFilter) {
            return FileUtil.wrapFilesNoCanonicalize(super.listFiles(filenameFilter));
        }
    }

    private static final class NonCanonicalizingFileSystemView
    extends FileSystemView {
        private final FileSystemView delegate = FileSystemView.getFileSystemView();

        public boolean isFloppyDrive(File file) {
            return this.delegate.isFloppyDrive(file);
        }

        public boolean isComputerNode(File file) {
            return this.delegate.isComputerNode(file);
        }

        public File createNewFolder(File file) throws IOException {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.createNewFolder(file));
        }

        public boolean isDrive(File file) {
            return this.delegate.isDrive(file);
        }

        public boolean isFileSystemRoot(File file) {
            return this.delegate.isFileSystemRoot(file);
        }

        public File getHomeDirectory() {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.getHomeDirectory());
        }

        public File createFileObject(File file, String string) {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.createFileObject(file, string));
        }

        public Boolean isTraversable(File file) {
            return this.delegate.isTraversable(file);
        }

        public boolean isFileSystem(File file) {
            return this.delegate.isFileSystem(file);
        }

        public File getChild(File file, String string) {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.getChild(file, string));
        }

        public File getParentDirectory(File file) {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.getParentDirectory(file));
        }

        public Icon getSystemIcon(File file) {
            return this.delegate.getSystemIcon(file);
        }

        public boolean isParent(File file, File file2) {
            return this.delegate.isParent(file, file2);
        }

        public String getSystemTypeDescription(File file) {
            return this.delegate.getSystemTypeDescription(file);
        }

        public File getDefaultDirectory() {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.getDefaultDirectory());
        }

        public String getSystemDisplayName(File file) {
            return this.delegate.getSystemDisplayName(file);
        }

        public File[] getRoots() {
            return FileUtil.wrapFilesNoCanonicalize(this.delegate.getRoots());
        }

        public boolean isHiddenFile(File file) {
            return this.delegate.isHiddenFile(file);
        }

        public File[] getFiles(File file, boolean bl) {
            return FileUtil.wrapFilesNoCanonicalize(this.delegate.getFiles(file, bl));
        }

        public boolean isRoot(File file) {
            return this.delegate.isRoot(file);
        }

        public File createFileObject(String string) {
            return FileUtil.wrapFileNoCanonicalize(this.delegate.createFileObject(string));
        }
    }
}

