/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project;

import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.projectapi.SimpleFileOwnerQueryImplementation;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.ProjectFactory2;
import org.netbeans.spi.project.ProjectState;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Union2;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectManager {
    private static final Logger LOG = Logger.getLogger(ProjectManager.class.getName());
    private static final Logger TIMERS = Logger.getLogger("TIMER.projects");
    private static final Lookup.Result<ProjectFactory> factories = Lookup.getDefault().lookupResult(ProjectFactory.class);
    private static final ProjectManager DEFAULT = new ProjectManager();
    private static final Mutex MUTEX = new Mutex();
    private final Map<FileObject, Union2<Reference<Project>, LoadStatus>> dir2Proj = new WeakHashMap<FileObject, Union2<Reference<Project>, LoadStatus>>();
    private final Set<Project> modifiedProjects = new HashSet<Project>();
    private final Set<Project> removedProjects = new WeakSet();
    private final Map<Project, ProjectFactory> proj2Factory = new WeakHashMap<Project, ProjectFactory>();
    private final FileChangeListener projectDeletionListener = new ProjectDeletionListener();
    private ThreadLocal<Set<FileObject>> loadingThread = new ThreadLocal();

    private ProjectManager() {
        factories.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ProjectManager.this.clearNonProjectCache();
            }
        });
    }

    public static ProjectManager getDefault() {
        return DEFAULT;
    }

    public static Mutex mutex() {
        return MUTEX;
    }

    void reset() {
        this.dir2Proj.clear();
        this.modifiedProjects.clear();
        this.proj2Factory.clear();
    }

    public Project findProject(final FileObject fileObject) throws IOException, IllegalArgumentException {
        if (fileObject == null) {
            throw new IllegalArgumentException("Attempted to pass a null directory to findProject");
        }
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("Attempted to pass a non-directory to findProject: " + fileObject);
        }
        try {
            return (Project)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Project>(){

                /*
                 * Exception decompiling
                 */
                public Project run() throws IOException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private Project createProject(FileObject fileObject) throws IOException {
        assert (fileObject != null);
        assert (fileObject.isFolder());
        assert (ProjectManager.mutex().isReadAccess());
        ProjectStateImpl projectStateImpl = new ProjectStateImpl();
        for (ProjectFactory projectFactory : factories.allInstances()) {
            Project project = projectFactory.loadProject(fileObject, projectStateImpl);
            if (project == null) continue;
            if (TIMERS.isLoggable(Level.FINE)) {
                LogRecord logRecord = new LogRecord(Level.FINE, "Project");
                logRecord.setParameters(new Object[]{project});
                TIMERS.log(logRecord);
            }
            this.proj2Factory.put(project, projectFactory);
            projectStateImpl.attach(project);
            return project;
        }
        return null;
    }

    public boolean isProject(FileObject fileObject) throws IllegalArgumentException {
        return this.isProject2(fileObject, false) != null;
    }

    public Result isProject2(FileObject fileObject) throws IllegalArgumentException {
        return this.isProject2(fileObject, true);
    }

    private Result isProject2(final FileObject fileObject, final boolean bl) throws IllegalArgumentException {
        if (fileObject == null) {
            throw new IllegalArgumentException("Attempted to pass a null directory to isProject");
        }
        if (!fileObject.isFolder()) {
            if (fileObject.isValid()) {
                throw new IllegalArgumentException("Attempted to pass a non-directory to isProject: " + fileObject);
            }
            return null;
        }
        return (Result)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Result>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Result run() {
                Result result;
                boolean bl2;
                block17: {
                    Object object;
                    block16: {
                        Object object2;
                        Map map = ProjectManager.this.dir2Proj;
                        synchronized (map) {
                            do {
                                if (!LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)(object2 = (Union2)ProjectManager.this.dir2Proj.get(fileObject)))) continue;
                                try {
                                    ProjectManager.this.dir2Proj.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    interruptedException.printStackTrace();
                                }
                            } while (LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)object2));
                            assert (!LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)object2));
                            if (LoadStatus.NO_SUCH_PROJECT.is((Union2<Reference<Project>, LoadStatus>)object2)) {
                                return null;
                            }
                            if (object2 != null) {
                                return ProjectManager.this.checkForProject(fileObject, bl);
                            }
                            ProjectManager.this.dir2Proj.put(fileObject, LoadStatus.LOADING_PROJECT.wrap());
                        }
                        bl2 = false;
                        try {
                            object2 = ProjectManager.this.checkForProject(fileObject, bl);
                            Map map2 = ProjectManager.this.dir2Proj;
                            synchronized (map2) {
                                bl2 = true;
                                ProjectManager.this.dir2Proj.notifyAll();
                                if (object2 != null) {
                                    ProjectManager.this.dir2Proj.put(fileObject, LoadStatus.SOME_SUCH_PROJECT.wrap());
                                    object = object2;
                                    // MONITOREXIT @DISABLED, blocks:[2, 6, 15] lbl33 : MonitorExitStatement: MONITOREXIT : var3_5
                                    Object var7_8 = null;
                                    if (bl2) return object;
                                    if ($assertionsDisabled || LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)((Union2)ProjectManager.this.dir2Proj.get(fileObject)))) break block16;
                                    throw new AssertionError();
                                }
                                ProjectManager.this.dir2Proj.put(fileObject, LoadStatus.NO_SUCH_PROJECT.wrap());
                                result = null;
                            }
                            break block17;
                        }
                        catch (Throwable throwable) {
                            Object var7_10 = null;
                            if (bl2) throw throwable;
                            assert (LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)((Union2)ProjectManager.this.dir2Proj.get(fileObject))));
                            ProjectManager.this.dir2Proj.remove(fileObject);
                            throw throwable;
                        }
                    }
                    ProjectManager.this.dir2Proj.remove(fileObject);
                    return object;
                }
                Object var7_9 = null;
                if (bl2) return result;
                assert (LoadStatus.LOADING_PROJECT.is((Union2<Reference<Project>, LoadStatus>)((Union2)ProjectManager.this.dir2Proj.get(fileObject))));
                ProjectManager.this.dir2Proj.remove(fileObject);
                return result;
            }
        });
    }

    private Result checkForProject(FileObject fileObject, boolean bl) {
        assert (fileObject != null);
        assert (fileObject.isFolder()) : fileObject;
        assert (ProjectManager.mutex().isReadAccess());
        for (ProjectFactory projectFactory : factories.allInstances()) {
            if (projectFactory instanceof ProjectFactory2 && bl) {
                Result result = ((ProjectFactory2)projectFactory).isProject2(fileObject);
                if (result == null) continue;
                return result;
            }
            if (!projectFactory.isProject(fileObject)) continue;
            return new Result(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearNonProjectCache() {
        Map<FileObject, Union2<Reference<Project>, LoadStatus>> map = this.dir2Proj;
        synchronized (map) {
            this.dir2Proj.values().removeAll(Arrays.asList(LoadStatus.NO_SUCH_PROJECT.wrap(), LoadStatus.SOME_SUCH_PROJECT.wrap()));
        }
    }

    public Set<Project> getModifiedProjects() {
        return (Set)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Set<Project>>(){

            public Set<Project> run() {
                return new HashSet<Project>(ProjectManager.this.modifiedProjects);
            }
        });
    }

    public boolean isModified(final Project project) throws IllegalArgumentException {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                Map map = ProjectManager.this.dir2Proj;
                synchronized (map) {
                    if (!ProjectManager.this.proj2Factory.containsKey(project)) {
                        throw new IllegalArgumentException("Project " + project + " not created by " + ProjectManager.this + " or was already deleted");
                    }
                }
                return ProjectManager.this.modifiedProjects.contains(project);
            }
        });
    }

    public void saveProject(final Project project) throws IOException, IllegalArgumentException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    if (ProjectManager.this.removedProjects.contains(project)) {
                        return null;
                    }
                    if (!ProjectManager.this.proj2Factory.containsKey(project)) {
                        throw new IllegalArgumentException("Project " + project + " not created by " + ProjectManager.this + " or was already deleted");
                    }
                    if (ProjectManager.this.modifiedProjects.contains(project)) {
                        ProjectFactory projectFactory = (ProjectFactory)ProjectManager.this.proj2Factory.get(project);
                        projectFactory.saveProject(project);
                        LOG.log(Level.FINE, "saveProject({0})", project.getProjectDirectory());
                        ProjectManager.this.modifiedProjects.remove(project);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            if (!project.getProjectDirectory().canWrite()) {
                throw new IOException("Project folder is not writeable.");
            }
            throw (IOException)mutexException.getException();
        }
    }

    public void saveAllProjects() throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    Iterator iterator = ProjectManager.this.modifiedProjects.iterator();
                    while (iterator.hasNext()) {
                        Project project = (Project)iterator.next();
                        ProjectFactory projectFactory = (ProjectFactory)ProjectManager.this.proj2Factory.get(project);
                        assert (projectFactory != null) : project;
                        projectFactory.saveProject(project);
                        LOG.log(Level.FINE, "saveProject({0})", project.getProjectDirectory());
                        iterator.remove();
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public boolean isValid(final Project project) {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                Map map = ProjectManager.this.dir2Proj;
                synchronized (map) {
                    return ProjectManager.this.proj2Factory.containsKey(project);
                }
            }
        });
    }

    static /* synthetic */ ThreadLocal access$100(ProjectManager projectManager) {
        return projectManager.loadingThread;
    }

    static /* synthetic */ Project access$300(ProjectManager projectManager, FileObject fileObject) throws IOException {
        return projectManager.createProject(fileObject);
    }

    static /* synthetic */ FileChangeListener access$400(ProjectManager projectManager) {
        return projectManager.projectDeletionListener;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LoadStatus {
        NO_SUCH_PROJECT,
        SOME_SUCH_PROJECT,
        LOADING_PROJECT;


        public boolean is(Union2<Reference<Project>, LoadStatus> union2) {
            return union2 != null && union2.hasSecond() && union2.second() == this;
        }

        public Union2<Reference<Project>, LoadStatus> wrap() {
            return Union2.createSecond((Object)((Object)this));
        }
    }

    private final class ProjectDeletionListener
    extends FileChangeAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent fileEvent) {
            Map map = ProjectManager.this.dir2Proj;
            synchronized (map) {
                ProjectManager.this.dir2Proj.remove(fileEvent.getFile());
            }
        }
    }

    private final class ProjectStateImpl
    implements ProjectState {
        private Project p;

        private ProjectStateImpl() {
        }

        void attach(Project project) {
            assert (project != null);
            assert (this.p == null);
            this.p = project;
        }

        public void markModified() {
            assert (this.p != null);
            LOG.log(Level.FINE, "markModified({0})", this.p.getProjectDirectory());
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    if (!ProjectManager.this.proj2Factory.containsKey(ProjectStateImpl.this.p)) {
                        throw new IllegalStateException("An attempt to call ProjectState.markModified on a deleted project: " + ProjectStateImpl.this.p.getProjectDirectory());
                    }
                    ProjectManager.this.modifiedProjects.add(ProjectStateImpl.this.p);
                    return null;
                }
            });
        }

        public void notifyDeleted() throws IllegalStateException {
            assert (this.p != null);
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    if (ProjectManager.this.proj2Factory.get(ProjectStateImpl.this.p) == null) {
                        throw new IllegalStateException("An attempt to call notifyDeleted more than once. Project: " + ProjectStateImpl.this.p.getProjectDirectory());
                    }
                    ProjectManager.this.dir2Proj.remove(ProjectStateImpl.this.p.getProjectDirectory());
                    ProjectManager.this.proj2Factory.remove(ProjectStateImpl.this.p);
                    ProjectManager.this.modifiedProjects.remove(ProjectStateImpl.this.p);
                    ProjectManager.this.removedProjects.add(ProjectStateImpl.this.p);
                    Collection collection = Lookup.getDefault().lookupAll(FileOwnerQueryImplementation.class);
                    for (FileOwnerQueryImplementation fileOwnerQueryImplementation : collection) {
                        if (!(fileOwnerQueryImplementation instanceof SimpleFileOwnerQueryImplementation)) continue;
                        ((SimpleFileOwnerQueryImplementation)fileOwnerQueryImplementation).resetLastFoundReferences();
                    }
                    return null;
                }
            });
        }
    }

    public static final class Result {
        private Icon icon;

        public Result(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

